/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling.model.kapt;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.AbstractKotlinGradleModelBuilder;
import org.jetbrains.kotlin.idea.gradleTooling.AndroidAwareGradleModelProvider;
import org.jetbrains.kotlin.idea.gradleTooling.ModelBuilderUtilsKt;
import org.jetbrains.kotlin.idea.gradleTooling.UtilsKt;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptGradleModel;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptGradleModelImpl;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptSourceSetModel;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptSourceSetModelImpl;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService;", "Lorg/jetbrains/kotlin/idea/gradleTooling/AbstractKotlinGradleModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService$ParameterizedModelBuilderService;", "<init>", "()V", "reportErrorMessage", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "canBuild", "", "buildAll", "Lorg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptGradleModelImpl;", "builderContext", "parameter", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService$Parameter;", "isWithJavaEnabled", "target", "Lorg/gradle/api/Named;", "getKaptDirectory", "funName", "sourceSetName", "kotlin.gradle.gradle-tooling.impl"})
@SourceDebugExtension(value={"SMAP\nKaptModelBuilderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaptModelBuilderService.kt\norg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n1617#2,9:149\n1869#2:158\n1870#2:160\n1626#2:161\n1869#2,2:162\n1#3:159\n1400#4,2:164\n1400#4,2:166\n*S KotlinDebug\n*F\n+ 1 KaptModelBuilderService.kt\norg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService\n*L\n119#1:149,9\n119#1:158\n119#1:160\n119#1:161\n121#1:162,2\n119#1:159\n134#1:164,2\n142#1:166,2\n*E\n"})
public final class KaptModelBuilderService
extends AbstractKotlinGradleModelBuilder
implements ModelBuilderService.ParameterizedModelBuilderService {
    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup((ModelBuilderService)this).withKind(Message.Kind.WARNING).withTitle("Gradle import errors").withText("Unable to build kotlin-kapt plugin configuration").withException(exception).reportMessage(project);
    }

    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)KaptGradleModel.class.getName());
    }

    @Nullable
    public KaptGradleModelImpl buildAll(@Nullable String modelName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.buildAll(project, null, null);
    }

    @Nullable
    public KaptGradleModelImpl buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext builderContext, @Nullable ModelBuilderService.Parameter parameter) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)builderContext, (String)"builderContext");
        return this.buildAll(project, builderContext, parameter);
    }

    /*
     * WARNING - void declaration
     */
    private final KaptGradleModelImpl buildAll(Project project, ModelBuilderContext builderContext, ModelBuilderService.Parameter parameter) {
        ModelBuilderService.Parameter parameter2 = parameter;
        AndroidAwareGradleModelProvider.Result androidVariantRequest = AndroidAwareGradleModelProvider.Companion.parseParameter(project, parameter2 != null ? parameter2.getValue() : null);
        if (androidVariantRequest.shouldSkipBuildAllCall()) {
            return null;
        }
        Plugin kaptPlugin = project.getPlugins().findPlugin("kotlin-kapt");
        boolean kaptIsEnabled = kaptPlugin != null;
        List sourceSets = new ArrayList();
        if (kaptIsEnabled) {
            Collection<Named> targets = ModelBuilderUtilsKt.getTargets(project);
            Collection<Named> collection = targets;
            if (!(collection == null || collection.isEmpty())) {
                for (Named target : targets) {
                    Collection<Named> compilations;
                    if (!this.isWithJavaEnabled(target) || ModelBuilderUtilsKt.getCompilations(target) == null) continue;
                    for (Named compilation : compilations) {
                        Task compileTask;
                        if (ModelBuilderUtilsKt.getCompileKotlinTaskName(compilation, project) == null) continue;
                        StringBuilder stringBuilder = new StringBuilder().append(target.getName());
                        String string = compilation.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String moduleName = stringBuilder.append(UtilsKt.capitalize(string)).toString();
                        KaptModelBuilderService.buildAll$handleCompileTask(this, project, sourceSets, moduleName, compileTask);
                    }
                }
            } else {
                List compileTasks;
                List list;
                Object object = ModelBuilderUtilsKt.getTarget(project);
                if (object != null && (object = ModelBuilderUtilsKt.getCompilations(object)) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable moduleName = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Task it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        Named comp = (Named)element$iv$iv;
                        boolean bl2 = false;
                        if (ModelBuilderUtilsKt.getCompileKotlinTaskName(comp, project) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    Set set = (Set)project.getAllTasks(false).get(project);
                    list = set != null ? CollectionsKt.filterNotNull((Iterable)set) : null;
                }
                List list2 = compileTasks = list;
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Task compileTask = (Task)element$iv;
                        boolean bl = false;
                        String sourceSetName = AbstractKotlinGradleModelBuilder.Companion.getSourceSetName(compileTask);
                        if (androidVariantRequest.shouldSkipSourceSet(sourceSetName)) continue;
                        KaptModelBuilderService.buildAll$handleCompileTask(this, project, sourceSets, sourceSetName, compileTask);
                    }
                }
            }
        }
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        return new KaptGradleModelImpl(kaptIsEnabled, file, sourceSets);
    }

    private final boolean isWithJavaEnabled(Named target) {
        Object object;
        block2: {
            Method[] methodArray = target.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getWithJavaEnabled") && it.getParameterCount() == 0)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            return false;
        }
        Method getWithJavaEnabledMethod = method;
        return Intrinsics.areEqual((Object)getWithJavaEnabledMethod.invoke((Object)target, new Object[0]), (Object)true);
    }

    private final String getKaptDirectory(String funName, Project project, String sourceSetName) {
        Object object;
        block4: {
            Plugin plugin = project.getPlugins().findPlugin("kotlin-kapt");
            if (plugin == null) {
                return "";
            }
            Plugin kotlinKaptPlugin = plugin;
            Method[] methodArray = kotlinKaptPlugin.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Modifier.isStatic(it.getModifiers()) && Intrinsics.areEqual((Object)it.getName(), (Object)funName) && it.getParameterCount() == 2)) continue;
                object = element$iv;
                break block4;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            return "";
        }
        Method targetMethod = method;
        Object[] objectArray = new Object[]{project, sourceSetName};
        Object object2 = targetMethod.invoke(null, objectArray);
        Object object3 = object2 instanceof File ? (File)object2 : null;
        if (object3 == null || (object3 = ((File)object3).getAbsolutePath()) == null) {
            object3 = "";
        }
        return object3;
    }

    private static final void buildAll$handleCompileTask(KaptModelBuilderService this$0, Project $project, List<KaptSourceSetModel> sourceSets, String moduleName, Task compileTask) {
        String sourceSetName;
        if (!AbstractKotlinGradleModelBuilder.Companion.getKotlinCompileJvmTaskClasses().contains(compileTask.getClass().getName())) {
            return;
        }
        String string = sourceSetName = AbstractKotlinGradleModelBuilder.Companion.getSourceSetName(compileTask);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        boolean isTest = StringsKt.endsWith$default((String)string2, (String)"test", (boolean)false, (int)2, null);
        String kaptGeneratedSourcesDir = this$0.getKaptDirectory("getKaptGeneratedSourcesDir", $project, sourceSetName);
        String kaptGeneratedClassesDir = this$0.getKaptDirectory("getKaptGeneratedClassesDir", $project, sourceSetName);
        String kaptGeneratedKotlinSourcesDir = this$0.getKaptDirectory("getKaptGeneratedKotlinSourcesDir", $project, sourceSetName);
        ((Collection)sourceSets).add(new KaptSourceSetModelImpl(moduleName, isTest, kaptGeneratedSourcesDir, kaptGeneratedClassesDir, kaptGeneratedKotlinSourcesDir));
    }
}

