/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.kernel;

import com.intellij.util.system.OS;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/execution/kernel/KernelProcessKiller;", "", "<init>", "()V", "kill", "", "process", "Ljava/lang/Process;", "connectionFile", "Ljava/nio/file/Path;", "closeStreams", "p", "killChildren", "killSelf", "Companion", "intellij.jupyter.execution"})
@SourceDebugExtension(value={"SMAP\nKernelProcessKiller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelProcessKiller.kt\ncom/intellij/jupyter/execution/kernel/KernelProcessKiller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class KernelProcessKiller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long KILL_TIMEOUT_MS = 1000L;

    public final void kill(@NotNull Process process, @Nullable Path connectionFile) {
        Object object;
        Object $this$kill_u24lambda_u242;
        Object $this$kill_u24lambda_u241;
        Object $this$kill_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        KernelProcessKiller kernelProcessKiller = this;
        try {
            $this$kill_u24lambda_u240 = kernelProcessKiller;
            boolean bl = false;
            super.closeStreams(process);
            $this$kill_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$kill_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        kernelProcessKiller = this;
        try {
            $this$kill_u24lambda_u241 = kernelProcessKiller;
            boolean bl = false;
            super.killChildren(process);
            $this$kill_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$kill_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        kernelProcessKiller = this;
        try {
            $this$kill_u24lambda_u242 = kernelProcessKiller;
            boolean bl = false;
            super.killSelf(process);
            $this$kill_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$kill_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        kernelProcessKiller = this;
        try {
            Boolean bl;
            KernelProcessKiller $this$kill_u24lambda_u243 = kernelProcessKiller;
            boolean bl2 = false;
            Path path = connectionFile;
            if (path != null) {
                Path p0 = path;
                boolean bl3 = false;
                bl = Files.deleteIfExists(p0);
            } else {
                bl = null;
            }
            object = Result.constructor-impl(bl);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void closeStreams(Process p) {
        Object object;
        Object $this$closeStreams_u24lambda_u241;
        Object $this$closeStreams_u24lambda_u240;
        KernelProcessKiller kernelProcessKiller = this;
        try {
            Unit unit;
            $this$closeStreams_u24lambda_u240 = kernelProcessKiller;
            boolean bl = false;
            OutputStream outputStream = p.getOutputStream();
            if (outputStream != null) {
                outputStream.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$closeStreams_u24lambda_u240 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            $this$closeStreams_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        kernelProcessKiller = this;
        try {
            Unit unit;
            $this$closeStreams_u24lambda_u241 = kernelProcessKiller;
            boolean bl = false;
            InputStream inputStream = p.getInputStream();
            if (inputStream != null) {
                inputStream.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$closeStreams_u24lambda_u241 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            $this$closeStreams_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        kernelProcessKiller = this;
        try {
            Unit unit;
            KernelProcessKiller $this$closeStreams_u24lambda_u242 = kernelProcessKiller;
            boolean bl = false;
            InputStream inputStream = p.getErrorStream();
            if (inputStream != null) {
                inputStream.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void killChildren(Process process) {
        long pid = process.pid();
        if (OS.CURRENT == OS.Windows) {
            String[] stringArray = new String[]{"taskkill", "/PID", String.valueOf(pid), "/T", "/F"};
            Runtime.getRuntime().exec(stringArray).waitFor();
            return;
        }
        ProcessHandle processHandle = ProcessHandle.of(pid).orElse(null);
        if (processHandle == null) {
            return;
        }
        ProcessHandle h = processHandle;
        h.descendants().forEach(arg_0 -> KernelProcessKiller.killChildren$lambda$1(arg_0 -> KernelProcessKiller.killChildren$lambda$0(this, arg_0), arg_0));
    }

    private final void killSelf(Process process) {
        Object object;
        String[] stringArray;
        Object $this$killSelf_u24lambda_u241;
        KernelProcessKiller kernelProcessKiller = this;
        try {
            KernelProcessKiller $this$killSelf_u24lambda_u240 = kernelProcessKiller;
            boolean bl = false;
            process.destroy();
            Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (process.waitFor(1000L, TimeUnit.MILLISECONDS)) {
            return;
        }
        long pid = process.pid();
        if (OS.CURRENT == OS.Windows) {
            String[] stringArray2 = new String[]{"taskkill", "/PID", String.valueOf(pid), "/T", "/F"};
            Runtime.getRuntime().exec(stringArray2).waitFor();
            process.waitFor(1000L, TimeUnit.MILLISECONDS);
            return;
        }
        KernelProcessKiller kernelProcessKiller2 = this;
        try {
            $this$killSelf_u24lambda_u241 = kernelProcessKiller2;
            boolean bl = false;
            stringArray = new String[]{"kill", "-TERM", String.valueOf(pid)};
            $this$killSelf_u24lambda_u241 = Result.constructor-impl((Object)Runtime.getRuntime().exec(stringArray).waitFor());
        }
        catch (Throwable bl) {
            $this$killSelf_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        if (process.waitFor(1L, TimeUnit.SECONDS)) {
            return;
        }
        kernelProcessKiller2 = this;
        try {
            KernelProcessKiller $this$killSelf_u24lambda_u242 = kernelProcessKiller2;
            boolean bl = false;
            stringArray = new String[]{"kill", "-9", String.valueOf(pid)};
            object = Result.constructor-impl((Object)Runtime.getRuntime().exec(stringArray).waitFor());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final Unit killChildren$lambda$0(KernelProcessKiller this$0, ProcessHandle child) {
        Object $this$killChildren_u24lambda_u240_u240;
        KernelProcessKiller kernelProcessKiller = this$0;
        try {
            $this$killChildren_u24lambda_u240_u240 = kernelProcessKiller;
            boolean bl = false;
            $this$killChildren_u24lambda_u240_u240 = Result.constructor-impl((Object)child.destroy());
        }
        catch (Throwable bl) {
            $this$killChildren_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        if (child.isAlive()) {
            Object object;
            kernelProcessKiller = this$0;
            try {
                KernelProcessKiller $this$killChildren_u24lambda_u240_u241 = kernelProcessKiller;
                boolean bl = false;
                object = Result.constructor-impl((Object)child.destroyForcibly());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void killChildren$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/execution/kernel/KernelProcessKiller$Companion;", "", "<init>", "()V", "KILL_TIMEOUT_MS", "", "intellij.jupyter.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

