/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.toolwindow;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.execution.toolwindow.KernelProcessToolWindowBuilderKt;
import com.intellij.jupyter.execution.toolwindow.KernelRunnableToolWindowSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\u00182\b\b\u0001\u0010\u001a\u001a\u00020\u0005H\u0004J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/execution/toolwindow/KernelProcessToolWindowBuilder;", "", "settings", "Lcom/intellij/jupyter/execution/toolwindow/KernelRunnableToolWindowSettings;", "title", "", "helpId", "<init>", "(Lcom/intellij/jupyter/execution/toolwindow/KernelRunnableToolWindowSettings;Ljava/lang/String;Ljava/lang/String;)V", "getSettings", "()Lcom/intellij/jupyter/execution/toolwindow/KernelRunnableToolWindowSettings;", "getHelpId", "()Ljava/lang/String;", "uiParent", "Lcom/intellij/openapi/Disposable;", "getUiParent", "()Lcom/intellij/openapi/Disposable;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "getUi", "()Lcom/intellij/execution/ui/RunnerLayoutUi;", "leftToolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createMainContent", "Lcom/intellij/ui/content/Content;", "createConsoleContent", "tabTitle", "collectContentTabs", "", "intellij.jupyter.execution"})
@SourceDebugExtension(value={"SMAP\nKernelProcessToolWindowBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelProcessToolWindowBuilder.kt\ncom/intellij/jupyter/execution/toolwindow/KernelProcessToolWindowBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n37#2,2:84\n*S KotlinDebug\n*F\n+ 1 KernelProcessToolWindowBuilder.kt\ncom/intellij/jupyter/execution/toolwindow/KernelProcessToolWindowBuilder\n*L\n45#1:84,2\n*E\n"})
public abstract class KernelProcessToolWindowBuilder {
    @NotNull
    private final KernelRunnableToolWindowSettings settings;
    @NotNull
    private final String title;
    @NotNull
    private final String helpId;
    @NotNull
    private final Disposable uiParent;
    @NotNull
    private final RunnerLayoutUi ui;

    public KernelProcessToolWindowBuilder(@NotNull KernelRunnableToolWindowSettings settings, @NlsSafe @NotNull String title, @NotNull String helpId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)helpId, (String)"helpId");
        this.settings = settings;
        this.title = title;
        this.helpId = helpId;
        Disposable disposable = Disposer.newDisposable((String)("Kernel UI " + this.helpId));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.uiParent = disposable;
        RunnerLayoutUi runnerLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)this.settings.getProject()).create(this.helpId, this.title, this.title, this.uiParent);
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi, (String)"create(...)");
        this.ui = runnerLayoutUi;
    }

    @NotNull
    protected final KernelRunnableToolWindowSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final String getHelpId() {
        return this.helpId;
    }

    @NotNull
    protected final Disposable getUiParent() {
        return this.uiParent;
    }

    @NotNull
    protected final RunnerLayoutUi getUi() {
        return this.ui;
    }

    @NotNull
    protected final ActionGroup leftToolbarActions() {
        AnAction stopAction = ActionManager.getInstance().getAction("JupyterShutdownNotebookAction");
        AnAction[] anActionArray = new AnAction[]{stopAction};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    public final Content createMainContent() {
        Collection $this$toTypedArray$iv = this.collectContentTabs();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Content[] contentArray = thisCollection$iv.toArray(new Content[0]);
        KernelProcessToolWindowBuilderKt.addNotebookTabsContent(this.ui, Arrays.copyOf(contentArray, contentArray.length));
        Content content = ContentFactory.getInstance().createContent(this.ui.getComponent(), this.title, true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content mainContent = content;
        Content[] contentArray2 = this.ui.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray2, (String)"getContents(...)");
        for (Content childContent : contentArray2) {
            Disposer.register((Disposable)((Disposable)mainContent), (Disposable)((Disposable)childContent));
        }
        Disposer.register((Disposable)((Disposable)mainContent), (Disposable)this.uiParent);
        mainContent.setCloseable(false);
        mainContent.setHelpId(this.helpId);
        return mainContent;
    }

    @NotNull
    protected final Content createConsoleContent(@Nls @NotNull String tabTitle) {
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        BackedNotebookVirtualFile notebookFile = this.settings.notebookVirtualFile();
        Project project = this.settings.getProject();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.settings.getProject());
        ConsoleViewImpl console2 = new ConsoleViewImpl(notebookFile, project, globalSearchScope){
            final /* synthetic */ BackedNotebookVirtualFile $notebookFile;
            {
                this.$notebookFile = $notebookFile;
                Intrinsics.checkNotNull((Object)$super_call_param$2);
                super($super_call_param$1, $super_call_param$2, true, true);
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                sink.set(JupyterHelper.INSTANCE.getFORCED_NOTEBOOK(), (Object)this.$notebookFile);
            }
        };
        ComponentWithActions.Impl consoleComponent = new ComponentWithActions.Impl(this.leftToolbarActions(), null, console2.getComponent(), null, console2.getComponent());
        this.settings.consoleWindowCreated(console2);
        Content content = this.ui.createContent(this.helpId + ".Console", (ComponentWithActions)consoleComponent, tabTitle, null, UiUtils.getPreferredFocusedComponent((JComponent)((JComponent)console2)));
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        return content;
    }

    @NotNull
    protected abstract List<Content> collectContentTabs();
}

