/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.ex;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteTempDirParamProvider
implements ConsoleRunContextParametersTuner {
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        if (project == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(1);
        }
        if (params == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(2);
        }
        if (dataSource.getDbms() != Dbms.SQLITE) {
            return;
        }
        if (Boolean.FALSE.equals(DbOptionProvider.getOptionValue((Object)dataSource, Option.class))) {
            return;
        }
        DatabaseArtifactList.ArtifactVersion artifact = SqliteTempDirParamProvider.getSqliteArtifact(dataSource);
        Path jarPath = artifact == null ? null : SqliteTempDirParamProvider.getSqliteJarPath(dataSource, project);
        Path jarFile = jarPath == null ? new File("xerial").toPath() : jarPath;
        Path path = DatabaseArtifactLoader.getInstance().getUnpackedPath(jarFile, artifact, DatabaseArtifactContext.Companion.getInstance(project, dataSource.getDatabaseDriver())).resolve("libs");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ParametersList vmParams = params.getVMParametersList();
        vmParams.addProperty("org.sqlite.tmpdir", EelNioBridgeServiceKt.asEelPath((Path)path).toString());
    }

    @NotNull
    private static Path getSqliteJarPath(@NotNull LocalDataSource dataSource, @NotNull Project project) {
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(4);
        }
        String path = (String)JBIterable.from((Iterable)DatabaseDriverClasspathManager.Companion.getInstance(project).getClasspathElements(dataSource)).flatten(e -> e.getClassesRootUrls()).find(p -> {
            String name = PathUtil.getFileName((String)p);
            return StringUtil.containsIgnoreCase((String)name, (String)"sqlite") || StringUtil.containsIgnoreCase((String)name, (String)"xerial");
        });
        Path path2 = Path.of(path.replace("file://", ""), new String[0]);
        if (path2 == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(5);
        }
        return path2;
    }

    @Nullable
    private static DatabaseArtifactList.ArtifactVersion getSqliteArtifact(@NotNull LocalDataSource dataSource) {
        DatabaseDriver driver;
        DatabaseDriver.ArtifactRef ar;
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(6);
        }
        DatabaseDriver.ArtifactRef artifactRef = ar = (driver = dataSource.getDatabaseDriver()) == null ? null : (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)driver.getArtifacts(), a -> a.getId().equals("Xerial SQLiteJDBC"));
        if (ar == null || ar.getArtifactVersion() == null) {
            return null;
        }
        DatabaseArtifactList.Artifact artifact = new DatabaseArtifactList.Artifact(ar.getId(), ar.getId());
        return new DatabaseArtifactList.ArtifactVersion(artifact, ar.getArtifactVersion(), Collections.emptyList(), Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/ex/SqliteTempDirParamProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/ex/SqliteTempDirParamProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqliteJarPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tuneParams";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSqliteJarPath";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSqliteArtifact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static final class Option
    extends DbOptionProvider.LocalDataSourceOptionProvider<Boolean> {
        private static final String KEY = "sqlite.override.lib.location";

        public boolean isApplicable(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Option.$$$reportNull$$$0(0);
            }
            return dataSource.getDbms() == Dbms.SQLITE;
        }

        @Nls
        public String getDisplayName() {
            return DatabaseBundle.message((String)"sqlite.override.native.lib.location", (Object[])new Object[0]);
        }

        @Nls
        public String getDescription() {
            return DatabaseBundle.message((String)"sqlite.use.ide.system.folder.to.unpack.native.library", (Object[])new Object[0]);
        }

        public Boolean load(@Nullable LocalDataSource dataSource) {
            String v;
            String string = v = dataSource == null ? null : dataSource.getAdditionalProperty(KEY);
            if (v == null) {
                return Option.getDefault();
            }
            return !"false".equals(v);
        }

        public void store(@NotNull LocalDataSource dataSource, Boolean value) {
            if (dataSource == null) {
                Option.$$$reportNull$$$0(1);
            }
            dataSource.setAdditionalProperty(KEY, Boolean.valueOf(!Option.getDefault()).equals(value) ? value.toString() : null);
        }

        @NotNull
        public DbOptionProvider.UiLocation getLocation() {
            DbOptionProvider.UiLocation uiLocation = DbOptionProvider.UiLocation.EXPERT;
            if (uiLocation == null) {
                Option.$$$reportNull$$$0(2);
            }
            return uiLocation;
        }

        private static boolean getDefault() {
            return true;
        }

        public DbOptionProvider.EditorDesc<Boolean> getEditor(LocalDataSource target, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                Option.$$$reportNull$$$0(3);
            }
            return DbOptionProvider.getCheckBox((Boolean)Option.getDefault());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/sqlite/ex/SqliteTempDirParamProvider$Option";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/sqlite/ex/SqliteTempDirParamProvider$Option";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "store";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

