/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0011\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007*\u00020\u0002H\u0002\u001a\u0011\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007*\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"insertAtCursor", "", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "string", "", "backspace", "getRemainingLinePart", "Lcom/intellij/openapi/util/NlsSafe;", "getTextAfterCursor", "intellij.terminal.frontend"})
public final class TerminalTypeAheadOutputModelControllerKt {
    private static final void insertAtCursor(TerminalOutputModel $this$insertAtCursor, String string) {
        $this$insertAtCursor.withTypeAhead((Function0<Unit>)((Function0)() -> TerminalTypeAheadOutputModelControllerKt.insertAtCursor$lambda$0($this$insertAtCursor, string)));
    }

    private static final void backspace(TerminalOutputModel $this$backspace) {
        int offset = ((TerminalOffset)$this$backspace.getCursorOffsetState().getValue()).toRelative();
        if (offset < 1) {
            return;
        }
        TerminalOffset replaceOffset = $this$backspace.relativeOffset(offset - 1);
        $this$backspace.replaceContent(replaceOffset, 1, " ", CollectionsKt.emptyList());
        $this$backspace.updateCursorPosition(replaceOffset);
    }

    private static final String getRemainingLinePart(TerminalOutputModel $this$getRemainingLinePart) {
        int cursorOffset = ((TerminalOffset)$this$getRemainingLinePart.getCursorOffsetState().getValue()).toRelative();
        Document document = $this$getRemainingLinePart.getDocument();
        int line = document.getLineNumber(cursorOffset);
        int lineEnd = document.getLineEndOffset(line);
        String string = document.getText(new TextRange(cursorOffset, lineEnd));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String remainingLinePart = string;
        return remainingLinePart;
    }

    private static final String getTextAfterCursor(TerminalOutputModel $this$getTextAfterCursor) {
        int cursorOffset = ((TerminalOffset)$this$getTextAfterCursor.getCursorOffsetState().getValue()).toRelative();
        String string = $this$getTextAfterCursor.getDocument().getText(new TextRange(cursorOffset, $this$getTextAfterCursor.getDocument().getTextLength()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit insertAtCursor$lambda$0(TerminalOutputModel $this_insertAtCursor, String $string) {
        String remainingLinePart = TerminalTypeAheadOutputModelControllerKt.getRemainingLinePart($this_insertAtCursor);
        int replaceLength = RangesKt.coerceAtMost((int)$string.length(), (int)remainingLinePart.length());
        TerminalOffset replaceOffset = (TerminalOffset)$this_insertAtCursor.getCursorOffsetState().getValue();
        $this_insertAtCursor.replaceContent(replaceOffset, replaceLength, $string, CollectionsKt.emptyList());
        TerminalOffset newCursorOffset = (TerminalOffset)RangesKt.coerceAtMost((Comparable)$this_insertAtCursor.absoluteOffset(replaceOffset.toAbsolute() + (long)$string.length()), (Comparable)$this_insertAtCursor.relativeOffset($this_insertAtCursor.getDocument().getTextLength()));
        $this_insertAtCursor.updateCursorPosition(newCursorOffset);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getTextAfterCursor(TerminalOutputModel $receiver) {
        return TerminalTypeAheadOutputModelControllerKt.getTextAfterCursor($receiver);
    }

    public static final /* synthetic */ void access$insertAtCursor(TerminalOutputModel $receiver, String string) {
        TerminalTypeAheadOutputModelControllerKt.insertAtCursor($receiver, string);
    }

    public static final /* synthetic */ void access$backspace(TerminalOutputModel $receiver) {
        TerminalTypeAheadOutputModelControllerKt.backspace($receiver);
    }
}

