/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.terminal.frontend.TerminalSearchController;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.BlockTerminalController;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H&J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalSearchActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeForTerminal", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "doWithBlockController", "blockController", "Lorg/jetbrains/plugins/terminal/block/BlockTerminalController;", "doWithReworkedController", "searchController", "Lcom/intellij/terminal/frontend/TerminalSearchController;", "isEnabledForCaret", "", "intellij.terminal.frontend"})
public abstract class TerminalSearchActionHandler
extends EditorActionHandler {
    @Nullable
    private final EditorActionHandler originalHandler;

    public TerminalSearchActionHandler(@Nullable EditorActionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    public final void executeForTerminal(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.doExecute(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        block1: {
            block2: {
                TerminalSearchController reworkedController;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                    BlockTerminalController blockController = TerminalDataContextUtils.INSTANCE.getBlockTerminalController(dataContext);
                    reworkedController = TerminalFrontendDataContextUtils.INSTANCE.getTerminalSearchController(dataContext);
                    if (blockController == null) break block0;
                    this.doWithBlockController(blockController);
                    break block1;
                }
                if (reworkedController == null) break block2;
                this.doWithReworkedController(editor, reworkedController);
                break block1;
            }
            EditorActionHandler editorActionHandler = this.originalHandler;
            if (editorActionHandler == null) break block1;
            editorActionHandler.execute(editor, caret, dataContext);
        }
    }

    public abstract void doWithBlockController(@NotNull BlockTerminalController var1);

    public abstract void doWithReworkedController(@NotNull Editor var1, @NotNull TerminalSearchController var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) return true;
        if (TerminalDataContextUtils.INSTANCE.isOutputEditor(editor)) return true;
        if (TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor)) return true;
        if (TerminalDataContextUtils.INSTANCE.isAlternateBufferModelEditor(editor)) return true;
        EditorActionHandler editorActionHandler = this.originalHandler;
        if (editorActionHandler == null) return false;
        if (!editorActionHandler.isEnabled(editor, caret, dataContext)) return false;
        return true;
    }
}

