/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.ui;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

public final class TerminalContainer {
    @ApiStatus.Internal
    @NotNull
    public static final DataKey<TerminalWidget> TERMINAL_WIDGET_DATA_KEY = DataKey.create((String)"terminalWidget");
    private final Content myContent;
    private final TerminalWidget myTerminalWidget;
    private final Project myProject;
    private final TerminalToolWindowManager myTerminalToolWindowManager;
    @Nullable
    private TerminalWrapperPanel myWrapperPanel;
    private boolean myForceHideUiWhenSessionEnds;

    public TerminalContainer(@NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget, @NotNull TerminalToolWindowManager terminalToolWindowManager) {
        if (project == null) {
            TerminalContainer.$$$reportNull$$$0(0);
        }
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(1);
        }
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(2);
        }
        if (terminalToolWindowManager == null) {
            TerminalContainer.$$$reportNull$$$0(3);
        }
        this.myForceHideUiWhenSessionEnds = false;
        this.myProject = project;
        this.myContent = content;
        this.myTerminalWidget = terminalWidget;
        this.myTerminalToolWindowManager = terminalToolWindowManager;
        terminalWidget.addTerminationCallback(() -> ApplicationManager.getApplication().invokeLater(() -> this.processSessionCompleted(), this.myProject.getDisposed()), (Disposable)terminalWidget);
        terminalToolWindowManager.register(this);
        Disposer.register((Disposable)content, () -> this.myTerminalToolWindowManager.unregister(this));
    }

    @NotNull
    public TerminalWidget getTerminalWidget() {
        TerminalWidget terminalWidget = this.myTerminalWidget;
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(4);
        }
        return terminalWidget;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(5);
        }
        return content;
    }

    public void closeAndHide() {
        this.myForceHideUiWhenSessionEnds = true;
        TtyConnector connector = this.myTerminalWidget.getTtyConnector();
        if (connector != null && connector.isConnected()) {
            connector.close();
        } else {
            this.processSessionCompleted();
        }
    }

    @NotNull
    public JPanel getWrapperPanel() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new TerminalWrapperPanel(this);
        }
        TerminalWrapperPanel terminalWrapperPanel = this.myWrapperPanel;
        if (terminalWrapperPanel == null) {
            TerminalContainer.$$$reportNull$$$0(6);
        }
        return terminalWrapperPanel;
    }

    private void processSessionCompleted() {
        if (this.myForceHideUiWhenSessionEnds || TerminalOptionsProvider.getInstance().getCloseSessionOnLogout()) {
            this.myTerminalToolWindowManager.closeTab(this.myContent);
        } else {
            String text = TerminalContainer.getSessionCompletedMessage(this.myTerminalWidget);
            this.myTerminalWidget.writePlainMessage("\n" + text + "\n");
            this.myTerminalWidget.setCursorVisible(false);
        }
    }

    @NotNull
    @Nls
    private static String getSessionCompletedMessage(@NotNull TerminalWidget widget) {
        if (widget == null) {
            TerminalContainer.$$$reportNull$$$0(7);
        }
        String text = "[" + TerminalBundle.message("session.terminated.text", new Object[0]) + "]";
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        if (connector != null) {
            Integer exitCode2 = null;
            try {
                exitCode2 = connector.getProcess().exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            String string = text + "\n[" + IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode2 != null ? exitCode2 : "unknown"}) + "]";
            if (string == null) {
                TerminalContainer.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            TerminalContainer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalToolWindowManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionCompletedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSessionCompletedMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class TerminalWrapperPanel
    extends JPanel
    implements UiDataProvider {
        private TerminalContainer myTerminal;

        private TerminalWrapperPanel(@NotNull TerminalContainer terminal) {
            if (terminal == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.setBorder(null);
            this.setFocusable(false);
            this.setChildTerminal(terminal);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(1);
            }
            if (this.myTerminal != null) {
                sink.set(TERMINAL_WIDGET_DATA_KEY, (Object)this.myTerminal.getTerminalWidget());
            }
        }

        private void setChildTerminal(@NotNull TerminalContainer terminal) {
            if (terminal == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(2);
            }
            if (this.myTerminal != null) {
                throw new IllegalStateException("Cannot set a new terminal when another terminal is still set");
            }
            this.myTerminal = terminal;
            this.myTerminal.myWrapperPanel = this;
            this.setChildComponent(terminal.myTerminalWidget.getComponent());
        }

        private void setChildComponent(@NotNull Component childComponent) {
            Container parent;
            if (childComponent == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(3);
            }
            if ((parent = childComponent.getParent()) != null) {
                parent.remove(childComponent);
            }
            this.removeAll();
            this.add(childComponent, "Center");
            this.revalidate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childComponent";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer$TerminalWrapperPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setChildTerminal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setChildComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

