/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0013\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/commit/CommitTabTitleUpdater;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "tabName", "", "defaultTitle", "Lkotlin/Function0;", "Lorg/jetbrains/annotations/Nls;", "pathsProvider", "", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "getTabName", "()Ljava/lang/String;", "getDefaultTitle", "()Lkotlin/jvm/functions/Function0;", "branchComponent", "Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "start", "", "updateTab", "setDefaultTitle", "dispose", "getTab", "Lcom/intellij/ui/content/Content;", "Companion", "intellij.platform.vcs.impl"})
public class CommitTabTitleUpdater
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final String tabName;
    @NotNull
    private final Function0<String> defaultTitle;
    @NotNull
    private final CurrentBranchComponent branchComponent;

    /*
     * WARNING - void declaration
     */
    public CommitTabTitleUpdater(@NotNull ChangesTree tree, @NotNull String tabName, @NotNull Function0<String> defaultTitle, @NotNull Function0<? extends Iterable<? extends FilePath>> pathsProvider) {
        void it;
        CurrentBranchComponent currentBranchComponent;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter(defaultTitle, (String)"defaultTitle");
        Intrinsics.checkNotNullParameter(pathsProvider, (String)"pathsProvider");
        this.tree = tree;
        this.tabName = tabName;
        this.defaultTitle = defaultTitle;
        CurrentBranchComponent currentBranchComponent2 = currentBranchComponent = new CurrentBranchComponent(this.tree, pathsProvider);
        CommitTabTitleUpdater commitTabTitleUpdater = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        commitTabTitleUpdater.branchComponent = currentBranchComponent;
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    @NotNull
    public final String getTabName() {
        return this.tabName;
    }

    @NotNull
    public final Function0<String> getDefaultTitle() {
        return this.defaultTitle;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    public void start() {
        UiNotifyConnector.Companion.doWhenFirstShown((Component)this.tree, () -> CommitTabTitleUpdater.start$lambda$0(this), (Disposable)this);
        this.branchComponent.addChangeListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((CommitTabTitleUpdater)this.receiver).updateTab();
            }
        }), this);
        Disposer.register((Disposable)this, () -> CommitTabTitleUpdater.start$lambda$1(this));
    }

    public void updateTab() {
        Content content = this.getTab();
        if (content == null) {
            return;
        }
        Content tab = content;
        tab.setDisplayName(Companion.getDisplayTabName(this.getProject(), this.tabName, this.branchComponent.getText()));
        tab.setDescription(this.branchComponent.getToolTipText());
    }

    private final void setDefaultTitle() {
        Content content = this.getTab();
        if (content == null) {
            return;
        }
        Content tab = content;
        tab.setDisplayName((String)this.defaultTitle.invoke());
        tab.setDescription(null);
    }

    public void dispose() {
    }

    private final Content getTab() {
        return ChangesViewContentManager.Companion.getInstance(this.getProject()).findContent(this.tabName);
    }

    private static final void start$lambda$0(CommitTabTitleUpdater this$0) {
        this$0.updateTab();
    }

    private static final void start$lambda$1(CommitTabTitleUpdater this$0) {
        this$0.setDefaultTitle();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/commit/CommitTabTitleUpdater$Companion;", "", "<init>", "()V", "getDisplayTabName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "project", "Lcom/intellij/openapi/project/Project;", "tabName", "branch", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getDisplayTabName(@NotNull Project project, @NotNull String tabName, @Nullable String branch) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
            if (ExperimentalUI.Companion.isNewUI()) {
                int contentsCount;
                ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(project, tabName);
                int n = toolWindow != null && (toolWindow = toolWindow.getContentManager()) != null ? toolWindow.getContentCount() : (contentsCount = 0);
                if (contentsCount == 1) {
                    return null;
                }
                return VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]);
            }
            String string = branch;
            boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
            if (bl) {
                Object[] objectArray = new Object[]{branch};
                return VcsBundle.message((String)"tab.title.commit.to.branch", (Object[])objectArray);
            }
            return VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

