/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportBuilder;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PgBaseImportBuilder;
import com.intellij.sql.dialects.postgres.PgDateTimeLanguageHelper;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateDomainStatement;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends SqlLanguageDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    public static boolean inPl(PsiElement element) {
        return SqlFileElementType.isInPl((PsiElement)element);
    }

    public final ReservedEntity getNewTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias;
    }

    public final ReservedEntity getOldTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias;
    }

    public final Map<String, ReservedEntity> getTriggerStringImplicits() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerStringImplicits;
    }

    public final ReservedEntity getTriggerNArgsColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerNArgsColumn;
    }

    public final ReservedEntity getTriggerArgVColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerArgVColumn;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"dpn", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"bigint", (String)"bigint", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"numeric", (String)"numeric", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"dp", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"bytea", (String)"bytea", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"name", (String)"name", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"oid", (String)"oid", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"gobject", (String)"geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"circle", (String)"circle", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"path", (String)"path", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"box", (String)"box", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"polygon", (String)"polygon", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"lseg", (String)"lseg", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"point", (String)"point", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"line", (String)"line", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"cidr", (String)"cidr", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"inet", (String)"inet", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"macaddr", (String)"macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tsvector", (String)"tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tsquery", (String)"tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"trigger", (String)"trigger", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"range", (String)"range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int4range", (String)"int4range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int4multirange", (String)"int4multirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int8range", (String)"int8range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int8multirange", (String)"int8multirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"numrange", (String)"numrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"nummultirange", (String)"nummultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tsrange", (String)"tsrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tsmultirange", (String)"tsmultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tstzrange", (String)"tstzrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"tstzmultirange", (String)"tstzmultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"daterange", (String)"daterange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"datemultirange", (String)"datemultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"txid_snapshot", (String)"txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"void", (String)"void", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"record", (String)"record", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"enum", (String)"enum", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"xml", (String)"xml", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"float4", (String)"float4", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int2vector", (String)"int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"json", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"jsonb", (String)"jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"jsonpath", (String)"jsonpath", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"regclass", (String)"regclass", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"regdictionary", (String)"regdictionary", (SqlLanguageDialectEx)this);
    }

    protected PgDialectBase(@NotNull String id) {
        if (id == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        BuiltinFunction definition;
        SqlReferenceExpression ref;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        SqlExpression qualifier = (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
        boolean isFunctionCall = place.getParent() instanceof SqlFunctionCallExpression;
        BuiltinFunction builtinFunction = definition = name2 == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name2);
        if (definition != null) {
            for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
                DasType type;
                if (prototype.getParams().length != 1 || processor.executeTarget((DasSymbol)definition, type = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType((BuiltinFunction.Prototype)prototype, (SqlReferenceExpression)ref, (PsiElement)qualifier, (PsiElement)ref), null, ResolveState.initial())) continue;
                return false;
            }
        }
        DasTypeSystemBase typeSystem = this.getTypeSystem();
        LazyInstanceData data = (LazyInstanceData)this.myInstanceData.getValue();
        if (PgDialectBase.inPl(place) && SqlImplUtil.getQualifier((PsiElement)place) == null) {
            if (!PgDialectBase.processReservedEntitiesWithTypeSimple((ReservedEntity)data.myFoundColumn, (DasType)typeSystem.getBooleanType(), (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                return false;
            }
            if (PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlExceptionWhenClause.class}) != null) {
                if (!PgDialectBase.processReservedEntitiesWithTypeSimple((ReservedEntity)data.mySqlStateColumn, (DasType)typeSystem.getStringType(), (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
                if (!PgDialectBase.processReservedEntitiesWithTypeSimple((ReservedEntity)data.mySqlErrmColumn, (DasType)typeSystem.getStringType(), (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
            }
        }
        return !PgDialectBase.inIndexExpression(place) && !PgDialectBase.inDomainCheck(place) || processor.executeTarget((DasSymbol)data.myValueColumn, (DasType)DasTypeSystemBase.UNKNOWN, Boolean.valueOf(false), ResolveState.initial());
    }

    private static boolean inIndexExpression(@NotNull PsiElement place) {
        SqlReferenceList refList;
        SqlOnTargetClauseImpl onTargetClause;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        return (onTargetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getParentOfType((PsiElement)(refList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)place, SqlReferenceList.class)), SqlOnTargetClauseImpl.class)) != null && onTargetClause.getParent() instanceof SqlCreateIndexStatement;
    }

    private static boolean inDomainCheck(@NotNull PsiElement place) {
        SqlConstraintDefinition constraint;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        return (constraint = (SqlConstraintDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, SqlConstraintDefinition.class)) != null && constraint.getKind() == ObjectKind.CHECK && constraint.getParent() instanceof SqlCreateDomainStatement;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        PsiElement place = ref.getElement();
        if (processor.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params == null ? Collections.emptyList() : params.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getDasType(), SqlTableType.class);
                if (type == null) {
                    return true;
                }
                Set expected = processor.getInitialExpectedTypes();
                processor.setExpectedKinds(Collections.singleton(ObjectKind.COLUMN));
                boolean res = SqlImplUtil.processDeclarationsInType((SqlTableType)type, (SqlScopeProcessor)processor, (ResolveState)state, (PsiElement)place);
                processor.setExpectedKinds(expected);
                if (!res) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        DasSymbol qualifierSymbol;
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        if (state == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.VARIABLE}) && qualifier instanceof SqlReferenceExpression && ((qualifierSymbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) == ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias || qualifierSymbol == ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias)) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref), null, Boolean.valueOf(false), state);
        }
        if (!processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor.getReferenceName() == null && qualifier.getDasType() == DasTypeSystemBase.UNKNOWN) {
            return true;
        }
        if (DasTypeUtilsKt.getCategory((DasType)qualifier.getDasType()) == DasTypeCategory.RECORD) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref), (DasType)DasTypeSystemBase.UNKNOWN, Boolean.valueOf(false), state);
        }
        SqlScopeProcessorBase filteringProcessor = PgDialectBase.filterSingleArgumentRoutines(processor);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants((SqlScopeProcessor)filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor, state, ref, qualifier);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        if (type == ObjectKind.COLUMN) {
            result.add((ObjectKind)ObjectKind.COLUMN);
        }
        return (T)super.getParentDbTypes(result, type);
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        PgDateTimeLanguageHelper pgDateTimeLanguageHelper = PgDateTimeLanguageHelper.INSTANCE;
        if (pgDateTimeLanguageHelper == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        return pgDateTimeLanguageHelper;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (strict) {
            return false;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.AGGREGATE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(type) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            DasObject o;
            DasObject dasObject = o = symbol != null ? symbol.getDasObject() : null;
            if (place == null || !(o instanceof PsiObject) || !PsiTreeUtil.isContextAncestor((PsiElement)((PsiObject)o), (PsiElement)place, (boolean)true)) {
                return true;
            }
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable = false;
            if (type == SqlDbElementType.LOCAL_ALIAS) {
                if (symbol == null) {
                    isTable = true;
                } else if (symbol instanceof SqlNamedQueryDefinitionImpl) {
                    isTable = true;
                } else if (symbol instanceof SqlAsExpression) {
                    SqlAsExpression alias = (SqlAsExpression)symbol;
                    if (!this.getDbms().isRedshift() || !(alias.getDasType() instanceof SqlTableType)) {
                        PsiElement parent = alias.getParent();
                        isTable = parent instanceof SqlFromClause || parent instanceof SqlJoinExpression;
                    }
                }
            } else if (type == ObjectKind.TABLE && !this.getDbms().isRedshift()) {
                boolean bl = isTable = PsiTreeUtil.getParentOfType((PsiElement)place, SqlResultSetExpression.class) != null;
            }
            if (isTable) {
                SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref == null || ref.getQualifierExpression() == null;
            }
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    private static SqlScopeProcessorBase filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessorBase processor = new SqlScopeProcessorBase(sqlProcessor.getReferenceName(), (SqlLanguageDialectEx)sqlProcessor.getDialect(), sqlProcessor.getDataSources(), sqlProcessor.getPlace()){

            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine((DasObject)symbol.getDasObject()) || sqlProcessor.executeTarget(symbol, dasType, forcedCaseSens, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PgDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setExpectedKinds(Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessorBase sqlScopeProcessorBase = processor;
        if (sqlScopeProcessorBase == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        return sqlScopeProcessorBase;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PgDialectBase.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas = SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.first), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames((DbDataSource)dataSource), SqlDialectImplUtilCore.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.second), (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])schemas))));
        if (treePattern == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        return treePattern;
    }

    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            PgDialectBase.$$$reportNull$$$0(16);
        }
        return expression.getReferenceElementType() == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE || super.isMultiIdReference(expression);
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            PgDialectBase.$$$reportNull$$$0(17);
        }
        if (text == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        return SqlLexer.isValidRawCopyToken((CharSequence)text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean requiresAsForAliasAt(@NotNull PsiElement element) {
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlInsertStatement.class}) != null;
    }

    @NotNull
    public SqlImportBuilder getImportBuilder() {
        PgBaseImportBuilder pgBaseImportBuilder = PgBaseImportBuilder.INSTANCE;
        if (pgBaseImportBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(20);
        }
        return pgBaseImportBuilder;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper((SqlLanguageDialectEx)this);
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = PgDialectBase.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = PgDialectBase.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            DasObject parent;
            if (namespace.getKind() == ObjectKind.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent = namespace.getDasParent()) != null && parent.getKind() == ObjectKind.DATABASE) {
                dbName = ObjectName.quoted((String)parent.getName());
            }
        }
        if (scName == null) {
            scName = PgDialect.LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Nullable
    protected static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig((DbDataSource)dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName((RawConnectionConfig)config), (Object)SqlDialectImplUtilCore.getUserName((RawConnectionConfig)config))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 15, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inIndexExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inDomainCheck";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 15, 20 -> new IllegalStateException(string);
        };
    }

    private class LazyInstanceData {
        private final ReservedEntity myNewTableAlias;
        private final ReservedEntity myOldTableAlias;
        private final Map<String, ReservedEntity> myTriggerStringImplicits;
        private final ReservedEntity myTriggerNArgsColumn;
        private final ReservedEntity myTriggerArgVColumn;
        private final ReservedEntity myFoundColumn;
        private final ReservedEntity mySqlStateColumn;
        private final ReservedEntity mySqlErrmColumn;
        private final ReservedEntity myValueColumn;

        private LazyInstanceData() {
            this.myNewTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "new", ObjectKind.TABLE);
            this.myOldTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "old", ObjectKind.TABLE);
            this.myTriggerStringImplicits = SqlDialectImplUtilCore.buildEntities((Dbms)PgDialectBase.this.getDbms(), (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event"});
            this.myTriggerNArgsColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_nargs", ObjectKind.COLUMN);
            this.myTriggerArgVColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_argv", ObjectKind.COLUMN);
            this.myFoundColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "FOUND", ObjectKind.COLUMN);
            this.mySqlStateColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLSTATE", ObjectKind.COLUMN);
            this.mySqlErrmColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLERRM", ObjectKind.COLUMN);
            this.myValueColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "VALUE", ObjectKind.COLUMN);
        }
    }
}

