/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u0010\u001a\u00020\u00052\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher;", "", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "configKey", "", "checkRelaxedNames", "activeEnvironments", "", "documentId", "", "<init>", "(Lcom/intellij/openapi/module/Module;ZLjava/lang/String;ZLjava/util/Set;I)V", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "MnConfigValueSearchKey", "MnConfigValueSearchParams", "MnConfigValueResult", "intellij.micronaut"})
public final class MnConfigValueSearcher {
    @NotNull
    private final Module module;
    private final boolean includeTests;
    @NotNull
    private final String configKey;
    private final boolean checkRelaxedNames;
    @NotNull
    private final Set<String> activeEnvironments;
    private final int documentId;

    public MnConfigValueSearcher(@NotNull Module module, boolean includeTests, @NotNull String configKey, boolean checkRelaxedNames, @NotNull Set<String> activeEnvironments, int documentId) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(activeEnvironments, (String)"activeEnvironments");
        this.module = module;
        this.includeTests = includeTests;
        this.configKey = configKey;
        this.checkRelaxedNames = checkRelaxedNames;
        this.activeEnvironments = activeEnvironments;
        this.documentId = documentId;
    }

    public /* synthetic */ MnConfigValueSearcher(Module module, boolean bl, String string, boolean bl2, Set set, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        this(module, bl, string, bl2, set, n);
    }

    @Nullable
    public final String findValueText() {
        CommonProcessors.FindFirstProcessor<MnConfigValueResult> processor2 = new CommonProcessors.FindFirstProcessor<MnConfigValueResult>(){

            protected boolean accept(MnConfigValueResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return result.getValueText() != null;
            }
        };
        this.process((Processor<? super MnConfigValueResult>)((Processor)processor2));
        MnConfigValueResult mnConfigValueResult = (MnConfigValueResult)processor2.getFoundValue();
        return mnConfigValueResult != null ? mnConfigValueResult.getValueText() : null;
    }

    public final boolean process(@NotNull Processor<? super MnConfigValueResult> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        MnConfigValueSearchKey searchKey = new MnConfigValueSearchKey(this.configKey, this.module);
        List<Pair<VirtualFile, MnConfigFileContributor>> configs = MnConfigFileContributor.Companion.findConfigFiles(this.module, this.includeTests, this.activeEnvironments);
        PsiManager psiManager = PsiManager.getInstance((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        for (Pair<VirtualFile, MnConfigFileContributor> config : configs) {
            PsiFile configPsiFile;
            if (psiManager2.findFile((VirtualFile)config.getFirst()) == null) continue;
            MnConfigValueSearchParams params = new MnConfigValueSearchParams(this.module, configPsiFile, this.documentId, this.checkRelaxedNames, this.activeEnvironments, searchKey);
            if (((MnConfigFileContributor)config.getSecond()).processConfigValues(params, processor2)) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J5\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "", "keyElement", "Lcom/intellij/psi/PsiElement;", "valueElement", "valueText", "", "params", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;)V", "getKeyElement", "()Lcom/intellij/psi/PsiElement;", "getValueElement", "getValueText", "()Ljava/lang/String;", "getParams", "()Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.micronaut"})
    public static final class MnConfigValueResult {
        @NotNull
        private final PsiElement keyElement;
        @Nullable
        private final PsiElement valueElement;
        @Nullable
        private final String valueText;
        @NotNull
        private final MnConfigValueSearchParams params;

        public MnConfigValueResult(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull MnConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
            this.params = params;
        }

        @NotNull
        public final PsiElement getKeyElement() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement getValueElement() {
            return this.valueElement;
        }

        @Nullable
        public final String getValueText() {
            return this.valueText;
        }

        @NotNull
        public final MnConfigValueSearchParams getParams() {
            return this.params;
        }

        @NotNull
        public final PsiElement component1() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement component2() {
            return this.valueElement;
        }

        @Nullable
        public final String component3() {
            return this.valueText;
        }

        @NotNull
        public final MnConfigValueSearchParams component4() {
            return this.params;
        }

        @NotNull
        public final MnConfigValueResult copy(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull MnConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new MnConfigValueResult(keyElement, valueElement, valueText, params);
        }

        public static /* synthetic */ MnConfigValueResult copy$default(MnConfigValueResult mnConfigValueResult, PsiElement psiElement, PsiElement psiElement2, String string, MnConfigValueSearchParams mnConfigValueSearchParams, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = mnConfigValueResult.keyElement;
            }
            if ((n & 2) != 0) {
                psiElement2 = mnConfigValueResult.valueElement;
            }
            if ((n & 4) != 0) {
                string = mnConfigValueResult.valueText;
            }
            if ((n & 8) != 0) {
                mnConfigValueSearchParams = mnConfigValueResult.params;
            }
            return mnConfigValueResult.copy(psiElement, psiElement2, string, mnConfigValueSearchParams);
        }

        @NotNull
        public String toString() {
            return "MnConfigValueResult(keyElement=" + this.keyElement + ", valueElement=" + this.valueElement + ", valueText=" + this.valueText + ", params=" + this.params + ")";
        }

        public int hashCode() {
            int result = this.keyElement.hashCode();
            result = result * 31 + (this.valueElement == null ? 0 : this.valueElement.hashCode());
            result = result * 31 + (this.valueText == null ? 0 : this.valueText.hashCode());
            result = result * 31 + this.params.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MnConfigValueResult)) {
                return false;
            }
            MnConfigValueResult mnConfigValueResult = (MnConfigValueResult)other;
            if (!Intrinsics.areEqual((Object)this.keyElement, (Object)mnConfigValueResult.keyElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueElement, (Object)mnConfigValueResult.valueElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueText, (Object)mnConfigValueResult.valueText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.params, (Object)mnConfigValueResult.params);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchKey;", "", "keyName", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;)V", "getKeyName", "()Ljava/lang/String;", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "getConfigKey", "()Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "parametrizedConfigKey", "Lcom/intellij/micronaut/config/MnParametrizedConfigKey;", "getParametrizedConfigKey", "()Lcom/intellij/micronaut/config/MnParametrizedConfigKey;", "parametrizedKey", "getParametrizedKey", "intellij.micronaut"})
    public static final class MnConfigValueSearchKey {
        @NotNull
        private final String keyName;
        @NotNull
        private final MetaConfigKey configKey;
        @Nullable
        private final MnParametrizedConfigKey parametrizedConfigKey;
        @Nullable
        private final String parametrizedKey;

        public MnConfigValueSearchKey(@NotNull String keyName, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.keyName = keyName;
            MetaConfigKey metaConfigKey = MnMetaConfigKeyManager.Companion.getInstance().findApplicationMetaConfigKey(module, this.keyName);
            if (metaConfigKey == null) {
                metaConfigKey = MnMetaConfigKeyManager.Companion.getInstance().createFakeConfigKey(module, this.keyName);
            }
            this.configKey = metaConfigKey;
            String string = this.configKey.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.parametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
            MnParametrizedConfigKey mnParametrizedConfigKey = this.parametrizedConfigKey;
            this.parametrizedKey = mnParametrizedConfigKey != null && (mnParametrizedConfigKey = mnParametrizedConfigKey.getParameterRange(this.keyName)) != null ? mnParametrizedConfigKey.substring(this.keyName) : null;
        }

        @NotNull
        public final String getKeyName() {
            return this.keyName;
        }

        @NotNull
        public final MetaConfigKey getConfigKey() {
            return this.configKey;
        }

        @Nullable
        public final MnParametrizedConfigKey getParametrizedConfigKey() {
            return this.parametrizedConfigKey;
        }

        @Nullable
        public final String getParametrizedKey() {
            return this.parametrizedKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "", "module", "Lcom/intellij/openapi/module/Module;", "configFile", "Lcom/intellij/psi/PsiFile;", "documentId", "", "checkRelaxedNames", "", "activeProfiles", "", "", "key", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchKey;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;IZLjava/util/Set;Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchKey;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getConfigFile", "()Lcom/intellij/psi/PsiFile;", "getDocumentId", "()I", "getCheckRelaxedNames", "()Z", "getActiveProfiles", "()Ljava/util/Set;", "getKey", "()Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchKey;", "matches", "keyText", "binder", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "intellij.micronaut"})
    public static final class MnConfigValueSearchParams {
        @NotNull
        private final Module module;
        @NotNull
        private final PsiFile configFile;
        private final int documentId;
        private final boolean checkRelaxedNames;
        @Nullable
        private final Set<String> activeProfiles;
        @NotNull
        private final MnConfigValueSearchKey key;

        public MnConfigValueSearchParams(@NotNull Module module, @NotNull PsiFile configFile, int documentId, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles, @NotNull MnConfigValueSearchKey key) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.module = module;
            this.configFile = configFile;
            this.documentId = documentId;
            this.checkRelaxedNames = checkRelaxedNames;
            this.activeProfiles = activeProfiles;
            this.key = key;
        }

        public /* synthetic */ MnConfigValueSearchParams(Module module, PsiFile psiFile, int n, boolean bl, Set set, MnConfigValueSearchKey mnConfigValueSearchKey, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = true;
            }
            this(module, psiFile, n, bl, set, mnConfigValueSearchKey);
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final PsiFile getConfigFile() {
            return this.configFile;
        }

        public final int getDocumentId() {
            return this.documentId;
        }

        public final boolean getCheckRelaxedNames() {
            return this.checkRelaxedNames;
        }

        @Nullable
        public final Set<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @NotNull
        public final MnConfigValueSearchKey getKey() {
            return this.key;
        }

        public final boolean matches(@NotNull String keyText, @NotNull MetaConfigKeyManager.ConfigKeyNameBinder binder) {
            Intrinsics.checkNotNullParameter((Object)keyText, (String)"keyText");
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            if (Intrinsics.areEqual((Object)keyText, (Object)this.key.getKeyName())) {
                return true;
            }
            if (this.checkRelaxedNames && binder.bindsTo(this.key.getConfigKey(), keyText)) {
                if (this.key.getParametrizedKey() == null) {
                    return true;
                }
                MnParametrizedConfigKey mnParametrizedConfigKey = this.key.getParametrizedConfigKey();
                Intrinsics.checkNotNull((Object)mnParametrizedConfigKey);
                Object object = mnParametrizedConfigKey.getParameterRange(keyText);
                if (object == null || (object = object.substring(keyText)) == null) {
                    return false;
                }
                Object parametrizedKeyText = object;
                return binder.matchesPart(this.key.getParametrizedKey(), (String)parametrizedKeyText);
            }
            return false;
        }
    }
}

