/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesSkipAutopopupInParameters;", "Lcom/intellij/codeInsight/completion/CompletionConfidence;", "<init>", "()V", "shouldSkipAutopopup", "Lcom/intellij/util/ThreeState;", "contextElement", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.micronaut"})
public final class MnPropertiesSkipAutopopupInParameters
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                if (!(contextElement instanceof PropertyKeyImpl)) break block6;
                Project project = ((PropertyKeyImpl)contextElement).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (MicronautUtils.hasMicronautLibrary(project) && MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block7;
            }
            return ThreeState.UNSURE;
        }
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)contextElement);
        if (metaConfigKey == null) {
            return ThreeState.UNSURE;
        }
        MetaConfigKey configKey = metaConfigKey;
        String string = configKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
        if (mnParametrizedConfigKey == null) {
            return ThreeState.UNSURE;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        int offsetInElement = offset - ((PropertyKeyImpl)contextElement).getStartOffset();
        String string2 = ((PropertyKeyImpl)contextElement).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        TextRange textRange = parametrizedConfigKey.getParameterRange(string2);
        if (textRange == null || (textRange = textRange.grown(1)) == null) {
            return ThreeState.UNSURE;
        }
        TextRange parameterRange = textRange;
        return parameterRange.contains(offsetInElement) ? ThreeState.YES : ThreeState.UNSURE;
    }
}

