/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javaee.utils.persistence.data.inspections.PartTreeInconsistencyUtils;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.data.inspections.MicronautDataRepositoriesInspection;
import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.micronaut.data.parser.MicronautProjection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class MicronautDataRepositoryMethodReturnTypeInspection
extends MicronautDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull UClass repositoryClass, @NotNull UMethod uMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (repositoryClass == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (uMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (typePair == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(4);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass domainType = (PsiClass)typePair.first;
        if (domainType == null) {
            return;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        PartTree.Subject subject = MicronautDataRepositoryMethodReturnTypeInspection.getSubject(psiMethod, domainType);
        if (subject.isDelete().booleanValue()) {
            if (!returnType.equals(PsiTypes.voidType()) && !MicronautDataRepositoryMethodReturnTypeInspection.isNumericType(repositoryClass, psiMethod, returnType)) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type.void", new Object[0]));
            }
        } else if (subject.isCountProjection()) {
            if (!MicronautDataRepositoryMethodReturnTypeInspection.isNumericType(repositoryClass, psiMethod, returnType)) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", "java.lang.Number"));
            }
        } else if (subject.isExistsProjection()) {
            if (!MicronautDataRepositoryMethodReturnTypeInspection.isAssignableType(returnType, (PsiType)PsiTypes.booleanType(), MicronautDataRepositoryMethodReturnTypeInspection.isReactiveRepository(repositoryClass))) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type.boolean", new Object[0]));
            }
        } else {
            MicronautProjection projection = MicronautPartTreeParserContext.extractProjection(subject);
            if (projection != null) {
                PsiType projectionType = projection.getType(domainType);
                if (projectionType != null && !MicronautDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(projectionType, psiMethod.getReturnType())) {
                    MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", projectionType.getCanonicalText()));
                }
            } else if (!MicronautDataRepositoryMethodReturnTypeInspection.isAssignableReturnType((PsiType)PsiTypesUtil.getClassType((PsiClass)domainType), psiMethod.getReturnType())) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", domainType.getName()));
            }
        }
    }

    private static boolean isNumericType(@NotNull UClass repositoryClass, PsiMethod psiMethod, PsiType returnType) {
        if (repositoryClass == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(5);
        }
        PsiClassType numberType = JavaPsiFacade.getElementFactory((Project)psiMethod.getProject()).createTypeByFQClassName("java.lang.Number");
        return MicronautDataRepositoryMethodReturnTypeInspection.isAssignableType(returnType, (PsiType)numberType, MicronautDataRepositoryMethodReturnTypeInspection.isReactiveRepository(repositoryClass));
    }

    @NotNull
    private static PartTree.Subject getSubject(@NotNull PsiMethod psiMethod, PsiClass domainType) {
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(6);
        }
        String name = psiMethod.getName();
        PartTree partTree = new PartTree(name, domainType, (PartTreeParserContext)MicronautPartTreeParserContext.create());
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(7);
        }
        return subject;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod, @InspectionMessage String message) {
        UTypeReferenceExpression returnTypeRef;
        if (holder == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(8);
        }
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(9);
        }
        if ((returnTypeRef = MicronautDataRepositoryMethodReturnTypeInspection.getReturnTypeRef(psiMethod)) == null) {
            return;
        }
        PsiElement identifier = returnTypeRef.getSourcePsi();
        if (identifier == null) {
            return;
        }
        TextRange textRange = identifier.getTextRange();
        if (textRange == null || textRange.isEmpty()) {
            return;
        }
        holder.registerProblem(identifier, message, new LocalQuickFix[0]);
    }

    private static UTypeReferenceExpression getReturnTypeRef(@NotNull UMethod psiMethod) {
        PsiElement sourcePsi;
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(10);
        }
        if ((sourcePsi = psiMethod.getSourcePsi()) == null) {
            return null;
        }
        for (PsiElement child : sourcePsi.getChildren()) {
            UTypeReferenceExpression expression = (UTypeReferenceExpression)UastContextKt.toUElement((PsiElement)child, UTypeReferenceExpression.class);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    public static boolean isAssignableReturnType(@NotNull PsiType expectedType, @Nullable PsiType methodReturnType) {
        if (expectedType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(11);
        }
        if (methodReturnType == null) {
            return false;
        }
        if (methodReturnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)methodReturnType) != null) {
            return true;
        }
        if (MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, methodReturnType)) {
            return true;
        }
        PsiType genericType = PsiUtil.extractIterableTypeParameter((PsiType)methodReturnType, (boolean)false);
        genericType = genericType != null ? genericType : MicronautDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(methodReturnType);
        PsiType psiType = genericType = genericType != null ? genericType : MicronautDataRepositoryMethodReturnTypeInspection.getSubstitutedReactiveStreamsParameters(methodReturnType);
        if (genericType != null) {
            if (MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, genericType)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, iterableTypeParameter)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTypeType(@NotNull PsiType expectedType, @NotNull PsiType methodReturnType) {
        if (expectedType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(12);
        }
        if (methodReturnType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(13);
        }
        return methodReturnType.isAssignableFrom(expectedType);
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"java.util.stream.Stream", "java.util.Optional", "io.micronaut.data.model.Page", "io.micronaut.data.model.Slice", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture"});
    }

    @Nullable
    public static PsiType getSubstitutedReactiveStreamsParameters(@Nullable PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"rx.Observable", "rx.Single", "io.reactivex.Observable", "io.reactivex.Flowable", "io.reactivex.Maybe", "io.reactivex.Single", "org.reactivestreams.Publisher", "reactor.core.publisher.Mono", "reactor.core.publisher.Flux"});
    }

    protected static boolean isReactiveRepository(UClass uClass) {
        return InheritanceUtil.isInheritor((PsiClass)uClass.getJavaPsi(), (String)"io.micronaut.data.repository.reactive.ReactiveStreamsCrudRepository");
    }

    private static boolean isAssignableType(@NotNull PsiType returnType, @NotNull PsiType requiredType, boolean isReactiveRepository) {
        if (returnType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(14);
        }
        if (requiredType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(15);
        }
        if (requiredType.isAssignableFrom(returnType)) {
            return true;
        }
        if (isReactiveRepository) {
            PsiType psiType = PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"reactor.core.publisher.Mono", "rx.Single", "rx.Observable"});
            return psiType != null && requiredType.isAssignableFrom(psiType);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNumericType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeRef";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableReturnType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableTypeType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

