/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.ArtifactProblemFix;
import com.intellij.database.dataSource.ClasspathModificationTracker;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.run.EelDatabaseHelperKt;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u0012H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J8\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u00122\u0006\u0010\t\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0014\u0010)\u001a\n **\u0004\u0018\u00010\u000e0\u000e*\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl;", "Lcom/intellij/database/dataSource/DatabaseDriverClasspathManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getNativeLibraryPaths", "", "Lcom/intellij/util/ui/classpath/SimpleClasspathElement;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "getAdditionalClasspathElements", "getElements", "inDir", "Ljava/nio/file/Path;", "getClasspathElements", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "artifact", "Lcom/intellij/database/dataSource/DatabaseDriver$ArtifactRef;", "context", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "hasDriverFiles", "", "getArtifactProblemsFix", "Lcom/intellij/database/dataSource/ArtifactProblemFix;", "createArtifactTransferFix", "driverName", "", "fixes", "Lkotlin/Function0;", "", "collectTransferRunnables", "isValidFiles", "collectPathsToTransfer", "localClassPath", "localNativeLibs", "collectPathsToTransferFrom", "elements", "dir", "urlToPath", "kotlin.jvm.PlatformType", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseDriverClasspathManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDriverClasspathManagerImpl.kt\ncom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1563#2:131\n1634#2,3:132\n1374#2:137\n1460#2,5:138\n1761#2,3:144\n1374#2:147\n1460#2,5:148\n1563#2:153\n1634#2,3:154\n1374#2:157\n1460#2,5:158\n1563#2:163\n1634#2,3:164\n1374#2:167\n1460#2,5:168\n1563#2:173\n1634#2,3:174\n1374#2:177\n1460#2,5:178\n1563#2:183\n1634#2,3:184\n1740#2,3:187\n1869#2,2:190\n37#3,2:135\n1#4:143\n*S KotlinDebug\n*F\n+ 1 DatabaseDriverClasspathManagerImpl.kt\ncom/intellij/database/dataSource/DatabaseDriverClasspathManagerImpl\n*L\n51#1:131\n51#1:132,3\n58#1:137\n58#1:138,5\n73#1:144,3\n93#1:147\n93#1:148,5\n93#1:153\n93#1:154,3\n94#1:157\n94#1:158,5\n94#1:163\n94#1:164,3\n102#1:167\n102#1:168,5\n102#1:173\n102#1:174,3\n103#1:177\n103#1:178,5\n103#1:183\n103#1:184,3\n104#1:187,3\n117#1:190,2\n53#1:135,2\n*E\n"})
public final class DatabaseDriverClasspathManagerImpl
implements DatabaseDriverClasspathManager {
    @NotNull
    private final Project project;

    public DatabaseDriverClasspathManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public List<SimpleClasspathElement> getNativeLibraryPaths(@NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(this.project, driver);
        if (!context.useEel()) {
            List list = driver.getNativeLibraryPaths();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNativeLibraryPaths(...)");
            return list;
        }
        if (!EelDatabaseHelperKt.hasNativeLibsDir(this.project)) {
            return new ArrayList();
        }
        return this.getElements(EelDatabaseHelperKt.getNativeLibsDir(this.project, driver));
    }

    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements(@NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(this.project, driver);
        if (!context.useEel()) {
            List list = driver.getAdditionalClasspathElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
            return list;
        }
        if (!EelDatabaseHelperKt.hasAdditionalClasspathDir(this.project)) {
            return new ArrayList();
        }
        return this.getElements(EelDatabaseHelperKt.getAdditionalClasspathDir(this.project, driver));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleClasspathElement> getElements(Path inDir) {
        void $this$mapTo$iv$iv;
        List<Path> list = Files.list(inDir).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(VfsUtilCore.pathToUrl((String)EelNioBridgeServiceKt.asEelPath((Path)it).toString()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        List list2 = SimpleClasspathElementFactory.createElements((String[])Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createElements(...)");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SimpleClasspathElement> getClasspathElements(@NotNull DatabaseDriver driver) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(this.project, driver);
        List list = driver.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DatabaseDriver.ArtifactRef it = (DatabaseDriver.ArtifactRef)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getElements(it, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.getAdditionalClasspathElements(driver)));
    }

    @NotNull
    public List<SimpleClasspathElement> getClasspathElements(@NotNull LocalDataSource dataSource) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                object = dataSource.getDatabaseDriver();
                if (object == null) break block2;
                DatabaseDriver it = object;
                boolean bl = false;
                List<SimpleClasspathElement> list = this.getClasspathElements(it);
                object = list;
                if (list != null) break block3;
            }
            object = new ArrayList();
        }
        return object;
    }

    private final List<SimpleClasspathElement> getElements(DatabaseDriver.ArtifactRef artifact, DatabaseArtifactContext context) {
        Object object;
        block3: {
            block2: {
                object = artifact.getArtifactVersion();
                if (object == null) break block2;
                Version it = object;
                boolean bl = false;
                List list = DatabaseArtifactManager.getClasspathElements((String)artifact.getId(), (Version)it, (DatabaseArtifactContext)context);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public boolean hasDriverFiles(@Nullable DatabaseDriver driver) {
        boolean bl;
        DatabaseArtifactContext context;
        block4: {
            if (driver == null) {
                return false;
            }
            context = DatabaseArtifactContext.Companion.getInstance(this.project, driver);
            List list = driver.getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseDriver.ArtifactRef it = (DatabaseDriver.ArtifactRef)element$iv;
                    boolean bl2 = false;
                    if (!it.hasElements(context)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl && this.isValidFiles(driver, context);
    }

    @Nullable
    public ArtifactProblemFix getArtifactProblemsFix(@NotNull DatabaseDriver driver) {
        DatabaseArtifactContext databaseArtifactContext;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DatabaseArtifactContext it = databaseArtifactContext = DatabaseArtifactContext.Companion.getInstance(this.project, driver);
        boolean bl = false;
        if (!it.useEel()) {
            return null;
        }
        return this.collectTransferRunnables(driver);
    }

    private final ArtifactProblemFix createArtifactTransferFix(String driverName, List<? extends Function0<Unit>> fixes) {
        String string = DatabaseBundle.message((String)"DataSourceConfigurable.transfer.driver", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"DataSourceConfigurable.drivers.not.transferred", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = DatabaseBundle.message((String)"DataSourceConfigurable.transferring.driver.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = DatabaseBundle.message((String)"notification.content.href.action0.transfer.missing.driver.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Object[] objectArray = new Object[]{driverName};
        String string5 = DatabaseBundle.message((String)"transfer.missing.a.href.action1", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        return new ArtifactProblemFix(string, string2, string3, string4, string5, fixes);
    }

    /*
     * WARNING - void declaration
     */
    private final ArtifactProblemFix collectTransferRunnables(DatabaseDriver driver) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object list$iv$iv;
        SimpleClasspathElement it;
        Iterable $this$flatMapTo$iv$iv2;
        List list = driver.getAdditionalClasspathElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (SimpleClasspathElement)element$iv$iv;
            boolean bl = false;
            List list2 = it.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClassesRootUrls(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            list$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.urlToPath((String)it));
        }
        List localClassPath = (List)destination$iv$iv;
        List list3 = driver.getNativeLibraryPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getNativeLibraryPaths(...)");
        Iterable $this$flatMap$iv2 = list3;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SimpleClasspathElement it2 = (SimpleClasspathElement)element$iv$iv;
            boolean bl = false;
            List list4 = it2.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getClassesRootUrls(...)");
            Iterable list$iv$iv2 = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String list$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            collection.add(this.urlToPath((String)it3));
        }
        List localNativeLibs = (List)destination$iv$iv2;
        String string = StringUtil.escapeXmlEntities((String)driver.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        String driverName = string;
        List<Function0<Unit>> fixes = this.collectPathsToTransfer(driver, localClassPath, localNativeLibs);
        return fixes.isEmpty() ? null : this.createArtifactTransferFix(driverName, fixes);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidFiles(DatabaseDriver driver, DatabaseArtifactContext context) {
        Path it;
        boolean bl;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv2;
        Object list$iv$iv;
        SimpleClasspathElement it2;
        void $this$flatMapTo$iv$iv;
        List list = driver.getAdditionalClasspathElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalClasspathElements(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it2 = (SimpleClasspathElement)element$iv$iv;
            boolean bl2 = false;
            List list2 = it2.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClassesRootUrls(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)collection2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)collection2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv2;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            collection = collection3;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it2);
            collection.add(this.urlToPath((String)it2));
        }
        List localClassPath = (List)collection3;
        List list3 = driver.getNativeLibraryPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getNativeLibraryPaths(...)");
        Iterable $this$flatMap$iv2 = list3;
        boolean $i$f$flatMap2 = false;
        Iterable iterable2 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : iterable2) {
            SimpleClasspathElement it3 = (SimpleClasspathElement)element$iv$iv;
            boolean bl4 = false;
            List list4 = it3.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getClassesRootUrls(...)");
            Iterable list$iv$iv2 = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        void var7_11 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : var7_11) {
            void it4;
            String list$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it4);
            collection.add(this.urlToPath((String)it4));
        }
        List localNativeLibs = (List)destination$iv$iv;
        if (context.useEel()) return this.collectPathsToTransfer(driver, localClassPath, localNativeLibs).isEmpty();
        Iterable $this$all$iv = localClassPath;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Path it5 = (Path)element$iv;
                boolean bl6 = false;
                if (Files.exists(it5, new LinkOption[0])) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = localNativeLibs;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (Path)element$iv;
            boolean bl7 = false;
        } while (Files.exists(it, new LinkOption[0]));
        return false;
    }

    private final List<Function0<Unit>> collectPathsToTransfer(DatabaseDriver driver, List<? extends Path> localClassPath, List<? extends Path> localNativeLibs) {
        return CollectionsKt.plus((Collection)this.collectPathsToTransferFrom(localClassPath, EelDatabaseHelperKt.getAdditionalClasspathDir(this.project, driver)), (Iterable)this.collectPathsToTransferFrom(localNativeLibs, EelDatabaseHelperKt.getNativeLibsDir(this.project, driver)));
    }

    private final List<Function0<Unit>> collectPathsToTransferFrom(List<? extends Path> elements, Path dir) {
        ClasspathModificationTracker modificationService = ClasspathModificationTracker.Companion.getInstance();
        ArrayList<Function0> result = new ArrayList<Function0>();
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Path expected = dir.resolve(PathsKt.getName((Path)it));
            Function0<Unit> callback = modificationService.checkAndGetUpdateCallback(it);
            if (Files.exists(expected, new LinkOption[0]) && callback == null) continue;
            result.add(() -> DatabaseDriverClasspathManagerImpl.collectPathsToTransferFrom$lambda$0$0(it, expected, callback));
        }
        return result;
    }

    private final Path urlToPath(String $this$urlToPath) {
        return Path.of(StringsKt.removePrefix((String)$this$urlToPath, (CharSequence)"file://"), new String[0]);
    }

    private static final Unit collectPathsToTransferFrom$lambda$0$0(Path $it, Path $expected, Function0 $callback) {
        block0: {
            Intrinsics.checkNotNull((Object)$expected);
            EelPathUtils.transferLocalContentToRemote$default((Path)$it, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit($expected)), null, (int)4, null);
            Function0 function0 = $callback;
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }
}

