/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Parameter;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class GermanParameters {
    public static final Parameter VARIANT = new Variant();
    public static final NodePattern deAtGerman = VARIANT.withValue("DE|AT");
    public static final Parameter GENDERN_STYLE = GermanParameters.gendernStyle();

    private static Parameter gendernStyle() {
        final Setting.Value consistently = new Setting.Value("consistently", "Konsequent");
        return new Parameter(Language.GERMAN, "gendernStyle", "Einheitliche Verwendung der geschlechtsspezifischen Form", ((StreamEx)StreamEx.of((Object)consistently).append(Arrays.stream(GendernStyle.values()).map(s -> new Setting.Value(s.name(), s.displayName)))).toList()){

            @Override
            public List<Setting.Value> possibleValues(RuleClient client) {
                return super.possibleValues(client).stream().filter(v -> client.supportsMetadataBasedDocumentAnalysis() || v != consistently).toList();
            }
        };
    }

    static enum GendernStyle {
        star("Gendersternchen (Sch\u00fcler*innen)"),
        gap("Gender-Gap (Sch\u00fcler_innen)"),
        colon("Doppelpunkt (Sch\u00fcler:innen)"),
        innerI("Binnen-I (Sch\u00fclerInnen)"),
        slash("Schr\u00e4gstrich (Sch\u00fcler/innen)");

        final String displayName;

        private GendernStyle(String displayName) {
            this.displayName = displayName;
        }
    }

    private static class Variant
    extends Parameter {
        private static final Setting.Value neutral = new Setting.Value("", "Neutral");

        Variant() {
            super(Language.GERMAN, "variant", "Die Variante von Deutsch", List.of(new Setting.Value("DE", "Deutschland"), new Setting.Value("AT", "\u00d6sterreich"), new Setting.Value("CH", "Die Schweiz (Schweizerhochdeutsch)"), neutral));
        }

        @Override
        @NotNull
        public Setting.Value defaultValue(TextStyle style, RuleClient client) {
            if (!client.hasVariantQuickFix() && !client.hasImplicitVariant()) {
                return neutral;
            }
            return super.defaultValue(style, client);
        }
    }
}

