/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GrammarRules;
import ai.grazie.rules.de.LemmaChanges;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TreeSupport;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class SemanticRules {
    private static final String unitPrefix = "Yokto|Zepto|Atoo|Femto|Piko|Nano|Mikro|Milli|Zenti|Dezi|Deka|Hekto|Kilo|Mega|Giga|Tera|Peta|Exa|Zetta|Yotta";
    static final NodePattern seasoned = NodePattern.N.lemma("(Winter|Fr\u00fchling|Sommer|Herbst).*");
    static final NodePattern familyMembers = NodePattern.N.lemma("(Paten)?(Tante|Onkel)|(Stief|Halb)?(Schwester|Bruder)|Cousine?|Schw[a\u00e4]ger(in)?|Nichte|Neffe|Kind|Baby|(Schwieger|Adoptiv|Pflege)?(Sohn|Tochter|Eltern)|(Ur)?(Gro\u00df|Schwieger|Stief|Adoptiv|Pflege)?(Mutter|Vater|Mama|Papa|O[mp]a|Enkel(in)?|Eltern)");
    static final NodePattern humanLike = NodePattern.or(NodePattern.N.lemma(".*(Besitzer|Besucher|Freund|Gast|Mensch|Person|Leute|Dame|Herr|Frau|Mann|Extremist|Erz\u00e4hler|Teufel|Gott|Krimineller|(Ver|Ein)brecher|Fl\u00fcchtige|Wesen|Bewohner|Konkurrent|Verd\u00e4chtige|Demonstrant|Rowdy|T\u00e4ter|Dieb|R\u00e4uber|H\u00e4ndler|Schmuggler|Betr\u00fcger|M\u00f6rder|Randalierer|Teilnehmer|J\u00e4hrige|Patient|Kunde)"), familyMembers);
    static final NodePattern humanLikeGroup = NodePattern.N.lemma("Familie");
    static final NodePattern animals = NodePattern.N.lemma(".*(Hund|Katze|Pferd|Vogel|Kuh|Schwein|Schaf|Hase|B\u00e4r|L\u00f6we|Elefant|Tiger|Fuchs|Wolf|Huhn|Gans|Fisch|Maus|Affe|Eule|Pinguin|Krokodil|Delfin|Wal|Nashorn|Zebra|Giraffe|K\u00e4nguru|Igel|Krabbe|Schmetterling|Spinne|Ameise|Biene|Esel|Rentier|Schlange|Frosch|Schildkr\u00f6te|Oktopus|Dachs|Robbe|Adler)");
    static final WordSet jobs = WordSet.loadResource("de/berufeUndStellen.txt");
    static final NodePattern job = NodePattern.custom(n -> {
        String lowForm = n.lowForm();
        String lowFormWithoutFemSuffix = n.lowForm().replaceFirst("in$", "");
        return SemanticRules.jobs.words.stream().anyMatch(word -> lowForm.endsWith((String)word) || lowFormWithoutFemSuffix.endsWith((String)word) || lowForm.endsWith("angestellten"));
    }).andNot(NodePattern.N.pos("ADJ.*").noPos("SUB.*")).noDependents("flat");
    static final NodePattern animate = NodePattern.or(humanLike, humanLikeGroup, animals, job, NodePattern.N.form("ich|mir|mich|du|dir|dich|wir|uns|euch|(nie|je)mand(e[mn]?)|jede([rmn])?"), NodePattern.N.formCaseSensitive("Sie").andNot(CommonPatterns.firstPhrase), NodePattern.N.label("PERSON|NATIONALITY_OR_GROUP").noForm("Schieber"), NodePattern.N.lemma("Verstorbene"), NodePattern.N.withDependent("flat.*", NodePattern.N.label("PERSON")));
    static final NodePattern units = NodePattern.N.lemma("(Yokto|Zepto|Atoo|Femto|Piko|Nano|Mikro|Milli|Zenti|Dezi|Deka|Hekto|Kilo|Mega|Giga|Tera|Peta|Exa|Zetta|Yotta|Quadrat|Kubik)meter|Meter|Grad|Prozent(punkt)?|Ma(ss|\u00df)|Gla(ss|\u00df)|Kilo|(Kilo)?gramm|St(\u00fc|ue)ck|Zoll|Liter|Tonne|Knoten");
    static final NodePattern food = NodePattern.N.formSuffix("bier(s|en?)?|wasser[sn]?|(wurst|w\u00fcrst(en?)?)|curry|kaffees?").noPos("VER.*");
    static final NodePattern timeUnit = NodePattern.N.lemmaCaseSensitive("(Yokto|Zepto|Atoo|Femto|Piko|Nano|Mikro|Milli|Zenti|Dezi|Deka|Hekto|Kilo|Mega|Giga|Tera|Peta|Exa|Zetta|Yotta)sekunde|Sekunde|(.*m|M)inute|(.*s|S)tunde|(.*t|T)ag|(.*w|W)oche|(.*m|M)onat|(.*j|J)ahr(zehnt|hundert|tausend)?").noLemma("(Land|Bundes)tag");
    static final NodePattern group = NodePattern.or(NodePattern.N.form("Mehrheit|H\u00e4lfte|Reihe|Menge|(An|Mehr|Viel)zahl|F\u00fclle|Bandbreite|Drittel|Viertel|F\u00fcnftel|Sechstel|Siebtel|Achtel|Neuntel|Zehntel|Zw\u00f6lftel|Zwanzigstel|Hundertstel|Tausendstel"), NodePattern.N.form(".*(undzwanzigstel|gruppe)"));
    static final String color = "((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)";
    static final NodePattern currencyName = NodePattern.N.form("(Reichs)?mark|Euro|Dollar|Pfund|Taler|Yuan|USD|Cent");
    static final NodePattern dayOfWeek = NodePattern.N.form("(" + String.join((CharSequence)"|", GermanDateChecker.INSTANCE.dayNames) + "|sonnabend)(en?)?");
    static final NodePattern daysOfWeekAbbr = NodePattern.N.formCaseSensitive("Mo|Di|Mi|Do|Fr|Sa|So");
    static final String partsOfDay = "((nach|vor)?mittag|abend|nacht|morgen)";
    static final NodePattern durableNoun = NodePattern.or(timeUnit, NodePattern.N.lemma("Weile"), dayOfWeek, GermanDateChecker.monthName, seasoned);
    static final NodePattern directSpeechVerb = NodePattern.or(NodePattern.N.lemma("((s|fr)ag|beton|erw\u00e4hn|behaupt|\u00fcberleg|erkl\u00e4r|mein|denk|glaub|hei\u00df|antwort|ruf|schrei|zisch|laut|konfrontier|les)en|(erl\u00e4uter|fl\u00fcster|erwider)n"), NodePattern.N.lemma("stellen").withDependent("obj", NodePattern.N.form("Fragen?")));
    static final String languageNameStr = "(.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch)";
    static final NodePattern languageName = NodePattern.N.form("(.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch)");
    static final NodePattern germanDialect = NodePattern.or(NodePattern.N.form("(alemann|ba(i|ye)r|boar|berliner|els(\u00e4|ae)ss|fr(\u00e4|ae)nk|hess|luxemburg|mecklenburg|m(\u00fc|ue)nchner|nassau|oberpf(\u00e4|ae)lz|ostfries|pf(\u00e4|ae)lz|rhein|schweizer|schw(\u00e4|ae)b|s(\u00e4|ae)chs|th(\u00fc|ue)ring|(\u00f6|oe)sterreich)isch|k(\u00f6|oe)lsch"), NodePattern.N.form(".*pommersch"));
    static final NodePattern inanimate = NodePattern.or(currencyName, dayOfWeek, durableNoun, timeUnit, food, units, seasoned);
    static final NodePattern cityName = NodePattern.or(WordSet.loadResource((String)"de/staedte.txt").lemmaPattern, NodePattern.N.inFormSequence(0, "San", "Francisco"), NodePattern.N.inFormSequence(0, "Addis", "Abeba"), NodePattern.N.inFormSequence(0, "Sankt", "Petersburg"), NodePattern.N.inFormSequence(0, "Belo", "Horizonte"), NodePattern.N.inFormSequence(0, "Kuala", "Lumpur"), NodePattern.N.inFormSequence(0, "Rio", "de", "Janeiro"), NodePattern.N.inFormSequence(0, "Los", "Angeles"), NodePattern.N.inFormSequence(0, "Buenos", "Aires"), NodePattern.N.inFormSequence(0, "New", "York"), NodePattern.N.inFormSequence(0, "S\u00e3o", "Paulo"), NodePattern.N.inFormSequence(0, "St.", "Gallen"));
    static final String uomAbbreviations = "[Kk][GgMmTt]|[Kk][Ww][Hh]|[Mk]t|[kKmMgGTPEZY]i?[Bb]|g|k?m[\u00b2\u00b3]";
    static final NodePattern languageLevels = NodePattern.N.form("[ABC]([12](\\.[12])?)|A0");
    static final NodePattern nounsCanBePersonal = NodePattern.N.lemma("(.*)?Kompetenz|Autonomie|Gleichheit|Bindung|Vermittlung|Medizin|Identit\u00e4t|Einheit|Ansatz");
    private static final NodePattern withoutPossessivePronoun = NodePattern.N.noDependents("det:poss");
    static final NodePattern personalToPersoenlich = NodePattern.N.lemma("personal").withHeadRelation("amod|root").directlyBefore(NodePattern.N.pos("SUB.*").andNot(humanLike.and(withoutPossessivePronoun)).andNot(nounsCanBePersonal.and(withoutPossessivePronoun))).andNot(GermanTreePatterns.englishWord.directlyBefore(GermanTreePatterns.englishWord));
    static final NodePattern gesternLike = NodePattern.N.form("(vor){0,2}?gestern");

    SemanticRules() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Semantics.ABSOLUTE_DATE_ISSUES", "Datumsprobleme (absolut)", "Datumsangaben m\u00fcssen g\u00fcltig sein, und Wochentage m\u00fcssen mit den Data \u00fcbereinstimmen.", null, () -> GermanDateChecker.INSTANCE.absolutePattern(), GermanDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.absolute), new Example("Ein Beispiel f\u00fcr ein falsches Datum ist <b>31. April</b>", new String[0])), new Rule.PatternRule("Semantics.RELATIVE_DATE_ISSUES", "Datumsprobleme (relativ)", "Logische Fehler, wenn der Text abh\u00e4ngig vom heutigen Datum interpretiert wird:\n<ul>\n<li>Ein Verb in Vergangenheitsform ist mit einem zuk\u00fcnftigen Datum kombiniert.\n<li>Ein verd\u00e4chtiges Datum mit dem vorherigen Jahr, am Jahresanfang geschrieben.\n<li>Ein Datum ohne Jahreszahl (also wahrscheinlich aus diesem Jahr) mit falschem Wochentag.\n</ul>\n", null, () -> GermanDateChecker.INSTANCE.relativePattern(), new Example("Wir haben das im <b>2053</b> gemacht", new String[0])), new Rule.PatternRule("Semantics.COMMONLY_CONFUSED_WORDS", "Leicht verwechselbare W\u00f6rter", "W\u00f6rter mit \u00e4hnlicher Bedeutung, Schreibweise oder Aussprache k\u00f6nnen leicht verwechselt werden.", null, () -> SemanticRules.commonlyConfusedWords(), new Example("Ich <b>wei\u00df</b> diese Person.", "Ich <b>kenne</b> diese Person."), new Example("Das Kind ist sehr <b>nach</b> zu mir.", "Das Kind ist sehr <b>nah</b> zu mir.")), new Rule.PatternRule("Semantics.TENSE_ADVERBIAL_MISMATCH", "Unstimmigkeit zwischen Zeitform und Adverbialbestimmung", "Zeitform und Zeitangabe stimmen nicht \u00fcberein.", null, () -> SemanticRules.gesternMitPraesens(), new Example("Letzten Sommer <b>sieht</b> er sie pl\u00f6tzlich.", "Letzten Sommer <b>sah</b> er sie pl\u00f6tzlich.", "Letzten Sommer <b>hat er sie pl\u00f6tzlich gesehen</b>.")).styleFlavor(StyleFlavor.Formality));
    }

    private static NodePattern bekommenWerden() {
        return NodePattern.N.lemma("bekommen").andOr(NodePattern.N.withDependent("obj", NodePattern.or(job, humanLike).noLemma("Kind|Baby|Tochter|Sohn").noDependents("det(:poss)?")), NodePattern.N.noDependents("obj").withDependent("xcomp", NodePattern.N.noDependents("obj"))).andOr(NodePattern.N.form("bekommen").andOr(NodePattern.N.withDependent("aux(:pass)?", NodePattern.or(NodePattern.N.lemma("haben").markAs("Aux"), NodePattern.N.lemma("sein"))).and((node, match) -> {
            NodeCorrector resultCorrector = NodeCorrector.replace(node, "geworden");
            Node aux = match.findMarkedNode("Aux");
            return match.withCorrector(aux != null ? resultCorrector.join(GrammarRules.habenToSein(aux)) : resultCorrector);
        }), NodePattern.N.correct(NodeCorrector.replace("werden"))), NodePattern.N.correct(LemmaChanges.changeOwnVerbLemma("werden"))).message("Meinten Sie eine Form von \u201ewerden\u201c?");
    }

    private static NodePattern languageLevel() {
        NodePattern nounsWithLanguageLevels = NodePattern.N.lemma(".*(Kurs|Test|Pr\u00fcfung|Sprechen|Schreiben|H\u00f6ren|Lesen|Zertifikat|Nachweis|Voraussetzung|Sprache|Kenntnis|Wissen|Grammatik|Wortschatz|F(\u00e4h|ert)igkeit)");
        return NodePattern.N.lemma("Level|Ebene").andOr(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.label("LANGUAGE"))), NodePattern.N.withHead("flat", NodePattern.N.markAs("Head")).directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, languageLevels.alreadyMarkedAs("Head"))).andOr(NodePattern.N.after(NodePattern.or(languageName, nounsWithLanguageLevels)), NodePattern.N.before(NodePattern.or(languageName, nounsWithLanguageLevels)))).andOr(NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Head")).message("Meinten Sie \u201eNiveau\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.marked("Head"), NodePointer.anchor(), m -> List.of(m.anchor().neighbor(-1).form() + "-Niveau"))), NodePattern.N.lemma("Ebene").and(SpellingRules.typoRegexReplacement("Ebene(.*)", "Niveau$1")), SpellingRules.typoRegexReplacement("Level(.*)", "Niveau$1"));
    }

    private static NodePattern mehrmaligMehrmals() {
        return NodePattern.N.form("mehrmalig").andOr(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("advmod|nummod"))).message("Wenn Sie meinen, wie oft etwas passiert, verwenden Sie \u201emehrmals\u201c").correct(NodeCorrector.replace("mehrmals"));
    }

    private static NodePattern noetigNotwendig() {
        return NodePattern.N.form("notwendig").withHead("advmod|xcomp", NodePattern.N.lemma("haben")).message("In Verbindung mit \u201ehaben\u201c wird standardsprachlich nur \u201en\u00f6tig\u201c verwendet").correct(NodeCorrector.replace("n\u00f6tig"));
    }

    private static NodePattern niemandDer() {
        return NodePattern.N.lemma("welch|wer").withHead("nsubj", NodePattern.N.withHead("acl", NodePattern.N.form("niemand").withOptionalDependent("nsubj", NodePattern.N.markAs("Subject")))).and((node, match) -> {
            Node subject = match.findMarkedNode("Subject");
            String pronomen = subject != null && (subject.hasPos(".*SIN:FEM.*") || subject.hasPos(".*PLU.*")) ? "die" : (subject != null && subject.hasPos(".*SIN:NEU.*") ? "das" : "der");
            return match.withCorrector(NodeCorrector.replace(node, pronomen)).withMessage("Verwenden Sie \u201e" + pronomen + "\u201c, wenn sich das Relativpronomen auf \u201eniemand\u201c bezieht");
        });
    }

    private static NodePattern mancherDer() {
        NodePattern headWithSecondSubject = NodePattern.N.withHead(NodePattern.N.withDependent("nsubj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Manches")).markAs("ReferenceWord")));
        NodePattern relClauseWithDasWelchesToWas = NodePattern.N.withDependent("acl", NodePattern.N.withDependent("nsubj", NodePattern.N.form("das|welches").correct(NodeCorrector.replace("was"))));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("manches").and(relClauseWithDasWelchesToWas).message("Verwenden Sie \u201ewas\u201c, wenn \u201e$_\u201c auf etwas Unbestimmtes verweist"), NodePattern.N.form("mancherlei").withHead(relClauseWithDasWelchesToWas).message("Das empfohlene Relativpronomen ist \u201ewas\u201c, wenn es um etwas Unbestimmtes oder Allgemeines geht")).markAs("Manches").andNot(headWithSecondSubject), NodePattern.N.lemma("manch").and(headWithSecondSubject).markAs("Manches").withDependent("acl", NodePattern.N.withDependent("obj", NodePattern.N.lemma("welch").and((node, match) -> {
            Node referenceWord = match.getMarkedNode("ReferenceWord");
            String pronomen = referenceWord.hasPos(".*SIN:FEM.*") || referenceWord.hasPos(".*PLU.*") ? "die" : (referenceWord.hasPos(".*SIN:NEU.*") ? "das" : "der");
            return match.withCorrector(NodeCorrector.replace(node, pronomen));
        }))).message("Verwenden Sie ein anderes Pronomen, wenn \u201emanche\u201c auf etwas Bestimmtes verweist"));
    }

    private static NodePattern wissenKennen() {
        NodePattern kennenObj = NodePattern.or(animate, NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION|NICKNAME|LANGUAGE|NATIONALITY_OR_GROUP|EVENT"), NodePattern.N.pos("EIG.*"), NodePattern.N.lemma("(P|.*p)roblem|(G|.*g)(esicht|rund)|(M|.*m)eter|(V|.*v)ariante"));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("wei(\u00df|ss)").andOr(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ich")).correct(NodeCorrector.replace("kenne")), NodePattern.N.correct(NodeCorrector.replace("kennt"))), NodePattern.N.form("wisse").andOr(NodePattern.N.withDependent("nsubj").correct(NodeCorrector.replace("kenne")), NodePattern.N.correct(NodeCorrector.replace("kenn"))), NodePattern.N.lemma("wissen").noForm("wei(\u00df|ss)").correct(ChangeLemma.to("kennen"))).andOr(NodePattern.or(NodePattern.N.withDependent("obj", kennenObj.markAs("Obj")).andNot(NodePattern.N.withHead("xcomp", NodePattern.N.pos("VER:MOD.*"))).noDependents("obj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Obj"))), NodePattern.N.withDependent("nsubj", kennenObj.markAs("Obj")).withDependent("obj", ReflexivePronouns.accReflexivPronomen), NodePattern.N.withHead("acl", kennenObj.markAs("Obj")).withDependent("obj", NodePattern.N.form("den|die|das"))).message("Mit \u201e$Obj\u201c wird normalerweise \u201ekennen\u201c benutzt"), NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(1, "an", "sich")).withDependent("obj", NodePattern.N.form("es|das")).message("Mit \u201ean sich\u201c wird normalerweise \u201ekennen\u201c benutzt")).noDependents("xcomp").andNot(NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(2, "a(n|uf)", ".*", "Seite").withNeighbor(-1, NodePattern.N.pos("PRO:POS:DAT.*")))), NodePattern.or(NodePattern.N.form("kennt").andOr(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ihr")).correct(NodeCorrector.replace("wei\u00dft")), NodePattern.N.correct(NodeCorrector.replace("wei\u00df"))), NodePattern.N.lemma("kennen").noForm("kennt").correct(ChangeLemma.to("wissen"))).withDependent("ccomp", NodePattern.N.withDependent("mark")).message("Mit Nebens\u00e4tzen wird normalerweise \u201ewissen\u201c benutzt"));
    }

    private static NodePattern statischStatistisch() {
        return NodePattern.N.form("statisch.*").withHead("amod", NodePattern.N.lemma("Bundesamt")).and(SpellingRules.typoRegexReplacement("statisch(.*)", "Statistisch$1"));
    }

    private static NodePattern antialkoholischAlkoholfrei() {
        NodePattern antiAlcoholTerms = NodePattern.N.lemma(".*(Propaganda|Bewegung|Initiative|Aktion|Offensive|Kampagne|Programm|Agenda|Strategie|Ideologie|Lehre|Doktrin|Werbung|Ver(band|einigung)|Gemeinschaft|Netzwerk|Ma(ss|\u00df)nahme)");
        return NodePattern.N.form("antialkoholisch(e[rnsm]?)?").andNot(NodePattern.N.withHead(antiAlcoholTerms)).message("Im Sinne von \u201ekein Alkohol enthalten\u201c verwenden Sie \u201ealkoholfrei\u201c oder \u201enicht alkoholisch\u201c").correct(NodeCorrector.regexReplace("anti(alkohol)isch(.*)", "$1frei$2")).correct(NodeCorrector.regexReplace("anti(alkoholisch.*)", "nicht $1"));
    }

    private static NodePattern nachNah() {
        return NodePattern.or(NodePattern.N.form("nach").andOr(NodePattern.N.withDependent("conj", NodePattern.N.form("Fern.*")), NodePattern.N.directlyBefore(NodePattern.N.form("an|bei|zu|neben").withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.form("nach").withHeadRelation("advmod")))).noHeadRelation("case|compound:prt").correct(NodeCorrector.replace("nah")), NodePattern.N.form("nah").withHead("case", NodePattern.N.noPos(".*STD")).correct(NodeCorrector.replace("nach"))).message("Die Pr\u00e4position \u201enach\u201c gibt eine Richtung an, w\u00e4hrend das Adjektiv \u201enah\u201c die N\u00e4he beschreibt");
    }

    private static NodePattern personalPersoenlich() {
        return personalToPersoenlich.message("Verwenden Sie \u201epers\u00f6nlich\u201c, um etwas Individuelles oder Direktes zu beschreiben").and(NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replace(node, StyleRules.getAdjLikeForm("pers\u00f6nlich", node.nextNode())))));
    }

    private static NodePattern sehrComparativeAdj() {
        return NodePattern.N.form("sehr").directlyBeforeHead().withHead("advmod", NodePattern.N.pos("ADJ:PRD:KOM").andNot(NodePattern.N.withHead("amod|root", NodePattern.or(NodePattern.N.pos("SUB.*"), NodePattern.N.noPos().label("PRODUCT")))).andNot(GermanTreePatterns.headInQuotes)).correct(NodeCorrector.replace("viel", "wesentlich", "deutlich")).message("Verwenden Sie statt \u201esehr\u201c ein anderes Wort zur Verst\u00e4rkung des Komparativs");
    }

    private static NodePattern commonlyConfusedWords() {
        return NodePattern.or(SemanticRules.wissenKennen(), SemanticRules.bekommenWerden(), SemanticRules.nachNah(), SemanticRules.personalPersoenlich(), SemanticRules.sehrComparativeAdj(), SemanticRules.oekumenischeMesse(), SemanticRules.enVsUng(), SemanticRules.antialkoholischAlkoholfrei(), SemanticRules.statischStatistisch(), SemanticRules.languageLevel(), SemanticRules.mehrmaligMehrmals(), SemanticRules.noetigNotwendig(), SemanticRules.niemandDer(), SemanticRules.mancherDer(), SemanticRules.ortStelle());
    }

    private static NodePattern ortStelle() {
        return NodePattern.N.inFormSequence(2, "an", "([mds]ein|unser|eue?r|ihr)(e[mnsr]?)", "Ort").and((node, match) -> {
            Node neighbour = node.prevNode();
            NodeCorrector fixPossessive = !neighbour.form().endsWith("er") ? NodeCorrector.replace(neighbour, neighbour.form().replaceFirst("([mds]ein|unser|eue?r|ihr).+", "$1er")) : null;
            return match.withCorrector(NodeCorrector.replace(node, "Stelle").join(fixPossessive)).withMessage("Meinten Sie \u201eStelle\u201c?");
        });
    }

    private static NodePattern enVsUng() {
        return NodePattern.or(NodePattern.N.form("zuweisen").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andOr(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.pos(".*SIN:FEM.*")), NodePattern.N.withDependent("dep", NodePattern.N.pos("ART.*SIN:FEM.*"))).and(SpellingRules.typoReplacement("Zuweisung")), NodePattern.N.form("(klein|gro(\u00df|ss)|zusammen|getrennt)schreiben").and(SpellingRules.typoRegexReplacement("(.+)en", "$1ung")));
    }

    private static NodePattern oekumenischeMesse() {
        return NodePattern.N.lemma("\u00f6kumenisch").withHead("amod", NodePattern.N.lemma(".*messe")).correct(NodeCorrector.replace("")).message("Zur Messe geh\u00f6rt auch das Abendmahl, welches nicht auf \u00f6kumenische Weise gefeiert wird");
    }

    private static NodePattern gesternMitPraesens() {
        NodePattern verbInPastTense = NodePattern.N.pos("VER.*PRT.*").withDependent("nsubj", NodePattern.N.markAs("Subj")).includeIntoReport().markAs("Verb");
        NodePattern verbInPresentTense = NodePattern.N.pos("VER.*PR\u00c4.*").noHeadRelation("xcomp").withDependent("nsubj", NodePattern.N.markAs("Subj")).andOr(NodePattern.N.withDependent("aux", NodePattern.N.pos("VER:MOD.*PR\u00c4").markAs("Verb").includeIntoReport()), NodePattern.N.noDependents("aux", NodePattern.or(NodePattern.N.lemma("haben"), NodePattern.N.pos("VER:MOD.*PRT"))).markAs("Verb").includeIntoReport());
        NodePattern seinVerb = WordSet.loadResource((String)"de/sein_verben.txt").lemmaPattern;
        NodePattern withoutPreposition = NodePattern.N.noDependents("case", NodePattern.N.form("seit|auf"));
        NodePattern temporalDetails = NodePattern.or(dayOfWeek, GermanDateChecker.monthName, NodePattern.N.lemma("Woche(nende)?|Monat|Sommer|Herbst|Winter|Fr\u00fchling"));
        NodePattern withoutArticle = NodePattern.N.noDependents("det");
        NodePattern morgenLike = NodePattern.N.form("(\u00fcber){0,2}morgen");
        NodePattern anyTemporal = NodePattern.or(gesternLike, morgenLike, temporalDetails);
        NodePattern relatedMismatchedTenseVerb = NodePattern.N.pos("VER.*(PRT|PR\u00c4).*").noDependents("advmod|nsubj(:pass)?|i?obj|obl|nmod|compound", anyTemporal);
        return NodePattern.or(NodePattern.or(NodePattern.N.lemma("n\u00e4chst").withHead("amod|obl", temporalDetails.withHead("i?obj|obl", verbInPastTense).and(withoutArticle)), morgenLike.pos("ADV:TMP").and(withoutPreposition).markAs("Morgen").withHead("advmod|obl", verbInPastTense.noDependents("mark", NodePattern.N.form("wenn"))).includeIntoReport()), NodePattern.or(NodePattern.N.lemma("(vor){0,2}letzte|gestrig|vorig"), gesternLike.and(withoutPreposition).includeIntoReport()).andOr(NodePattern.N.withHead("advmod", CommonPatterns.possiblySkipUp("i?obj|obl", verbInPresentTense)), NodePattern.N.withHead("amod", temporalDetails.and(withoutArticle).and(withoutPreposition.withHead("i?obj|obl", verbInPresentTense)))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("case", NodePattern.N.form("seit|ab"))))).and((node, match) -> {
            String msg;
            String number;
            Node verb = match.getMarkedNode("Verb");
            Node subj = match.getMarkedNode("Subj");
            Node morgen = match.findMarkedNode("Morgen");
            String subjLowForm = subj.lowForm();
            String string = subjLowForm.equals("wir") || subjLowForm.equals("ihr") ? "PLU" : (subjLowForm.equals("ich") || subjLowForm.equals("du") ? "SIN" : (!subj.hasPos(".*") || subj.hasPos(".*NOM:SIN.*") || subj.nerLabel() != null ? "SIN" : (number = subj.hasPos(".*NOM:PLU.*") ? "PLU" : ".*")));
            String person = subjLowForm.equals("ich") || subjLowForm.equals("wir") ? "1" : (subjLowForm.equals("du") || subjLowForm.equals("ihr") ? "2" : "3");
            List filteredDependents = ((StreamEx)StreamEx.of(verb.findDependents("conj|ccomp")).filter(relatedMismatchedTenseVerb::matches)).flatMap(dep -> StreamEx.of((Object)dep).append(dep.findDependents("conj")).filter(relatedMismatchedTenseVerb::matches)).toList();
            boolean isVerbPrae = verb.hasPos("VER.*PR\u00c4.*");
            String auxVerb = isVerbPrae ? (seinVerb.matches(verb) ? "sein" : "haben") : "werden";
            String partOrInf = isVerbPrae ? "VER:PA2:(SFT|NON)" : "VER:INF.*";
            String inflVerb = isVerbPrae ? ":PRT(.*)?" : ":PR\u00c4(.*)?";
            TreeSupport treeSupport = verb.tree().treeSupport();
            List<String> participleOrInfinitive = treeSupport.inflectNode(verb, "VER:.*", partOrInf);
            List<String> aux = treeSupport.synthesize(auxVerb, auxVerb, "VER.*", "VER:" + person + ":" + number + ":.*PR\u00c4:(SFT|NON)");
            List<String> inflectedVerb = treeSupport.inflectNode(verb, "VER:.*", "VER:(MOD:)?" + person + ":" + number + inflVerb);
            String basisMsg = "W\u00e4hlen Sie eine passende Zeitform, da das Ergebnis in der %s liegt";
            String string2 = !filteredDependents.isEmpty() ? "Passen Sie die zeitliche Angabe und die Verbform an" : (msg = verb.hasPos("VER.*PRT.*") ? String.format(basisMsg, "Zukunft") : String.format(basisMsg, "Vergangenheit"));
            if (filteredDependents.isEmpty()) {
                match = match.withCorrector(NodeCorrector.replace(verb, inflectedVerb));
            }
            if (!verb.hasPos("VER:MOD.*") && filteredDependents.isEmpty()) {
                Node clauseEnd = SemanticRules.findFinalVerbPosition(verb);
                if (clauseEnd == null) {
                    return null;
                }
                if (participleOrInfinitive.isEmpty()) {
                    return null;
                }
                NodeCorrector verbToPerfectOrFutureForm = NodeCorrector.replace(verb, aux).join(NodeCorrector.insertAfter(clauseEnd, " " + participleOrInfinitive.get(0)));
                match = match.withCorrector(verbToPerfectOrFutureForm);
                if (morgen != null && morgen.hasForm("morgen")) {
                    match = match.withCorrector(NodeCorrector.replace(morgen, "am Morgen"));
                }
            }
            return match.withMessage(msg).withReportedNodes(filteredDependents);
        });
    }

    @Nullable
    private static Node findFinalVerbPosition(Node verb) {
        Node dep;
        Iterator iterator = Lists.reverse(verb.allDependents()).iterator();
        while (iterator.hasNext() && !(dep = (Node)iterator.next()).isBefore(verb)) {
            Node subClause;
            if (dep.hasHeadRelation("punct")) continue;
            if (dep.hasHeadRelation("parataxis|conj|csubj|[cx]comp|a(dv)?cl")) {
                return dep.phraseStart().prevNode();
            }
            if (dep.hasHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound") && (subClause = dep.findSingleDependent("[cx]comp|acl")) != null) {
                return subClause.phraseStart().prevNode();
            }
            return dep.phraseEnd();
        }
        return null;
    }
}

