/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Parameter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnglishParameters {
    public static final Parameter DASH_STYLE = new DashStyle();
    public static final Parameter CONTRACTION_USE = new ContractionUse();
    static final NodePattern suggestFullForms = CONTRACTION_USE.withValue("|consistently|never");
    static final NodePattern suggestContractedForms = CONTRACTION_USE.withValue("|consistently|always");
    public static final Variant VARIANT = new Variant();
    public static final Parameter SPELL_OUT_NUMERALS = new SpellOutNumerals();
    public static final Parameter SPACES_IN_NAME_INITIALS = new Parameter(Language.ENGLISH, "spacesInNameInitials", "Format names that contain initials using", List.of(new Setting.Value("useSpaces", "Non-breaking spaces (J.\u00a0R.\u00a0R.\u00a0Tolkien)"), new Setting.Value("noSpaces", "No spaces (J.R.R.\u00a0Tolkien)")));
    public static final Parameter NUMBER_FORMATTING = new Parameter(Language.ENGLISH, "numberFormatting", "Format large numbers using", List.of(new Setting.Value("comma", "Comma (10,000)"), new Setting.Value("narrowNbsp", "Narrow non-breaking space (10\u202f000)")));
    public static final Parameter SERIAL_COMMA = new UseSerialComma();

    static class DashStyle
    extends Parameter {
        static final Setting.Value emNoSpace = new Setting.Value("emDashNoSpace", "Em dash\u2014without spaces");
        static final Setting.Value emSpaced = new Setting.Value("emDashSpaced", "Em dash \u2014 with spaces");
        static final Setting.Value en = new Setting.Value("enDash", "En dash \u2013 with spaces");

        private DashStyle() {
            super(Language.ENGLISH, "dashStyle", "Replace hyphens that break sentences with", List.of(emNoSpace, emSpaced, en));
        }
    }

    static class ContractionUse
    extends Parameter {
        static final Setting.Value always = new Setting.Value("always", "Always");
        static final Setting.Value never = new Setting.Value("never", "Never");
        static final Setting.Value consistently = new Setting.Value("consistently", "Consistently");

        private ContractionUse() {
            super(Language.ENGLISH, "contractionUse", "Prefer contractions", List.of(always, never, consistently));
        }

        @Override
        public List<Setting.Value> possibleValues(RuleClient client) {
            return super.possibleValues(client).stream().filter(v -> client.supportsMetadataBasedDocumentAnalysis() || v != consistently).toList();
        }
    }

    public static class Variant
    extends Parameter {
        private static final Setting.Value neutral = new Setting.Value("", "Neutral");
        public static final String BRITISH_OXFORD_ID = "GB-oxendict";
        private static final String OXFORD_SPELLING_UK = "Oxford spelling (UK)";

        Variant() {
            super(Language.ENGLISH, "variant", "The variant of English", List.of(new Setting.Value("US", "United States"), new Setting.Value("GB", "United Kingdom"), new Setting.Value(BRITISH_OXFORD_ID, OXFORD_SPELLING_UK), new Setting.Value("CA", "Canada"), new Setting.Value("AU", "Australia"), new Setting.Value("NZ", "New Zealand"), neutral));
        }

        @Override
        @NotNull
        public Setting.Value defaultValue(TextStyle style, RuleClient client) {
            if (!client.hasVariantQuickFix() && !client.hasImplicitVariant()) {
                return neutral;
            }
            return super.defaultValue(style, client);
        }

        static String countryAdj(Setting.Value value) {
            return Variant.countryAdj(value.id());
        }

        private static String countryAdj(String id) {
            return switch (id) {
                case "US" -> "American";
                case "GB", BRITISH_OXFORD_ID -> "British";
                case "CA" -> "Canadian";
                case "AU" -> "Australian";
                case "NZ" -> "New Zealand";
                default -> throw new UnsupportedOperationException(id);
            };
        }

        ActionSuggestion.ChangeParameter changeTo(@NotNull String valueId) {
            String s = valueId.equals(BRITISH_OXFORD_ID) ? OXFORD_SPELLING_UK : Variant.countryAdj(valueId) + " English";
            return new ActionSuggestion.ChangeParameter(this, valueId, "Switch to " + s);
        }
    }

    static class SpellOutNumerals
    extends Parameter {
        static final String singleLargeDesc = "0\u20139 including large numerals";
        static final String singleDoubleLargeDesc = "0\u201399 including large numerals";
        static final String singleDesc = "0\u20139 excluding large numerals";

        private SpellOutNumerals() {
            super(Language.ENGLISH, "spellOutNumerals", "Spell out numbers", List.of(new Setting.Value("single+large", "0\u20139 including large numerals (five thousand)"), new Setting.Value("single+double+large", "0\u201399 including large numerals (fifty thousand)"), new Setting.Value("single", "0\u20139 excluding large numerals (5 thousand)")));
        }
    }

    static class UseSerialComma
    extends Parameter {
        static final Setting.Value always = new Setting.Value("always", "Always");
        static final Setting.Value consistently = new Setting.Value("consistently", "Consistently");

        private UseSerialComma() {
            super(Language.ENGLISH, "useSerialComma", "Use serial (Oxford) commas", List.of(always, consistently, new Setting.Value("never", "Never")));
        }

        @Override
        public List<Setting.Value> possibleValues(RuleClient client) {
            return super.possibleValues(client).stream().filter(v -> client.supportsMetadataBasedDocumentAnalysis() || v != consistently).toList();
        }
    }
}

