/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

class Semantics {
    @Language(value="RegExp")
    static final String nounNumbers = "dozen|hundred|thousand|million|billion|(ga)?zillion";
    static final String numberTens = "twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety";
    static final String numbers2_9 = "two|three|four|five|six|seven|eight|nine";
    @Language(value="RegExp")
    static final String numbers = "two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eightteen|nineteen|twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety|dozen|hundred|thousand|million|billion|(ga)?zillion";
    @Language(value="RegExp")
    static final String exactParts = "part|half|third|quarter";
    @Language(value="RegExp")
    static final String parts = "part|half|third|quarter|most|rest|majority|minority";
    @Language(value="RegExp")
    static final String numberActions = "increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce";
    @Language(value="RegExp")
    static final String includeSynonyms = "include|contain|consist|incorporate|constitute";
    @Language(value="RegExp")
    static final String postureVerbs = "sit|stand|lie|lean|hunch|kneel|crouch";
    @Language(value="RegExp")
    static final String placementVerbs = "put|place|lay|locate|position|bury|leave|step|stomp|park|stack";
    @Language(value="RegExp")
    static final String continuousActionVerbs = "go|walk|drive|sleep|live|work|store|expand|run";
    @Language(value="RegExp")
    static final String mentalActivityVerbs = "think|decide|plan|consider|understand|believe|remember|know|realize|feel|miss|dream|fear|enjoy|hope|ensure|agree|disagree|determine|recognize|approve|want|care";
    @Language(value="RegExp")
    static final String activitiesWithObj = "study|practice|research|prepare|clean|pack|paint|play|fix|repair|install|download|upload|keep|save|watch|avoid|recommend|learn|store";
    @Language(value="RegExp")
    static final String oneTimeNotScheduledEvents = "see|call|create|try|tell|ask|find|add|offer|happen|hear|check|win|lose|identify|encourage|mention|miss|discover|surprise|experience|knock|ring";
    static final NodePattern singleActionInThePast = NodePattern.N.pos("VBD").lemma("see|call|create|try|tell|ask|find|add|offer|happen|hear|check|win|lose|identify|encourage|mention|miss|discover|surprise|experience|knock|ring|put|place|lay|locate|position|bury|leave|step|stomp|park|stack").andNot(NodePattern.N.lemma("try").withDependent("xcomp"));
    @Language(value="RegExp")
    static final String createSynonyms = "create|form|establish|build|develop|renovate|construct|design";
    @Language(value="RegExp")
    static final String electSynonyms = "elect|select|appoint";
    @Language(value="RegExp")
    static final String publishSynonyms = "publish|release|launch";
    static final NodePattern actionWithButtonAsObj = NodePattern.N.lemma("press|hit|click|tap");
    static final NodePattern lemmasDenotingGroupsAsPastParticiple = NodePattern.N.lemma("disable|injure|educate|marginali[zs]e|stigmati[zs]e|abuse|displace|oppress|decease|wound");
    static final NodePattern adjectivesPossiblyDenotingGroups = NodePattern.or(NodePattern.N.form("young|elderly|homeless|poor|rich|wealthy|blind|deaf|sick|famous|unemployed|dead"), lemmasDenotingGroupsAsPastParticiple.pos("VBN")).noPos("NNP");
    static final NodePattern possiblyCountableCollective = NodePattern.N.form("staff|faculty|youth|police");
    static final String pluralizableCollective = "carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang";
    static final NodePattern nounMissingPluralPos = NodePattern.N.form("insignia");
    static final NodePattern possiblePluralNN = NodePattern.or(NodePattern.or(NodePattern.N.form("remainder|intelligentsia|leadership|emoji|data|statistics|means|public|clergy|peasantry|elderly|latter|former|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eightteen|nineteen|twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety|dozen|hundred|thousand|million|billion|(ga)?zillion|carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang"), possiblyCountableCollective, nounMissingPluralPos).noDependents("det", NodePattern.N.form("a")), NodePattern.N.form("population").noDependents("det", NodePattern.N.noForm("the")), NodePattern.N.form("part|half|third|quarter|most|rest|majority|minority"));
    static final NodePattern ageRelatedWords = NodePattern.N.lemma("young|old|age");
    static final NodePattern humanSpecificAgeRelatedAdjectives = NodePattern.or(NodePattern.N.lemma("adolescent|teenage|underage|elderly"), NodePattern.N.inFormSequence(2, "middle", "-", "aged"), NodePattern.N.form("old").withDependent("obl:npmod", NodePattern.N.lemma("year").beforeHead().withDependent("nummod")));
    static final NodePattern maritalStatus = NodePattern.N.form("widowed|(un)?married|single|divorced");
    static final NodePattern timeRelatedWords = NodePattern.N.lemma("early|late");
    static final NodePattern opticalDevice = NodePattern.N.lemma("lens|(micro|tele)scope|camera|binocular|projector|glass");
    static final NodePattern opticsRelatedWords = NodePattern.N.lemma("optic(al)?|distort(ion)?|reflect(ion)?|aberration|a?chromatic");
    @Language(value="RegExp")
    static final String pluralDisciplines = "sports|physics|maths|arts|mechanics|materials|robotics";
    static final NodePattern possiblySingularNNS = NodePattern.or(NodePattern.N.form("savings|measles|criteria|customs|innings|bacteria|waterworks|labs|means|sports|physics|maths|arts|mechanics|materials|robotics"), NodePattern.N.form("thanks").withDependent("amod", NodePattern.N.noPos("DT")));
    @Language(value="RegExp")
    static final String femaleStereotypeOccupation = "nurse|midwife|secretary";
    static final String academicDegree = "master|bachelor|associate";
    static final String academicDegreeHeadNoun = "degree|qualification|diploma|certificate|program(me)?";
    static final String professionalLevel = "beginner|amateur";
    @Language(value="RegExp")
    static final String occupation = "artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate";
    @Language(value="RegExp")
    static final String socialRelation = "client|customer|friend|user|colleague|teammate|groupmate|citizen|nominee|immigrant|emigrant|migrant|refugee|resident|slave|veteran|patient|employee|subordinate|chief|superior|superordinate|reportee|underboss|boss|subsidiary|managee|manager|leadee|leader";
    static final NodePattern abstractHuman = NodePattern.or(NodePattern.N.lemma("person|human|individual|teen(ager)?|adolescent|youngster|youngling|earthling|darling|sportling|changeling|shaveling|witling|overling|underling|weakling"), NodePattern.N.lemma("member").withDependent("compound", NodePattern.N.form("staff")));
    static final String genderedAbstractHumanFemale = "woman|girl(friend)?|dudette|lady|princess";
    static final String genderedAbstractHumanMale = "man|boy(friend)?|dude|guy|(lord|prince)(ling)?";
    static final String genderedAbstractHuman = "woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?";
    static final String universalConcepts = "humanity|humankind|mankind|life|creation|civilization|nature|time|space|eternity|reality|existence|heaven|hell|society|history";
    static final String natureSynonyms = "nature|character|essence|quality|type|sort|description|aspect|kind|tone|caliber";
    static final String actSynonyms = "act|action|activity|operation|plan|reaction|response|deed|move";
    static final String versionSynonyms = "version|release|edition|update|publication";
    static final String goalSynonyms = "goal|aim|objective";
    static final String bodyParts = "face|arm|leg|hand|head|eye|ear|nose|mouth|lips|teeth|tongue|neck|chest|belly|hip|shoulder|elbow|wrist|finger|thumb|back|spine|heart|stomach|throat|forehead|chin|cheek|jaw";
    static final NodePattern educationalInstitution = NodePattern.N.lemma("school|college|university|academy|conservato(ry|rium|ire)");
    static final NodePattern kindredRelationNonGendered = NodePattern.N.lemma("cousin|sibling|nibling|relative|(grand)?child|(grand)?parent|kid|foundling|youngster");
    static final NodePattern kindredRelationFemale = NodePattern.or(NodePattern.N.lemma("(step)?sister|aunt(ie)?|mom(my)?|niece|granny|(house)?wife"), NodePattern.N.lemma(".*mother|.*daughter(ling)?"));
    static final NodePattern kindredRelationMale = NodePattern.or(NodePattern.N.lemma("(step)?brother|uncle|dad(dy)?|nephew|husband"), NodePattern.N.lemma(".*father|(.*(grand|step))?son(ling)?"));
    static final NodePattern kindredRelation = NodePattern.or(kindredRelationMale, kindredRelationFemale, kindredRelationNonGendered);
    private static final NodePattern creaturePattern = NodePattern.N.lemma("creature");
    static final NodePattern humanLikePattern = NodePattern.or(NodePattern.N.lemma("devil|ghost|god(ling)?|I|you|we|he|she|police|company|party|[sS]enate|opposition|crowd|celebrity|character|artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate|client|customer|friend|user|colleague|teammate|groupmate|citizen|nominee|immigrant|emigrant|migrant|refugee|resident|slave|veteran|patient|employee|subordinate|chief|superior|superordinate|reportee|underboss|boss|subsidiary|managee|manager|leadee|leader|woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?|beginner|amateur"), EnglishTreePatterns.someAnyEveryNoAnimate, CommonPatterns.nerPerson, kindredRelation, abstractHuman, NodePattern.N.form("others"), NodePattern.N.form(".+ists?").noLemma(".*"), NodePattern.N.pos("NNPS?").form(".+ans?"));
    static final NodePattern people = NodePattern.N.form("people");
    static final NodePattern ambiguousPeople = people.and(NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.form("whole"), NodePattern.N.label("NATIONALITY_OR_GROUP|MISC"))), NodePattern.N.withDependent("det", NodePattern.N.form("an?|no")), NodePattern.N.withDependent("nummod", NodePattern.or(NodePattern.N.form("one"), NodePattern.N.withDependent("compound", NodePattern.N.form("one")))).andNot(NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.custom(n -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(n)) == Number.plural)))));
    static final WordSet chemicalElements = WordSet.loadResource("en/words/chemical_elements.txt");
    private static final Set<String> possibleCountableChemicalElements = Set.of("tin", "lead", "gold", "silver", "bronze");
    static final Predicate<String> isDefinitelyUncountableNoun = new Predicate<String>(){
        final Set<String> set;
        {
            this.set = WordSet.loadResource((String)"en/words/definitely_uncountable.txt").words;
        }

        @Override
        public boolean test(String s) {
            return this.set.contains(s) || s.endsWith("ware") || chemicalElements.contains(s) && !possibleCountableChemicalElements.contains(s);
        }
    };
    static final NodePattern definitelyUncountableLemma = NodePattern.custom(n -> n.lemmaReadings().stream().anyMatch(isDefinitelyUncountableNoun));
    static final String[] disciplineSuffixes = new String[]{"graphy", "metry", "onomy", "ology", "iatry"};
    static final Predicate<String> isPossiblyUncountableNoun = new Predicate<String>(){
        final Set<String> set;
        final String[] suffixes;
        final String[] longWordSuffixes;
        {
            this.set = WordSet.loadResource((String)"en/words/possibly_uncountable.txt").words;
            this.suffixes = new String[]{"mania", "ism", "ibility", "iability", "ivity", "ness", "cracy", "opia", "osis", "itis", "algia", "amnios", "enia", "emia", "pepsia", "nesis"};
            this.longWordSuffixes = new String[]{"ance", "ancy", "ence", "ency"};
        }

        @Override
        public boolean test(String s) {
            return isDefinitelyUncountableNoun.test(s) || possibleCountableChemicalElements.contains(s) || this.set.contains(s) || (Arrays.stream(disciplineSuffixes).anyMatch(suf -> s.endsWith((String)suf)) || Arrays.stream(this.suffixes).anyMatch(suf -> s.endsWith((String)suf)) && !s.endsWith("oness") || Arrays.stream(this.longWordSuffixes).anyMatch(suf -> s.endsWith((String)suf)) && s.length() > 8) && !Articles.requiresArticle.contains(s);
        }
    };
    static final String disciplines = "sports|physics|maths|arts|mechanics|materials|robotics|science|history|medicine|literature|music|cinema|.+(" + String.join((CharSequence)"|", disciplineSuffixes) + ")";
    static final NodePattern possiblyUncountableLemma = NodePattern.custom(n -> n.lemmaReadings().stream().anyMatch(isPossiblyUncountableNoun));
    static final NodePattern possiblyUncountableForm = NodePattern.custom(n -> isPossiblyUncountableNoun.test(n.lowForm()));
    static final NodePattern requiresArticleInContext = NodePattern.or(NodePattern.N.form("extension").directlyAfter(NodePattern.N.form("browser")), NodePattern.N.lemma("type").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("of")), NodePattern.N.withDependent("compound", NodePattern.N.onlyPos("NN").directlyBeforeHead()), NodePattern.N.withDependent("case", NodePattern.N.form("of").beforeHead())));
    static final NodePattern definitelyCountable = NodePattern.or(requiresArticleInContext, NodePattern.N.lemma("admin").withHead("nmod", NodePattern.N.form("one")).withDependent("case", NodePattern.N.form("of")), NodePattern.N.lemma("application").andNot(NodePattern.N.withDependent("nmod", NodePattern.N.noLemma("quality|origin|sorts?|type|kind|form|variety|lot|ton|bunch|heap|bit|deal|number").withDependent("case", NodePattern.N.form("of")))), NodePattern.N.lemma("jam").withDependent("compound", NodePattern.N.form("traffic")), NodePattern.N.form("right").withDependent("acl", EnglishTreePatterns.withToMark), NodePattern.N.inFormSequence(0, "forms?", "of"), NodePattern.N.lemma("game").andOr(NodePattern.N.withDependent("compound"), NodePattern.N.withDependent("amod", NodePattern.N.lemma("modern"))), NodePattern.N.form("organi[zs]ation").andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("(an)?other|single|large|small|huge|tiny|respectable|voluntary|known|renowned|(inter)?national|collective|municipal|governmental")), NodePattern.N.withDependent("compound", NodePattern.or(CommonPatterns.capitalizedMiddle, NodePattern.N.form("charity")))).andNot(NodePattern.N.withHead("nmod", NodePattern.N.lemma("form|aspect|system|approach|pattern"))), NodePattern.N.form("option").andOr(NodePattern.N.withDependent("amod|compound"), NodePattern.N.directlyBefore(NodePattern.N.form("to"))), NodePattern.N.lemma("opportunity").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("amod", NodePattern.N.noPos("JJR")))).noDependents("acl", NodePattern.N.withDependent("mark", NodePattern.N.form("for"))).andNot(NodePattern.N.withDependent("acl", NodePattern.N.withDependent("mark", NodePattern.N.form("to"))).withDependent("amod", NodePattern.N.pos("JJR"))), NodePattern.N.form("change").andOr(NodePattern.N.withDependent("nmod|acl"), NodePattern.N.withDependent("amod", NodePattern.N.pos("JJ.*").noPotentialPos("RB"))), NodePattern.N.form("chance").noDependents("amod", NodePattern.N.form("pure")).withDependent("acl"), NodePattern.N.form("character").withDependent("amod|nmod:poss|compound", NodePattern.N.noPos("DT")), NodePattern.N.form("service").noDependents("compound|amod", NodePattern.N.form("community|voluntary|poor|bad|excellent")), NodePattern.N.form("time").withDependent("amod", NodePattern.N.noForm("high").noPos("RB|NN.*").noDependents()).withDependent("cop"), NodePattern.N.form("culture").withDependent("amod", NodePattern.N.form("(an)?other|different|common")), NodePattern.N.form("capital").andNot(NodePattern.or(NodePattern.N.inPhrase(NodePattern.N.lemma("increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce|have")), NodePattern.N.withDependent("case", NodePattern.N.form("with|without")))), NodePattern.N.form("error").withDependent("amod", NodePattern.N.form("various")), NodePattern.N.form("statement").andOr(NodePattern.N.withDependent("amod|compound|ccomp|acl(:relcl)?"), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("ccomp").and(EnglishTreePatterns.withThatMark))), NodePattern.N.form("estate").noDependents("amod|compound", NodePattern.N.form("real|screen")), NodePattern.N.form("proportion").andOr(NodePattern.N.withDependent("amod|nmod"), NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.form("substance|residence|reference|appearance").withDependent("amod|compound|nmod(:poss)?|det"));
    private static final NodePattern hasIndefiniteArticle = NodePattern.N.withDependent("det", NodePattern.N.form("an?").beforeHead());
    private static final NodePattern aLot = NodePattern.N.inFormSequence(1, "a", "lot");
    static final NodePattern numberDelegatingGroup = NodePattern.or(NodePattern.N.form("lots|loads|handful|stacks|deal|boatload|plethora|plenty"), NodePattern.N.inFormSequence(0, "total", "of"), NodePattern.N.form("number|quantity").andOr(NodePattern.N.withDependent("amod", NodePattern.N.pos("JJS")), NodePattern.N.withDependent("det", NodePattern.N.form("an?"))).noDependents("nmod:poss|nummod", NodePattern.N.beforeHead()).andNot(NodePattern.N.withHead("nsubj", NodePattern.or(NodePattern.N.lemma("increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce"), NodePattern.N.pos("JJR")))), NodePattern.N.form("share|range").and(hasIndefiniteArticle), NodePattern.N.form("bunch").and(hasIndefiniteArticle).andNot(EnglishTreePatterns.isSubjectOfExpl), aLot);
    static final NodePattern possiblyNumberDelegatingGroup = NodePattern.or(NodePattern.N.form("set|subset|chunk|portion|variety|fleet|couple|team|group|bunch|host|raft|bulk|myriad|pair|class"), NodePattern.N.inFormSequence(0, "number", "of").noDependents("det"), NodePattern.N.inFormSequence(0, "proportion", "of"), NodePattern.N.form("lot").noDependents("det"), EnglishTreePatterns.kinda.withDependent("nmod", NodePattern.N.pos("NNS").withDependent("case", NodePattern.N.form("of"))).withDependent("det", Questions.whWord), NodePattern.N.form("percentage").withDependent("amod"), NodePattern.N.form("part|half|third|quarter|most|rest|majority|minority").noDependents("nmod", possiblyUncountableForm), NodePattern.N.inFormSequence(0, "category", "of").withDependent("nmod", NodePattern.N.pos("NNS")).and(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("appos", NodePattern.N.pos("NNS").afterHead()))));
    static final NodePattern plainGroup = NodePattern.N.lemma("collection|multitude|glossary|couple|pair");
    static final NodePattern anyGroup = NodePattern.or(numberDelegatingGroup, possiblyNumberDelegatingGroup, plainGroup).noDependents("compound");
    static final NodePattern saySynonym = NodePattern.N.lemma("say|tell|announce|declare|claim");
    static final NodePattern directSpeech = NodePattern.or(saySynonym, NodePattern.N.lemma("ask|write|report|reply|inform|state"));
    static final NodePattern toHaveOpinion = NodePattern.N.lemma("believe|think|guess");
    static final NodePattern trashSynonyms = NodePattern.N.lemma("garbage|waste|trash|dust|refuse|kerbside");
    static final NodePattern dataSynonyms = NodePattern.N.lemma("sample|data|evidence|resource|blood|urine|information");
    static final NodePattern resourcesSynonyms = NodePattern.N.lemma("resource|time|money|energy");
    static final NodePattern feeSynonyms = NodePattern.N.lemma("tax|debt|toll|fee");
    static final NodePattern actionWithNumbers = NodePattern.or(NodePattern.N.lemma("increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce").withDependent("obj|nsubj:pass"), NodePattern.N.lemma("replace|multiply|subtract|assign"), NodePattern.N.inFormSequence(0, "take", "away"));
    static final NodePattern neverImperative = NodePattern.N.lemma("deserve|need|concern|mean|seem|matter|owe|own|possess|contain|fear|envy");
    static final NodePattern raisingVerb = NodePattern.N.lemma("seem|appear");
    static final NodePattern uncountableOnlyWhenPlural = NodePattern.N.lemma("fish|good|saving");
    static final NodePattern uncountableOnlyWhenSingular = NodePattern.N.form("room|water");
    static final NodePattern singularUncountableAllowingArticle = NodePattern.N.form("shame|equilibrium|consensus|proliferation|patchwork");
    static final NodePattern possiblyNonPluralizableGroup = NodePattern.N.form("vote");
    static final NodePattern timeUnits = NodePattern.or(NodePattern.N.lemma("year|term|semester|century|day|month|decade|autumn|winter|spring|fall|summer|night|evening|morning|season|period|hour|minute|moment"), NodePattern.N.lemma("week.*|.*second"));
    static final NodePattern progressUnit = NodePattern.N.lemma("stage|step|phase");
    static final NodePattern attemptSynonyms = NodePattern.N.lemma("attempt|try|shot|effort");
    @Language(value="RegExp")
    static final String pluralTimeUnits = "hours|days|weeks|months|years|decades|ages|eons|yonks";
    static final NodePattern adverbialTimePoints = NodePattern.N.lemma("tonight|today|yesterday|tomorrow|now|then|soon|later");
    static final NodePattern timePoints = NodePattern.or(adverbialTimePoints, NodePattern.N.lemma("before|after"), NodePattern.N.lemmaCaseSensitive("start|end|beginning").directlyBefore(NodePattern.N.form("of")));
    @Language(value="RegExp")
    static final String uomAbbreviations = "((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])";
    @Language(value="RegExp")
    static final String uom = "(foot|inch|mile|ounce|pound|degree|gallon)|(kilo|deci|centi|milli|nano)?(meter|metre|liter|litre|gram(me)?|hertz|watt)|(mega|giga)?(tonne|pixel|hertz|watt)";
    static final NodePattern uomPattern = NodePattern.or(NodePattern.N.lemma("(foot|inch|mile|ounce|pound|degree|gallon)|(kilo|deci|centi|milli|nano)?(meter|metre|liter|litre|gram(me)?|hertz|watt)|(mega|giga)?(tonne|pixel|hertz|watt)"), NodePattern.N.form("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"), NodePattern.N.form("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])/((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"));
    @Language(value="RegExp")
    static final String monthsShort = "jan|feb|mar|apr|may|jun|jul|aug|sept|oct|nov|dec";
    @Language(value="RegExp")
    static final String currencyNames = "baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar";
    @Language(value="RegExp")
    static final String currencyCentNames = "cent|penny|paise|centavo|kopec?k|copeck|jiao|chiao|fen|rappen|centime|ore|grosz|ban|kobo|piastre|piaster|kurush?|sentimo|sen";
    @Language(value="RegExp")
    static final String currencyAbbreviations = "RUB|EUR|USD|GBP|BTC|ETH";
    @Language(value="RegExp")
    static final String currencyKinds = "note|banknote";
    static final NodePattern currencyPattern = NodePattern.or(NodePattern.N.lemma("baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar"), NodePattern.N.lemma("cent|penny|paise|centavo|kopec?k|copeck|jiao|chiao|fen|rappen|centime|ore|grosz|ban|kobo|piastre|piaster|kurush?|sentimo|sen"), NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]|RUB|EUR|USD|GBP|BTC|ETH"));
    @Language(value="RegExp")
    static final String hourIndication = "pm|am|a\\.m\\.?|p\\.m\\.?|o['\u2019`\u2018]clock";
    @Language(value="RegExp")
    static final String inTransport = "car|taxi|truck|(mini)?van|stroller|canoe|kayak";
    @Language(value="RegExp")
    static final String onTransport = "bus|train|boat|ferry|ship|(aero|air)?plane|tram|(bi|tri|mono|motor)cycle|skateboard|(motor)?bike|horse";
    @Language(value="RegExp")
    static final String transportAction = "get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly";
    @Language(value="RegExp")
    static final String actionInTransport = "sit|sleep|wait|trap|stay|smoke";
    static final WordSet isTransport = WordSet.loadResource("en/words/modes_of_transport.txt");
    static final NodePattern isProgrammingLanguage = WordSet.loadResource((String)"en/words/programming_languages.txt").formPattern;
    static final NodePattern addressWord = NodePattern.N.lemma("street|avenue|ave|lane|floor|road|district");
    static final NodePattern animalPattern = NodePattern.N.lemma("cat|dog|butterfly|horse|cow|bull|sheep|kitten|rabbit|snake|crocodile|ape|monkey|bear|giraffe|lion|tiger|wolverine|leopard|jaguar|rhino(ceros)?|rat|mouse|ant|spider(ling)?|bee(tle)?|chicken|jellyfish|grasshoper|flea|cockroach|lobster|elephant|dolphin|penguin|kangaroo|hippo(potamus)?|cheetah|gorilla|zebra|fox|wolf|ostrich|shark|octopus|turtle|bat|owl|hedgehog|koala|squirrel|deer|elk|moose|bird|duck(ling)?|goose(ling)?|gosling|fatling|lamb(ling)?|puff(in|ling)|cageling|wildling|doe(ling)?|goat(ling)?|pig(let|ling)?|swan(ling)?|cygnet|nestling|ridgeling|suckling");
    private static final NodePattern plant = NodePattern.N.lemma("plant|apple|pear|grape(fruit)?|(water?)melon|orange|satsuma|lemon|banana|peach|cherry|(straw|goose|black|blue|rasp)?berry|potato|kale|sprout|broccoli|carrot|pepper|paprika|tomato|cucumber|(chick)?pea|lentil|(hazel|pea)nut|oak|birch|cactus");
    static final NodePattern sportsGames = NodePattern.N.lemma("chess|(basket|base|volley|hand|foot)ball|soccer|badminton|athletics|tennis|golf|hockey|rugby|cricket");
    static final NodePattern sport = NodePattern.or(sportsGames, NodePattern.N.form("swimming|running|boxing|gymnastics|wrestling"));
    static final NodePattern game = NodePattern.or(NodePattern.N.lemma("(video)?games?|cards"), sportsGames);
    static final NodePattern typesOfBuildings = NodePattern.N.lemma("(coffee|tea|guest|road)?house|villa|building|dorm(itory)?|(book)?shop|(book)?store|studio|cabin|court|hotel|hospital|hospice|morgue|mortuary|station");
    static final NodePattern partsOfBuilding = NodePattern.N.lemma("(ball|bath|bed|board|chat|check|class|cloak|court|guard|house|mail|news|play|press|rest|sales|school|show|work)?room|bath|toilets?|lavatory|attic|cellar|hall|kitchen|office|terrace|roof|balcony|flat|appartment|basement");
    static final NodePattern geographicalRegions = NodePattern.N.lemma("country|county|town|district|land|ground|island|river|continent");
    static final NodePattern physicalPlace = NodePattern.or(NodePattern.N.lemma("city|centre|center|street|road|field"), partsOfBuilding, typesOfBuildings, educationalInstitution, geographicalRegions, Semantics.isTransport.lemmaPattern, NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION"));
    static final NodePattern loneALot = aLot.noDependents("nmod");
    private static final NodePattern inanimatePattern = NodePattern.or(possiblyUncountableLemma.andNot(possiblyCountableCollective).noLemma("carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang"), NodePattern.N.lemma("much|it|this|number|amount|piece|novel|lack|law|instrument|book|cot|task|clock|Interpol|use|infrastructure|phone|gene|militia|meeting|lifespan|day|(small)?pox|case|change|percentage|outage|claim|data|idea|expression|grammar|vocabulary|loss|sign|typhoon|liver|drug|story|edge|marriage|argument|recession|thread|threat|question|army|button|design|computer|regret|article|tablet|media|option|setting|problem|way|mind|mood|state|(water)?fall|reply|e?mail|system|solution|product|cycle|loop|SQL|query|test|check|event|deployment|traffic|doll|toy|seed(ling)?|vetch(ling)?|technique|tactic|approach|view|(view)?point|situation|humanity|humankind|mankind|life|creation|civilization|nature|time|space|eternity|reality|existence|heaven|hell|society|history"), NodePattern.N.form("that").andNot(NodePattern.N.withHead("mark|nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.withHeadRelation("acl:relcl"))), EnglishTreePatterns.someAnyEveryNoThing, NodePattern.N.lemma(".+ing").noLemma(".+ling"), NodePattern.N.lemma(".*class"), loneALot, plant, CommonPatterns.hardcodedProduct, physicalPlace, EnglishTreePatterns.namedITPlace);
    static final NodePattern unlikelyToBeAdj = NodePattern.N.form("party|city|deficit|work|forward|wonted|sport");
    static final NodePattern color = NodePattern.N.form("(black|green|yellow|pink|gray)(ish)?|red(dish)?|(whit|orang|blu|purpl)(e|ish)");
    static final NodePattern season = NodePattern.N.lemma("winter|spring|summer|fall|autumn");
    static final NodePattern degreeAdj = NodePattern.N.form("certain|great|special|strong|weak|small|little|big|large|(in)?significant|long");
    static final NodePattern customsAndBorderProtection = NodePattern.N.inFormSequence(0, "Customs", "and", "Border", "Protection");
    static final NodePattern composeForX = NodePattern.N.inFormSequence(0, "compose", "for", "desktop|web");
    static final NodePattern dockerCompose = NodePattern.N.inFormSequence(1, "docker", "compose");
    static final NodePattern definitelyUncountableNoun = NodePattern.or(definitelyUncountableLemma.noForm("failing|ironworks").andNot(NodePattern.N.inFormSequence(0, "knowledge|access", "of")).andNot(NodePattern.N.inFormSequence(0, "thirst", "for")).andNot(NodePattern.N.inFormSequence(2, "e", "-", "mail")).andNot(CommonPatterns.capitalizedMiddle).noDependents("amod", NodePattern.N.form("little")), NodePattern.N.lemma("air").withDependent("amod", NodePattern.N.lemma("fresh|hot|cold|clean|polluted|transparent"))).andNot(NodePattern.N.pos("VBG").directlyBefore(NodePattern.N.form("one")));
    static final NodePattern withContrastMarker = NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.form("additional|other")), NodePattern.N.withDependent("det", NodePattern.N.form("no")));
    static final NodePattern differOrSame = NodePattern.N.lemma("differ|different|difference|same|similar|equal|vary");
    static final NodePattern fractionDenominator = NodePattern.or(NodePattern.N.form("thirds|fifths|eighths|ninths|twelfths"), NodePattern.N.form(".+ths").and(n -> n.tree().treeSupport().tagToken(n.lowForm().substring(0, n.lowForm().length() - 3)).hasPos("CD")));
    static final NodePattern rareIntransitiveMeaning = NodePattern.N.lemma("build|find").noDependents("obj");
    static final NodePattern useSupposeTo = NodePattern.N.lemma("use|suppose").directlyBefore(NodePattern.N.form("to"));
    static final NodePattern thanksApologies = NodePattern.N.form("thanks?|apologies");
    static final NodePattern orderOfMagnitude = NodePattern.N.inFormSequence(0, "orders?", "of", "magnitude");
    static final NodePattern liveEvent = NodePattern.N.lemma("performance|broadcast|stream|recording|event|show|gig|session|presentation|workshop|music|concert|match");
    static final NodePattern event = NodePattern.or(liveEvent, NodePattern.N.lemma("meeting"));
    static final NodePattern maidOfHonor = NodePattern.N.inFormSequence(0, "maid", "of", "honou?r");
    static final NodePattern reallySingularProperName = NodePattern.or(NodePattern.N.form("John|Peter|Mozilla"), NodePattern.N.label("PERSON").noForm(".+s|Swift|Kabyle").andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.formCaseSensitive("\\p{Lu}.+s")))));
    static final NodePattern needsCapitalization = NodePattern.or(NodePattern.N.form("I"), NodePattern.N.pos("NNP").noForm("other").noHeadRelation("advmod|det|nummod|amod"), NodePattern.N.label("MISC").noForm("alcohol|tobacco"), NodePattern.N.label("LOCATION").withHeadRelation("amod"), NodePattern.N.label("PRODUCT").noFormCaseSensitive("Namespaces").noHeadRelation("amod"), CommonPatterns.hardcodedProduct, NodePattern.N.label("PERSON|GEO_POLITICAL_ENTITY|ORGANIZATION|NICKNAME|LANGUAGE|NATIONALITY_OR_GROUP|DATE|EVENT"));
    static final NodePattern allowedCompoundPluralHead = NodePattern.or(NodePattern.N.lemmaCaseSensitive("Act|Day|analysis|analyst|cup|department|directory|document|factory|folder|group|league|major|manager|pack|section|engineering|system|(sub)?committee|team|union|company|tax|API|sidebar|widget|panel?|view|center|block|feature|track"), NodePattern.N.formCaseSensitive("Service"), EnglishTreePatterns.verbOrPluralCompoundToleratingHead);
    static final NodePattern potentiallyNamedCompoundPlural = CommonPatterns.capitalized.withHead("compound", NodePattern.not(CommonPatterns.capitalized).form("tool|diagram|page|library|window|list"));
    static final NodePattern allowedCompoundPluralNonHead = NodePattern.or(NodePattern.N.form("enemies|publications|assists|admissions|drinks|events|compounds|classifieds|customs|appeals|sales|comics|activities|antiques|antiquities|singles|systems|rewards|kids|ladies|writers|chemicals|weapons|arms|settings|communications|samples|earnings|measles|clothes|souls|las|letters|details|issues|claims|goods|permissions|sweepstakes|appropriations|operations|microsystems|mechatronics|(tele)?communications|microservices|generics|coroutines|sports|physics|maths|arts|mechanics|materials|robotics"), NodePattern.N.formCaseSensitive("Rails"));
    static final NodePattern attributiveOnlyAdj = WordSet.loadResource((String)"en/words/adj_attributive.txt").formPattern;
    private static final NodePattern oneInX = NodePattern.N.inFormSequence(0, "one", "in").withNeighbor(2, NodePattern.N.pos("CD")).withNeighbor(3, CommonPatterns.possiblySkipUp("amod|compound", NodePattern.N.pos("NNS").markAs("X")));
    static final NodePattern frequencyAdverb = NodePattern.or(NodePattern.N.form("always|sometimes|usually|never|often|frequently|rarely|repeatedly|occasionally"), timeUnits.withDependent("det", NodePattern.N.form("each|every")));
    static final NodePattern intensifier = NodePattern.N.form("just|totally|absolutely|much|really");
    private static final NodePattern generalWord = NodePattern.or(NodePattern.N.form("sun|earth|moon|planet|gravity|east|west|north|south|land|continent|people|sport|spiritwater|beer|wine|alcohol|juice|born|humanity|humankind|mankind|life|creation|civilization|nature|time|space|eternity|reality|existence|heaven|hell|society|history"), NodePattern.N.lemma("earthquake|ocean|rain|wind|plant|animal|human|gas|liquid|solid"), NodePattern.N.label("LOCATION|GEO_POLITICAL_ENTITY"), frequencyAdverb, NodePattern.N.lemma("probably|improbable|(un)?likely"), NodePattern.or(animalPattern, plant).pos("NNS"), NodePattern.N.withHead("acl:relcl", NodePattern.N.lemma("way")));
    static final NodePattern generalTruth = NodePattern.custom(n -> {
        Node end = n.phraseEnd();
        return ((StreamEx)n.phraseStart().forward().takeWhileInclusive(n1 -> n1 != end)).anyMatch(generalWord::matches);
    });
    private static final NodePattern moreAndMore = NodePattern.N.sameWordAs(2).directlyBefore(NodePattern.N.form("and")).withNeighbor(2, NodePattern.N.pos("JJR"));
    private static final Set<String> negativePrefixes = Set.of("de", "un", "ir", "mis", "in", "im");
    private static final Set<String> positivePrefixes = Set.of("en");

    Semantics() {
    }

    static boolean canDescribeAbstractConcept(Node clause) {
        return !color.matches(clause) && !humanLikePattern.matches(clause) && !animalPattern.matches(clause) && !anyGroup.matches(clause);
    }

    @Nullable
    static Animacy animacy(Node node) {
        if (humanLikePattern.matches(node) || creaturePattern.matches(node)) {
            return Animacy.humanLike;
        }
        if (animalPattern.matches(node)) {
            return Animacy.animal;
        }
        if (inanimatePattern.matches(node)) {
            return Animacy.inanimate;
        }
        if (node.lowForm().equals("one") || EnglishTreePatterns.anyPercent.matches(node) || anyGroup.matches(node)) {
            NodeMatch match = oneInX.match(node);
            if (match != null) {
                return Semantics.animacy(match.getMarkedNode("X"));
            }
            for (Node nmod : node.findDependents("nmod")) {
                if (!NodePattern.N.withDependent("case", NodePattern.N.form("of")).matches(nmod)) continue;
                return Semantics.animacy(nmod);
            }
            return EnglishTreePatterns.copAdjOne.matches(node) ? null : Animacy.humanLike;
        }
        return null;
    }

    static boolean canDescribeSameEntity(List<Node> nouns) {
        return nouns.size() == 2 && moreAndMore.matches(nouns.get(0)) || nouns.stream().allMatch(n -> n.hasForm("father|husband|mother|wife|cleric|activist|colleague|licensing|billing|.+(ness|ence|ise|[st]ion)|god|man") && !n.hasDependent("nmod:poss"));
    }

    static boolean areSimilarOpposites(Node noun1, Node noun2) {
        String word2;
        String word1 = noun1.lowForm();
        String suffix = Strings.commonSuffix((CharSequence)word1, (CharSequence)(word2 = noun2.lowForm()));
        if (suffix.isEmpty()) {
            return false;
        }
        return Semantics.isPositiveNegative(word1, word2, suffix) || Semantics.isPositiveNegative(word2, word1, suffix);
    }

    private static boolean isPositiveNegative(String positive, String negative, String suffix) {
        if (suffix.equals(positive) && negativePrefixes.contains(Semantics.removeSuffix(negative, suffix))) {
            return true;
        }
        return !suffix.equals(positive) && !suffix.equals(negative) && positivePrefixes.contains(Semantics.removeSuffix(positive, suffix)) && negativePrefixes.contains(Semantics.removeSuffix(negative, suffix));
    }

    private static String removeSuffix(String word, String suffix) {
        return word.substring(0, word.length() - suffix.length());
    }

    @Nullable
    static String removeNegativePrefix(String word) {
        for (String prefix : negativePrefixes) {
            if (!word.startsWith(prefix)) continue;
            return word.substring(prefix.length());
        }
        return null;
    }

    static enum Animacy {
        humanLike,
        animal,
        inanimate;

        final NodePattern pattern = NodePattern.custom(n -> Semantics.animacy(n) == this);
    }
}

