/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

class TypographyRules {
    private static final String USE_SMART_APOSTROPHE = "Use a smart apostrophe";
    static final String NBSP_IBAN = "For better readability, split the IBAN by non-breaking spaces after every fourth character";
    private static final String NUMBER_GROUPING = "Consider dividing the number into groups of three digits for better readability";
    static final String NBSP_NUMBER_UNIT = "There should be a space between the number and the unit of measurement";

    TypographyRules() {
    }

    static NodePattern smartApostrophe() {
        return NodePattern.or(NodePattern.N.form("'.+").noSpaceBefore().withHeadRelation("cop|aux|aux:pass"), NodePattern.N.form("'s?").noSpaceBefore().withHead("case", NodePattern.N.noHeadRelation("cop|aux|aux:pass")), NodePattern.N.inFormSequence(1, "let", "'s").noSpaceBefore(), NodePattern.N.form("o'clock|n't")).includeIntoReport().andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.includeIntoReport())).correct(NodeCorrector.regexReplace("(.*)'(.*)", "$1\u2019$2").batchCapable("UseSmartApostrophe")).message(USE_SMART_APOSTROPHE).and((node, match) -> match.enableAutoFix());
    }

    static NodePattern numberFormatting() {
        NodePattern number = NodePattern.N.form("[1-9]\\d{4,}");
        NodePattern possiblyAddress = NodePattern.or(NodePattern.N.withHeadRelation("list|fixed|<unk>|obl:tmod"), CommonPatterns.possiblySkipDown("appos", NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|MISC")));
        NodePattern documentName = NodePattern.N.form("no|number|data|sample|passport|document|certificate|registration");
        NodePattern possiblyDocumentNumber = NodePattern.or(NodePattern.N.inPhrase(documentName), NodePattern.ROOT.withDependent("nsubj", documentName));
        return number.andNot(NodePattern.or(NodePattern.N.withHead(possiblyAddress), CommonPatterns.possiblySkipDown(".*", possiblyAddress))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHead("appos|parataxis", NodePattern.or(NodePattern.N.pos("NNP"), NodePattern.N.noPos(), NodePattern.N.withHeadRelation("parataxis"))))).andNot(NodePattern.N.withHeadRelation("nummod|nmod").noDependents("case").afterHead()).andNot(NodePattern.N.withHeadRelation("appos").directlyAfterHead()).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(possiblyDocumentNumber).and((node, match) -> {
            String formattingParameter = EnglishParameters.NUMBER_FORMATTING.getValue(node.tree());
            DecimalFormat df = new DecimalFormat("#,###");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(formattingParameter.equals("narrowNbsp") ? (char)'\u202f' : (char)',');
            df.setDecimalFormatSymbols(symbols);
            BigInteger numberParsed = new BigInteger(node.form());
            String formatted = df.format(numberParsed);
            return match.withCorrector(NodeCorrector.replace(node, formatted));
        }).message(NUMBER_GROUPING);
    }
}

