/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PolarityItemViolations;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.List;

class WordConfusion {
    static final NodePattern loseLoose = NodePattern.N.form("looses?").andOr(EnglishTreePatterns.clause.and(CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("obj"))), NodePattern.N.directlyAfter(EnglishTreePatterns.negation).directlyBefore(NodePattern.N.pos("NN.*|PRP.*|DT")));
    static final String IN_PRINCIPLE_MSG = "Did you mean 'in principle'?";
    static final NodePattern lowercaseI = NodePattern.N.formCaseSensitive("i").andNot(SubjectVerbAgreement.misparsedId);
    static final NodePattern wheyThey = NodePattern.N.form("whey").withHead("nsubj.*", EnglishTreePatterns.addAuxVerbs(NodePattern.N.pos("VBP?")));
    static final NodePattern inIt = NodePattern.N.form("in").withHead("nsubj.*", EnglishTreePatterns.addAuxVerbs(NodePattern.N.pos("VBP?")));
    static final NodePattern copHeadTypo = NodePattern.N.withDependent("cop|aux:pass", NodePattern.N.directlyBeforeHead()).andOr(NodePattern.N.form("sh[ou]re").and(EnglishTreePatterns.typoReplacement("sure")), NodePattern.N.form("seem").and(EnglishTreePatterns.typoReplacement("seen")));
    static final NodePattern youYourTypo = NodePattern.N.form("you").directlyBefore(NodePattern.N.pos("NN.*").noHeadRelation("obl:tmod").andNot(EnglishTreePatterns.localUnk).and(Semantics.Animacy.inanimate.pattern)).directlyAfter(NodePattern.N.withHeadRelation("cop")).withNeighbor(-2, CommonPatterns.letterWord);
    private static final NodePattern ofAfterModal = NodePattern.N.form("of").noDependents(NodePattern.N.afterHead()).directlyAfter(NodePattern.N.form("should|could|would|might|must|will|may").noPos("NN.*").markAs("Modal"));
    static final NodePattern percentConfusedWithPercentage = NodePattern.or(NodePattern.N.inFormSequence(0, "percents?", "of"), NodePattern.N.form("percent").andOr(NodePattern.N.withDependent("amod", Semantics.degreeAdj), NodePattern.N.inFlatTree().after(Semantics.degreeAdj))).andNot(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("nummod"))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.number));
    private static final NodePattern XApart = NodePattern.N.lemma("fall|tear|be|break|set|take|come|stand|drift|grow|tell|split|blow|keep|move|cut|tease");
    static final NodePattern aPart = NodePattern.N.inFormSequence(1, "a", "part").andOr(NodePattern.N.withHead("advmod|obj|xcomp", XApart).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("case"))), NodePattern.N.withHeadRelation("root|ccomp").withDependent("cop", NodePattern.N.lemma("be")).noDependents(NodePattern.N.afterHead().noHeadRelation("punct")), NodePattern.N.inFormSequence(1, "a", "part", "from").andOr(NodePattern.N.withNeighbor(-1, CommonPatterns.firstWord), NodePattern.N.withNeighbor(-2, CommonPatterns.firstWord.withHeadRelation("cc|punct"))));
    private static final String LOOSE_MSG = "Did you mean 'lose' (no longer have something, or fail in a game or competition)?";
    private static final String STAFF_MSG = "Did you mean 'stuff' (things, material)?";
    private static final String I_MSG = "Did you mean the 'I' pronoun?";
    private static final NodePattern fromWereWhere = NodePattern.N.form("were").withDependent("case").and(EnglishTreePatterns.typoReplacement("where"));
    static final NodePattern wereWeTypo = NodePattern.N.form("were").directlyBefore(NodePattern.not(EnglishTreePatterns.negation)).andOr(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withHead("aux.*", NodePattern.N.noDependents("nsubj.*"))).markAs("Were").withHead(NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.after("Were").markAs("Next")), NodePattern.N.markAs("Next"))).and(NodePattern.markedNodeMatches("Next", NodePattern.N.potentialPos("VBP|MD"))).noDependents().and(EnglishTreePatterns.typoReplacement("we"));
    static final NodePattern wontWant = NodePattern.or(NodePattern.N.form("wo").directlyBefore(TreeMigration.revise("CONTRACTED_NOT might be enough", NodePattern.N.form("n['\u2019`\u2018]?t").markAs("End"))), NodePattern.N.form("wont").markAs("End")).andOr(NodePattern.N.withDependent("xcomp", EnglishTreePatterns.withToMark).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withDependent("case").trace("case on subject")), NodePattern.N.markAs("Wo").withHead("aux|dep", NodePattern.or(NodePattern.N.pos("NN.*|PRP").noPotentialPos("VBP?").noDependents("cop|aux|aux:pass", NodePattern.N.beforeHead().after("Wo")), NodePattern.N.withDependent("mark", NodePattern.N.form("to").after("Wo"))))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "want")).message("Did you mean 'want'?");
    static final NodePattern myMayTypo = NodePattern.N.form("my").andOr(NodePattern.N.withHeadRelation("aux|discourse").andNot(CommonPatterns.lastWord), NodePattern.N.and(CommonPatterns.beforeSkipping(NodePattern.N.pos("PDT"), NodePattern.N.onlyPos("PRP.*"))), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.potentialPos("VB").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").noDependents("cop|aux|aux:pass").noHeadRelation("advcl").noForm("motive"), NodePattern.N.form("the|be"), NodePattern.N.formCaseSensitive("a").spaceAfter()))).and(EnglishTreePatterns.typoReplacement("may"));
    static final NodePattern itDirectlyBeforeHead = NodePattern.N.formCaseSensitive("[Ii]t").directlyBeforeHead();
    static final NodePattern lowerHigherNoun = NodePattern.N.form("level|score|temperature|rate|number|amount|rank|cost|price|altitude|volume|pressure|risk|speed|density|performance|attendance|priority|frequency");

    WordConfusion() {
    }

    static NodePattern similarWordConfusion() {
        return NodePattern.or(WordConfusion.principalPrinciple(), WordConfusion.aBut(), WordConfusion.loose(), WordConfusion.stuff(), WordConfusion.proofProve(), WordConfusion.thank(), WordConfusion.capitalizeI(), WordConfusion.wheyThey(), WordConfusion.oSpaceClock(), WordConfusion.nrNo(), EnglishTreePatterns.doSoTypo.and(EnglishTreePatterns.typoReplacement("so")), WordConfusion.whetherWeather(), WordConfusion.youYour(), WordConfusion.ofHave(), WordConfusion.lifeLive(), WordConfusion.affectEffect(), WordConfusion.outOur(), copHeadTypo, WordConfusion.onOne(), WordConfusion.liveLoveLike(), WordConfusion.mans(), WordConfusion.varyVery(), WordConfusion.seeSea(), WordConfusion.illWill(), WordConfusion.webSight(), WordConfusion.expandExpend(), WordConfusion.whichWitch(), WordConfusion.thinkThing(), WordConfusion.markTypo(), WordConfusion.isIt(), WordConfusion.inIt(), WordConfusion.heartHeard(), WordConfusion.deThe(), WordConfusion.noNot(), WordConfusion.atAl(), WordConfusion.aPart(), WordConfusion.intransitiveToTransitive(), WordConfusion.transitiveToIntransitive(), WordConfusion.wanderWonder(), WordConfusion.quietQuite(), WordConfusion.defenseDefend(), WordConfusion.supper(), wereWeTypo, fromWereWhere, wontWant, myMayTypo).andNot(CommonPatterns.quotedWord);
    }

    private static NodePattern nrNo() {
        return NodePattern.N.inFormSequence(0, "Nr", "\\.").withNeighbor(2, CommonPatterns.withNumberLikeForm).andOr(EnglishParameters.VARIANT.withValue("GB.*").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "No")), NodePattern.N.correct(NodeCorrector.replace("No"))).message("Did you mean the abbreviation for 'number'?");
    }

    private static NodePattern intransitiveToTransitive() {
        NodePattern citation = CommonPatterns.capitalized.directlyAfter(CommonPatterns.openingParen);
        NodePattern misparsedObl = NodePattern.N.withPhraseStart(NodePattern.N.pos("IN").before("Obj"));
        NodePattern misparsedAdvmod = NodePattern.or(NodePattern.N.inFormSequence(1, "a", "bit|little"), NodePattern.N.noDependents().and(n -> n.tree().treeSupport().tagToken(n.lowForm() + "ly").hasPos("RB")));
        return NodePattern.N.withDependent("obj", NodePattern.N.pos("NN.*|PRP").andNot(citation).andNot(misparsedAdvmod).markAs("Obj").andNot(misparsedObl)).andOr(NodePattern.N.lemma("proceed").and(WordConfusion.verbLemmaReplacement("process")).correct(NodeCorrector.insertBefore(NodePointer.marked("Obj"), "with ")), NodePattern.N.lemma("rise").andNot(NodePattern.markedNodeMatches("Obj", EnglishTreePatterns.anyPercent)).andOr(NodePattern.markedNodeMatches("Obj", NodePattern.N.form("health")).and(WordConfusion.verbLemmaReplacement("improve")), WordConfusion.verbLemmaReplacement("raise")));
    }

    private static NodePattern transitiveToIntransitive() {
        return NodePattern.N.lemma("raise").andOr(NodePattern.N.withDependent("obl.*", NodePattern.N.afterHead()).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("i?obj|nsubj:pass"), NodePattern.N.withHeadRelation("acl"), NodePattern.N.withHeadRelation("acl:relcl").noDependents("mark|advmod", NodePattern.N.beforeHead())))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("fund"))), NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "up", "to"))).and(WordConfusion.verbLemmaReplacement("rise"));
    }

    private static NodePattern verbLemmaReplacement(String newLemma) {
        return NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma(newLemma)).message("Did you mean 'to " + newLemma + "'?");
    }

    private static NodePattern mans() {
        return NodePattern.N.form("mans").andOr(NodePattern.not(EnglishTreePatterns.clause), NodePattern.N.withDependent("cop")).andNot(CommonPatterns.capitalizedMiddle).andOr(EnglishTreePatterns.compound.and(EnglishTreePatterns.typoReplacement("man\u2019s")), EnglishTreePatterns.typoReplacement("men"));
    }

    private static NodePattern isIt() {
        NodePattern isToIt = NodePattern.N.form("is").directlyBefore(NodePattern.N.pos("MD|VBZ")).reportEverythingTouched().andOr(NodePattern.N.withHead("nsubj|expl", NodePattern.not(NodePattern.N.pos("VBP?|MD").noDependents("cop|aux|aux:pass")).andNot(CommonPatterns.severalDependents("expl"))), NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Is")).noDependents("case")))).andNot(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl").noDependents("mark")).and(EnglishTreePatterns.typoReplacement("it"));
        NodePattern itToIs = NodePattern.or(itDirectlyBeforeHead.withHead("nsubj", NodePattern.N.pos("JJ.*|VBG").noPos("VBD").andOr(NodePattern.N.withHeadRelation("amod").afterHead(), NodePattern.N.noForm("worth").withHeadRelation("acl(:relcl)?|conj")).noDependents("cop|aux|aux:pass|xcomp").and(CommonPatterns.skipConjUp(NodePattern.N.noDependents("mark", NodePattern.N.noForm("that"))))), NodePattern.N.form("it").withHeadRelation("cop|aux|aux:pass")).and(EnglishTreePatterns.typoReplacement("is"));
        return NodePattern.or(isToIt, itToIs);
    }

    private static NodePattern markTypo() {
        return CommonPatterns.firstChildPhrase.andOr(NodePattern.N.withHead("cop|aux|aux:pass|advcl", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.markAs("Subj")).withDependent("cop|aux|aux:pass", NodePattern.N.after("Subj").pos("MD|VB[ZDP]")).andNot(NodePattern.ROOT.and(CommonPatterns.withQuestionMark)).noHeadRelation("csubj|acl:relcl|parataxis")), NodePattern.N.withHeadRelation("advmod")).andNot(NodePattern.N.directlyAfter(NodePattern.N.noLemma(".*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("WDT|IN"))).noDependents(NodePattern.N.beforeHead()).andOr(NodePattern.N.form("is").and(EnglishTreePatterns.typoReplacement("if")), NodePattern.N.form("were").and(EnglishTreePatterns.typoReplacement("where")));
    }

    private static NodePattern whichWitch() {
        return NodePattern.N.form("witch").withHeadRelation("mark|nsubj(:pass)?").noDependents().and(EnglishTreePatterns.typoReplacement("which"));
    }

    private static NodePattern thinkThing() {
        return NodePattern.N.form("thinks?").andOr(NodePattern.N.withDependent("amod|det|nmod:poss"), NodePattern.N.directlyBefore(NodePattern.N.form("like")).withDependent("acl|advcl|nmod", CommonPatterns.insideQuotes), NodePattern.N.directlyAfter(NodePattern.ROOT.onlyPos("JJ")), NodePattern.ROOT.directlyAfter(NodePattern.N.pos("DT")).noDependents("cop|aux|aux:pass").directlyBefore(NodePattern.N.withHeadRelation("cop"))).correct(NodeCorrector.regexReplace("think(s)?", "thing$1")).andOptionally(NodePattern.N.form("thinks").correct(NodeCorrector.replace("thoughts"))).message("Did you mean another word?");
    }

    private static NodePattern liveLoveLike() {
        return NodePattern.N.inFormSequence(0, "live", "to").directlyAfter(NodePattern.N.lemma("will").form(".+d")).correct(NodeCorrector.replace("like", "love")).message("Did you mean 'like' or 'love'?");
    }

    private static NodePattern onOne() {
        return NodePattern.N.inFormSequence(0, "on", "of").and(EnglishTreePatterns.typoReplacement("one"));
    }

    private static NodePattern ofHave() {
        return ofAfterModal.reportEverythingTouched().andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("PRP"))).and((of, match) -> {
            Node modal = match.getMarkedNode("Modal");
            boolean contracted = EnglishParameters.suggestContractedForms.matches(of);
            String have = contracted && !modal.hasForm("will") ? "\u2019ve" : " have";
            return match.withCorrector(NodeCorrector.replace(of, "").join(NodeCorrector.insertAfter(modal, have)));
        }).message("'Of' does not typically follow '$_'");
    }

    private static NodePattern whetherWeather() {
        return NodePattern.N.form("whether").andOr(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"), NodePattern.N.withHead("mark|case", NodePattern.or(NodePattern.N.withHeadRelation("obl.*"), NodePattern.N.withHeadRelation("advcl").noPos("VB.*").noDependents("cop|aux|aux:pass")))).withHead(NodePattern.N.withPhraseEnd(NodePattern.not(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("or"))).markAs("End"))).noMatchUntil("End", NodePattern.N.form("or")).and(EnglishTreePatterns.typoReplacement("weather"));
    }

    private static NodePattern affectEffect() {
        NodePattern effectedNoun = NodePattern.N.lemma("change|will");
        return NodePattern.or(NodePattern.N.lemma("affect").onlyPos("NNS?").noHeadRelation("compound").noDependents("obj").noDependents("punct", CommonPatterns.colon).andNot(NodePattern.N.inFormSequence(1, "facial|flat|blunted|constricted|restricted|labile|inappropriate", "affects?")).inPhrase(NodePattern.ROOT.withPhraseStart(NodePattern.N.markAs("Sent start"))).noMatchUntil("Sent start", NodePattern.N.lemma("patient|interpersonal")).message("Did you mean 'effect' (consequence, result)?").correct(NodeCorrector.regexReplace("affect(.*)", "effect$1")), NodePattern.N.lemma("effect").onlyPos("VB[^G]?").andOr(NodePattern.N.withDependent("obj", NodePattern.not(effectedNoun)), NodePattern.N.withDependent("aux:pass").andNot(NodePattern.N.withHead(effectedNoun))).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("by"))).message("Did you mean the verb 'affect' (to influence)?").correct(NodeCorrector.regexReplace("effect(.*)", "affect$1"))).andNot(CommonPatterns.capitalizedMiddle);
    }

    private static NodePattern lifeLive() {
        NodePattern animalClassPattern = NodePattern.N.lemma("animal|pet|insect|predator|bird|mammal|creature|bug|reptile|amphibian|carnivore|primate");
        return NodePattern.N.form("life").withHead("compound", CommonPatterns.possiblySkipUp("compound", NodePattern.or(Semantics.animalPattern, animalClassPattern, Semantics.liveEvent).withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.lemma("see|watch|observe|look|hear|listen|attend|participate|come")))).noDependents().and(EnglishTreePatterns.typoReplacement("live"));
    }

    private static NodePattern outOur() {
        return NodePattern.N.form("out").markAs("Out").withHead("case|compound|amod|nmod:poss|dep", NodePattern.N.pos("NNS?").noHeadRelation("compound|obj").noDependents("cop|aux|aux:pass|nmod:poss|det", NodePattern.not(NodePattern.N.alreadyMarkedAs("Out"))).noDependents("case", NodePattern.N.after("Out")).noDependents("amod|compound", NodePattern.N.before("Out")).noDependents("compound", NodePattern.N.noPos())).withOnlyDependents(NodePattern.N.withHeadRelation("flat")).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.PUNCT, NodePattern.N.form("/"), NodePattern.N.lemma("variable|parameter|port|of|channel")))).and(EnglishTreePatterns.typoReplacement("our"));
    }

    private static NodePattern youYour() {
        NodePattern misparsedNP = NodePattern.N.pos("VBG").withHeadRelation("ccomp");
        NodePattern your = NodePattern.N.form("your").andOr(NodePattern.N.withHead("nsubj", NodePattern.N.potentialPos("VBP")).directlyBeforeHead().and(EnglishTreePatterns.typoReplacement("you")), NodePattern.N.withHeadRelation("obl").withDependent("case").message("Is there a noun missing after 'your'?"), NodePattern.or(NodePattern.N.withHead("nsubj", NodePattern.N.potentialPos("VB[NG]|JJ.*|NN.*|PRP").andNot(EnglishTreePatterns.misparsedObl).andNot(misparsedNP)), NodePattern.N.withNextSibling(NodePattern.N.beforeHead().withHead("det", NodePattern.N.noDependents("case")).andNot(CommonPatterns.capitalizedMiddle)), NodePattern.N.withHead("nmod:poss", NodePattern.ROOT.pos("JJ").andOr(NodePattern.N.noPos("NN"), NodePattern.N.pos("NN").withDependent("advmod", NodePattern.N.directlyBeforeHead()), NodePattern.N.inFormSequence(0, "one", "of")).noDependents("case")), NodePattern.N.withHeadRelation("cop|aux|aux:pass")).and(EnglishTreePatterns.typoReplacement("you\u2019re"))).markAs("Your").andNot(NodePattern.N.withHead(NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Your"))), NodePattern.N.withHeadRelation("xcomp"), NodePattern.N.withHeadRelation("ccomp").withDependent("mark", NodePattern.N.form("that")))));
        NodePattern you = youYourTypo.and(EnglishTreePatterns.typoReplacement("your"));
        return NodePattern.or(your, you);
    }

    private static NodePattern oSpaceClock() {
        return NodePattern.N.inFormSequence(0, "o", "['\u2019`\u2018]", "clock").andOr(NodePattern.N.spaceAfter(), NodePattern.N.withNeighbor(1, NodePattern.N.spaceAfter())).message("'o\u2019clock' is written without spaces").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "o\u2019clock"));
    }

    private static NodePattern wheyThey() {
        return wheyThey.and(EnglishTreePatterns.typoReplacement("they"));
    }

    private static NodePattern inIt() {
        return inIt.and(EnglishTreePatterns.typoReplacement("it")).and((node, match) -> match.concedingToOtherGrammarCheckers());
    }

    private static NodePattern varyVery() {
        return NodePattern.N.form("vary").andOr(NodePattern.N.beforeHead().andOr(NodePattern.N.withHead("advmod", NodePattern.N.pos("JJ")), NodePattern.N.directlyAfter(NodePattern.N.form("the")).withHead("amod|compound", NodePattern.N.pos("NN.*")), NodePattern.N.withHead("amod", NodePattern.N.pos("NN.*")).withNextSibling(NodePattern.N.withHeadRelation("amod"))), NodePattern.N.withDependent("cop|aux:pass", NodePattern.N.lemma("be")).directlyBefore(NodePattern.N.pos("JJ"))).and(EnglishTreePatterns.typoReplacement("very"));
    }

    private static NodePattern seeSea() {
        return NodePattern.N.form("see").andNot(CommonPatterns.capitalizedMiddle).andOr(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").afterHead().withDependent("case", NodePattern.N.pos("IN")).noDependents("amod|compound", NodePattern.N.form("holy")).and(EnglishTreePatterns.typoReplacement("sea")), NodePattern.N.withHeadRelation("advcl|acl").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("mark", NodePattern.N.form("at|for").directlyBeforeHead().markAs("Prep")).and(EnglishTreePatterns.typoReplacement("seeing")).andOptionally(NodePattern.N.withHeadRelation("acl").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to"))));
    }

    private static NodePattern capitalizeI() {
        NodePattern compatibleFiniteVerb = NodePattern.or(NodePattern.N.pos("VB[PD]|MD"), NodePattern.N.form("will|have"));
        NodePattern possiblyMisparsedCompound = NodePattern.N.directlyAfter(NodePattern.N.pos("JJ").withDependent("det")).directlyBefore(NodePattern.N.potentialPos("NN.*"));
        NodePattern misparsedLetterSequence = NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc").and(CommonPatterns.afterSkipping(CommonPatterns.comma, NodePattern.N.form("[a-z]"))));
        return lowercaseI.noDependents().withHead("nsubj.*|flat", NodePattern.or(compatibleFiniteVerb.noDependents("cop|aux|aux:pass"), NodePattern.N.withDependent("cop|aux|aux:pass", compatibleFiniteVerb).noDependents("cop|aux|aux:pass", NodePattern.N.pos("VBZ")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.anyPos().withHeadRelation("nsubj"))).andNot(possiblyMisparsedCompound).andNot(misparsedLetterSequence).correct(NodeCorrector.replace("I")).and(CommonPatterns.highlightPlusOneChar).message(I_MSG);
    }

    private static NodePattern proofProve() {
        return NodePattern.or(NodePattern.N.lemma("proof").and(EnglishTreePatterns.verbalClause).andOr(NodePattern.N.withDependent("advmod", NodePattern.N.form("mathematically|logically")), NodePattern.N.withDependent("obj|nsubj:pass", NodePattern.N.lemma("theorem|lemma")), NodePattern.N.withDependent("obj", NodePattern.N.form(".+sel(f|ves)")), NodePattern.N.withDependent("ccomp"), NodePattern.N.withDependent("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("to")))).correct(EnglishTreePatterns.changeVerbLemma("prove")).message("Did you mean 'prove'?"), NodePattern.N.form("prove").andOr(NodePattern.N.withDependent("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case"), NodePattern.N.withHeadRelation("xcomp").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("of")))).correct(NodeCorrector.replace("proof")).message("Did you mean the noun 'proof'?"));
    }

    private static NodePattern stuff() {
        NodePattern stuffVerbs = NodePattern.N.lemma("hide|store|bring|deliver|do|lose");
        NodePattern stuffNouns = NodePattern.N.lemma("box");
        return NodePattern.N.form("staff").andOr(NodePattern.N.withDependent("amod", NodePattern.N.form("different|lost|related|other")), NodePattern.N.withDependent("compound", NodePattern.N.form("work")), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("like"))).noDependents("compound"), NodePattern.N.withHead("obj", NodePattern.or(stuffVerbs, NodePattern.N.withDependent("xcomp", stuffVerbs.potentialPos("VBN")))), NodePattern.N.withHead("nmod", stuffNouns)).correct(NodeCorrector.replace("stuff")).message(STAFF_MSG);
    }

    private static NodePattern loose() {
        NodePattern losingNoun = NodePattern.N.lemma("effort|record|season|mind|job|money|wallet");
        return NodePattern.or(loseLoose.correct(NodeCorrector.regexReplace("loose(.*)", "lose$1")), NodePattern.N.form("loosing").correct(NodeCorrector.replace("losing")).andOr(NodePattern.N.withDependent("obj", losingNoun), NodePattern.N.withHead("compound|amod", losingNoun))).message(LOOSE_MSG);
    }

    private static NodePattern aBut() {
        return NodePattern.N.formCaseSensitive("but").directlyAfter(NodePattern.N.formCaseSensitive("a").andNot(NodePattern.N.directlyAfter(Questions.whWord)).andNot(CommonPatterns.firstWord)).and(EnglishTreePatterns.typoReplacement("bit"));
    }

    private static NodePattern principalPrinciple() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "in", "principal").reportEverythingTouched().withHeadRelation("obl").correct(NodeCorrector.replace("principle")).message(IN_PRINCIPLE_MSG), NodePattern.N.form("principals").andOr(NodePattern.N.withDependent("amod", NodePattern.N.form("basic|general")), NodePattern.N.withDependent("case", NodePattern.N.form("against")), NodePattern.N.withHead("obj", NodePattern.N.lemma("violate")), NodePattern.N.withDependent("case", NodePattern.N.form("to")).withHead("obl", NodePattern.N.lemma("stick"))).and(EnglishTreePatterns.typoReplacement("principles")), NodePattern.N.form("principle").andOr(NodePattern.N.withHead("amod", NodePattern.N.lemma("activity|investigator")), NodePattern.N.withDependent("compound", NodePattern.N.form("school"))).and(EnglishTreePatterns.typoReplacement("principal")));
    }

    private static NodePattern thank() {
        return NodePattern.or(NodePattern.N.form("thank").directlyBefore(NodePattern.or(NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_LIKE_NODE), NodePattern.N.form("for|to"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("to"))).and(EnglishTreePatterns.typoReplacement("thanks")), NodePattern.N.form("thanks").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("you")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withDependent("cop|aux|aux:pass").directlyBefore(NodePattern.N.withHeadRelation("obj"))).and(EnglishTreePatterns.typoReplacement("thank")));
    }

    private static NodePattern illWill() {
        return NodePattern.N.form("ill").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nsubj")).directlyBefore(NodePattern.N.pos("VB")), NodePattern.N.withHead("aux", NodePattern.N.pos("VB"))).and(EnglishTreePatterns.typoReplacement("will"));
    }

    private static NodePattern webSight() {
        return NodePattern.N.form("(sight|sit)s?").directlyAfter(NodePattern.N.form("web")).message("Did you mean 'website'?").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, "web" + node.lowForm().replace("t", "te").replace("gh", ""))));
    }

    private static NodePattern expandExpend() {
        NodePattern expandable = NodePattern.or(NodePattern.N.lemma("horizon|business|knowledge|mind|vocabulary|carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang"), Semantics.possiblyCountableCollective);
        return NodePattern.or(NodePattern.N.lemma("expand").withDependent("obj|nsubj:pass", CommonPatterns.possiblySkipDown("nmod", Semantics.resourcesSynonyms.noDependents("compound|amod"))).correct(EnglishTreePatterns.changeVerbLemma("expend")).message("Expand' means 'to increase in size'; did you mean 'expend' (to spend, use)?"), NodePattern.N.lemma("expend").andOr(NodePattern.N.withDependent("obj|nsubj:pass", expandable), NodePattern.N.withHead("amod", expandable), NodePattern.N.withDependent("obj").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("into"))), EnglishTreePatterns.clause.noHeadRelation("acl(:relcl)?|advcl").noDependents("obj|nsubj:pass")).correct(EnglishTreePatterns.changeVerbLemma("expand")).message("'Expend' means 'to spend'; did you mean 'expand' (to increase in size)?`"));
    }

    private static NodePattern heartHeard() {
        return NodePattern.or(NodePattern.N.form("heart|herd").andOr(NodePattern.N.withDependent("aux", NodePattern.N.lemma("have")), NodePattern.N.directlyBefore(NodePattern.N.withHead("mark", NodePattern.N.withDependent("nsubj.*")))), NodePattern.N.inFormSequence(0, "heart", "of").withHead("obj", NodePattern.N.lemma("have")).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("gold|stone|oak|hearts|palm|darkness")))).noDependents("det|nmod:poss").and(EnglishTreePatterns.typoReplacement("heard"));
    }

    private static NodePattern wanderWonder() {
        return NodePattern.N.pos("VB.?").andOr(NodePattern.N.lemma("wander").directlyBefore(NodePattern.N.form("if|whether|why|how|what|who|that|which")).correct(NodeCorrector.regexReplace("wander", "wonder")).message("Did you mean 'wonder'?"), NodePattern.N.lemma("wonder").directlyBefore(NodePattern.N.form("around|through|into|down|over|from|away|out|up|back|along|aimlessly|round|far|by|freely|among|across|outside|onto|alone")).correct(NodeCorrector.regexReplace("wonder", "wander")).message("Did you mean 'wander'?"));
    }

    private static NodePattern quietQuite() {
        NodePattern quiteANoun = NodePattern.N.withDependent("det", NodePattern.N.form("an?").directlyAfter("Quiet"));
        NodePattern suggestOnlyQuite = CommonPatterns.skipUp("advmod|amod", NodePattern.or(NodePattern.N.withDependent("cop").andNot(Questions.question), NodePattern.N.withHead("xcomp", AdverbAdjectiveConfusion.adjRequiringVerbs.andNot(Questions.question)), quiteANoun));
        return NodePattern.or(NodePattern.N.form("quiet").markAs("Quiet").andOr(NodePattern.N.withHead(quiteANoun), NodePattern.N.directlyBeforeHead().withHead("advmod|amod", NodePattern.N.pos("JJ")), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").directlyBefore(NodePattern.N.pos("JJ").noPotentialPos("RB"))).andOr(suggestOnlyQuite.correct(NodeCorrector.replace("quite")), NodePattern.N.withHead(NodePattern.N.pos("JJ").noPos("NN.*").noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")).correct(NodeCorrector.replace("quite", "quietly")).andOptionally(AdverbAdjectiveConfusion.suggestAdjAnd.correct(NodeCorrector.replace("quiet and")))).message("Did you mean 'quite'?"), NodePattern.N.form("quite").andOr(NodePattern.N.withHead("amod", NodePattern.N.noPos("JJ")), NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withDependent("cop", EnglishTreePatterns.imperativeVB)).andOptionally(NodePattern.N.withHead(Articles.nounWithoutDeterminer.onlyPos("NN").andOr(Semantics.possiblyUncountableLemma, Semantics.definitelyUncountableNoun).correct(NodeCorrector.insertBefore("a lot of ")))).correct(NodeCorrector.replace("quiet")).message("Did you mean 'quiet'?"));
    }

    private static NodePattern defenseDefend() {
        NodePattern sportNouns = NodePattern.N.lemma("(corner|quarter|half|full)back|pass");
        NodePattern sportOrganization = CommonPatterns.capitalizedMiddle.pos("NN.*").label("ORGANIZATION");
        return NodePattern.N.form("defens(e[ds]?|ing)").noHeadRelation("amod").withDependent("obj", NodePattern.not(sportNouns).andNot(sportOrganization)).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", sportOrganization).andNot(CommonPatterns.skipConjUp(NodePattern.N.withDependent("obj", sportNouns))).correct(NodeCorrector.regexReplace("defense(.*)", "defend$1")).message("Did you mean 'defend'?");
    }

    private static NodePattern supper() {
        return NodePattern.N.form("super").pos("NN").noHeadRelation("compound|root|appos").andNot(CommonPatterns.quotedWord).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).and(EnglishTreePatterns.typoReplacement("supper"));
    }

    static NodePattern deThe() {
        String relations = "compound|nmod:poss|amod";
        return NodePattern.N.form("de").andOr(NodePattern.N.directlyBeforeHead().withHeadRelation(relations).noDependents("compound").markAs("De").directlyBefore(NodePattern.N.pos("NNS?").andNot(EnglishTreePatterns.withToMark).noDependents("det|nmod:poss", NodePattern.N.beforeHead().andNot(NodePattern.N.alreadyMarkedAs("De"))).andNot(NodePattern.N.withHead("obj", CommonPatterns.severalDependents("obj"))).andNot(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.inFormSequence(1, "chef", "de", "mission")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation(relations))), NodePattern.N.withHeadRelation("det")).and(EnglishTreePatterns.typoReplacement("the"));
    }

    private static NodePattern noNot() {
        return NodePattern.or(NodePattern.N.lemma("not").markAs("Not").directlyAfter(NodePattern.N.lemma("have|do|be|can|should|would").withDependent("obj|nsubj", NodePattern.N.pos("NN.?").afterHead().noLemma("lot|enough|(any|every|no|some).*").withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead().withHeadRelation("amod|compound").noPos("RB|DT").noForm("enough|sufficient").noDependents(), NodePattern.N.alreadyMarkedAs("Not"), NodePattern.N.afterHead())).markAs("Noun")).noDependents(NodePattern.not(NodePattern.N.alreadyMarkedAs("Not")).pos("RB").before("Noun").afterHead())).andOr(NodePattern.N.form("not").and(EnglishTreePatterns.typoReplacement("no")), EnglishTreePatterns.typoReplacement(" no")), NodePattern.N.form("no").directlyAfter(NodePattern.N.withHeadRelation("cop|aux|aux:pass").andNot(CommonPatterns.firstWord.form("may"))).withHead("advmod", NodePattern.N.noForm("longer|more|less|different|doubt|other")).and(EnglishTreePatterns.typoReplacement("not")));
    }

    static NodePattern commonlyConfusedWords() {
        return NodePattern.or(WordConfusion.borrowLend(), WordConfusion.veryReally(), WordConfusion.workJob(), WordConfusion.besideBesides(), WordConfusion.rememberRemind(), WordConfusion.percent(), WordConfusion.whileWhen(), WordConfusion.layLie(), WordConfusion.sayTell(), WordConfusion.bringTake(), WordConfusion.wellSuitting(), WordConfusion.littleSmall(), WordConfusion.compriseComposeConsist(), WordConfusion.neededNecessary(), WordConfusion.lessMoreLowerHigher(), WordConfusion.soSuch(), WordConfusion.handy(), WordConfusion.itIsSure(), WordConfusion.womanWife(), WordConfusion.asWellAsAnd()).andNot(CommonPatterns.quotedWord);
    }

    private static NodePattern asWellAsAnd() {
        return NodePattern.N.inFormSequence(0, "as", "well", "as").withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.withDependent("cc:preconj", NodePattern.N.form("both").includeIntoReport(ReportingKind.Hover)).andNot(CommonPatterns.severalDependents("conj")))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "and")).message("'both' and 'as well as' are not typically used together");
    }

    private static NodePattern itIsSure() {
        return NodePattern.N.form("sure").withDependent("cop", NodePattern.N.lemma("be")).withDependent("nsubj|expl", NodePattern.N.form("it")).withDependent("ccomp", EnglishTreePatterns.clause).correct(NodeCorrector.replace("certain")).message("'It is sure' is uncommon");
    }

    private static NodePattern womanWife() {
        return NodePattern.N.form("wom[ae]n").withDependent("nmod:poss", NodePattern.N.form("my|your|his").markAs("Poss")).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).message("'$Poss woman' can sound objectifying in modern English").andOr(NodePattern.N.form("woman").correct(NodeCorrector.replace("wife", "girlfriend")), NodePattern.N.correct(NodeCorrector.replace("wives", "girlfriends")));
    }

    private static NodePattern handy() {
        return NodePattern.N.form("handys?").andOr(NodePattern.N.withDependent("det|nmod:poss", NodePattern.N.noForm("its").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("in")))), NodePattern.N.withDependent("case", NodePattern.N.form("by"))).correct(NodeCorrector.regexReplace("handy(s?)", "phone$1")).message("Did you mean 'phone'?");
    }

    private static NodePattern soSuch() {
        NodePattern quantifier = NodePattern.N.form("few|many|little|much");
        NodePattern noun = NodePattern.N.pos("NN.*").markAs("Noun").andOr(NodePattern.N.withDependent("cop").noPos("JJ|VB.*"), NodePattern.N.withHeadRelation("root|nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").noDependents("cop").noPotentialPos("JJ")).noDependents("det|case|nmod:poss", NodePattern.N.after("So")).andNot(Semantics.thanksApologies);
        NodePattern clauseStartingSo = NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("Clause")).and(NodePattern.markedNodeMatches("Clause", NodePattern.N.withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, CommonPatterns.skipForward(NodePattern.N.withHeadRelation("cc.*"), NodePattern.N.alreadyMarkedAs("So"))))));
        return NodePattern.or(NodePattern.N.form("so").directlyBeforeHead().markAs("So").withHead("advmod", NodePattern.or(noun, NodePattern.N.pos("JJ").beforeHead().withHead("amod", noun).andNot(quantifier).andNot(WordSeparation.soCalled))).noDependents().andNot(NodePattern.N.withPrevSibling(EnglishTreePatterns.negation)).andNot(clauseStartingSo).and((so, match) -> {
            Node prev = so.prevNode();
            if (prev != null && prev.hasForm("a")) {
                return match.withCorrector(NodeCorrector.replaceNodes(prev, so, "such " + Articles.getIndefiniteArticle(so.neighbor(1))));
            }
            Node headNoun = match.getMarkedNode("Noun");
            if (Articles.singularCountableNoun.matches(headNoun) && Articles.nounWithoutDeterminer.matches(headNoun)) {
                return match.withCorrector(NodeCorrector.replace(so, "such " + Articles.getIndefiniteArticle(so.neighbor(1))));
            }
            return match.withCorrector(NodeCorrector.replace(so, "such"));
        }).message("Use 'such' with noun phrases"), NodePattern.N.form("such").beforeHead().markAs("Such").andOr(NodePattern.N.withHead("advmod|amod|det", NodePattern.N.potentialPos("JJ.*|RB.*").andOr(NodePattern.N.withDependent("cop").noDependents("det", NodePattern.N.before("Such")), NodePattern.N.withHeadRelation("advmod"))), NodePattern.N.withHeadRelation("advmod|amod").directlyBefore(quantifier)).correct(NodeCorrector.replace("so")).message("Use 'so' with adjectives or adverbs"));
    }

    private static NodePattern lessMoreLowerHigher() {
        NodePattern twiceMoreLessThan = NodePattern.N.withDependent("advmod", NodePattern.N.form("twice|thrice").directlyBeforeHead()).directlyBefore(NodePattern.N.form("than").withHeadRelation("case|mark"));
        return NodePattern.or(NodePattern.N.directlyBeforeHead().withHead("amod", lowerHigherNoun.markAs("Noun")), NodePattern.N.withDependent("cop").noDependents("advmod|obl:npmod", NodePattern.N.form("half")).noDependents("obl:npmod", NodePattern.N.beforeHead().withDependent("nummod")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than").withHead("case", NodePattern.N.withDependent("nummod")))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than").withHead("case|mark", NodePattern.N.pos("CD"))).trace("less than 9")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than").andNot(NodePattern.N.withHead("case|mark", NodePattern.N.form("number|amount|that|what")))).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.form("number|amount")).noDependents(NodePattern.N.form("much")).andNot(twiceMoreLessThan)).and(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", lowerHigherNoun.markAs("Noun"))))).andOr(NodePattern.N.form("less|fewer").andOr(twiceMoreLessThan.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "as low as")).message("Use 'low' with nouns implying levels, such as '$Noun'"), NodePattern.N.correct(NodeCorrector.replace("lower")).message("Use 'lower' with nouns implying levels, such as '$Noun'")), NodePattern.N.form("more").andOr(twiceMoreLessThan.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "as high as")).message("Use 'high' with nouns implying levels, such as '$Noun'"), NodePattern.N.andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nummod").beforeHead())).correct(NodeCorrector.replace("higher", "greater")).message("Use 'higher' or 'greater' with nouns implying levels, such as '$Noun'"))).noDependents("conj").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than")).withHead(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withHeadRelation("nummod"))));
    }

    private static NodePattern neededNecessary() {
        return NodePattern.N.form("needed").andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andOr(NodePattern.N.beforeHead().withHeadRelation("amod"), NodePattern.N.withDependent("cop|aux:pass").withDependent("expl|nsubj:pass", NodePattern.N.form("it"))).andNot(CommonPatterns.insideQuotes).includeIntoReport().withOptionalDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("by").markAs("By"))).andNot(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for"))).and(NodePattern.markedNodeMatches("By", NodePattern.N))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("much"))).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.form("not").markAs("Not").includeIntoReport()).andNot(PolarityItemViolations.preventLexicalNegation)).and((needed, match) -> {
            Node not = match.findMarkedNode("Not");
            NodeCorrector corrector = not != null ? NodeCorrector.replaceNodes(not, needed, "unnecessary") : NodeCorrector.replace(needed, "necessary");
            Node by = match.findMarkedNode("By");
            corrector = corrector.join(by == null ? null : NodeCorrector.replace(by, "for"));
            return match.withCorrector(corrector);
        }).message("'needed' as a participle seems unnatural");
    }

    private static NodePattern sayTell() {
        return NodePattern.N.form("said").withDependent("aux:pass", NodePattern.N.markAs("Aux")).withDependent("ccomp").withDependent("nsubj:pass", NodePattern.N.pos("PRP").noForm("it")).and(EnglishTreePatterns.typoReplacement("told")).andOptionally(NodePattern.N.noDependents("cop|aux").correct(NodeCorrector.replace(NodePointer.marked("Aux"), "")));
    }

    private static NodeCorrector changeLemmaInflectLikeBe(Node node, Node be, String newLemma) {
        String bePos = be.posReadings().get(0);
        List<String> verbFormList = node.tree().treeSupport().synthesize(newLemma, newLemma, "VBN", bePos);
        String verbForm = !verbFormList.isEmpty() ? verbFormList.get(0) : newLemma;
        return NodeCorrector.replace(node, verbForm).join(NodeCorrector.removeNode(be));
    }

    private static NodePattern compriseComposeConsist() {
        NodePattern withCaseOf = NodePattern.N.withDependent("case", NodePattern.N.form("of").markAs("Of"));
        NodePattern possiblyParts = NodePattern.not(Semantics.possiblePluralNN).noLemma("carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang").andNot(Semantics.Animacy.humanLike.pattern).andOr(NodePattern.N.pos("NNS").withDependent("nummod", NodePattern.N.noLabel(".*").beforeHead()).andNot(EnglishTreePatterns.anyPercent).noDependents("advmod"), NodePattern.N.withDependent("nmod", withCaseOf.withDependent("conj")), Semantics.numberDelegatingGroup, NodePattern.N.lemma("two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eightteen|nineteen|twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety|dozen|hundred|thousand|million|billion|(ga)?zillion").directlyBefore(NodePattern.N.form("of")));
        return NodePattern.or(NodePattern.N.lemma("comprise").withDependent("obl", withCaseOf).noDependents("cop|aux|aux:pass").andOr(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withHeadRelation("acl|amod|advcl").afterHead().andOr(NodePattern.N.form("comprised").correct(NodeCorrector.replace("comprising").join(NodeCorrector.replace(NodePointer.marked("Of"), ""))).correct(EnglishTreePatterns.changeVerbLemma("compose")), NodePattern.N.form("comprising").correct(NodeCorrector.replace(NodePointer.marked("Of"), ""))).correct(NodeCorrector.replace("consisting")), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").correct(NodeCorrector.replace(NodePointer.marked("Of"), "")).correct(EnglishTreePatterns.changeVerbLemma("consist"))).message("'To comprise' is usually used without 'of'. Did you mean another word?"), NodePattern.N.form("comprised|consisted").withDependent("obl", withCaseOf).withDependent("aux:pass|cop", NodePattern.N.lemma("be").markAs("Be")).and(NodePattern.custom((node, match) -> {
            Node be = match.getMarkedNode("Be");
            Node of = match.getMarkedNode("Of");
            return match.withCorrector(WordConfusion.changeLemmaInflectLikeBe(node, be, "consist")).withCorrector(WordConfusion.changeLemmaInflectLikeBe(node, be, "comprise").join(NodeCorrector.removeNode(of))).withCorrector(EnglishTreePatterns.changeVerbLemma("compose").corrector(node)).withMessage("'To " + node.lemmaReadings().get(0) + "' is not usually used in the passive voice. Did you mean another word?");
        })), NodePattern.N.lemma("comprise").andOr(NodePattern.N.withDependent("obj", NodePattern.not(possiblyParts)).withDependent("nsubj", possiblyParts.noDependents("conj")).correct(EnglishTreePatterns.changeVerbLemma("compose")).correct(EnglishTreePatterns.changeVerbLemma("constitute")).correct(EnglishTreePatterns.changeVerbLemma("form")), NodePattern.N.withDependent("obl", withCaseOf.lemma("carp|committee|service|family|company|team|pair|club|offensive|crowd|squad|generation|government|parliament|firm|elite|school|group|army|herd|class|union|jury|assembly|audience|flock|manis|colony|authority|gang")).withDependent("nsubj", NodePattern.not(possiblyParts)).correct(EnglishTreePatterns.changeVerbLemma("compose").join(NodeCorrector.replace(NodePointer.marked("Of"), ""))).correct(EnglishTreePatterns.changeVerbLemma("constitute").join(NodeCorrector.replace(NodePointer.marked("Of"), ""))).correct(EnglishTreePatterns.changeVerbLemma("form").join(NodeCorrector.replace(NodePointer.marked("Of"), "")))).message("'To comprise' typically means 'to include'. Did you mean another word?"), NodePattern.N.lemma("compose").withDependent("obj", possiblyParts).withDependent("nsubj", NodePattern.not(possiblyParts).andNot(Semantics.Animacy.humanLike.pattern).markAs("Subj")).correct(EnglishTreePatterns.changeVerbLemma("comprise")).correct(EnglishTreePatterns.changeVerbLemma("consist").join(NodeCorrector.insertAfter(" of"))).and(NodePattern.custom((node, match) -> {
            Node subj = match.getMarkedNode("Subj");
            boolean past = node.hasPos("VBD");
            String beForm = VerbInflectionNumber.from(node, subj).past(past).inflectBe();
            return match.withCorrector(NodeCorrector.insertBefore(node, beForm + " ").join(NodeCorrector.replace(node, "composed of")));
        })).message("If you mean 'to include', consider using a different verb"));
    }

    private static NodePattern layLie() {
        return NodePattern.or(NodePattern.N.lemma("lay").directlyBefore(NodePattern.N.form("around|low|on|ahead")).noDependents("obj|aux:pass").message("Did you mean 'to lie' (to recline)?").andOr(NodePattern.N.form("laying").correct(NodeCorrector.replace("lying")), NodePattern.N.form("laid").correct(NodeCorrector.replace("lay")), NodePattern.N.form("lay").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").noDependents("cop"))).correct(NodeCorrector.replace("lie")), NodePattern.N.form("lays").withDependent("nsubj").noDependents("cop").correct(NodeCorrector.replace("lies"))), NodePattern.N.form("lain").withDependent("aux:pass").correct(NodeCorrector.replace("laid")).message("Did you mean 'to lay' (to put something down)?"));
    }

    private static NodePattern percent() {
        return percentConfusedWithPercentage.correct(NodeCorrector.regexReplace("percent(s?)", "percentage$1")).message("Use 'percentage' for a general relationship rather than a specific measure");
    }

    private static NodePattern borrowLend() {
        NodePattern withToArgument = NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to").markAs("To").includeIntoReport().andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case")))));
        NodePattern withPossibleToArgument = NodePattern.N.withDependent("advcl", EnglishTreePatterns.withToMark);
        return NodePattern.or(NodePattern.N.lemma("borrow").includeIntoReport().andOr(NodePattern.N.withDependent("iobj").message("Did you mean 'lend'?"), withToArgument.correct(NodeCorrector.replace(NodePointer.marked("To"), "from")).message("If you meant 'borrow' (to receive something), use the preposition 'from'. Otherwise, 'lend' should be used")).correct(EnglishTreePatterns.changeVerbLemma("lend")), NodePattern.N.lemma("lend").includeIntoReport().noDependents("iobj").andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("from").includeIntoReport().correct(NodeCorrector.replace(NodePointer.anchor(), "to")).message("If you meant 'lend' (to give something), use the preposition 'to'. Otherwise, 'borrow' should be used"))), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("obj", NodePattern.N.noForm("hand|advice|support|moisture|(it|them)sel(f|ves)")).noHeadRelation("acl:relcl").message("Did you mean 'borrow'?")).andNot(CommonPatterns.possiblySkipDown("advmod", NodePattern.or(withToArgument, withPossibleToArgument))).andNot(NodePattern.N.withHeadRelation("acl:relcl|ccomp").withDependent("obj", NodePattern.N.pos("PRP.*"))).correct(EnglishTreePatterns.changeVerbLemma("borrow")));
    }

    private static NodePattern bringTake() {
        return NodePattern.or(NodePattern.N.lemma("take").withDependent("iobj", NodePattern.N.form("me|us").markAs("IObj").includeIntoReport(ReportingKind.Hover)).withDependent("obj", NodePattern.N.withDependent("det").after("IObj").noPotentialPos("IN").andNot(CommonPatterns.possiblySkipDown("nmod", NodePattern.or(Semantics.progressUnit, Semantics.attemptSynonyms, Semantics.timeUnits, NodePattern.N.form("time"))))).message("You don\u2019t usually 'take' things towards you; did you mean 'bring'?").correct(EnglishTreePatterns.changeVerbLemma("bring")), NodePattern.N.lemma("bring").withDependent("advmod|compound:prt", NodePattern.or(NodePattern.N.form("away").noDependents().andNot(NodePattern.N.directlyBefore(NodePattern.N.form("from"))), CommonPatterns.lastChildPhrase.form("out")).markAs("Particle").includeIntoReport(ReportingKind.Hover)).withDependent("obj", NodePattern.N.before("Particle")).message("You don\u2019t usually 'bring' things $Particle; did you mean 'take'?").correct(EnglishTreePatterns.changeVerbLemma("take")));
    }

    private static NodePattern wellSuitting() {
        NodePattern ing = NodePattern.N.pos("VBG").noForm("being").andOr(NodePattern.N.withDependent("obj|obl", NodePattern.N.afterHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("IN"))).correct(NodeCorrector.inflect("VBD").join(NodeCorrector.insertAfter(" to"))), NodePattern.N.correct(NodeCorrector.inflect("VBD")));
        NodePattern able = NodePattern.N.form(".*able").and(node -> node.tree().treeSupport().tagToken(node.form().replace("able", "ed")).hasPos("VBD")).correct(NodeCorrector.regexReplace("able", "ed"));
        return NodePattern.N.form("well").noPos("NN").andNot(NodePattern.N.inFormSequence(2, "river", "and|or", "well")).includeIntoReport().and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen.includeIntoReport(), NodePattern.or(ing, able).includeIntoReport())).message("Use past participles in compound adjectives with the word 'well'");
    }

    private static NodePattern littleSmall() {
        NodePattern thing = Semantics.Animacy.inanimate.pattern;
        NodePattern little = NodePattern.N.form("little").andOr(EnglishTreePatterns.adjInPredicativePosition.noHeadRelation("amod").andOr(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", thing), NodePattern.N.withHead("acl:relcl", thing)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("too|as").markAs("Advmod")).directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.sameWordAs("Advmod")))).message("'Little' is usually used before nouns. Did you mean 'small'?"), NodePattern.N.withDependent("advmod", NodePattern.N.form("quite|rather|very").markAs("Adv").includeIntoReport(ReportingKind.Hover)).withHead("amod", thing.andNot(Semantics.possiblyUncountableForm)).message("Use 'small' with grading adverbs like '$Adv'"));
        NodePattern small = NodePattern.N.form("small").withHead("amod", NodePattern.or(NodePattern.N.lemma("woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?|artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate"), Semantics.kindredRelation)).message("'Small' usually refers to physical size. Did you mean 'little'?");
        return NodePattern.or(little.correct(NodeCorrector.replace("small")), small.correct(NodeCorrector.replace("little")));
    }

    private static NodePattern veryReally() {
        return NodePattern.N.form("very").directlyBefore(EnglishTreePatterns.verbalClause.noPos("JJ|VBN|NN").andNot(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("cop|aux|aux:pass")).pos("VB"))).correct(NodeCorrector.replace("really")).correct(NodeCorrector.insertAfter(" much")).message("Use 'really' or 'very much' to modify a verb");
    }

    private static NodePattern workJob() {
        NodePattern jobCondition = NodePattern.or(NodePattern.N.withHead("obl", NodePattern.N.lemma("look|apply")).afterHead(), NodePattern.N.withHead("obj", NodePattern.N.lemma("find|get|lose|change|quit|give|offer|land|take|leave")).afterHead(), NodePattern.ROOT.withDependent("cop", NodePattern.N.pos("VB[PZ]")).withDependent("det", NodePattern.N.form("an?")).noDependents("nmod", EnglishTreePatterns.byPP)).andNot(NodePattern.N.inFormSequence(0, "works?", "of")).andNot(NodePattern.N.inFormSequence(0, "works?", "in", "progress")).andNot(NodePattern.N.inFormSequence(0, "works?", "-", "in", "-", "progress"));
        return NodePattern.or(NodePattern.N.form("work").and(jobCondition).correct(NodeCorrector.replace("job")).withDependent("det", NodePattern.N.form("an?").correct(NodeCorrector.replace(""))).message("Did you mean 'job' (a specific role, position)?"), NodePattern.N.form("works").onlyPos("NNS").and(jobCondition).andOr(NodePattern.N.withDependent("amod", NodePattern.N.pos("DT").noForm("such")).correct(NodeCorrector.replace("jobs")).message("Did you mean 'jobs' (specific roles, positions)?"), NodePattern.N.noDependents(NodePattern.N.beforeHead()).and(EnglishTreePatterns.typoReplacement("work"))), NodePattern.N.inFormSequence(1, "before|after", "job").correct(NodeCorrector.replace("work")).and(EnglishTreePatterns.typoReplacement("work")));
    }

    private static NodePattern besideBesides() {
        NodePattern actionWithLocation = NodePattern.N.lemma("sit|stand|lie|lean|hunch|kneel|crouch|put|place|lay|locate|position|bury|leave|step|stomp|park|stack|go|walk|drive|sleep|live|work|store|expand|run");
        return NodePattern.or(NodePattern.N.form("beside").markAs("Beside").andOr(NodePattern.N.withHeadRelation("advmod").andNot(NodePattern.N.withHead(actionWithLocation)), NodePattern.N.withHead("mark", NodePattern.N.withHeadRelation("advcl")), NodePattern.N.withHead("case", NodePattern.N.andOr(NodePattern.N.withHead("obl", NodePattern.N.andNot(NodePattern.N.noDependents("expl").withDependent("nsubj", NodePattern.N.afterHead()))).beforeHead(), TreeMigration.revise("try deleting", NodePattern.N.withHead("obl", EnglishTreePatterns.verbalClause.andNot(actionWithLocation).withDependent("obj", NodePattern.N.before("Beside").withDependent("det|amod", NodePattern.N.beforeHead())))), NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("obj").before("Beside").withDependent("det|amod", NodePattern.N.beforeHead())).and(Semantics.Animacy.humanLike.pattern), NodePattern.N.withHeadRelation("nmod").directlyBefore(CommonPatterns.comma).beforeHead(), NodePattern.N.withHead("nmod", NodePattern.N.withDependent("nummod").withDependent("acl:relcl"))))).correct(NodeCorrector.replace("besides")).message("Did you mean 'besides' ('in addition to', 'apart from')?"), NodePattern.N.form("besides").markAs("Besides").andOr(NodePattern.N.directlyBefore(NodePattern.N.form(".+(self|selves)")), NodePattern.N.directlyAfter(NodePattern.N.lemma("pale").potentialPos("VB.*")), NodePattern.N.inFormSequence(0, "besides", "each", "other"), NodePattern.N.inFormSequence(0, "besides", "the", "point"), NodePattern.N.withHead("advmod|obl", actionWithLocation).noDependents(".*").afterHead(), NodePattern.N.withHead("case", NodePattern.N.afterHead().noDependents("punct").andOr(NodePattern.N.noLemma("one|few").withHead("nmod", NodePattern.N.beforeHead().withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(Semantics.withContrastMarker)).andNot(NodePattern.N.withDependent("nmod:poss").withHead(NodePattern.N.withDependent("det", NodePattern.or(NodePattern.N.form("all|any|no|every|each|some|both"), EnglishTreePatterns.demonstratives)))), NodePattern.N.withHead("obl", EnglishTreePatterns.verbalClause.andOr(actionWithLocation.noDependents("obj", Semantics.withContrastMarker), NodePattern.N.pos("VBN").withDependent("aux:pass"), NodePattern.N.pos("VBG").withDependent("aux")))))).correct(NodeCorrector.replace("beside")).message("Did you mean 'beside' ('next to')?"));
    }

    private static NodePattern rememberRemind() {
        return NodePattern.N.lemma("remember").withDependent("i?obj", NodePattern.N.markAs("IObj").noDependents(".*")).andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("of"))), TreeMigration.revise("tree-en", NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("mark", Questions.whWord))), NodePattern.N.withDependent("obj", Questions.whWord.withDependent("advcl:relcl")), NodePattern.N.withDependent("[xc]comp", NodePattern.N.withDependent("mark"))).correct(EnglishTreePatterns.changeVerbLemma("remind")).andOptionally(NodePattern.N.withDependent("xcomp").correct(NodeCorrector.replace(NodePointer.marked("IObj"), ""))).message("Did you mean 'remind'?");
    }

    private static NodePattern whileWhen() {
        NodePattern continuousAction = NodePattern.N.lemma("go|walk|drive|sleep|live|work|store|expand|run|study|practice|research|prepare|clean|pack|paint|play|fix|repair|install|download|upload|keep|save|watch|avoid|recommend|learn|store|sit|stand|lie|lean|hunch|kneel|crouch");
        return NodePattern.N.form("while").markAs("While").withHead("mark", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.beforeHead()).andOr(NodePattern.N.pos("NN.*|CD").withHead("advcl", continuousAction.pos("VBD").noDependents("aux")), Semantics.singleActionInThePast.withHead("advcl", NodePattern.N.pos("VBG").withDependent("aux", NodePattern.N.form("was|were"))))).and(EnglishTreePatterns.typoReplacement("when"));
    }

    private static NodePattern atAl() {
        return NodePattern.N.form("at").directlyBefore(NodePattern.N.form("al").directlyBefore(CommonPatterns.dot)).andOr(CommonPatterns.afterSkipping(CommonPatterns.comma, CommonPatterns.capitalized).correct(NodeCorrector.replace("et")).message("Did you mean an abbreviation for 'et alii'?"), NodePattern.N.directlyAfter(CommonPatterns.lowerCase).correct(NodeCorrector.replace(NodePointer.neighbor(1), "all")).message("Did you mean 'at all'?")).reportEverythingTouched();
    }

    private static NodePattern aPart() {
        return NodePattern.or(NodePattern.N.form("apart").directlyBefore(NodePattern.N.form("of")).andOr(NodePattern.N.withHead("advmod", XApart).afterHead().correct(NodeCorrector.replace(NodePointer.neighbor(1), "from")).message("Did you mean 'apart from'?"), NodePattern.or(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(EnglishTreePatterns.clause)), NodePattern.ROOT.withDependent("cop", NodePattern.N.afterHead())).correct(NodeCorrector.replace("a part")).message("Did you mean 'a part of'?"), NodePattern.N.correct(NodeCorrector.replace("a part")).correct(NodeCorrector.replace(NodePointer.neighbor(1), "from")).message("Did you mean 'a part of' or 'apart from'?")), aPart.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "apart")).message("Did you mean 'apart'?")).reportEverythingTouched();
    }
}

