/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.ru.GrammarRules;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.SemanticRules;
import ai.grazie.rules.ru.SpellingRules;
import ai.grazie.rules.ru.StyleRules;
import ai.grazie.rules.ru.TypographyRules;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.toolkit.PosHighlighting;
import ai.grazie.rules.toolkit.Selectioner;
import ai.grazie.rules.toolkit.StructuralWrapper;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class RussianToolkit
extends LanguageToolkit {
    public static final RussianToolkit INSTANCE = new RussianToolkit();

    private RussianToolkit() {
        super(Language.RUSSIAN);
    }

    @Override
    protected List<Rule> createRules() {
        return StreamEx.of((Object[])new Rule[0]).append(PunctuationRules.highestPriorityRules()).append(SpellingRules.rules()).append(GrammarRules.priorityRules()).append(PunctuationRules.priorityRules()).append(GrammarRules.rules()).append(SemanticRules.rules()).append(PunctuationRules.rules()).append(TypographyRules.rules()).append(StyleRules.rules()).toList();
    }

    @Override
    @Nullable
    public PosHighlighting posHighlight(Node node) {
        if (node.hasPos("VB:.*")) {
            return PosHighlighting.VERB;
        }
        if (node.hasPos("D?PT.*")) {
            return PosHighlighting.VERB;
        }
        if (node.hasPos("ADV")) {
            return PosHighlighting.ADVERB;
        }
        if (node.hasPos("ADJ:.*")) {
            return PosHighlighting.ADJECTIVE;
        }
        if (node.hasPos("NN:.*")) {
            return PosHighlighting.NOUN;
        }
        if (node.hasPos("CONJ")) {
            return PosHighlighting.CONJUNCTION;
        }
        return null;
    }

    @Override
    public Selectioner selectioner() {
        return new Selectioner();
    }

    @Override
    @Nullable
    public StructuralWrapper getStructuralWrapper() {
        return new StructuralWrapper(){

            @Override
            protected boolean isPunctuation(Node node) {
                return RussianTreePatterns.commaOrStronger.matches(node);
            }

            @Override
            protected boolean isClauseLike(Node node) {
                return RussianTreePatterns.clause.matches(node);
            }
        };
    }

    @Override
    public String getRuleDescriptionLinkText() {
        return "\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435";
    }

    @Override
    public List<SettingGroup> getSettings(RuleClient client) {
        Map map = StreamEx.of(this.publishedRules()).toMap(r -> r.id, Function.identity());
        return List.of(new SettingGroup("\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0438\u044f", RussianToolkit.ruleSetting(map, "Typography.HYPHEN_TO_DASH", new Parameter[0]), RussianToolkit.ruleSetting(map, "Style.EXCLAMATION_MARK", new Parameter[0]), RussianToolkit.ruleSetting(map, "Style.EXPRESSIVE_PUNCTUATION", new Parameter[0]), RussianToolkit.ruleSetting(map, "Style.SMILEY_OR_EMOJI_USE", new Parameter[0])));
    }
}

