/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.Tree;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.disambiguation.Disambiguator;

@ApiStatus.Internal
public class LTTagger
implements Tagger {
    public final Language language;
    public final Supplier<Disambiguator> disambiguator;

    public LTTagger(Language language) {
        this(language, () -> ((Language)language).getDisambiguator());
    }

    public LTTagger(Language language, Supplier<Disambiguator> disambiguator) {
        this.language = language;
        this.disambiguator = Suppliers.memoize(disambiguator::get);
    }

    @Override
    public boolean approximateLTDisambiguator() {
        return false;
    }

    @Override
    public Tree.Token tagSingleToken(String token) {
        try {
            List tagged = this.language.getTagger().tag(List.of(token));
            List<Tree.Reading> readings = tagged.size() == 1 ? this.toReadings((AnalyzedTokenReadings)tagged.get(0)) : List.of();
            return new Tree.Token(0, this.normalizeToken(token), token, readings);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Tree.Token> tagTokens(List<String> tokens) {
        boolean approximateLT = this.approximateLTDisambiguator();
        try {
            ArrayList<AnalyzedTokenReadings> tagged = new ArrayList<AnalyzedTokenReadings>(this.language.getTagger().tag(tokens));
            if (approximateLT) {
                int last;
                AnalyzedToken sentStart = new AnalyzedToken("", "SENT_START", null);
                tagged.add(0, new AnalyzedTokenReadings(new AnalyzedToken[]{sentStart}, 0));
                for (int i = 1; i < tagged.size(); ++i) {
                    ((AnalyzedTokenReadings)tagged.get(i)).setWhitespaceBefore(((AnalyzedTokenReadings)tagged.get(i - 1)).getToken());
                }
                for (last = tagged.size() - 1; last >= 0 && ((AnalyzedTokenReadings)tagged.get(last)).isWhitespace(); --last) {
                }
                if (last > 0) {
                    ((AnalyzedTokenReadings)tagged.get(last)).setSentEnd();
                }
            }
            AnalyzedSentence disambiguated = this.disambiguator.get().disambiguate(new AnalyzedSentence(tagged.toArray(new AnalyzedTokenReadings[0])));
            return ((StreamEx)StreamEx.of((Object[])disambiguated.getTokens()).skip(approximateLT ? 1L : 0L)).map(token -> new Tree.Token(token.getStartPos(), this.normalizeToken(token.getToken()), token.getToken(), this.toReadings((AnalyzedTokenReadings)token))).toList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String normalizeToken(String form) {
        return form;
    }

    protected List<Tree.Reading> toReadings(AnalyzedTokenReadings token) {
        return ((StreamEx)StreamEx.of((Collection)token.getReadings()).map(t -> {
            String pos;
            String string = pos = Strings.isNullOrEmpty((String)t.getPOSTag()) ? null : t.getPOSTag();
            if ("SENT_END".equals(pos)) {
                return null;
            }
            String lemma = Strings.isNullOrEmpty((String)t.getLemma()) ? null : t.getLemma();
            return pos == null && lemma == null ? null : new Tree.Reading(pos, lemma);
        }).nonNull().distinct()).toList();
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        try {
            Synthesizer synthesizer = Objects.requireNonNull(this.language.getSynthesizer());
            return Lists.newArrayList((Object[])synthesizer.synthesize(new AnalyzedToken(form, srcPos, lemma), targetPos, true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

