/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;
import org.languagetool.rules.patterns.CaseConversionHelper;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tools.StringTools;

@NullMarked
public abstract class TreeSupport {
    public static final int CLOUD_BATCH_SIZE = Integer.getInteger("grazie.parsing.batch.size", 32);
    protected static final String CLOUD_MODEL_NAME = "gml-all-trf-v4-exp";
    protected static final List<String> CLOUD_PARSER_OPTIONS = List.of("ensure_proj", "use_v2_tokenizer");
    public static final String CLOUD_NER_VERSION = "v2";
    final Tagger tagger;
    private final org.languagetool.Language ltLanguage;
    protected final Supplier<@Nullable WordListWithFrequency> hunspell;
    private final ai.grazie.nlp.langs.Language grazieLanguage;

    protected TreeSupport(org.languagetool.Language ltLanguage) {
        this(ltLanguage, () -> null);
    }

    protected TreeSupport(org.languagetool.Language ltLanguage, Supplier<@Nullable WordListWithFrequency> hunspell) {
        this.ltLanguage = ltLanguage;
        this.hunspell = Suppliers.memoize(hunspell::get);
        this.tagger = this.createTagger();
        this.grazieLanguage = Objects.requireNonNull(ai.grazie.nlp.langs.Language.Companion.parse(ltLanguage.getShortCode()));
    }

    public ai.grazie.nlp.langs.Language getGrazieLanguage() {
        return this.grazieLanguage;
    }

    public String getCloudTreeModelName() {
        return CLOUD_MODEL_NAME;
    }

    public List<String> getCloudParserOptions() {
        return CLOUD_PARSER_OPTIONS;
    }

    public boolean needsNer() {
        return false;
    }

    protected Tagger createTagger() {
        return new LTTagger(this.ltLanguage);
    }

    public Tree buildTree(SentenceWithTreeDependencies conllu, @Nullable SentenceWithNERAnnotations ner) {
        return Tree.build(this, conllu, ner);
    }

    public abstract CrazyParseDetector crazyParseDetector();

    public abstract String quote(String var1);

    public abstract Quotes getAllQuotes();

    public boolean isInsideQuotes(Node node) {
        Quotes quotes = this.getAllQuotes();
        for (Node each : (StreamEx)node.back().skip(1L)) {
            if (!quotes.canBeAnyQuote(each.form())) continue;
            if (!quotes.canBeOpeningQuote(each.form()) || !Quotes.openingPosition.matches(each)) break;
            return true;
        }
        for (Node each : (StreamEx)node.forward().skip(1L)) {
            if (!quotes.canBeAnyQuote(each.form())) continue;
            if (!quotes.canBeClosingQuote(each.form()) || !Quotes.closingPosition.matches(each)) break;
            return true;
        }
        return false;
    }

    protected boolean shouldPreserveCase(TextChange.Replacement change, Tree tree, String prevText) {
        return StringTools.startsWithUppercase((String)prevText) || prevText.length() > 1 && StringTools.isAllUppercase((String)prevText);
    }

    public boolean hasAllCapitalizedStyle(Tree tree) {
        boolean hasTrulyLowerCase = false;
        for (Node node : tree.nodes()) {
            if (!CommonPatterns.letterWord.matches(node)) continue;
            if (!Character.isUpperCase(node.form().charAt(0))) {
                return false;
            }
            if (hasTrulyLowerCase) continue;
            hasTrulyLowerCase = this.isTrulyLowerCase(node) && !TreeSupport.hasOnlyPunctuationBefore(tree.text(), node.startOffset());
        }
        return hasTrulyLowerCase;
    }

    public boolean isTrulyLowerCase(Node node) {
        return false;
    }

    public final org.languagetool.Language language() {
        return this.ltLanguage;
    }

    public List<String> inflectNode(Node node, @Language(value="RegExp") String posRegex, String posReplacement) {
        Pattern posPattern = Pattern.compile(posRegex);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Tree.Reading reading : this.tagToken(node.form()).tokenReadings()) {
            Matcher matcher;
            String posTag = reading.pos();
            String lemma = reading.lemma();
            if (posTag == null || lemma == null || !(matcher = posPattern.matcher(posTag)).matches()) continue;
            String targetPos = matcher.replaceAll(posReplacement);
            result.addAll(this.synthesize(node.form(), lemma, posTag, targetPos));
        }
        return new ArrayList<String>(result);
    }

    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        List<String> result = this.tagger.synthesize(form, lemma, srcPos, targetPos);
        if (result.stream().anyMatch(StringTools::isAllUppercase)) {
            result.removeIf(s1 -> StringTools.isAllUppercase((String)s1) && result.stream().anyMatch(s2 -> s2.equalsIgnoreCase((String)s1) && !s2.equals(s1)));
        }
        return result;
    }

    public boolean isAcceptedBySpellchecker(String word) {
        WordListWithFrequency hunspell = this.hunspell.get();
        if (hunspell != null) {
            return hunspell.contains(word, true);
        }
        try {
            SpellingCheckRule rule = this.ltLanguage.getDefaultSpellingRule();
            return rule != null && !rule.isMisspelled(word);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSuggestedBySpellchecker(String word) {
        WordListWithFrequency hunspell = this.hunspell.get();
        if (hunspell != null) {
            if (!hunspell.contains(word, true)) {
                return false;
            }
            return hunspell.suggest(word + word.charAt(word.length() - 1)).contains(word);
        }
        try {
            SpellingCheckRule rule = this.ltLanguage.getDefaultSpellingRule();
            return rule != null && !rule.isMisspelled(word);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> similarWords(String form) {
        return List.of();
    }

    public Tree.Token tagToken(String form) {
        return this.tagger.tagSingleToken(form);
    }

    protected Tree disambiguateWithParameters(Tree tree) {
        return tree;
    }

    public static boolean hasOnlyPunctuationBefore(CharSequence sentence, int start) {
        for (int i = 0; i < start; ++i) {
            if (TreeSupport.isIgnorableStartPunctuation(sentence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIgnorableStartPunctuation(char c) {
        return CharUtil.isAnyOf("-\u2013\u2014\"\u00ab\u201e\u201c\u00bb", c) || CharUtil.isAnySpace(c) || Character.getType(c) == 28;
    }

    public static boolean isCapitalizedSentenceStart(Node node) {
        return TreeSupport.isCapitalizedSentenceStart(node.tree().text(), node.startOffset());
    }

    public static boolean isCapitalizedSentenceStart(CharSequence sentence, int offset) {
        return TreeSupport.hasOnlyPunctuationBefore(sentence, offset) && offset < sentence.length() && Character.isUpperCase(sentence.charAt(offset));
    }

    public static String preserveCase(String prevText, String replacement, @Nullable org.languagetool.Language language) {
        return CaseConversionHelper.convertCase((Match.CaseConversion)Match.CaseConversion.PRESERVE, (String)replacement, (String)prevText, (org.languagetool.Language)language);
    }
}

