/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.uk.UkrainianCrazyParseDetector;
import ai.grazie.rules.uk.UkrainianTreeDisambiguator;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

@NullMarked
public class UkrainianTreeSupport
extends TreeSupport {
    private static final NodePattern lowerCase = NodePattern.N.anyPos().noPos(".*name.*");

    public UkrainianTreeSupport(Language ltLanguage) {
        this(ltLanguage, () -> null);
    }

    public UkrainianTreeSupport(Language language, Supplier<@Nullable WordListWithFrequency> hunspell) {
        super(language, hunspell);
        assert (language.getShortCode().equals("uk"));
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return lowerCase.matches(node);
    }

    @Override
    public Tree buildTree(SentenceWithTreeDependencies conllu, @Nullable SentenceWithNERAnnotations ner) {
        return new UkrainianTreeDisambiguator(super.buildTree(conllu, ner)).disambiguateByTree();
    }

    @Override
    protected Tagger createTagger() {
        return UkrainianTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(Language language) {
        return new LTTagger(language, () -> {
            if (language.getUnifierConfiguration().getEquivalenceFeatures().isEmpty()) {
                new JLanguageTool(language);
            }
            return language.getDisambiguator();
        }){

            @Override
            public boolean approximateLTDisambiguator() {
                return true;
            }

            @Override
            public String normalizeToken(String token) {
                return UkrainianTreeSupport.normalizeApostrophes(token);
            }
        };
    }

    static String normalizeApostrophes(String token) {
        return token.contains("\u2019") || token.contains("\u02bc") ? token.replaceAll("[\u2019\u02bc]", "'") : token;
    }

    @Override
    public List<String> inflectNode(Node node, String posRegex, String posReplacement) {
        List<String> result = super.inflectNode(node, posRegex, posReplacement);
        if (node.rawForm().contains("\u2019")) {
            return result.stream().map(s -> s.replaceAll("'", "\u2019")).toList();
        }
        if (node.rawForm().contains("\u02bc")) {
            return result.stream().map(s -> s.replaceAll("'", "\u02bc")).toList();
        }
        return result;
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        List<String> result = super.synthesize(form, lemma, srcPos, targetPos);
        if (targetPos.startsWith("verb:rev:") && form.endsWith("\u044f")) {
            result.removeIf(s -> s.endsWith("\u044c"));
        }
        if (targetPos.startsWith("verb:rev:") && form.endsWith("\u044c")) {
            result.removeIf(s -> s.endsWith("\u044f"));
        }
        result.remove("\u043b\u044e\u0434\u0438\u043d\u0430\u043c");
        return result;
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return UkrainianCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text) {
        return "\u00ab" + text + "\u00bb";
    }

    @Override
    public Quotes getAllQuotes() {
        return UkrainianTreePatterns.quotes;
    }
}

