/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.impl.fs.LocalEelFileSystemApiKt;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u000bH\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u000bH\u0096@\u00a2\u0006\u0002\u0010\u001aJ*\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u000bH\u0096@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/platform/eel/impl/fs/LocalEelOpenedFileReader;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader;", "eelFs", "Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;", "byteChannel", "Ljava/nio/channels/SeekableByteChannel;", "path_", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;Ljava/nio/channels/SeekableByteChannel;Lcom/intellij/platform/eel/path/EelPath;)V", "read", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/ReadResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader$ReadError;", "buf", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "offset", "", "(Ljava/nio/ByteBuffer;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "getPath", "()Lcom/intellij/platform/eel/path/EelPath;", "close", "", "Lcom/intellij/platform/eel/fs/EelOpenedFile$CloseError;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tell", "Lcom/intellij/platform/eel/fs/EelOpenedFile$TellError;", "seek", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekError;", "whence", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;", "(JLcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stat", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$StatError;", "intellij.platform.eel.impl"})
public final class LocalEelOpenedFileReader
implements EelOpenedFile.Reader {
    @NotNull
    private final NioBasedEelFileSystemApi eelFs;
    @NotNull
    private final SeekableByteChannel byteChannel;
    @NotNull
    private final EelPath path_;
    @NotNull
    private final EelPath path;

    public LocalEelOpenedFileReader(@NotNull NioBasedEelFileSystemApi eelFs, @NotNull SeekableByteChannel byteChannel, @NotNull EelPath path_) {
        Intrinsics.checkNotNullParameter((Object)eelFs, (String)"eelFs");
        Intrinsics.checkNotNullParameter((Object)byteChannel, (String)"byteChannel");
        Intrinsics.checkNotNullParameter((Object)path_, (String)"path_");
        this.eelFs = eelFs;
        this.byteChannel = byteChannel;
        this.path = this.path_ = path_;
    }

    @Nullable
    public Object read(@NotNull ByteBuffer buf, @NotNull Continuation<? super EelResult<? extends ReadResult, ? extends EelOpenedFile.Reader.ReadError>> $completion) {
        return LocalEelFileSystemApiKt.access$doRead(this.eelFs, this.byteChannel, buf);
    }

    @Nullable
    public Object read(@NotNull ByteBuffer buf, long offset, @NotNull Continuation<? super EelResult<? extends ReadResult, ? extends EelOpenedFile.Reader.ReadError>> $completion) {
        return LocalEelFileSystemApiKt.access$doRead(this.eelFs, this.byteChannel, offset, buf);
    }

    @NotNull
    public EelPath getPath() {
        return this.path;
    }

    @Nullable
    public Object close(@NotNull Continuation<? super EelResult<Unit, ? extends EelOpenedFile.CloseError>> $completion) {
        return LocalEelFileSystemApiKt.access$doClose(this.eelFs, this.byteChannel, this.path_);
    }

    @Nullable
    public Object tell(@NotNull Continuation<? super EelResult<Long, ? extends EelOpenedFile.TellError>> $completion) {
        return LocalEelFileSystemApiKt.access$doTell(this.eelFs, this.byteChannel, this.path_);
    }

    @Nullable
    public Object seek(long offset, @NotNull EelOpenedFile.SeekWhence whence, @NotNull Continuation<? super EelResult<Long, ? extends EelOpenedFile.SeekError>> $completion) {
        return LocalEelFileSystemApiKt.access$doSeek(this.eelFs, this.byteChannel, this.path_, whence, offset);
    }

    @Nullable
    public Object stat(@NotNull Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
        return this.eelFs.stat(this.path_, EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW, $completion);
    }
}

