/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs.telemetry;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.eel.impl.fs.telemetry.FsQueryStatCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000389:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\"0!JB\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0013\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006;"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer;", "", "<init>", "()V", "ijentMetricsScope", "Lcom/intellij/platform/diagnostic/telemetry/Scope;", "getIjentMetricsScope$intellij_platform_eel_impl", "()Lcom/intellij/platform/diagnostic/telemetry/Scope;", "ijentTracer", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "getIjentTracer$intellij_platform_eel_impl", "()Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "ijentTracer$delegate", "Lkotlin/Lazy;", "ijentMeter", "Lio/opentelemetry/api/metrics/Meter;", "getIjentMeter$intellij_platform_eel_impl", "()Lio/opentelemetry/api/metrics/Meter;", "ijentMeter$delegate", "eventsCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getEventsCounter$intellij_platform_eel_impl", "()Ljava/util/concurrent/atomic/AtomicLong;", "extendedFsEventsCounter", "", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey;", "getExtendedFsEventsCounter$intellij_platform_eel_impl", "()Ljava/util/Map;", "extendedFsEventsDurationNanos", "getExtendedFsEventsDurationNanos$intellij_platform_eel_impl", "extendedFsEventsRepeatIntervalNanos", "getExtendedFsEventsRepeatIntervalNanos$intellij_platform_eel_impl", "dumpCounters", "", "Lkotlin/Pair;", "", "Lkotlin/Function0;", "", "fsQueryStatCounter", "Lcom/intellij/platform/eel/impl/fs/telemetry/FsQueryStatCounter;", "getFsQueryStatCounter", "()Lcom/intellij/platform/eel/impl/fs/telemetry/FsQueryStatCounter;", "reportFsEvent", "", "delegate", "Ljava/nio/file/spi/FileSystemProvider;", "path1", "Ljava/nio/file/Path;", "path2", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "startTime", "Ljava/time/Instant;", "endTime", "success", "", "DelegateType", "FsEventKey", "Operation", "intellij.platform.eel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Measurer.kt\ncom/intellij/platform/eel/impl/fs/telemetry/Measurer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1374#2:201\n1460#2,2:202\n1462#2,3:205\n1285#2,2:208\n1299#2,4:210\n1285#2,2:214\n1299#2,4:216\n1285#2,2:220\n1299#2,4:222\n1#3:204\n*S KotlinDebug\n*F\n+ 1 Measurer.kt\ncom/intellij/platform/eel/impl/fs/telemetry/Measurer\n*L\n110#1:201\n110#1:202,2\n110#1:205,3\n29#1:208,2\n29#1:210,4\n30#1:214,2\n30#1:216,4\n31#1:220,2\n31#1:222,4\n*E\n"})
public final class Measurer {
    @NotNull
    public static final Measurer INSTANCE;
    @NotNull
    private static final Scope ijentMetricsScope;
    @NotNull
    private static final Lazy ijentTracer$delegate;
    @NotNull
    private static final Lazy ijentMeter$delegate;
    @NotNull
    private static final AtomicLong eventsCounter;
    @NotNull
    private static final Map<FsEventKey, AtomicLong> extendedFsEventsCounter;
    @NotNull
    private static final Map<FsEventKey, AtomicLong> extendedFsEventsDurationNanos;
    @NotNull
    private static final Map<FsEventKey, AtomicLong> extendedFsEventsRepeatIntervalNanos;
    @Nullable
    private static final FsQueryStatCounter fsQueryStatCounter;

    private Measurer() {
    }

    @NotNull
    public final Scope getIjentMetricsScope$intellij_platform_eel_impl() {
        return ijentMetricsScope;
    }

    @NotNull
    public final IJTracer getIjentTracer$intellij_platform_eel_impl() {
        Lazy lazy = ijentTracer$delegate;
        return (IJTracer)lazy.getValue();
    }

    @NotNull
    public final Meter getIjentMeter$intellij_platform_eel_impl() {
        Lazy lazy = ijentMeter$delegate;
        return (Meter)lazy.getValue();
    }

    @NotNull
    public final AtomicLong getEventsCounter$intellij_platform_eel_impl() {
        return eventsCounter;
    }

    @NotNull
    public final Map<FsEventKey, AtomicLong> getExtendedFsEventsCounter$intellij_platform_eel_impl() {
        return extendedFsEventsCounter;
    }

    @NotNull
    public final Map<FsEventKey, AtomicLong> getExtendedFsEventsDurationNanos$intellij_platform_eel_impl() {
        return extendedFsEventsDurationNanos;
    }

    @NotNull
    public final Map<FsEventKey, AtomicLong> getExtendedFsEventsRepeatIntervalNanos$intellij_platform_eel_impl() {
        return extendedFsEventsRepeatIntervalNanos;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, Function0<Long>>> dumpCounters() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = FsEventKey.Companion.getVALUES();
        Collection collection = CollectionsKt.listOf((Object)TuplesKt.to((Object)"ijent.events.count", Measurer::dumpCounters$lambda$0));
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair pair;
            FsEventKey key = (FsEventKey)element$iv$iv;
            boolean bl = false;
            String keyString = key.toString();
            Object[] objectArray = new Pair[3];
            objectArray[0] = TuplesKt.to((Object)(keyString + ".count"), () -> Measurer.dumpCounters$lambda$1$0(key));
            objectArray[1] = TuplesKt.to((Object)(keyString + ".duration.ms"), () -> Measurer.dumpCounters$lambda$1$1(key));
            Pair pair2 = pair = TuplesKt.to((Object)(keyString + ".repeat.interval.ms"), () -> Measurer.dumpCounters$lambda$1$2(key));
            int n = 2;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            boolean bl3 = Intrinsics.areEqual((Object)key.getRepeated(), (Object)true);
            objectArray2[n] = bl3 ? pair : null;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final FsQueryStatCounter getFsQueryStatCounter() {
        return fsQueryStatCounter;
    }

    public final void reportFsEvent(@NotNull FileSystemProvider delegate, @Nullable Path path1, @Nullable Path path2, @NotNull Operation operation, @NotNull Instant startTime, @NotNull Instant endTime, boolean success) {
        java.time.Duration repeatInterval;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        DelegateType delegateType = DelegateType.Companion.fromDelegateClass(delegate.getClass());
        Pair pair = fsQueryStatCounter != null ? TuplesKt.to((Object)((repeatInterval = fsQueryStatCounter.repeatedTime(delegateType, path1, path2, operation, startTime, endTime, success)) != null ? 1 : 0), (Object)repeatInterval) : TuplesKt.to(null, null);
        Boolean repeated = (Boolean)pair.component1();
        java.time.Duration repeatInterval2 = (java.time.Duration)pair.component2();
        FsEventKey key = new FsEventKey(delegateType, operation, success, repeated);
        AtomicLong atomicLong = extendedFsEventsCounter.get(key);
        Intrinsics.checkNotNull((Object)atomicLong);
        atomicLong.incrementAndGet();
        AtomicLong atomicLong2 = extendedFsEventsDurationNanos.get(key);
        Intrinsics.checkNotNull((Object)atomicLong2);
        atomicLong2.addAndGet(java.time.Duration.between(startTime, endTime).toNanos());
        Measurer $this$reportFsEvent_u24lambda_u240 = this;
        boolean bl = false;
        FsEventKey keyWithNullRepeatedAndSuccess = FsEventKey.copy$default(key, null, null, null, null, 3, null);
        AtomicLong atomicLong3 = extendedFsEventsCounter.get(keyWithNullRepeatedAndSuccess);
        Intrinsics.checkNotNull((Object)atomicLong3);
        atomicLong3.incrementAndGet();
        AtomicLong atomicLong4 = extendedFsEventsDurationNanos.get(keyWithNullRepeatedAndSuccess);
        Intrinsics.checkNotNull((Object)atomicLong4);
        atomicLong4.addAndGet(java.time.Duration.between(startTime, endTime).toNanos());
        if (repeated != null) {
            FsEventKey keyWithNullRepeated = FsEventKey.copy$default(key, null, null, null, null, 7, null);
            AtomicLong atomicLong5 = extendedFsEventsCounter.get(keyWithNullRepeated);
            Intrinsics.checkNotNull((Object)atomicLong5);
            atomicLong5.incrementAndGet();
            AtomicLong atomicLong6 = extendedFsEventsDurationNanos.get(keyWithNullRepeated);
            Intrinsics.checkNotNull((Object)atomicLong6);
            atomicLong6.addAndGet(java.time.Duration.between(startTime, endTime).toNanos());
        }
        if (Intrinsics.areEqual((Object)repeated, (Object)true)) {
            AtomicLong atomicLong7 = extendedFsEventsRepeatIntervalNanos.get(key);
            Intrinsics.checkNotNull((Object)atomicLong7);
            java.time.Duration duration = repeatInterval2;
            Intrinsics.checkNotNull((Object)duration);
            atomicLong7.addAndGet(duration.toNanos());
        }
    }

    private static final IJTracer ijentTracer_delegate$lambda$0() {
        return TelemetryManager.Companion.getTracer(ijentMetricsScope);
    }

    private static final Meter ijentMeter_delegate$lambda$0() {
        return TelemetryManager.Companion.getMeter(ijentMetricsScope);
    }

    private static final void lambda$0$0(ObservableLongMeasurement $it, Function0 $getter) {
        $it.record(((Number)$getter.invoke()).longValue());
    }

    private static final long dumpCounters$lambda$0() {
        return eventsCounter.get();
    }

    private static final long dumpCounters$lambda$1$0(FsEventKey $key) {
        AtomicLong atomicLong = extendedFsEventsCounter.get($key);
        Intrinsics.checkNotNull((Object)atomicLong);
        return atomicLong.get();
    }

    private static final long dumpCounters$lambda$1$1(FsEventKey $key) {
        AtomicLong atomicLong = extendedFsEventsDurationNanos.get($key);
        Intrinsics.checkNotNull((Object)atomicLong);
        return Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)atomicLong.get(), (DurationUnit)DurationUnit.NANOSECONDS));
    }

    private static final long dumpCounters$lambda$1$2(FsEventKey $key) {
        AtomicLong atomicLong = extendedFsEventsRepeatIntervalNanos.get($key);
        Intrinsics.checkNotNull((Object)atomicLong);
        long intervalSum = DurationKt.toDuration((long)atomicLong.get(), (DurationUnit)DurationUnit.NANOSECONDS);
        AtomicLong atomicLong2 = extendedFsEventsCounter.get(FsEventKey.copy$default($key, null, null, null, false, 7, null));
        Intrinsics.checkNotNull((Object)atomicLong2);
        long uniqueCount = atomicLong2.get();
        return Duration.getInWholeMilliseconds-impl((long)Duration.div-UwyO8pc((long)intervalSum, (double)RangesKt.coerceAtLeast((long)uniqueCount, (long)1L)));
    }

    static {
        FsEventKey it;
        AtomicLong atomicLong;
        Map map;
        Object t;
        Iterable $this$associateWithTo$iv$iv;
        INSTANCE = new Measurer();
        ijentMetricsScope = new Scope("ijent", PlatformScopesKt.PlatformMetrics, true);
        ijentTracer$delegate = LazyKt.lazy(Measurer::ijentTracer_delegate$lambda$0);
        ijentMeter$delegate = LazyKt.lazy(Measurer::ijentMeter_delegate$lambda$0);
        eventsCounter = new AtomicLong();
        Iterable $this$associateWith$iv = FsEventKey.Companion.getVALUES();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            FsEventKey fsEventKey = (FsEventKey)element$iv$iv;
            t = element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            atomicLong = new AtomicLong();
            map.put(t, atomicLong);
        }
        extendedFsEventsCounter = destination$iv$iv;
        $this$associateWith$iv = FsEventKey.Companion.getVALUES();
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (FsEventKey)element$iv$iv;
            t = element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            atomicLong = new AtomicLong();
            map.put(t, atomicLong);
        }
        extendedFsEventsDurationNanos = destination$iv$iv;
        $this$associateWith$iv = FsEventKey.Companion.getVALUES();
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (FsEventKey)element$iv$iv;
            t = element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            atomicLong = new AtomicLong();
            map.put(t, atomicLong);
        }
        extendedFsEventsRepeatIntervalNanos = destination$iv$iv;
        for (Pair<String, Function0<Long>> pair : INSTANCE.dumpCounters()) {
            ObservableLongMeasurement observableLongMeasurement;
            String key = (String)pair.component1();
            Function0 getter = (Function0)pair.component2();
            ObservableLongMeasurement it2 = observableLongMeasurement = INSTANCE.getIjentMeter$intellij_platform_eel_impl().counterBuilder(key).buildObserver();
            boolean bl = false;
            INSTANCE.getIjentMeter$intellij_platform_eel_impl().batchCallback(() -> Measurer.lambda$0$0(it2, getter), (ObservableMeasurement)it2, new ObservableMeasurement[0]);
        }
        fsQueryStatCounter = FsEventKey.Companion.getCountUniquePathsEnabled() ? new FsQueryStatCounter() : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "", "<init>", "(Ljava/lang/String;I)V", "local", "wsl", "docker", "Companion", "intellij.platform.eel.impl"})
    public static final class DelegateType
    extends Enum<DelegateType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final AtomicReference<Map<Class<?>, DelegateType>> classToTypeCache;
        public static final /* enum */ DelegateType local;
        public static final /* enum */ DelegateType wsl;
        public static final /* enum */ DelegateType docker;
        private static final /* synthetic */ DelegateType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DelegateType[] values() {
            return (DelegateType[])$VALUES.clone();
        }

        public static DelegateType valueOf(String value) {
            return Enum.valueOf(DelegateType.class, value);
        }

        @NotNull
        public static EnumEntries<DelegateType> getEntries() {
            return $ENTRIES;
        }

        static {
            local = new DelegateType();
            wsl = new DelegateType();
            docker = new DelegateType();
            $VALUES = delegateTypeArray = new DelegateType[]{DelegateType.local, DelegateType.wsl, DelegateType.docker};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            classToTypeCache = new AtomicReference<Map>(new LinkedHashMap());
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J\u0016\u0010\r\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002R<\u0010\u0004\u001a0\u0012,\u0012*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b \t*\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType$Companion;", "", "<init>", "()V", "classToTypeCache", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Ljava/lang/Class;", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "kotlin.jvm.PlatformType", "fromDelegateClass", "clazz", "Ljava/nio/file/spi/FileSystemProvider;", "fromDelegateClassInternal", "intellij.platform.eel.impl"})
        @SourceDebugExtension(value={"SMAP\nMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Measurer.kt\ncom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DelegateType fromDelegateClass(@NotNull Class<FileSystemProvider> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                DelegateType delegateType = (DelegateType)((Object)((Map)classToTypeCache.get()).get(clazz));
                if (delegateType != null) {
                    DelegateType it = delegateType;
                    boolean bl = false;
                    return it;
                }
                Object v = ((Map)classToTypeCache.updateAndGet(arg_0 -> Companion.fromDelegateClass$lambda$1(clazz, arg_0))).get(clazz);
                Intrinsics.checkNotNull(v);
                return (DelegateType)((Object)v);
            }

            private final DelegateType fromDelegateClassInternal(Class<FileSystemProvider> clazz) {
                if (Intrinsics.areEqual((Object)clazz.getName(), (Object)"com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystemProvider")) {
                    return wsl;
                }
                if (Intrinsics.areEqual((Object)clazz.getName(), (Object)"com.intellij.docker.ijent.MountsAwareFileSystemProvider")) {
                    return docker;
                }
                if (!RoutingAwareFileSystemProvider.class.isAssignableFrom(clazz)) {
                    return local;
                }
                throw new IllegalStateException(("Unknown delegate class: " + clazz.getName()).toString());
            }

            private static final Map fromDelegateClass$lambda$1(Class $clazz, Map it) {
                it.putIfAbsent($clazz, Companion.fromDelegateClassInternal($clazz));
                return it;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J:\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey;", "", "delegateType", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "success", "", "repeated", "<init>", "(Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getDelegateType", "()Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "getOperation", "()Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "getSuccess", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getRepeated", "toString", "", "component1", "component2", "component3", "component4", "copy", "(Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey;", "equals", "other", "hashCode", "", "Companion", "intellij.platform.eel.impl"})
    @SourceDebugExtension(value={"SMAP\nMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Measurer.kt\ncom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n774#2:201\n865#2,2:202\n1374#2:204\n1460#2,2:205\n1374#2:207\n1460#2,2:208\n1374#2:210\n1460#2,2:211\n1563#2:213\n1634#2,3:214\n1462#2,3:217\n1462#2,3:220\n1462#2,3:223\n*S KotlinDebug\n*F\n+ 1 Measurer.kt\ncom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey\n*L\n84#1:201\n84#1:202,2\n86#1:204\n86#1:205,2\n87#1:207\n87#1:208,2\n88#1:210\n88#1:211,2\n90#1:213\n90#1:214,3\n88#1:217,3\n87#1:220,3\n86#1:223,3\n*E\n"})
    public static final class FsEventKey {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final DelegateType delegateType;
        @NotNull
        private final Operation operation;
        @Nullable
        private final Boolean success;
        @Nullable
        private final Boolean repeated;
        @NotNull
        private static final List<FsEventKey> VALUES;

        public FsEventKey(@NotNull DelegateType delegateType, @NotNull Operation operation, @Nullable Boolean success, @Nullable Boolean repeated) {
            Intrinsics.checkNotNullParameter((Object)((Object)delegateType), (String)"delegateType");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            this.delegateType = delegateType;
            this.operation = operation;
            this.success = success;
            this.repeated = repeated;
        }

        @NotNull
        public final DelegateType getDelegateType() {
            return this.delegateType;
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        @Nullable
        public final Boolean getSuccess() {
            return this.success;
        }

        @Nullable
        public final Boolean getRepeated() {
            return this.repeated;
        }

        @NotNull
        public String toString() {
            String string;
            String string2;
            Boolean bl = this.success;
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                string2 = ".success";
            } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                string2 = ".failure";
            } else if (bl == null) {
                string2 = "";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String successKey = string2;
            Boolean bl2 = this.repeated;
            if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
                string = ".repeated";
            } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
                string = ".initial";
            } else if (bl2 == null) {
                string = "";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String repeatedKey = string;
            String delegateTypeKey = switch (WhenMappings.$EnumSwitchMapping$0[this.delegateType.ordinal()]) {
                case 1 -> ".local";
                case 2 -> ".ijent.wsl";
                case 3 -> ".ijent.docker";
                default -> throw new NoWhenBranchMatchedException();
            };
            String keyString = "nio.fs" + delegateTypeKey + "." + this.operation + successKey + repeatedKey;
            return keyString;
        }

        @NotNull
        public final DelegateType component1() {
            return this.delegateType;
        }

        @NotNull
        public final Operation component2() {
            return this.operation;
        }

        @Nullable
        public final Boolean component3() {
            return this.success;
        }

        @Nullable
        public final Boolean component4() {
            return this.repeated;
        }

        @NotNull
        public final FsEventKey copy(@NotNull DelegateType delegateType, @NotNull Operation operation, @Nullable Boolean success, @Nullable Boolean repeated) {
            Intrinsics.checkNotNullParameter((Object)((Object)delegateType), (String)"delegateType");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            return new FsEventKey(delegateType, operation, success, repeated);
        }

        public static /* synthetic */ FsEventKey copy$default(FsEventKey fsEventKey, DelegateType delegateType, Operation operation, Boolean bl, Boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                delegateType = fsEventKey.delegateType;
            }
            if ((n & 2) != 0) {
                operation = fsEventKey.operation;
            }
            if ((n & 4) != 0) {
                bl = fsEventKey.success;
            }
            if ((n & 8) != 0) {
                bl2 = fsEventKey.repeated;
            }
            return fsEventKey.copy(delegateType, operation, bl, bl2);
        }

        public int hashCode() {
            int result = this.delegateType.hashCode();
            result = result * 31 + this.operation.hashCode();
            result = result * 31 + (this.success == null ? 0 : ((Object)this.success).hashCode());
            result = result * 31 + (this.repeated == null ? 0 : ((Object)this.repeated).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FsEventKey)) {
                return false;
            }
            FsEventKey fsEventKey = (FsEventKey)other;
            if (this.delegateType != fsEventKey.delegateType) {
                return false;
            }
            if (this.operation != fsEventKey.operation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.success, (Object)fsEventKey.success)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repeated, (Object)fsEventKey.repeated);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Companion = new Companion(null);
            Iterable $this$filter$iv = (Iterable)DelegateType.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DelegateType it = (DelegateType)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != DelegateType.wsl || SystemInfo.isWindows)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv2;
                DelegateType delegateType = (DelegateType)((Object)element$iv$iv);
                boolean bl = false;
                Iterable $this$flatMap$iv2 = (Iterable)Operation.getEntries();
                boolean $i$f$flatMap2 = false;
                Iterable iterable2 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    void $this$flatMapTo$iv$iv3;
                    Operation operation = (Operation)((Object)element$iv$iv2);
                    boolean bl2 = false;
                    Object[] objectArray = new Boolean[]{null, true, false};
                    Iterable $this$flatMap$iv3 = CollectionsKt.listOf((Object[])objectArray);
                    boolean $i$f$flatMap3 = false;
                    Iterable iterable3 = $this$flatMap$iv3;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo3 = false;
                    for (Object element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                        void $this$mapTo$iv$iv;
                        List list;
                        Boolean success = (Boolean)element$iv$iv3;
                        boolean bl3 = false;
                        if (Companion.getCountUniquePathsEnabled() && success != null) {
                            Object[] objectArray2 = new Boolean[]{null, true, false};
                            list = CollectionsKt.listOf((Object[])objectArray2);
                        } else {
                            list = CollectionsKt.listOf(null);
                        }
                        List repeatedChoices = list;
                        Iterable $this$map$iv = repeatedChoices;
                        boolean $i$f$map = false;
                        Iterable iterable4 = $this$map$iv;
                        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void repeated;
                            Boolean bl4 = (Boolean)item$iv$iv;
                            Collection collection = destination$iv$iv4;
                            boolean bl5 = false;
                            collection.add(new FsEventKey(delegateType, operation, success, (Boolean)repeated));
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv4;
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            VALUES = (List)var3_3;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey$Companion;", "", "<init>", "()V", "countUniquePathsEnabled", "", "getCountUniquePathsEnabled", "()Z", "VALUES", "", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$FsEventKey;", "getVALUES", "()Ljava/util/List;", "intellij.platform.eel.impl"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean getCountUniquePathsEnabled() {
                return Boolean.parseBoolean(System.getProperty("nio.mrfs.telemetry.count.unique.paths", "false"));
            }

            @NotNull
            public final List<FsEventKey> getVALUES() {
                return VALUES;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DelegateType.values().length];
                try {
                    nArray[DelegateType.local.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DelegateType.wsl.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DelegateType.docker.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b!\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006\""}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "", "<init>", "(Ljava/lang/String;I)V", "directoryStreamClose", "directoryStreamIteratorNext", "directoryStreamIteratorRemove", "fileSystemClose", "fileSystemNewWatchService", "providerCheckAccess", "providerCopy", "providerCreateDirectory", "providerCreateLink", "providerCreateSymbolicLink", "providerDelete", "providerDeleteIfExists", "providerGetFileAttributeView", "providerGetFileStore", "providerIsHidden", "providerIsSameFile", "providerMove", "providerNewByteChannel", "providerNewDirectoryStream", "providerReadAttributes", "providerReadSymbolicLink", "providerSetAttribute", "seekableByteChannelClose", "seekableByteChannelNewPosition", "seekableByteChannelPosition", "seekableByteChannelRead", "seekableByteChannelSize", "seekableByteChannelTruncate", "seekableByteChannelWrite", "supportedFileAttributeViews", "intellij.platform.eel.impl"})
    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation directoryStreamClose = new Operation();
        public static final /* enum */ Operation directoryStreamIteratorNext = new Operation();
        public static final /* enum */ Operation directoryStreamIteratorRemove = new Operation();
        public static final /* enum */ Operation fileSystemClose = new Operation();
        public static final /* enum */ Operation fileSystemNewWatchService = new Operation();
        public static final /* enum */ Operation providerCheckAccess = new Operation();
        public static final /* enum */ Operation providerCopy = new Operation();
        public static final /* enum */ Operation providerCreateDirectory = new Operation();
        public static final /* enum */ Operation providerCreateLink = new Operation();
        public static final /* enum */ Operation providerCreateSymbolicLink = new Operation();
        public static final /* enum */ Operation providerDelete = new Operation();
        public static final /* enum */ Operation providerDeleteIfExists = new Operation();
        public static final /* enum */ Operation providerGetFileAttributeView = new Operation();
        public static final /* enum */ Operation providerGetFileStore = new Operation();
        public static final /* enum */ Operation providerIsHidden = new Operation();
        public static final /* enum */ Operation providerIsSameFile = new Operation();
        public static final /* enum */ Operation providerMove = new Operation();
        public static final /* enum */ Operation providerNewByteChannel = new Operation();
        public static final /* enum */ Operation providerNewDirectoryStream = new Operation();
        public static final /* enum */ Operation providerReadAttributes = new Operation();
        public static final /* enum */ Operation providerReadSymbolicLink = new Operation();
        public static final /* enum */ Operation providerSetAttribute = new Operation();
        public static final /* enum */ Operation seekableByteChannelClose = new Operation();
        public static final /* enum */ Operation seekableByteChannelNewPosition = new Operation();
        public static final /* enum */ Operation seekableByteChannelPosition = new Operation();
        public static final /* enum */ Operation seekableByteChannelRead = new Operation();
        public static final /* enum */ Operation seekableByteChannelSize = new Operation();
        public static final /* enum */ Operation seekableByteChannelTruncate = new Operation();
        public static final /* enum */ Operation seekableByteChannelWrite = new Operation();
        public static final /* enum */ Operation supportedFileAttributeViews = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        @NotNull
        public static EnumEntries<Operation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.directoryStreamClose, Operation.directoryStreamIteratorNext, Operation.directoryStreamIteratorRemove, Operation.fileSystemClose, Operation.fileSystemNewWatchService, Operation.providerCheckAccess, Operation.providerCopy, Operation.providerCreateDirectory, Operation.providerCreateLink, Operation.providerCreateSymbolicLink, Operation.providerDelete, Operation.providerDeleteIfExists, Operation.providerGetFileAttributeView, Operation.providerGetFileStore, Operation.providerIsHidden, Operation.providerIsSameFile, Operation.providerMove, Operation.providerNewByteChannel, Operation.providerNewDirectoryStream, Operation.providerReadAttributes, Operation.providerReadSymbolicLink, Operation.providerSetAttribute, Operation.seekableByteChannelClose, Operation.seekableByteChannelNewPosition, Operation.seekableByteChannelPosition, Operation.seekableByteChannelRead, Operation.seekableByteChannelSize, Operation.seekableByteChannelTruncate, Operation.seekableByteChannelWrite, Operation.supportedFileAttributeViews};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

