/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.JavaTestUtil;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.MockConfiguration;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerTestCase
extends ExecutionWithDebuggerToolsTestCase {
    protected static final int DEFAULT_ADDRESS = 3456;
    protected static final String TEST_JDK_NAME = "JDK";
    protected DebuggerSession myDebuggerSession;
    private ExecutionEnvironment myExecutionEnvironment;
    private RunProfileState myRunnableState;
    private final List<ThrowableRunnable<Throwable>> myTearDownRunnables = new ArrayList<ThrowableRunnable<Throwable>>();
    private CompilerManagerImpl myCompilerManager;
    private final AtomicBoolean myProcessStarted = new AtomicBoolean();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (this.myDebugProcess != null) {
                this.myDebugProcess.stop(true);
                this.myDebugProcess.waitFor();
                this.myDebugProcess.dispose();
            }
        }));
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> EdtTestUtil.runInEdtAndWait(() -> FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles())));
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            new RunAll(this.myTearDownRunnables).run();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myTearDownRunnables.clear();
            super.tearDown();
        }
        if (this.myCompilerManager != null) {
            DebuggerTestCase.assertTrue((boolean)this.myCompilerManager.awaitNettyThreadPoolTermination(1L, TimeUnit.MINUTES));
            this.myCompilerManager = null;
        }
    }

    protected final void atDebuggerTearDown(ThrowableRunnable<Throwable> runnable) {
        this.myTearDownRunnables.add(0, runnable);
    }

    protected final <T> void restoreSettingAfterTest(Supplier<? extends T> getter, Consumer<? super T> setter) {
        Object oldValue = getter.get();
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> setter.accept((Object)oldValue)));
    }

    protected final <T> void setSettingForTest(Supplier<? extends T> getter, Consumer<? super T> setter, T newValue) {
        Object oldValue = getter.get();
        setter.accept(newValue);
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> setter.accept(oldValue)));
    }

    @Override
    protected void initApplication() throws Exception {
        super.initApplication();
        JavaTestUtil.setupInternalJdkAsTestJDK(this.getTestRootDisposable(), TEST_JDK_NAME);
        DebuggerSettings.getInstance().setTransport(0);
        DebuggerSettings.getInstance().SKIP_CONSTRUCTORS = false;
        DebuggerSettings.getInstance().SKIP_GETTERS = false;
        NodeRendererSettings.getInstance().getClassRenderer().SHOW_DECLARED_TYPE = true;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            DebuggerTestCase.$$$reportNull$$$0(0);
        }
        super.runTestRunnable(testRunnable);
        if (this.getDebugProcess() != null) {
            this.runProcess();
            this.waitProcess(this.getDebugProcess().getProcessHandler());
            this.waitForCompleted();
            DebuggerTestCase.assertNull((Object)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(this.getDebugProcess().getProcessHandler()));
            this.myDebuggerSession = null;
        }
        this.throwExceptionsIfAny();
        this.checkTestOutput();
    }

    protected final void runProcess() {
        if (this.getDebugProcess() != null && this.myProcessStarted.compareAndSet(false, true)) {
            this.getDebugProcess().getProcessHandler().startNotify();
        }
    }

    protected void checkTestOutput() throws Exception {
        this.getChecker().checkValid(this.getTestProjectJdk());
    }

    protected void disposeSession(DebuggerSession debuggerSession) {
        UIUtil.invokeAndWaitIfNeeded(() -> ((DebuggerSession)debuggerSession).dispose());
    }

    protected void createLocalProcess(String className) throws ExecutionException {
        this.createLocalProcess(this.createJavaParameters(className));
    }

    protected void createLocalProcess(JavaParameters javaParameters) throws ExecutionException {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebuggerSession = this.createLocalProcess(0, javaParameters);
        this.myDebugProcess = this.myDebuggerSession.getProcess();
    }

    protected DebuggerSession createLocalSession(final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().setTransport(0);
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        RemoteConnection debugParameters = new RemoteConnectionBuilder(debuggerRunnerSettings.LOCAL, debuggerRunnerSettings.getTransport(), debuggerRunnerSettings.getDebugPort()).project(this.myProject).asyncAgent(true).create(javaParameters);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration(this.myProject, this.myModule)).build();
        this.myRunnableState = new JavaCommandLineState(this, environment){

            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @NotNull
            protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                TargetedCommandLineBuilder targetedCommandLineBuilder = this.getJavaParameters().toCommandLine(request);
                if (targetedCommandLineBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                return targetedCommandLineBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTargetedCommandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTargetedCommandLine";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.myExecutionEnvironment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration(this.myProject, this.myModule)).build();
        DefaultDebugEnvironment debugEnvironment = new DefaultDebugEnvironment(this.myExecutionEnvironment, this.myRunnableState, debugParameters, false);
        this.myDebuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)debugEnvironment);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                XDebugSessionImpl session = (XDebugSessionImpl)XDebuggerManager.getInstance((Project)this.myProject).startSession(this.myExecutionEnvironment, new XDebugProcessStarter(){

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)DebuggerTestCase.this.myDebuggerSession);
                        if (javaDebugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return javaDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                });
                session.activateSession(false);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }, ModalityState.any());
        this.myDebugProcess = this.myDebuggerSession.getProcess();
        this.myDebugProcess.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebuggerTestCase.assertNotNull((Object)this.myDebuggerSession);
        DebuggerTestCase.assertNotNull((Object)this.myDebugProcess);
        return this.myDebuggerSession;
    }

    protected int getTraceMode() {
        return 0;
    }

    protected DebuggerSession createLocalProcess(int transport, final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().setTransport(transport);
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.setLocal(true);
        debuggerRunnerSettings.setTransport(transport);
        debuggerRunnerSettings.setDebugPort(transport == 0 ? "0" : String.valueOf(3456));
        this.myExecutionEnvironment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration(this.myProject, this.myModule)).build();
        this.myRunnableState = new JavaCommandLineState(this, this.myExecutionEnvironment){

            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @NotNull
            protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
                if (request == null) {
                    4.$$$reportNull$$$0(0);
                }
                TargetedCommandLineBuilder targetedCommandLineBuilder = this.getJavaParameters().toCommandLine(request);
                if (targetedCommandLineBuilder == null) {
                    4.$$$reportNull$$$0(1);
                }
                return targetedCommandLineBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTargetedCommandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTargetedCommandLine";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        RemoteConnection debugParameters = new RemoteConnectionBuilder(debuggerRunnerSettings.LOCAL, debuggerRunnerSettings.getTransport(), debuggerRunnerSettings.getDebugPort()).project(this.myProject).checkValidity(true).asyncAgent(false).create(javaParameters);
        AsyncStacksUtils.addDebuggerAgent((JavaParameters)javaParameters, (Project)this.myProject, (boolean)true, (Disposable)this.getTestRootDisposable());
        this.myExecutionEnvironment.putUserData((Key)DefaultDebugEnvironment.DEBUGGER_TRACE_MODE, (Object)this.getTraceMode());
        DebuggerSession debuggerSession = this.attachVirtualMachine(this.myRunnableState, this.myExecutionEnvironment, debugParameters, false);
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        debuggerSession.getProcess().addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    5.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$5";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession createRemoteProcess(int transport, boolean serverMode, JavaParameters javaParameters) throws ExecutionException {
        DebuggerSession debuggerSession;
        RemoteConnection remoteConnection = new RemoteConnectionBuilder(serverMode, transport, null).suspend(true).create(javaParameters);
        GeneralCommandLine commandLine = javaParameters.toCommandLine();
        if (serverMode) {
            debuggerSession = this.attachVM(remoteConnection, false);
            commandLine.createProcess();
        } else {
            commandLine.createProcess();
            debuggerSession = this.attachVM(remoteConnection, true);
        }
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession attachVM(RemoteConnection remoteConnection, boolean pollConnection) {
        RemoteStateState remoteState = new RemoteStateState(this.myProject, remoteConnection);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration(this.myProject, this.myModule)).build();
        DebuggerSession debuggerSession = null;
        try {
            debuggerSession = this.attachVirtualMachine((RunProfileState)remoteState, environment, remoteConnection, pollConnection);
        }
        catch (ExecutionException e) {
            DebuggerTestCase.fail((String)e.getMessage());
        }
        debuggerSession.getProcess().getProcessHandler().addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    6.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$6";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return debuggerSession;
    }

    protected void createBreakpoints(String className) {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((String)("Class for breakpoint installation not found " + className), (Object)psiClass);
            return psiClass.getContainingFile();
        });
        this.createBreakpoints(psiFile);
    }

    protected Value evaluate(CodeFragmentKind kind, String code, EvaluationContextImpl evaluationContext) throws EvaluateException {
        WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(this.myProject, (TextWithImports)new TextWithImportsImpl(kind, code));
        watchItemDescriptor.setContext(evaluationContext);
        EvaluateException exception = watchItemDescriptor.getEvaluateException();
        if (exception != null) {
            throw exception;
        }
        return watchItemDescriptor.getValue();
    }

    protected Value evaluate(CodeFragmentKind kind, String code, SuspendContextImpl suspendContext) throws EvaluateException {
        return this.evaluate(kind, code, this.createEvaluationContext(suspendContext));
    }

    protected EvaluationContextImpl createEvaluationContext(SuspendContextImpl suspendContext) {
        try {
            StackFrameProxyImpl proxy = suspendContext.getFrameProxy();
            DebuggerTestCase.assertNotNull((Object)proxy);
            return new EvaluationContextImpl(suspendContext, proxy, (Value)proxy.thisObject());
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    private void waitForCompleted() {
        final SynchronizationBasedSemaphore s = new SynchronizationBasedSemaphore();
        s.down();
        final InvokeThread.WorkerThreadRequest request = this.getDebugProcess().getManagerThread().getCurrentRequest();
        Thread thread = new Thread(this, "Joining " + String.valueOf(request)){

            @Override
            public void run() {
                try {
                    request.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        if (request.isDone()) {
            thread.interrupt();
        }
        this.waitFor(() -> {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.invokeRatherLater(new DebuggerCommandImpl(){

            protected void action() {
                LOG.assertTrue(false);
            }

            protected void commandCancelled() {
                DebuggerTestCase.this.invokeRatherLater(new DebuggerCommandImpl(){

                    protected void action() {
                        LOG.assertTrue(false);
                    }

                    protected void commandCancelled() {
                        s.up();
                    }
                });
            }
        });
        this.waitFor(s::waitFor);
        this.myCompilerManager = (CompilerManagerImpl)CompilerManager.getInstance((Project)this.getProject());
        this.myCompilerManager.waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES);
    }

    private DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext, StackFrameProxyImpl stackFrame) {
        DebuggerSession[] session = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded(() -> {
            session[0] = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getSession((DebugProcess)suspendContext.getDebugProcess());
        });
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext((DebuggerSession)session[0], (SuspendContextImpl)suspendContext, (ThreadReferenceProxyImpl)(stackFrame != null ? stackFrame.threadProxy() : null), (StackFrameProxyImpl)stackFrame);
        debuggerContext.initCaches();
        return debuggerContext;
    }

    public DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext) {
        StackFrameProxyImpl proxy = DebuggerTestCase.getFrameProxy(suspendContext);
        return this.createDebuggerContext(suspendContext, proxy);
    }

    protected static StackFrameProxyImpl getFrameProxy(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebuggerTestCase.$$$reportNull$$$0(1);
        }
        return suspendContext.getFrameProxy();
    }

    protected void createBreakpointInHelloWorld() {
        DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("HelloWorld", GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((Object)psiClass);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiClass.getContainingFile());
            DebuggerTestCase.assertNotNull((Object)breakpointManager.addLineBreakpoint(document, 3));
        }, (ModalityState)ApplicationManager.getApplication().getDefaultModalityState());
    }

    protected void createHelloWorldProcessWithBreakpoint() throws ExecutionException {
        this.createLocalProcess("HelloWorld");
        this.createBreakpointInHelloWorld();
    }

    protected void printAsyncStackTrace() {
        if (!this.myLogAllCommands) {
            this.printContext((StackFrameContext)this.getDebugProcess().getDebuggerContext());
        }
        List<XStackFrame> frames = this.collectFrames(this.getDebuggerSession().getXDebugSession());
        this.systemPrintln("vvv stack trace vvv");
        frames.forEach(f -> {
            XDebuggerFramesList.ItemWithSeparatorAbove withSeparator;
            if (f instanceof XDebuggerFramesList.ItemWithSeparatorAbove && (withSeparator = (XDebuggerFramesList.ItemWithSeparatorAbove)f).hasSeparatorAbove()) {
                this.systemPrintln("-- " + withSeparator.getCaptionAboveOf() + " --");
            }
            if (f instanceof XFramesView.HiddenStackFramesItem) {
                this.systemPrintln("  <hidden frames>");
            } else {
                this.systemPrintln("  " + this.getFramePresentation((XStackFrame)f));
            }
        });
        this.systemPrintln("^^^ stack trace ^^^");
    }

    @NotNull
    protected List<XStackFrame> collectFrames(@Nullable XDebugSession session) {
        List<XStackFrame> list = List.of();
        if (list == null) {
            DebuggerTestCase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected String getFramePresentation(XStackFrame f) {
        String string = f.toString();
        if (string == null) {
            DebuggerTestCase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    public RunProfileState getRunnableState() {
        return this.myRunnableState;
    }

    public DebuggerSession attachVirtualMachine(RunProfileState state, ExecutionEnvironment environment, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        DebuggerTestCase.assertFalse((boolean)EDT.isCurrentThreadEdt());
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection));
        DebuggerTestCase.assertNotNull((Object)debuggerSession);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                XDebuggerManager.getInstance((Project)this.myProject).startSession(environment, new XDebugProcessStarter(this){

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
                        if (javaDebugProcess == null) {
                            9.$$$reportNull$$$0(1);
                        }
                        return javaDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$9";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$9";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                });
            }
            catch (ExecutionException e) {
                DebuggerTestCase.fail((String)e.getMessage());
            }
        }, ModalityState.any());
        return debuggerSession;
    }

    protected void disableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, false);
    }

    protected void enableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, true);
    }

    private void setRendererEnabled(NodeRenderer renderer, boolean state) {
        this.setSettingForTest(() -> ((NodeRenderer)renderer).isEnabled(), arg_0 -> ((NodeRenderer)renderer).setEnabled(arg_0), state);
    }

    protected void doWhenXSessionPaused(ThrowableRunnable runnable) {
        this.doWhenXSessionPaused(runnable, false);
    }

    protected void doWhenXSessionPausedThenResume(ThrowableRunnable runnable) {
        this.doWhenXSessionPaused(runnable, true);
    }

    private void doWhenXSessionPaused(final ThrowableRunnable runnable, final boolean thenResume) {
        XDebugSession session = this.getDebuggerSession().getXDebugSession();
        DebuggerTestCase.assertNotNull((Object)session);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                if (DebuggerTestCase.this.myLogAllCommands) {
                    DebuggerTestCase.this.printContext("Stopped at ", (StackFrameContext)DebuggerTestCase.this.getDebugProcess().getDebuggerContext());
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        DebuggerTestCase.this.addException(e);
                    }
                    finally {
                        if (thenResume) {
                            DebuggerTestCase.this.resume();
                        }
                    }
                });
            }
        });
    }

    protected void resume() {
        SwingUtilities.invokeLater(() -> {
            if (this.myLogAllCommands) {
                this.printContext("Resuming ", (StackFrameContext)this.getDebugProcess().getDebuggerContext());
            }
            XDebugSession session = this.getDebuggerSession().getXDebugSession();
            DebuggerTestCase.assertNotNull((Object)session);
            session.resume();
        });
    }

    protected void setUpPacketsMeasureTest() {
        ApplicationManagerEx.setInStressTest((boolean)true);
        this.setRegistryPropertyForTest("debugger.track.instrumentation", "false");
        this.setRegistryPropertyForTest("debugger.evaluate.single.threaded.timeout", "-1");
        this.setRegistryPropertyForTest("debugger.preload.types.hierarchy", "false");
        boolean dfa = ViewsGeneralSettings.getInstance().USE_DFA_ASSIST;
        boolean dfaGray = ViewsGeneralSettings.getInstance().USE_DFA_ASSIST_GRAY_OUT;
        ViewsGeneralSettings.getInstance().USE_DFA_ASSIST = false;
        ViewsGeneralSettings.getInstance().USE_DFA_ASSIST_GRAY_OUT = false;
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> {
            ViewsGeneralSettings.getInstance().USE_DFA_ASSIST = dfa;
            ViewsGeneralSettings.getInstance().USE_DFA_ASSIST_GRAY_OUT = dfaGray;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFrames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFramePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFrameProxy";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

