/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.util.PathUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class OutputChecker {
    public static final ProcessOutputType[] OUTPUT_ORDER = new ProcessOutputType[]{ProcessOutputType.SYSTEM, ProcessOutputType.STDOUT, ProcessOutputType.STDERR};
    private static final String JDK_HOME_STR = "!JDK_HOME!";
    private static final Pattern JDI_BUG_OUTPUT_PATTERN_1 = Pattern.compile("ERROR:\\s+JDWP\\s+Unable\\s+to\\s+get\\s+JNI\\s+1\\.2\\s+environment,\\s+jvm->GetEnv\\(\\)\\s+return\\s+code\\s+=\\s+-2\n");
    private static final Pattern JDI_BUG_OUTPUT_PATTERN_2 = Pattern.compile("JDWP\\s+exit\\s+error\\s+AGENT_ERROR_NO_JNI_ENV.*]\n");
    private static final String[] IGNORED_IN_STDERR = new String[]{"Picked up _JAVA_OPTIONS:", "Picked up JAVA_TOOL_OPTIONS:"};
    private final Supplier<String> myAppPath;
    private final Supplier<String> myOutputPath;
    private Map<Key<?>, StringBuffer> myBuffers;
    private String myTestName;
    private static String HOST_NAME = null;
    private static String CANONICAL_HOST_NAME = null;

    public OutputChecker(Supplier<String> appPath, Supplier<String> outputPath) {
        this.myAppPath = appPath;
        this.myOutputPath = outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String testName) {
        IdeaLogger.ourErrorsOccurred = null;
        this.myTestName = Character.toLowerCase(testName.charAt(0)) + testName.substring(1);
        OutputChecker outputChecker = this;
        synchronized (outputChecker) {
            this.myBuffers = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s, Key<?> outputType) {
        OutputChecker outputChecker = this;
        synchronized (outputChecker) {
            if (this.myBuffers != null) {
                if (outputType == ProcessOutputType.STDERR) {
                    if (ContainerUtil.exists((Object[])IGNORED_IN_STDERR, s::contains)) {
                        return;
                    }
                }
                this.myBuffers.computeIfAbsent(outputType, k -> new StringBuffer()).append(s);
            }
        }
    }

    public void println(String s, Key<?> outputType) {
        this.print(s + "\n", outputType);
    }

    public void checkValid(Sdk jdk) throws Exception {
        this.checkValid(jdk, false);
    }

    private Path getOutFile(Path outsDir, Sdk jdk, @Nullable Path current, String prefix) {
        String name = this.myTestName + prefix;
        Path res = outsDir.resolve(name + ".out");
        if (current == null || Files.exists(res, new LinkOption[0])) {
            current = res;
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        for (int feature = version.getMaxLanguageLevel().feature(); feature > 6; --feature) {
            Path outFile = outsDir.resolve(name + ".jdk" + feature + ".out");
            if (!Files.exists(outFile, new LinkOption[0])) continue;
            current = outFile;
            break;
        }
        return current;
    }

    public void checkValid(Sdk jdk, boolean sortClassPath) throws Exception {
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        String actual = this.preprocessBuffer(this.buildOutputString(), sortClassPath);
        Path outsDir = NioFiles.createDirectories((Path)Path.of(this.myAppPath.get(), "outs"));
        Path outFile = this.getOutFile(outsDir, jdk, null, "");
        if (!Files.exists(outFile, new LinkOption[0])) {
            if (SystemInfo.isWindows) {
                outFile = this.getOutFile(outsDir, jdk, outFile, ".win");
            } else if (SystemInfo.isUnix) {
                outFile = this.getOutFile(outsDir, jdk, outFile, ".unx");
            }
        }
        if (!Files.exists(outFile, new LinkOption[0])) {
            Files.writeString(outFile, (CharSequence)actual, new OpenOption[0]);
            Assert.fail((String)("Test file created " + String.valueOf(outFile) + "\n**************** Don't forget to put it into VCS! *******************"));
        } else {
            String originalText = Files.readString(outFile);
            String expected = StringUtilRt.convertLineSeparators((String)originalText);
            if (!expected.equals(actual)) {
                System.out.println("expected:");
                System.out.println(originalText);
                System.out.println("actual:");
                System.out.println(actual);
                int len = Math.min(expected.length(), actual.length());
                if (expected.length() != actual.length()) {
                    System.out.println("Text sizes differ: expected " + expected.length() + " but actual: " + actual.length());
                }
                if (expected.length() > len) {
                    System.out.println("Rest from expected text is: \"" + expected.substring(len) + "\"");
                } else if (actual.length() > len) {
                    System.out.println("Rest from actual text is: \"" + actual.substring(len) + "\"");
                }
                throw new FileComparisonFailedError(null, expected, actual, outFile.toString());
            }
        }
    }

    private synchronized String buildOutputString() {
        StringBuilder result = new StringBuilder();
        for (ProcessOutputType key : OUTPUT_ORDER) {
            StringBuffer buffer = this.myBuffers.get(key);
            if (buffer == null) continue;
            result.append(buffer);
        }
        return result.toString();
    }

    private String preprocessBuffer(String buffer, boolean sortClassPath) {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return buffer;
        }
        return (String)ReadAction.compute(() -> {
            String result = buffer;
            result = result.replace("\r\n", "\n");
            result = result.replace('\r', '\n');
            result = this.replaceAdditionalInOutput(result);
            result = OutputChecker.replacePath(result, this.myAppPath.get(), "!APP_PATH!");
            result = OutputChecker.replacePath(result, this.myOutputPath.get(), "!OUTPUT_PATH!");
            result = OutputChecker.replacePath(result, JavaSdkUtil.getIdeaRtJarPath(), "!RT_JAR!");
            if (PluginManagerCore.isRunningFromSources()) {
                result = OutputChecker.replacePath(result, DebuggerUtilsImpl.getIdeaRtPath(), "!RT_JAR!");
            }
            String junit4JarPaths = StringUtil.join(IntelliJProjectConfiguration.getProjectLibraryClassesRootPaths("JUnit4"), (String)File.pathSeparator);
            result = OutputChecker.replacePath(result, junit4JarPaths, "!JUNIT4_JARS!");
            VirtualFile homeDirectory = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomeDirectory();
            Assert.assertNotNull((Object)homeDirectory);
            result = OutputChecker.replacePath(result, homeDirectory.getPath(), JDK_HOME_STR);
            if (!StringUtil.isEmpty((String)CANONICAL_HOST_NAME)) {
                result = StringUtil.replace((String)result, (String)CANONICAL_HOST_NAME, (String)"!HOST_NAME!", (boolean)true);
            }
            if (!StringUtil.isEmpty((String)HOST_NAME)) {
                result = StringUtil.replace((String)result, (String)HOST_NAME, (String)"!HOST_NAME!", (boolean)true);
            }
            result = result.replace("127.0.0.1", "!HOST_NAME!");
            Path productionFile = Path.of(PathUtil.getJarPathForClass(OutputChecker.class), new String[0]);
            if (Files.isDirectory(productionFile, new LinkOption[0])) {
                result = OutputChecker.replacePath(result, UriUtil.trimTrailingSlashes((String)productionFile.getParent().toUri().toString()), "!PRODUCTION_PATH!");
            }
            result = OutputChecker.replacePath(result, PathManager.getHomePath(), "!IDEA_HOME!");
            result = result.replace("Process finished with exit code 255", "Process finished with exit code -1");
            result = result.replaceAll(" -javaagent:.*?debugger-agent\\.jar(=.+?\\.props)?", "");
            result = result.replaceAll(" -agentpath:\\S*memory_agent([\\w^\\s]*)?\\.\\S+", "");
            result = result.replaceAll("!HOST_NAME!:\\d*", "!HOST_NAME!:!HOST_PORT!");
            result = result.replaceAll("at '.*?'", "at '!HOST_NAME!:PORT_NAME!'");
            result = result.replaceAll("address: '.*?'", "address: '!HOST_NAME!:PORT_NAME!'");
            result = result.replaceAll("\"?file:.*AppletPage.*\\.html\"?", "file:!APPLET_HTML!");
            result = result.replaceAll("\"(!JDK_HOME!.*?)\"", "$1");
            result = result.replaceAll("\"(!APP_PATH!.*?)\"", "$1");
            result = result.replaceAll("\"(-D.*?)\"", "$1");
            result = result.replaceAll("-Didea.launcher.port=\\d*", "-Didea.launcher.port=!IDEA_LAUNCHER_PORT!");
            result = result.replaceAll("-Dfile.encoding=[\\w-]*", "-Dfile.encoding=!FILE_ENCODING!");
            result = result.replace("-Dsun.stdout.encoding=UTF-8 -Dsun.stderr.encoding=UTF-8 ", "");
            result = result.replace("-Dkotlinx.coroutines.debug.enable.creation.stack.trace=false ", "");
            result = result.replace("-Ddebugger.agent.enable.coroutines=true ", "");
            result = result.replace("-Dkotlinx.coroutines.debug.enable.flows.stack.trace=true ", "");
            result = result.replace("-Dkotlinx.coroutines.debug.enable.mutable.state.flows.stack.trace=true ", "");
            result = result.replace("-Ddebugger.async.stack.trace.for.all.threads=true ", "");
            result = result.replace("-Ddebugger.agent.support.throwable=false ", "");
            result = result.replaceAll("\\((.*):\\d+\\)", "($1:!LINE_NUMBER!)");
            result = result.replaceAll("lambda\\$(.*)\\$\\d+", "lambda\\$$1\\$L");
            result = OutputChecker.fixSlashes(result, JDK_HOME_STR);
            result = result.replace("!JDK_HOME!\\bin\\java.exe", "!JDK_HOME!\\bin\\java");
            result = OutputChecker.stripQuotesAroundClasspath(result);
            Matcher matcher = Pattern.compile("-classpath\\s+(\\S+)\\s+").matcher(result);
            while (matcher.find()) {
                String classPath = matcher.group(1);
                String[] classPathElements = classPath.split(File.pathSeparator);
                ArrayList<String> classpathRes = new ArrayList<String>();
                boolean hasJdkJars = false;
                for (String element : classPathElements) {
                    if (!element.startsWith(JDK_HOME_STR)) {
                        classpathRes.add(element);
                        continue;
                    }
                    hasJdkJars = true;
                }
                if (hasJdkJars) {
                    classpathRes.add("!JDK_JARS!");
                }
                if (sortClassPath) {
                    Collections.sort(classpathRes);
                }
                String sortedPath = StringUtil.join(classpathRes, (String)";");
                result = result.replace(" " + classPath + " ", " " + sortedPath + " ");
            }
            result = JDI_BUG_OUTPUT_PATTERN_1.matcher(result).replaceAll("");
            result = JDI_BUG_OUTPUT_PATTERN_2.matcher(result).replaceAll("");
            return result;
        });
    }

    protected static String replacePath(String result, String path, String replacement) {
        result = StringUtil.replace((String)result, (String)FileUtil.toSystemDependentName((String)path), (String)replacement, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        result = StringUtil.replace((String)result, (String)FileUtil.toSystemIndependentName((String)path), (String)replacement, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        return result;
    }

    private static String fixSlashes(String text, String jdkHomeMarker) {
        int commandLineStart = text.indexOf(jdkHomeMarker);
        while (commandLineStart != -1) {
            char c;
            StringBuilder builder = new StringBuilder(text);
            for (int i2 = commandLineStart + 1; i2 < builder.length() && (c = builder.charAt(i2)) != '\n'; ++i2) {
                if (c != File.separatorChar) continue;
                builder.setCharAt(i2, '\\');
            }
            text = builder.toString();
            commandLineStart = text.indexOf(jdkHomeMarker, commandLineStart + 1);
        }
        return text;
    }

    protected String replaceAdditionalInOutput(String str) {
        return str;
    }

    private static String stripQuotesAroundClasspath(String result) {
        int spaceIdx;
        String cp = "-classpath ";
        int cpIdx = 0;
        while ((cpIdx = ((String)result).indexOf(cp, cpIdx)) != -1 && (spaceIdx = ((String)result).indexOf(" ", cpIdx + cp.length())) != -1) {
            result = ((String)result).substring(0, cpIdx) + cp + StringUtil.unquoteString((String)((String)result).substring(cpIdx + cp.length(), spaceIdx)) + ((String)result).substring(spaceIdx);
            cpIdx += cp.length();
        }
        return result;
    }

    static {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            HOST_NAME = localHost.getHostName();
            CANONICAL_HOST_NAME = localHost.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

