/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.TestIndexingModeSupporter;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaIndexingModeCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@TestDataPath(value="$CONTENT_ROOT/testData")
public abstract class LightJavaCodeInsightFixtureTestCase
extends UsefulTestCase
implements TestIndexingModeSupporter {
    @NotNull
    public static final LightProjectDescriptor JAVA_1_4 = new ProjectDescriptor(LanguageLevel.JDK_1_4);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_4_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_4, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_5 = new ProjectDescriptor(LanguageLevel.JDK_1_5);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_6 = new ProjectDescriptor(LanguageLevel.JDK_1_6);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_7 = new ProjectDescriptor(LanguageLevel.JDK_1_7);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_7_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_7, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_8 = new ProjectDescriptor(LanguageLevel.JDK_1_8);
    @NotNull
    public static final LightProjectDescriptor JAVA_8_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_8, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_9 = new ProjectDescriptor(LanguageLevel.JDK_1_9);
    @NotNull
    public static final LightProjectDescriptor JAVA_9_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_9, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_11 = new ProjectDescriptor(LanguageLevel.JDK_11);
    @NotNull
    public static final LightProjectDescriptor JAVA_11_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_11, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_12 = new ProjectDescriptor(LanguageLevel.JDK_12);
    @NotNull
    public static final LightProjectDescriptor JAVA_13 = new ProjectDescriptor(LanguageLevel.JDK_13);
    @NotNull
    public static final LightProjectDescriptor JAVA_14 = new ProjectDescriptor(LanguageLevel.JDK_14);
    @NotNull
    public static final LightProjectDescriptor JAVA_15 = new ProjectDescriptor(LanguageLevel.JDK_15);
    @NotNull
    public static final LightProjectDescriptor JAVA_16 = new ProjectDescriptor(LanguageLevel.JDK_16);
    @NotNull
    public static final LightProjectDescriptor JAVA_17 = new ProjectDescriptor(LanguageLevel.JDK_17);
    @NotNull
    public static final LightProjectDescriptor JAVA_17_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_17, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_18 = new ProjectDescriptor(LanguageLevel.JDK_18);
    @NotNull
    public static final LightProjectDescriptor JAVA_19 = new ProjectDescriptor(LanguageLevel.JDK_19);
    @NotNull
    public static final LightProjectDescriptor JAVA_20 = new ProjectDescriptor(LanguageLevel.JDK_20);
    @NotNull
    public static final LightProjectDescriptor JAVA_21 = new ProjectDescriptor(LanguageLevel.JDK_21_PREVIEW);
    @NotNull
    public static final LightProjectDescriptor JAVA_21_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_21_PREVIEW, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_22 = new ProjectDescriptor(LanguageLevel.JDK_22_PREVIEW);
    @NotNull
    public static final LightProjectDescriptor JAVA_23 = new ProjectDescriptor(LanguageLevel.JDK_23_PREVIEW);
    @NotNull
    public static final LightProjectDescriptor JAVA_24 = new ProjectDescriptor(LanguageLevel.JDK_24);
    @NotNull
    public static final LightProjectDescriptor JAVA_25 = new ProjectDescriptor(LanguageLevel.JDK_25);
    @NotNull
    public static final LightProjectDescriptor JAVA_X = new ProjectDescriptor(LanguageLevel.JDK_X);
    @NotNull
    public static final LightProjectDescriptor JAVA_LATEST = new ProjectDescriptor(LanguageLevel.HIGHEST){

        @Override
        public Sdk getSdk() {
            return IdeaTestUtil.getMockJdk17();
        }
    };
    @NotNull
    public static final LightProjectDescriptor JAVA_LATEST_WITH_LATEST_JDK = new ProjectDescriptor(LanguageLevel.HIGHEST);
    protected JavaCodeInsightTestFixture myFixture;
    @NotNull
    private TestIndexingModeSupporter.IndexingMode myIndexingMode = TestIndexingModeSupporter.IndexingMode.SMART;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder<IdeaProjectTestFixture> fixtureBuilder = factory.createLightFixtureBuilder(this.getProjectDescriptor(), this.getTestName(false));
        IdeaProjectTestFixture fixture = fixtureBuilder.getFixture();
        this.myFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, this.getTempDirFixture());
        this.myFixture = JavaIndexingModeCodeInsightTestFixture.Companion.wrapFixture(this.myFixture, this.getIndexingMode());
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
        IdeaTestUtil.setProjectLanguageLevel(this.getProject(), LanguageLevel.JDK_1_6);
    }

    @NotNull
    protected TempDirTestFixture getTempDirFixture() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        return policy != null ? policy.createTempDirTestFixture() : new LightTempDirTestFixtureImpl(true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFixture != null) {
                this.myFixture.tearDown();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_LATEST;
        if (lightProjectDescriptor == null) {
            LightJavaCodeInsightFixtureTestCase.$$$reportNull$$$0(0);
        }
        return lightProjectDescriptor;
    }

    protected String getTestDataPath() {
        String communityPath = PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/');
        String path = communityPath + this.getBasePath();
        return new File(path).exists() ? path : communityPath + "/../" + this.getBasePath();
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiFile getFile() {
        return this.myFixture.getFile();
    }

    protected Editor getEditor() {
        return this.myFixture.getEditor();
    }

    protected Module getModule() {
        return this.myFixture.getModule();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public PsiElementFactory getElementFactory() {
        return JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    protected PsiFile createLightFile(FileType fileType, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, language, (CharSequence)text, false, true);
    }

    @Override
    public void setIndexingMode(@NotNull TestIndexingModeSupporter.IndexingMode mode) {
        if (mode == null) {
            LightJavaCodeInsightFixtureTestCase.$$$reportNull$$$0(1);
        }
        this.myIndexingMode = mode;
    }

    @Override
    @NotNull
    public TestIndexingModeSupporter.IndexingMode getIndexingMode() {
        TestIndexingModeSupporter.IndexingMode indexingMode = this.myIndexingMode;
        if (indexingMode == null) {
            LightJavaCodeInsightFixtureTestCase.$$$reportNull$$$0(2);
        }
        return indexingMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setIndexingMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    protected static class ProjectDescriptor
    extends DefaultLightProjectDescriptor {
        protected final LanguageLevel myLanguageLevel;
        private final boolean myWithAnnotations;

        public ProjectDescriptor(@NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                ProjectDescriptor.$$$reportNull$$$0(0);
            }
            this(languageLevel, false);
        }

        public ProjectDescriptor(@NotNull LanguageLevel languageLevel, boolean withAnnotations) {
            if (languageLevel == null) {
                ProjectDescriptor.$$$reportNull$$$0(1);
            }
            this.myLanguageLevel = languageLevel;
            this.myWithAnnotations = withAnnotations;
        }

        @Override
        public void setUpProject(@NotNull Project project, @NotNull LightProjectDescriptor.SetupHandler handler) throws Exception {
            if (project == null) {
                ProjectDescriptor.$$$reportNull$$$0(2);
            }
            if (handler == null) {
                ProjectDescriptor.$$$reportNull$$$0(3);
            }
            if (this.myLanguageLevel.isPreview() || this.myLanguageLevel == LanguageLevel.JDK_X) {
                AcceptedLanguageLevelsSettings.allowLevel((Disposable)project, (LanguageLevel)this.myLanguageLevel);
            }
            super.setUpProject(project, handler);
        }

        @Override
        public Sdk getSdk() {
            Sdk jdk = IdeaTestUtil.getMockJdk(this.myLanguageLevel.toJavaVersion());
            return this.myWithAnnotations ? PsiTestUtil.addJdkAnnotations(jdk) : jdk;
        }

        @NotNull
        public String getSdkName() {
            String string = IdeaTestUtil.getMockJdkName(this.myLanguageLevel.toJavaVersion());
            if (string == null) {
                ProjectDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
            if (module2 == null) {
                ProjectDescriptor.$$$reportNull$$$0(5);
            }
            if (model == null) {
                ProjectDescriptor.$$$reportNull$$$0(6);
            }
            if (contentEntry == null) {
                ProjectDescriptor.$$$reportNull$$$0(7);
            }
            ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
            if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                ProjectDescriptor.addJetBrainsAnnotationsWithTypeUse(model);
            } else {
                ProjectDescriptor.addJetBrainsAnnotations(model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase$ProjectDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase$ProjectDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpProject";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "configureModule";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

