/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DbObjectsSEContributor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObjectsGoToContributor;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.scopes.DbDataSourceScope;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbObjectCategory;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.util.TypeVisibilityStateHolder;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DisposableGotoModelWithPersistentFilter;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0006)*+,-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0016J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\u001f\u001a\u00020\u001cH\u0014J\u0016\u0010 \u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012H\u0014J\u001e\u0010!\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012H\u0014J \u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor;", "Lcom/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)V", "DB_COMMAND", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereCommandInfo;", "myFilterStateService", "Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService;", "getGroupName", "", "Lorg/jetbrains/annotations/Nls;", "getSortWeight", "", "isShownInSeparateTab", "", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "onChanged", "Ljava/lang/Runnable;", "getSupportedCommands", "createModel", "Lcom/intellij/ide/util/gotoByName/FilteringGotoByModel;", "project", "Lcom/intellij/openapi/project/Project;", "findProjectScope", "Lcom/intellij/psi/search/SearchScope;", "scopeDescriptors", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "everywhereScope", "findEverywhereScope", "findScopeOrReturnSomething", "scopeId", "createScopes", "processSelectedItem", "selected", "", "modifiers", "searchText", "Factory", "FilterStateService", "MyGotoModel", "MyContributor", "CustomFiltersAction", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n30#2,2:369\n1056#3:371\n774#3:372\n865#3,2:373\n*S KotlinDebug\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor\n*L\n49#1:369,2\n61#1:371\n129#1:372\n129#1:373,2\n*E\n"})
public final class DbObjectsSEContributor
extends AbstractGotoSEContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchEverywhereCommandInfo DB_COMMAND;
    @NotNull
    private final FilterStateService myFilterStateService;
    @NotNull
    private static final Logger LOG;

    public DbObjectsSEContributor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super(event);
        this.DB_COMMAND = new SearchEverywhereCommandInfo("db", DatabaseBundle.message((String)"go.to.database.object", (Object[])new Object[0]), (SearchEverywhereContributor)this);
        Object object = event.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        ComponentManager $this$service$iv = (ComponentManager)object;
        boolean $i$f$service = false;
        Class<FilterStateService> serviceClass$iv = FilterStateService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.myFilterStateService = (FilterStateService)object2;
    }

    @NotNull
    public String getGroupName() {
        String string = DatabaseBundle.message((String)"go.to.table.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public int getSortWeight() {
        return 200;
    }

    public boolean isShownInSeparateTab() {
        return Companion.hasDatabaseTab(this.myProject);
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged2) {
        Intrinsics.checkNotNullParameter((Object)onChanged2, (String)"onChanged");
        JBIterable jBIterable = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)this.myProject).getDataSources()).map(arg_0 -> DbObjectsSEContributor.getActions$lambda$1(DbObjectsSEContributor::getActions$lambda$0, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"unique(...)");
        Iterable $this$sortedBy$iv = (Iterable)jBIterable;
        boolean $i$f$sortedBy = false;
        List dbmses = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Dbms it = (Dbms)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (Dbms)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        PersistentSearchEverywhereContributorFilter dbmsFilter2 = new PersistentSearchEverywhereContributorFilter(dbmses, (TypeVisibilityStateHolder)this.myFilterStateService.getMyDbmsState(), arg_0 -> DbObjectsSEContributor.getActions$lambda$3(getActions.dbmsFilter.1.INSTANCE, arg_0), arg_0 -> DbObjectsSEContributor.getActions$lambda$4(getActions.dbmsFilter.2.INSTANCE, arg_0));
        PersistentSearchEverywhereContributorFilter catFilter2 = new PersistentSearchEverywhereContributorFilter((List)DbObjectCategory.getEntries(), (TypeVisibilityStateHolder)this.myFilterStateService.getMyCategoryState(), arg_0 -> DbObjectsSEContributor.getActions$lambda$5(getActions.catFilter.1.INSTANCE, arg_0), arg_0 -> DbObjectsSEContributor.getActions$lambda$6((Function1)getActions.catFilter.2.INSTANCE, arg_0));
        List actions = CollectionsKt.toMutableList((Collection)this.doGetActions(dbmsFilter2, null, onChanged2));
        actions.removeIf(arg_0 -> DbObjectsSEContributor.getActions$lambda$8(DbObjectsSEContributor::getActions$lambda$7, arg_0));
        String string = DatabaseBundle.message((String)"action.dbms.filter.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CustomFiltersAction dbmsFilterAction = new CustomFiltersAction(dbmsFilter2, onChanged2, DbDataSourceScope.BADGED_DBMS, string);
        String string2 = DatabaseBundle.message((String)"action.object.kind.filter.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CustomFiltersAction kindFilterAction = new CustomFiltersAction(catFilter2, onChanged2, null, string2);
        dbmsFilterAction.getMyOther().add((ToggleAction)kindFilterAction);
        kindFilterAction.getMyOther().add((ToggleAction)dbmsFilterAction);
        actions.add(dbmsFilterAction);
        actions.add(kindFilterAction);
        return actions;
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        boolean dbOnlyCommands = DbObjectsSEContributor.Companion.isDbTabVisible(this.myProject);
        ArrayList<SearchEverywhereCommandInfo> result = new ArrayList<SearchEverywhereCommandInfo>();
        if (!dbOnlyCommands) {
            result.add(this.DB_COMMAND);
        }
        for (DbObjectCategory cat : DbObjectCategory.getEntries()) {
            if (cat == DbObjectCategory.OTHER) continue;
            Object[] objectArray = new Object[]{cat.getDisplayName()};
            result.add(new SearchEverywhereCommandInfo((String)(dbOnlyCommands ? cat.getId() : "db." + cat.getId()), IdeBundle.message((String)"go.to.class.title.prefix", (Object[])objectArray), (SearchEverywhereContributor)this));
        }
        return result;
    }

    @NotNull
    public FilteringGotoByModel<?> createModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean isDbTab = DbObjectsSEContributor.Companion.isDbTabVisible(project);
        FilterStateService.SetState<Dbms> dbmses = this.myFilterStateService.getMyDbmsState().copy();
        FilterStateService.SetState<DbObjectCategory> categories = this.myFilterStateService.getMyCategoryState().copy();
        return (FilteringGotoByModel)new MyGotoModel(project, (Function1<? super DasObject, Boolean>)((Function1)arg_0 -> DbObjectsSEContributor.createModel$lambda$0(isDbTab, dbmses, arg_0)), (Function1<? super DasObject, Boolean>)((Function1)arg_0 -> DbObjectsSEContributor.createModel$lambda$1(isDbTab, categories, arg_0)));
    }

    @NotNull
    protected SearchScope findProjectScope(@NotNull List<? extends ScopeDescriptor> scopeDescriptors, @NotNull SearchScope everywhereScope) {
        Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
        Intrinsics.checkNotNullParameter((Object)everywhereScope, (String)"everywhereScope");
        return everywhereScope;
    }

    @NotNull
    protected SearchScope findEverywhereScope(@NotNull List<? extends ScopeDescriptor> scopeDescriptors) {
        Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
        return this.findScopeOrReturnSomething(scopeDescriptors, "all");
    }

    private final SearchScope findScopeOrReturnSomething(List<? extends ScopeDescriptor> scopeDescriptors, String scopeId) {
        ScopeDescriptor found;
        ScopeDescriptor scopeDescriptor;
        ScopeDescriptor scopeDescriptor2 = Companion.findScopeById(scopeDescriptors, scopeId);
        if (scopeDescriptor2 == null) {
            scopeDescriptor2 = (ScopeDescriptor)CollectionsKt.firstOrNull(scopeDescriptors);
        }
        if ((scopeDescriptor = (found = scopeDescriptor2)) == null || (scopeDescriptor = scopeDescriptor.getScope()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            scopeDescriptor = (SearchScope)globalSearchScope;
        }
        return scopeDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ScopeDescriptor> createScopes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = super.createScopes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScopeDescriptor it = (ScopeDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!it.scopeEquals(null) && it.getScope() instanceof DbDataSourceScope)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        if (selected instanceof DbElement) {
            NavigationItem navigationItem = DbNavigationUtils.createFromTreeNavigatable((DbElement)selected);
            Intrinsics.checkNotNullExpressionValue((Object)navigationItem, (String)"createFromTreeNavigatable(...)");
            return super.processSelectedItem((Object)navigationItem, modifiers, searchText);
        }
        return super.processSelectedItem(selected, modifiers, searchText);
    }

    private static final Dbms getActions$lambda$0(DbDataSource it) {
        return it.getDbms();
    }

    private static final Dbms getActions$lambda$1(Function1 $tmp0, Object p0) {
        return (Dbms)$tmp0.invoke(p0);
    }

    private static final String getActions$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Icon getActions$lambda$4(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    private static final String getActions$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Icon getActions$lambda$6(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    private static final boolean getActions$lambda$7(AnAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof SearchEverywhereFiltersAction;
    }

    private static final boolean getActions$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean createModel$lambda$0(boolean $isDbTab, FilterStateService.SetState $dbmses, DasObject it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($isDbTab) {
            Dbms dbms = DbImplUtilCore.getDbms((DasObject)it);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            bl = $dbmses.isVisible(dbms);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean createModel$lambda$1(boolean $isDbTab, FilterStateService.SetState $categories, DasObject it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($isDbTab) {
            ObjectKind objectKind = it.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            bl = $categories.isVisible(DbObjectCategory.Companion.detect(objectKind));
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final String getTabId() {
        return Companion.getTabId();
    }

    @JvmStatic
    public static final boolean hasDatabaseTab(@NotNull Project project) {
        return Companion.hasDatabaseTab(project);
    }

    static {
        Logger logger = Logger.getInstance(DbObjectsSEContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0011J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$Companion;", "", "<init>", "()V", "tabId", "", "getTabId$annotations", "getTabId", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "hasDatabaseTab", "", "project", "Lcom/intellij/openapi/project/Project;", "findScopeById", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "scopeDescriptors", "", "scopeId", "hasScopeId", "scope", "getScopeId", "isDbTabVisible", "findCategory", "Lkotlin/Pair;", "Lcom/intellij/database/util/DbObjectCategory;", "pattern", "isCommandEnd", "start", "", "skipWhitespaces", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1#2:369\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTabId() {
            String string = DbObjectsSEContributor.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getTabId$annotations() {
        }

        @JvmStatic
        public final boolean hasDatabaseTab(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PlatformUtils.isDataGrip() || PlatformUtils.isDataSpell() || AdvancedSettings.Companion.getBoolean("database.show.search.tab") && !DbPsiFacade.getInstance((Project)project).getDataSources().isEmpty();
        }

        @Nullable
        public final ScopeDescriptor findScopeById(@NotNull List<? extends ScopeDescriptor> scopeDescriptors, @NotNull String scopeId) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(scopeDescriptors, (String)"scopeDescriptors");
                Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
                Iterable iterable = scopeDescriptors;
                for (Object t : iterable) {
                    ScopeDescriptor it = (ScopeDescriptor)t;
                    boolean bl = false;
                    if (!Companion.hasScopeId(it, scopeId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean hasScopeId(@NotNull ScopeDescriptor scope2, @NotNull String scopeId) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
            return Intrinsics.areEqual((Object)this.getScopeId(scope2), (Object)scopeId);
        }

        @Nullable
        public final String getScopeId(@NotNull ScopeDescriptor scope2) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            SearchScope searchScope = scope2.getScope();
            DbDataSourceScope dbDataSourceScope = searchScope instanceof DbDataSourceScope ? (DbDataSourceScope)searchScope : null;
            return dbDataSourceScope != null ? dbDataSourceScope.getScopeId() : null;
        }

        private final boolean isDbTabVisible(Project project) {
            SearchEverywhereManager searchEverywhereManager;
            try {
                searchEverywhereManager = SearchEverywhereManager.getInstance((Project)project);
            }
            catch (IllegalStateException e) {
                LOG.info("Couldn't initialize SearchEverywhereManager from a backend contributor: " + e.getMessage());
                return true;
            }
            SearchEverywhereManager manager = searchEverywhereManager;
            return !manager.isShown() || Intrinsics.areEqual((Object)this.getTabId(), (Object)manager.getSelectedTabID());
        }

        private final Pair<DbObjectCategory, String> findCategory(String pattern) {
            String accelerator = SearchTopHitProvider.Companion.getTopHitAccelerator();
            if (!StringsKt.startsWith$default((String)pattern, (String)accelerator, (boolean)false, (int)2, null)) {
                return null;
            }
            int start = accelerator.length();
            if (StringUtil.startsWith((CharSequence)pattern, (int)start, (CharSequence)"db")) {
                if (this.isCommandEnd(pattern, start += 2)) {
                    start = this.skipWhitespaces(pattern, start);
                    String string = pattern.substring(start);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return new Pair(null, (Object)string);
                }
                if (pattern.charAt(start) != '.') {
                    return null;
                }
                ++start;
            }
            for (DbObjectCategory cat : DbObjectCategory.getEntries()) {
                if (!StringUtil.startsWith((CharSequence)pattern, (int)start, (CharSequence)cat.getId())) continue;
                start = this.skipWhitespaces(pattern, start + cat.getId().length());
                String string = pattern.substring(start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return new Pair((Object)cat, (Object)string);
            }
            return null;
        }

        private final boolean isCommandEnd(String pattern, int start) {
            return pattern.length() <= start || Character.isWhitespace(pattern.charAt(start));
        }

        private final int skipWhitespaces(String pattern, int start) {
            int idx;
            for (idx = start; idx < pattern.length() && Character.isWhitespace(pattern.charAt(idx)); ++idx) {
            }
            return idx;
        }

        public static final /* synthetic */ Pair access$findCategory(Companion $this, String pattern) {
            return $this.findCategory(pattern);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B4\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction;", "T", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFiltersAction;", "filter", "Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;", "onChanged", "Ljava/lang/Runnable;", "myIcon", "Lcom/intellij/ui/BadgeIconSupplier;", "myDescription", "", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "<init>", "(Lcom/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter;Ljava/lang/Runnable;Lcom/intellij/ui/BadgeIconSupplier;Ljava/lang/String;)V", "myOther", "", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getMyOther", "()Ljava/util/List;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbObjectsSEContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1869#2,2:369\n*S KotlinDebug\n*F\n+ 1 DbObjectsSEContributor.kt\ncom/intellij/database/actions/DbObjectsSEContributor$CustomFiltersAction\n*L\n289#1:369,2\n*E\n"})
    private static final class CustomFiltersAction<T>
    extends SearchEverywhereFiltersAction<T> {
        @Nullable
        private final BadgeIconSupplier myIcon;
        @NotNull
        private final String myDescription;
        @NotNull
        private final List<ToggleAction> myOther;

        public CustomFiltersAction(@NotNull PersistentSearchEverywhereContributorFilter<T> filter, @NotNull Runnable onChanged2, @Nullable BadgeIconSupplier myIcon, @NotNull String myDescription) {
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)onChanged2, (String)"onChanged");
            Intrinsics.checkNotNullParameter((Object)myDescription, (String)"myDescription");
            super(filter, onChanged2);
            this.myIcon = myIcon;
            this.myDescription = myDescription;
            this.myOther = new ArrayList();
        }

        @NotNull
        public final List<ToggleAction> getMyOther() {
            return this.myOther;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            if (this.myIcon != null) {
                e.getPresentation().setIcon(this.myIcon.getLiveIndicatorIcon(this.isActive()));
            }
            e.getPresentation().setDescription(this.myDescription);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.setSelected(e, state);
            if (state) {
                Iterable $this$forEach$iv = this.myOther;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ToggleAction it = (ToggleAction)element$iv;
                    boolean bl = false;
                    it.setSelected(e, false);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$Factory;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributorFactory;", "", "<init>", "()V", "createContributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "initEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            Intrinsics.checkNotNullParameter((Object)initEvent, (String)"initEvent");
            WeightedSearchEverywhereContributor weightedSearchEverywhereContributor = PSIPresentationBgRendererWrapper.wrapIfNecessary((AbstractGotoSEContributor)new DbObjectsSEContributor(initEvent));
            Intrinsics.checkNotNullExpressionValue((Object)weightedSearchEverywhereContributor, (String)"wrapIfNecessary(...)");
            return (SearchEverywhereContributor)weightedSearchEverywhereContributor;
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService;", "", "<init>", "()V", "myDbmsState", "Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "Lcom/intellij/database/Dbms;", "getMyDbmsState", "()Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "myCategoryState", "Lcom/intellij/database/util/DbObjectCategory;", "getMyCategoryState", "SetState", "intellij.database.impl"})
    private static final class FilterStateService {
        @NotNull
        private final SetState<Dbms> myDbmsState = new SetState();
        @NotNull
        private final SetState<DbObjectCategory> myCategoryState = new SetState();

        public FilterStateService() {
            this.myCategoryState.setVisible(DbObjectCategory.COLUMNS, false);
            this.myCategoryState.setVisible(DbObjectCategory.SERVERS, false);
            this.myCategoryState.setVisible(DbObjectCategory.ROLES, false);
            this.myCategoryState.setVisible(DbObjectCategory.CONSTRAINTS, false);
            this.myCategoryState.setVisible(DbObjectCategory.INDICES, false);
            this.myCategoryState.setVisible(DbObjectCategory.OTHER, false);
        }

        @NotNull
        public final SetState<Dbms> getMyDbmsState() {
            return this.myDbmsState;
        }

        @NotNull
        public final SetState<DbObjectCategory> getMyCategoryState() {
            return this.myCategoryState;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$FilterStateService$SetState;", "T", "Lcom/intellij/ide/util/TypeVisibilityStateHolder;", "<init>", "()V", "myHiddenItems", "", "setVisible", "", "type", "value", "", "(Ljava/lang/Object;Z)V", "isVisible", "(Ljava/lang/Object;)Z", "copy", "intellij.database.impl"})
        public static final class SetState<T>
        implements TypeVisibilityStateHolder<T> {
            @NotNull
            private final Set<T> myHiddenItems;

            public SetState() {
                Set set = Collections.synchronizedSet(new HashSet());
                Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
                this.myHiddenItems = set;
            }

            public void setVisible(T type, boolean value) {
                boolean bl = value ? this.myHiddenItems.remove(type) : this.myHiddenItems.add(type);
            }

            public boolean isVisible(T type) {
                return !this.myHiddenItems.contains(type);
            }

            @NotNull
            public final SetState<T> copy() {
                SetState<T> res2 = new SetState<T>();
                res2.myHiddenItems.addAll((Collection)this.myHiddenItems);
                return res2;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$MyContributor;", "Lcom/intellij/database/psi/DbObjectsGoToContributor;", "myDbmsFilter", "Lkotlin/Function1;", "Lcom/intellij/database/model/DasObject;", "", "myCatFilter", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getMyCatFilter", "()Lkotlin/jvm/functions/Function1;", "setMyCatFilter", "(Lkotlin/jvm/functions/Function1;)V", "filterObjects", "Lcom/intellij/util/containers/JBIterable;", "objects", "", "getNavigationItem", "Lcom/intellij/navigation/NavigationItem;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "o", "intellij.database.impl"})
    private static final class MyContributor
    extends DbObjectsGoToContributor {
        @NotNull
        private final Function1<DasObject, Boolean> myDbmsFilter;
        @NotNull
        private Function1<? super DasObject, Boolean> myCatFilter;

        public MyContributor(@NotNull Function1<? super DasObject, Boolean> myDbmsFilter, @NotNull Function1<? super DasObject, Boolean> myCatFilter) {
            Intrinsics.checkNotNullParameter(myDbmsFilter, (String)"myDbmsFilter");
            Intrinsics.checkNotNullParameter(myCatFilter, (String)"myCatFilter");
            this.myDbmsFilter = myDbmsFilter;
            this.myCatFilter = myCatFilter;
        }

        @NotNull
        public final Function1<DasObject, Boolean> getMyCatFilter() {
            return this.myCatFilter;
        }

        public final void setMyCatFilter(@NotNull Function1<? super DasObject, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.myCatFilter = function1;
        }

        @NotNull
        public JBIterable<DasObject> filterObjects(@NotNull Iterable<? extends DasObject> objects) {
            Intrinsics.checkNotNullParameter(objects, (String)"objects");
            JBIterable jBIterable = super.filterObjects(objects).filter(arg_0 -> MyContributor.filterObjects$lambda$0((Function1)new Function1<DasObject, Boolean>(this.myCatFilter){

                public final Boolean invoke(DasObject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (Boolean)((Function1)this.receiver).invoke((Object)p0);
                }
            }, arg_0)).filter(arg_0 -> MyContributor.filterObjects$lambda$1((Function1)new Function1<DasObject, Boolean>(this.myDbmsFilter){

                public final Boolean invoke(DasObject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (Boolean)((Function1)this.receiver).invoke((Object)p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        @Override
        @Nullable
        protected NavigationItem getNavigationItem(@Nullable DbDataSource dataSource, @Nullable DasObject o) {
            return super.getNavigationItem(dataSource, o);
        }

        private static final boolean filterObjects$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean filterObjects$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0019\u0010!\u001a\u00130\u000e\u00a2\u0006\u000e\b\"\u0012\n\b#\u0012\u0006\b\n0$8%H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010)\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\bH\u0016J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\bH\u0016RA\u0010\f\u001a(\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0014\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/actions/DbObjectsSEContributor$MyGotoModel;", "Lcom/intellij/ide/util/gotoByName/DisposableGotoModelWithPersistentFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbmsFilter", "Lkotlin/Function1;", "Lcom/intellij/database/model/DasObject;", "", "catFilter", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "mySeparators", "", "", "kotlin.jvm.PlatformType", "getMySeparators", "()[Ljava/lang/String;", "mySeparators$delegate", "Lkotlin/Lazy;", "myContributor", "Lcom/intellij/database/actions/DbObjectsSEContributor$MyContributor;", "filterValueFor", "item", "Lcom/intellij/navigation/NavigationItem;", "(Lcom/intellij/navigation/NavigationItem;)Lkotlin/Unit;", "getContributorList", "", "Lcom/intellij/navigation/ChooseByNameContributor;", "getItemProvider", "Lcom/intellij/ide/util/gotoByName/ChooseByNameItemProvider;", "context", "Lcom/intellij/psi/PsiElement;", "getPromptText", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getNotInMessage", "getNotFoundMessage", "getCheckBoxName", "loadInitialCheckBoxState", "saveInitialCheckBoxState", "state", "getSeparators", "getFullName", "element", "", "willOpenEditor", "intellij.database.impl"})
    private static final class MyGotoModel
    extends DisposableGotoModelWithPersistentFilter<Unit> {
        @NotNull
        private final Lazy mySeparators$delegate;
        @NotNull
        private final MyContributor myContributor;

        public MyGotoModel(@NotNull Project project, @NotNull Function1<? super DasObject, Boolean> dbmsFilter2, @NotNull Function1<? super DasObject, Boolean> catFilter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(dbmsFilter2, (String)"dbmsFilter");
            Intrinsics.checkNotNullParameter(catFilter2, (String)"catFilter");
            super(project, CollectionsKt.emptyList());
            this.mySeparators$delegate = LazyKt.lazy(() -> MyGotoModel.mySeparators_delegate$lambda$0(this));
            this.myContributor = new MyContributor(dbmsFilter2, catFilter2);
        }

        private final String[] getMySeparators() {
            Lazy lazy = this.mySeparators$delegate;
            return (String[])lazy.getValue();
        }

        @Nullable
        protected Unit filterValueFor(@NotNull NavigationItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return null;
        }

        @NotNull
        protected List<ChooseByNameContributor> getContributorList() {
            return CollectionsKt.listOf((Object)this.myContributor);
        }

        @NotNull
        public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context) {
            return (ChooseByNameItemProvider)new DefaultChooseByNameItemProvider(context, this){
                final /* synthetic */ MyGotoModel this$0;
                {
                    this.this$0 = $receiver;
                    super($context);
                }

                public boolean filterElementsWithWeights(ChooseByNameViewModel base, FindSymbolParameters parameters, ProgressIndicator indicator, Processor<? super FoundItemDescriptor<?>> consumer) {
                    FindSymbolParameters findSymbolParameters;
                    Intrinsics.checkNotNullParameter((Object)base, (String)"base");
                    Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                    String string = parameters.getCompletePattern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCompletePattern(...)");
                    Pair category = com.intellij.database.actions.DbObjectsSEContributor$Companion.access$findCategory(DbObjectsSEContributor.Companion, string);
                    if (category != null) {
                        MyGotoModel.access$getMyContributor$p(this.this$0).setMyCatFilter((Function1<? super DasObject, Boolean>)((Function1)arg_0 -> getItemProvider.1.filterElementsWithWeights$lambda$0(category, arg_0)));
                        findSymbolParameters = parameters.withCompletePattern((String)category.getSecond());
                    } else {
                        findSymbolParameters = parameters;
                    }
                    FindSymbolParameters newParameters = findSymbolParameters;
                    return super.filterElementsWithWeights(base, newParameters, indicator, consumer);
                }

                private static final boolean filterElementsWithWeights$lambda$0(Pair $category, DasObject it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DbObjectCategory dbObjectCategory = (DbObjectCategory)((Object)$category.getFirst());
                    if (dbObjectCategory != null) {
                        ObjectKind objectKind = it.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                        bl = dbObjectCategory.contains(objectKind);
                    } else {
                        bl = true;
                    }
                    return bl;
                }
            };
        }

        @NotNull
        public String getPromptText() {
            Object[] objectArray = new Object[]{StringUtil.toLowerCase((String)this.myContributor.getElementKind())};
            String string = IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getNotInMessage() {
            String string = IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
            return string;
        }

        @NotNull
        public String getNotFoundMessage() {
            String string = IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
            return string;
        }

        @Nullable
        public String getCheckBoxName() {
            return null;
        }

        public boolean loadInitialCheckBoxState() {
            return false;
        }

        public void saveInitialCheckBoxState(boolean state) {
        }

        @NotNull
        public String[] getSeparators() {
            String[] stringArray = this.getMySeparators();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"<get-mySeparators>(...)");
            return stringArray;
        }

        @Nullable
        public String getFullName(@NotNull Object element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.myContributor.getQualifiedName((NavigationItem)element);
        }

        public boolean willOpenEditor() {
            return true;
        }

        private static final String[] mySeparators_delegate$lambda$0(MyGotoModel this$0) {
            return GotoClassModel2.getSeparatorsFromContributors((ChooseByNameContributor[])this$0.getContributors());
        }

        public static final /* synthetic */ MyContributor access$getMyContributor$p(MyGotoModel $this) {
            return $this.myContributor;
        }
    }
}

