/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseStringUsageTarget;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateSpec;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchDbElementUsage;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.FullTextSearchOptionsStorage;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbeTierUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getSearchableTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/psi/DbElement;", "elements", "getSelectedElements", "Companion", "TableGrouper", "SearchGroup", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class FullTextSearchAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JBIterable<DbElement> targets = this.getSearchableTargets(this.getSelectedElements(e));
        e.getPresentation().setEnabledAndVisible(targets.isNotEmpty());
        DbeTierUtil.adjustPaidTier((AnActionEvent)e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JBIterable<DbElement> selectedTargets = this.getSearchableTargets(this.getSelectedElements(e));
        List list = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)selectedTargets)).expandAndSkip(Conditions.or((Condition)DasUtil.byClass(DasNamespace.class), (Condition)DasUtil.byClass(DasDataSource.class)))).filter(DbTable.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List targets = list;
        if (targets.isEmpty()) {
            return;
        }
        FullTextSearchOptions options = new FullTextSearchOptions(FullTextSearchOptionsStorage.getText(), FullTextSearchOptionsStorage.getMatchCase(), FullTextSearchOptionsStorage.getSearchTarget(), FullTextSearchOptionsStorage.getLocation(), FullTextSearchOptionsStorage.getMaxNumOfFetchedRows());
        new DatabaseStringUsageTarget(project2, FullTextSearchAction.Companion.createFindModel(project2, ""), options, targets).showSettings();
    }

    private final JBIterable<DbElement> getSearchableTargets(JBIterable<DbElement> elements) {
        JBIterable jBIterable = elements.filter(arg_0 -> FullTextSearchAction.getSearchableTargets$lambda$1(FullTextSearchAction::getSearchableTargets$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<DbElement> getSelectedElements(AnActionEvent e) {
        block2: {
            DbElement dbElement;
            block4: {
                block3: {
                    DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
                    if (grid == null) break block2;
                    DasTable table = DataGridUtil.getDatabaseTable(grid);
                    DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)((CoreGrid)grid));
                    dbElement = DbImplUtil.findElement((DbDataSource)dataSource, (DasObject)((DasObject)table));
                    if (dbElement == null) break block3;
                    DbElement it = dbElement;
                    boolean bl = false;
                    JBIterable jBIterable = JBIterable.of((Object)it);
                    dbElement = jBIterable;
                    if (jBIterable != null) break block4;
                }
                JBIterable jBIterable = JBIterable.empty();
                dbElement = jBIterable;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            }
            return dbElement;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
    }

    private static final boolean getSearchableTargets$lambda$0(DbElement it) {
        if (!(it instanceof DbDataSource || it instanceof DbNamespaceImpl || it instanceof DbTable)) {
            return false;
        }
        LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)FullTextSearchAction.Companion.getDbDataSource(it)));
        return dataSource != null;
    }

    private static final boolean getSearchableTargets$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J&\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J^\u0010$\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u000e\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002JA\u00102\u001a\u0014\u0012\u0004\u0012\u000204\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f032\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b9J\u0018\u0010:\u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010;\u001a\u00020!H\u0003J\n\u0010<\u001a\u00020=*\u00020>J\u0014\u0010?\u001a\u0004\u0018\u00010\u000b2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002\u00a8\u0006B"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$Companion;", "", "<init>", "()V", "searchStatement", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "insertNewLines", "", "search", "project", "Lcom/intellij/openapi/project/Project;", "targets", "", "Lcom/intellij/database/psi/DbTable;", "listener", "Lcom/intellij/usages/UsageViewManager$UsageViewStateListener;", "setupViewPresentation", "Lcom/intellij/usages/UsageViewPresentation;", "findModel", "Lcom/intellij/find/FindModel;", "createFindModel", "text", "", "createSearcher", "Lcom/intellij/usages/UsageSearcher;", "checkTables", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/usages/Usage;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tables", "tablesCount", "", "currentTablesCount", "getPredicates", "", "Lcom/intellij/database/data/types/ColumnRef;", "dbms", "Lcom/intellij/database/Dbms;", "version", "Lcom/intellij/database/util/Version;", "getPredicates$intellij_database_impl", "qualifyTable", "dataSourceName", "toDecorator", "Lcom/intellij/database/util/DbImplUtilCore$StringLiteralDecorator;", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions$Location;", "getDbDataSource", "target", "Lcom/intellij/database/psi/DbElement;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n1321#2,2:351\n1803#3,3:353\n*S KotlinDebug\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$Companion\n*L\n199#1:351,2\n153#1:353,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void searchStatement(@NotNull DdlBuilder builder, @NotNull BasicTableOrView table, @NotNull DbDataSource dbDataSource, @NotNull FullTextSearchOptions options, @NotNull List<PredicatesHelper.PredicateProducer> predicates, boolean insertNewLines) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
            DmlHelper ddlGenerator = (DmlHelper)DmlHelper.Companion.getEP().forDbms(dbDataSource.getDbms());
            SelectTask task = DmlTaskKt.allColumns((DasObject)((DasObject)table)).version(dbDataSource.getVersion()).limit(options.getMaxNumOfFetchedRows()).insertNewLines(insertNewLines).whereClause((WhereClause)new PredicatesWhereClause(predicates, "OR", null, 4, null)).build(builder);
            ddlGenerator.generate((DmlTask)task);
        }

        public final void search(@NotNull Project project, @NotNull FullTextSearchOptions options, @NotNull Collection<? extends DbTable> targets, @Nullable UsageViewManager.UsageViewStateListener listener2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            if (usageViewManager == null) {
                return;
            }
            UsageViewManager manager = usageViewManager;
            String string = options.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            FindModel findModel = this.createFindModel(project, string);
            DatabaseStringUsageTarget usageTarget = new DatabaseStringUsageTarget(project, findModel, options, targets);
            UsageViewPresentation presentation = this.setupViewPresentation(findModel);
            FindUsagesProcessPresentation findUsagesProcessPresentation = FindInProjectUtil.setupProcessPresentation((UsageViewPresentation)presentation);
            Intrinsics.checkNotNullExpressionValue((Object)findUsagesProcessPresentation, (String)"setupProcessPresentation(...)");
            FindUsagesProcessPresentation processPresentation = findUsagesProcessPresentation;
            UsageTarget[] usageTargetArray = new UsageTarget[]{usageTarget};
            manager.searchAndShowUsages(usageTargetArray, () -> Companion.search$lambda$0(project, options, targets), processPresentation, presentation, listener2);
        }

        private final UsageViewPresentation setupViewPresentation(FindModel findModel) {
            UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation((FindModel)findModel);
            Intrinsics.checkNotNullExpressionValue((Object)usageViewPresentation, (String)"setupViewPresentation(...)");
            UsageViewPresentation presentation = usageViewPresentation;
            presentation.setUsageTypeFilteringAvailable(false);
            return presentation;
        }

        private final FindModel createFindModel(Project project, String text) {
            FindModel findModel = new FindModel();
            findModel.setStringToFind(text);
            findModel.setCustomScope((SearchScope)GlobalSearchScope.everythingScope((Project)project));
            findModel.setCustomScope(true);
            return findModel;
        }

        private final UsageSearcher createSearcher(Project project, FullTextSearchOptions options, Collection<? extends DbTable> targets) {
            return arg_0 -> Companion.createSearcher$lambda$0(targets, project, options, arg_0);
        }

        private final void checkTables(Project project, DatabaseConnection connection, Processor<? super Usage> processor, LocalDataSource dataSource, FullTextSearchOptions options, ProgressIndicator indicator, Collection<? extends BasicTableOrView> tables, int tablesCount, int currentTablesCount) {
            DbDataSource dbDataSource = DbImplUtil.getDbDataSource((Project)project, (DasDataSource)((DasDataSource)dataSource));
            if (dbDataSource == null) {
                return;
            }
            DbDataSource dbDataSource2 = dbDataSource;
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((Dbms)dataSource.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
            DatabaseDialectEx dialect = databaseDialectEx;
            BasicTableOrView currentTable = null;
            int i = 0;
            Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> $this$forEach$iv = FtsUtilKt.chooseElementsIterator(tables, dbDataSource2, options);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DdlBuilder builder;
                Triple triple = (Triple)element$iv;
                boolean bl = false;
                List predicates = (List)triple.component1();
                BasicTableOrView table = (BasicTableOrView)triple.component2();
                DbElement element = (DbElement)triple.component3();
                indicator.checkCanceled();
                String string = dataSource.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                indicator.setText(Companion.qualifyTable(table, string));
                if (!Intrinsics.areEqual((Object)table, currentTable)) {
                    currentTable = table;
                    indicator.setFraction((double)(++i + currentTablesCount) / (double)tablesCount);
                }
                if (predicates.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)new DdlBuilder().withDialect(dialect).qualifyReferences(true), (String)"qualifyReferences(...)");
                Companion.searchStatement(builder, table, dbDataSource2, options, predicates, false);
                SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM));
                String string2 = builder.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
                int count = ((Number)simpleSmartStatement.execute((Object)string2, StandardResultsProcessors.linesCount((int)options.getMaxNumOfFetchedRows())).rightOr((Object)0)).intValue();
                if (count <= 0) continue;
                FullTextSearchDbElementUsage elementUsage = (FullTextSearchDbElementUsage)ReadAction.compute(() -> Companion.checkTables$lambda$0$0(element, count, options, predicates));
                processor.process((Object)elementUsage);
            }
        }

        @NotNull
        public final Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> getPredicates$intellij_database_impl(@NotNull Dbms dbms, @Nullable Version version, @NotNull BasicTableOrView table, @NotNull FullTextSearchOptions options) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object[] objectArray = new PredicateOperation[3];
            objectArray[0] = new EqualsPredicateOperation(null, 1, null);
            objectArray[1] = ContainsInIndexedTextOperation.INSTANCE;
            LikeOpType likeOpType = options.getLocation().getLikeOpType();
            Intrinsics.checkNotNullExpressionValue((Object)likeOpType, (String)"getLikeOpType(...)");
            objectArray[2] = new LikePredicateOperation(likeOpType, options.isMatchCase(), false, 4, null);
            Set operations = SetsKt.setOf((Object[])objectArray);
            List list = DasUtil.getColumns((DasObject)((DasObject)table)).map(arg_0 -> Companion.getPredicates$lambda$1(arg_0 -> Companion.getPredicates$lambda$0(options, operations, arg_0), arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List specs = list;
            PredicatesHelper predicatesHelper = PredicatesHelperKt.predicatesHelper((Dbms)dbms);
            List<OperandType> list2 = options.getSearchScope().getTypes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypes(...)");
            return predicatesHelper.getPredicateProducers(specs, list2, null, version, false);
        }

        @NlsSafe
        private final String qualifyTable(BasicTableOrView table, String dataSourceName) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (BasicIntrospectableArea par = (BasicIntrospectableArea)table.getParent(); par != null; par = par.getParent()) {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)par.getName(), (String)"getName(...)");
                if (!(!StringsKt.isBlank((CharSequence)name))) continue;
                if (first) {
                    first = false;
                } else {
                    b.insert(0, ".");
                }
                b.insert(0, name);
            }
            if (!first) {
                b.insert(0, ".");
            }
            b.insert(0, dataSourceName);
            return table.getName() + " (" + b + ")";
        }

        @NotNull
        public final DbImplUtilCore.StringLiteralDecorator toDecorator(@NotNull FullTextSearchOptions.Location $this$toDecorator) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toDecorator), (String)"<this>");
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$toDecorator.ordinal()]) {
                case 1 -> DbImplUtilCore.StringLiteralDecorator.CONTAINS;
                case 2 -> DbImplUtilCore.StringLiteralDecorator.STARTS_WITH;
                case 3 -> DbImplUtilCore.StringLiteralDecorator.ENDS_WITH;
                case 4 -> DbImplUtilCore.StringLiteralDecorator.PLAIN;
                case 5 -> DbImplUtilCore.StringLiteralDecorator.MATCHES;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final DbDataSource getDbDataSource(DbElement target) {
            DbDataSource dbDataSource;
            if (target == null || target instanceof DbDataSource) {
                DbElement dbElement = target;
                Intrinsics.checkNotNull((Object)dbElement, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbDataSource");
                dbDataSource = (DbDataSource)dbElement;
            } else {
                dbDataSource = this.getDbDataSource(target.getParent());
            }
            return dbDataSource;
        }

        private static final UsageSearcher search$lambda$0(Project $project, FullTextSearchOptions $options, Collection $targets) {
            return Companion.createSearcher($project, $options, $targets);
        }

        private static final void createSearcher$lambda$0(Collection $targets, Project $project, FullTextSearchOptions $options, Processor processor) {
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            AsyncUtil.withAsyncFriendly((ProgressIndicator)indicator, () -> Companion.createSearcher$lambda$0$0($targets, indicator, $project, processor, $options));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit createSearcher$lambda$0$0(Collection $targets, ProgressIndicator $indicator, Project $project, Processor $processor, FullTextSearchOptions $options) {
            void $this$fold$iv;
            List<SearchGroup> groups = new TableGrouper($targets).getGroups();
            Iterable iterable = groups;
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void g;
                SearchGroup searchGroup = (SearchGroup)element$iv;
                int tablesCount = accumulator$iv;
                boolean bl = false;
                accumulator$iv = tablesCount + g.getTables().size();
            }
            int tablesCount = accumulator$iv;
            $indicator.setFraction(0.0);
            $indicator.setIndeterminate(false);
            Ref.IntRef currentTablesCount = new Ref.IntRef();
            for (SearchGroup searchGroup : groups) {
                Set<BasicTableOrView> tables = searchGroup.component1();
                LocalDataSource dataSource = searchGroup.component2();
                SearchPath searchPath = searchGroup.component3();
                try {
                    DatabaseSessionManager.getFacade((Project)$project, (DatabaseConnectionPoint)((DatabaseConnectionPoint)dataSource), null, (SearchPath)searchPath, (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEXT_SEARCH)).runSync(arg_0 -> Companion.createSearcher$lambda$0$0$1($indicator, $project, $processor, dataSource, $options, tables, tablesCount, currentTablesCount, arg_0));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                currentTablesCount.element += tables.size();
            }
            return Unit.INSTANCE;
        }

        private static final Unit createSearcher$lambda$0$0$1(ProgressIndicator $indicator, Project $project, Processor $processor, LocalDataSource $dataSource, FullTextSearchOptions $options, Set $tables, int $tablesCount, Ref.IntRef $currentTablesCount, InterruptibleDatabaseConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNull((Object)$indicator);
            InterruptibleDatabaseConnectionKt.withCancelling((InterruptibleDatabaseConnection)connection, (ProgressIndicator)$indicator, () -> Companion.createSearcher$lambda$0$0$1$0($project, connection, $processor, $dataSource, $options, $indicator, $tables, $tablesCount, $currentTablesCount));
            return Unit.INSTANCE;
        }

        private static final Unit createSearcher$lambda$0$0$1$0(Project $project, InterruptibleDatabaseConnection $connection, Processor $processor, LocalDataSource $dataSource, FullTextSearchOptions $options, ProgressIndicator $indicator, Set $tables, int $tablesCount, Ref.IntRef $currentTablesCount) {
            DatabaseConnection databaseConnection = (DatabaseConnection)$connection;
            Intrinsics.checkNotNull((Object)$processor);
            Intrinsics.checkNotNull((Object)$indicator);
            Companion.checkTables($project, databaseConnection, (Processor<? super Usage>)$processor, $dataSource, $options, $indicator, $tables, $tablesCount, $currentTablesCount.element);
            return Unit.INSTANCE;
        }

        private static final FullTextSearchDbElementUsage checkTables$lambda$0$0(DbElement $element, int $count, FullTextSearchOptions $options, List $predicates) {
            return FullTextSearchDbElementUsage.Companion.create($element, $count, $options.getMaxNumOfFetchedRows(), $predicates);
        }

        private static final PredicateSpec getPredicates$lambda$0(FullTextSearchOptions $options, Set $operations, DasColumn it) {
            Intrinsics.checkNotNull((Object)it);
            ColumnRef columnRef = (ColumnRef)new DasColumnRef(it);
            String string = $options.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new PredicateSpec(columnRef, (PredicateValue)new StringPredicateValue(string, false, 2, null), $operations);
        }

        private static final PredicateSpec getPredicates$lambda$1(Function1 $tmp0, Object p0) {
            return (PredicateSpec)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FullTextSearchOptions.Location.values().length];
                try {
                    nArray[FullTextSearchOptions.Location.CONTAINS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.STARTS_WITH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.ENDS_WITH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.LIKE_PATTERN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.MATCHES.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002J\t\u0010\u0012\u001a\u00020\u0006H\u0086\u0002J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "", "tables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Ljava/util/Set;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "getTables", "()Ljava/util/Set;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "component1", "component2", "component3", "intellij.database.impl"})
    public static final class SearchGroup {
        @NotNull
        private final Set<BasicTableOrView> tables;
        @NotNull
        private final LocalDataSource dataSource;
        @Nullable
        private final SearchPath searchPath;

        public SearchGroup(@NotNull Set<? extends BasicTableOrView> tables, @NotNull LocalDataSource dataSource, @Nullable SearchPath searchPath) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            this.tables = tables;
            this.dataSource = dataSource;
            this.searchPath = searchPath;
        }

        @NotNull
        public final Set<BasicTableOrView> getTables() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath getSearchPath() {
            return this.searchPath;
        }

        @NotNull
        public final Set<BasicTableOrView> component1() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource component2() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath component3() {
            return this.searchPath;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001a0\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$TableGrouper;", "", "myTargets", "", "Lcom/intellij/database/psi/DbTable;", "<init>", "(Ljava/util/Collection;)V", "getGroups", "", "Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "getAllTables", "Lcom/intellij/database/model/basic/BasicTableOrView;", "schemas", "", "Lcom/intellij/database/model/basic/BasicSchema;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "getAllSchemas", "namespace", "Lcom/intellij/database/psi/DbNamespaceImpl;", "getSchema", "getTable", "table", "groupedTables", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "mustReconnect", "", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$TableGrouper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,350:1\n382#2,7:351\n382#2,7:367\n1460#3,5:358\n1491#3:363\n1516#3,3:364\n1519#3,3:374\n153#4,3:377\n*S KotlinDebug\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$TableGrouper\n*L\n280#1:351,7\n325#1:367,7\n288#1:358,5\n325#1:363\n325#1:364,3\n325#1:374,3\n328#1:377,3\n*E\n"})
    public static final class TableGrouper {
        @NotNull
        private final Collection<DbTable> myTargets;

        public TableGrouper(@NotNull Collection<? extends DbTable> myTargets) {
            Intrinsics.checkNotNullParameter(myTargets, (String)"myTargets");
            this.myTargets = myTargets;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SearchGroup> getGroups() {
            Map groupedTables = new LinkedHashMap();
            for (DbTable target : this.myTargets) {
                BasicTableOrView table;
                Object object;
                void $this$getOrPut$iv;
                LocalDataSource dataSource;
                DbDataSource dbDataSource;
                if (this.getTable(target) == null || Companion.getDbDataSource((DbElement)target) == null || DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbDataSource)) == null) continue;
                Map map2 = groupedTables;
                LocalDataSource key$iv = dataSource;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(table);
            }
            return this.getGroups(groupedTables);
        }

        /*
         * WARNING - void declaration
         */
        private final List<BasicTableOrView> getAllTables(Iterable<? extends BasicSchema> schemas, DbDataSource dbDataSource) {
            List elements = new ArrayList();
            for (ObjectKind tableKind : ModelConsts.TABLE_OR_VIEW_KINDS) {
                void $this$flatMapTo$iv;
                Iterable<? extends BasicSchema> iterable = schemas;
                Collection destination$iv = elements;
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    BasicSchema s = (BasicSchema)element$iv;
                    boolean bl = false;
                    JBIterable jBIterable = s.getDasChildren(tableKind).filter(BasicTableOrView.class).filter(arg_0 -> TableGrouper.getAllTables$lambda$0$1(arg_0 -> TableGrouper.getAllTables$lambda$0$0(dbDataSource, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    Iterable list$iv = (Iterable)jBIterable;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
            }
            return elements;
        }

        private final Collection<BasicSchema> getAllSchemas(DbNamespaceImpl namespace, DbDataSource dbDataSource) {
            BasicSchema schema = this.getSchema(namespace);
            if (schema != null) {
                return CollectionsKt.listOf((Object)schema);
            }
            JBIterable jBIterable = namespace.getDasChildren(ObjectKind.SCHEMA);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getDasChildren(...)");
            JBIterable dbSchemas = jBIterable;
            List schemas = new ArrayList();
            for (DbElement dbSchema : dbSchemas) {
                if (!(dbSchema instanceof DbNamespaceImpl) || (schema = this.getSchema((DbNamespaceImpl)dbSchema)) == null || DbImplUtil.findElement((DbDataSource)dbDataSource, (DasObject)((DasObject)schema)) == null) continue;
                schemas.add(schema);
            }
            return schemas;
        }

        private final BasicSchema getSchema(DbNamespaceImpl namespace) {
            Object object = namespace.getDelegate();
            return object instanceof BasicSchema ? (BasicSchema)object : null;
        }

        private final BasicTableOrView getTable(DbTable table) {
            Object object = table.getDelegate();
            return object instanceof BasicTableOrView ? (BasicTableOrView)object : null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<SearchGroup> getGroups(Map<LocalDataSource, ? extends Set<? extends BasicTableOrView>> groupedTables) {
            ArrayList<SearchGroup> groups = new ArrayList<SearchGroup>();
            for (Map.Entry<LocalDataSource, ? extends Set<? extends BasicTableOrView>> entry : groupedTables.entrySet()) {
                Serializable serializable;
                LocalDataSource dataSource = entry.getKey();
                Set<? extends BasicTableOrView> tables = entry.getValue();
                Dbms dbms = dataSource.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                if (this.mustReconnect(dbms)) {
                    void $this$mapTo$iv;
                    void $this$groupByTo$iv$iv;
                    Map $this$groupBy$iv;
                    Iterable iterable = tables;
                    boolean $i$f$groupBy = false;
                    void var9_11 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        void $this$getOrPut$iv$iv$iv;
                        BasicTableOrView it = (BasicTableOrView)element$iv$iv;
                        boolean bl = false;
                        SearchPath key$iv$iv = DbImplUtil.getDatabaseToSwitch((SearchPath)SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)((DasObject)DbImplUtil.getSearchPathObject((DatabaseDialectEx)DbImplUtil.getDatabaseDialect((Dbms)dataSource.getDbms()), (DasObject)((DasObject)it))))));
                        Map map2 = destination$iv$iv;
                        SearchPath key$iv$iv$iv = key$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    Collection destination$iv = groups;
                    boolean $i$f$mapTo = false;
                    for (Map.Entry item$iv : $this$mapTo$iv.entrySet()) {
                        Map.Entry entry2 = item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        SearchPath searchPath = (SearchPath)entry2.getKey();
                        List ts = (List)entry2.getValue();
                        collection.add(new SearchGroup(CollectionsKt.toSet((Iterable)ts), dataSource, searchPath));
                    }
                    serializable = (Serializable)((Object)destination$iv);
                    continue;
                }
                serializable = Boolean.valueOf(groups.add(new SearchGroup(tables, dataSource, null)));
            }
            return groups;
        }

        private final boolean mustReconnect(Dbms dbms) {
            return dbms.isPostgres();
        }

        private static final boolean getAllTables$lambda$0$0(DbDataSource $dbDataSource, BasicTableOrView it) {
            return DbImplUtil.findElement((DbDataSource)$dbDataSource, (DasObject)((DasObject)it)) != null;
        }

        private static final boolean getAllTables$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

