/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.ConsolesMigrationManagerKt;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUiUtil;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourcePerFileMappings;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EmptyIcon;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseRunners {
    private DatabaseRunners() {
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getAttachDataSourceSchemasRunners(@Nullable JdbcConsoleProvider.Info info2) {
        if (info2 == null || info2.model.statements().isEmpty() || info2.editor == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (info2.editor instanceof EditorWindow && !((EditorWindow)info2.editor).isValid()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile virtualFile = info2.editor.getVirtualFile();
        if (virtualFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = info2.originalFile.getProject();
        @Nls String title = SessionsUtil.getSessionTitle((VirtualFile)virtualFile);
        BiConsumer<DatabaseSession, Boolean> consumer = (newSession, chooseSchema) -> {
            JdbcConsole console = JdbcConsoleProvider.attachConsole(project, newSession, virtualFile);
            if (console != null) {
                Runnable runnable = () -> JdbcConsoleProvider.doRunQueryInConsole(console, info2);
                if (chooseSchema.booleanValue()) {
                    DatabaseRunners.chooseSchemaAndRun((Editor)info2.editor, runnable);
                } else {
                    runnable.run();
                }
            }
        };
        return DatabaseRunners.getAttachDataSourceSchemasRunners(info2.file, virtualFile, title, consumer);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getAttachDataSourceSchemasRunners(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull @Nls String title, @NotNull @NotNull BiConsumer<? super @NotNull DatabaseSession, Boolean> consumer) {
        DbDataSource forcedDataSource;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            DatabaseRunners.$$$reportNull$$$0(4);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(6);
        }
        if ((forcedDataSource = DbImplUtil.getForcedDataSourceForExec((PsiFile)file)) != null) {
            if (DbVFSUtils.isAssociatedWithDataSourceAndSchema((VirtualFile)virtualFile)) {
                List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(DatabaseRunners.createDataSourceRunner(forcedDataSource, title, (Consumer<? super DatabaseSession>)((Consumer)session -> consumer.accept((DatabaseSession)session, false))));
                if (list == null) {
                    DatabaseRunners.$$$reportNull$$$0(7);
                }
                return list;
            }
            List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(DatabaseRunners.createDataSourceSchemasRunner(forcedDataSource, title, consumer));
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(8);
            }
            return list;
        }
        return DatabaseRunners.getDataSourceSchemasRunners(file, title, null, consumer);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getDataSourceSchemasRunners(@NotNull PsiFile file, @NotNull @Nls String title, @Nullable DatabaseSession current, @NotNull BiConsumer<? super @Nullable DatabaseSession, Boolean> consumer) {
        String currentDataSourceId;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(9);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(11);
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        String string = currentDataSourceId = current == null ? null : current.getConnectionPoint().getDataSource().getUniqueId();
        if (currentDataSourceId != null) {
            result.add(DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"detach.data.source", (Object[])new Object[0]), false, false, false, AllIcons.Actions.Cancel, () -> consumer.accept(null, false)));
        }
        JBIterable dataSources = DbImplUtil.getAppropriateDataSourcesForExec((PsiFile)file);
        for (DbDataSource dataSource : dataSources) {
            if (dataSource.getUniqueId().equals(currentDataSourceId)) continue;
            result.add(DatabaseRunners.createDataSourceSchemasRunner(dataSource, title, consumer));
        }
        JBIterable allDataSources = DbImplUtil.getAllDataSourcesForExec((PsiFile)file);
        int dataSourcesSize = dataSources.size();
        if (dataSourcesSize == allDataSources.take(dataSourcesSize + 1).size()) {
            ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
            if (arrayList == null) {
                DatabaseRunners.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        final List allDataSourcesSubRunners = allDataSources.filter(d -> !d.getUniqueId().equals(currentDataSourceId)).map(d -> DatabaseRunners.createDataSourceSchemasRunner(d, title, consumer)).toList();
        MyRunner allDataSourcesRunner = new MyRunner(DatabaseBundle.message((String)"all.runner.title", (Object[])new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                List list = allDataSourcesSubRunners;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$1", "getSubRunners"));
            }
        };
        result.add(allDataSourcesRunner);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createDataSourceSchemasRunner(@NotNull DbDataSource dataSource, @NotNull @Nls String title, @NotNull BiConsumer<? super DatabaseSession, Boolean> consumer) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(14);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(16);
        }
        Runnable defaultSchemaRunnable = () -> DatabaseRunners.runInDataSource(dataSource, title, (Consumer<? super DatabaseSession>)((Consumer)session -> consumer.accept((DatabaseSession)session, false)));
        final PersistenceConsoleProvider.Runner defaultSchemaRunner = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"use.default.schema", (Object[])new Object[0]), false, true, false, EmptyIcon.ICON_16, defaultSchemaRunnable);
        Runnable chooseSchemaRunnable = () -> DatabaseRunners.runInDataSource(dataSource, title, (Consumer<? super DatabaseSession>)((Consumer)session -> consumer.accept((DatabaseSession)session, true)));
        final PersistenceConsoleProvider.Runner chooseSchemaRunner = DatabaseRunners.createRunner(DatabaseBundle.message((String)"choose.schema", (Object[])new Object[0]), EmptyIcon.ICON_16, null, chooseSchemaRunnable);
        return new MyRunner(dataSource.getName(), true, false, false, dataSource.getIcon(), DatabaseRunners.getDataSourceRunnerColor(dataSource), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                List<PersistenceConsoleProvider.Runner> list = Arrays.asList(defaultSchemaRunner, chooseSchemaRunner);
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$2", "getSubRunners"));
            }
        };
    }

    public static void chooseSchemaAndRun(@NotNull Editor editor2, @Nullable Runnable runnable) {
        if (editor2 == null) {
            DatabaseRunners.$$$reportNull$$$0(17);
        }
        ChooseSchemaAction action = new ChooseSchemaAction();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent());
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)dataContext);
        Runnable finalRunnable = runnable == null ? null : () -> ApplicationManager.getApplication().invokeLater(runnable);
        action.actionPerformed(event, finalRunnable);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getAttachDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @NotNull @NotNull Consumer<? super @NotNull DatabaseSession> consumer) {
        DbDataSource forcedDataSource;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(18);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(20);
        }
        if ((forcedDataSource = DbImplUtil.getForcedDataSourceForExec((PsiFile)file)) != null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(DatabaseRunners.createDataSourceRunner(forcedDataSource, title, consumer));
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(21);
            }
            return list;
        }
        return DatabaseRunners.getDataSourceRunners(file, title, null, consumer);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getSwitchDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @NotNull DatabaseSession current, @NotNull Consumer<? super @Nullable DatabaseSession> consumer) {
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(22);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(23);
        }
        if (current == null) {
            DatabaseRunners.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(25);
        }
        return DatabaseRunners.getDataSourceRunners(file, title, current, consumer);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @Nullable DatabaseSession current, @NotNull Consumer<? super @Nullable DatabaseSession> consumer) {
        String currentDataSourceId;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(26);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(28);
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        String string = currentDataSourceId = current == null ? null : current.getConnectionPoint().getDataSource().getUniqueId();
        if (currentDataSourceId != null) {
            result.add(DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"detach.data.source", (Object[])new Object[0]), false, false, false, AllIcons.Actions.Cancel, () -> consumer.consume(null)));
        }
        JBIterable dataSources = DbImplUtil.getAppropriateDataSourcesForExec((PsiFile)file);
        for (DbDataSource dataSource : dataSources) {
            if (dataSource.getUniqueId().equals(currentDataSourceId)) continue;
            result.add(DatabaseRunners.createDataSourceRunner(dataSource, title, consumer));
        }
        JBIterable allDataSources = DbImplUtil.getAllDataSourcesForExec((PsiFile)file);
        int dataSourcesSize = dataSources.size();
        if (dataSourcesSize == allDataSources.take(dataSourcesSize + 1).size()) {
            ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
            if (arrayList == null) {
                DatabaseRunners.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        final List allDataSourcesSubRunners = allDataSources.filter(d -> !d.getUniqueId().equals(currentDataSourceId)).map(d -> DatabaseRunners.createDataSourceRunner(d, title, consumer)).toList();
        MyRunner allDataSourcesRunner = new MyRunner(DatabaseBundle.message((String)"all.runner.title", (Object[])new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                List list = allDataSourcesSubRunners;
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$3", "getSubRunners"));
            }
        };
        result.add(allDataSourcesRunner);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createDataSourceRunner(@NotNull DbDataSource dataSource, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(31);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(33);
        }
        Runnable runnable = () -> DatabaseRunners.runInDataSource(dataSource, title, consumer);
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource((DbDataSource)dataSource);
        if (DbImplUtil.isConnected((Project)dataSource.getProject(), (LocalDataSource)localDataSource)) {
            return DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, dataSource.getName(), dataSource.getIcon(), DatabaseRunners.getDataSourceRunnerColor(dataSource), runnable);
        }
        return DatabaseRunners.createRunner(dataSource.getName(), dataSource.getIcon(), DatabaseRunners.getDataSourceRunnerColor(dataSource), runnable);
    }

    public static void runInDataSource(@NotNull DbDataSource dataSource, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(34);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(35);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(36);
        }
        Project project = dataSource.getProject();
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource((DbDataSource)dataSource);
        DatabaseSession session = DatabaseSessionManager.getSession((Project)project, (DatabaseConnectionPoint)localDataSource, (String)title);
        consumer.consume((Object)session);
    }

    @Nullable
    private static Color getDataSourceRunnerColor(@NotNull DbDataSource o) {
        if (o == null) {
            DatabaseRunners.$$$reportNull$$$0(37);
        }
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(o.getProject()).getState();
        boolean useColors = state.useColors && state.inDatabaseView;
        return useColors ? DatabaseColorManager.getColor((DbElement)o) : null;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getSessionRunners(@NotNull DatabaseSession current, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer) {
        if (current == null) {
            DatabaseRunners.$$$reportNull$$$0(38);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(39);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(40);
        }
        Project project = current.getProject();
        LocalDataSource localDataSource = ((DatabaseConnectionPoint)current.getTarget()).getDataSource();
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(DatabaseRunners.createNewSessionRunner(project, localDataSource, title, consumer));
        for (DatabaseSession session : DatabaseSessionManager.getSessions((Project)project, (LocalDataSource)localDataSource)) {
            if (session == current) continue;
            result.add(DatabaseRunners.createSessionRunner(session, consumer));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createNewSessionRunner(@NotNull Project project, @NotNull LocalDataSource localDataSource, @Nls @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer) {
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(42);
        }
        if (localDataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(43);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(44);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(45);
        }
        Icon icon = LayeredIcon.create((Icon)SessionsUiUtil.getIcon((boolean)false), (Icon)AllIcons.Actions.New);
        Runnable runnable = () -> {
            DatabaseSession session = DatabaseSessionManager.openSession((Project)project, (DatabaseConnectionPoint)localDataSource, (String)title);
            consumer.consume((Object)session);
        };
        return DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"new.session", (Object[])new Object[0]), false, false, false, icon, runnable);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createSessionRunner(@NotNull DatabaseSession session, @NotNull Consumer<? super DatabaseSession> consumer) {
        if (session == null) {
            DatabaseRunners.$$$reportNull$$$0(46);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(47);
        }
        String title = session.getTitle();
        return DatabaseRunners.createRunner(title, SessionsUiUtil.getIcon((boolean)session.isConnected()), null, () -> consumer.consume((Object)session));
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceConsolesRunner(final @NotNull DbDataSource dataSource, final @NotNull Consumer<? super VirtualFile> consumer) {
        if (dataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(48);
        }
        if (consumer == null) {
            DatabaseRunners.$$$reportNull$$$0(49);
        }
        final Project project = dataSource.getProject();
        return new MyRunner(dataSource.getName(), false, false, true, dataSource.getIcon(0), DatabaseRunners.getDataSourceRunnerColor(dataSource), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getDataSourceRootDir((DasDataSource)dataSource);
                Icon icon = dataSource.getIcon(0);
                Icon newIcon = LayeredIcon.create((Icon)DatabaseIcons.ConsoleRun, (Icon)AllIcons.Actions.New);
                boolean consolesMigrated = ConsolesMigrationManagerKt.areConsolesMigrated((Project)project);
                String newRunnerName = ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(project, DatabaseBundle.message((String)"console.new.console", (Object[])new Object[0]), DatabaseBundle.message((String)"console.new.file", (Object[])new Object[0]));
                LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, newRunnerName, false, consoleDir == null || consolesMigrated, true, newIcon, () -> {
                    if (localDataSource != null) {
                        consumer.consume((Object)DatabaseEditorHelper.createNewQueryFile(project, localDataSource));
                    }
                });
                if (consoleDir == null && !ConsolesMigrationManagerKt.areConsolesMigrated((Project)project)) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                Map allRunningFiles = JBIterable.from(JdbcConsole.getActiveConsoles(project)).toReverseMap(o -> o.getVirtualFile());
                DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                if (!consolesMigrated) {
                    VirtualFile defaultConsoleFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)dataSource);
                    PersistenceConsoleProvider.Runner defRunner = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"console.default", (Object[])new Object[0]), allRunningFiles.containsKey(defaultConsoleFile), true, true, icon, () -> consumer.consume(ObjectUtils.notNull((Object)defaultConsoleFile, () -> Objects.requireNonNull(DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource)))));
                    List list = JBIterable.of((Object[])new PersistenceConsoleProvider.Runner[]{newRunner, defRunner}).append((Object)DatabaseRunners.getAllRunnersLegacy(project, rootType, consoleDir, allRunningFiles, (Consumer<? super VirtualFile>)consumer, icon)).toList();
                    if (list == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                List<VirtualFile> attachedFiles = DataSourcePerFileMappings.getInstance(project).getAttachedFiles(dataSource.getUniqueId());
                if (attachedFiles.isEmpty()) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                if (attachedFiles.size() > 100) {
                    attachedFiles = attachedFiles.subList(0, 100);
                }
                final JBIterable perFile = JBIterable.from(attachedFiles).map(file -> new MyRunner(file.getName(), allRunningFiles.containsKey(file), false, true, icon, null, () -> consumer.consume(file)));
                MyRunner allFilesRunner = new MyRunner(this, DatabaseBundle.message((String)"all.runner.title", (Object[])new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

                    @NotNull
                    public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                        List list = perFile.toList();
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$4$1", "getSubRunners"));
                    }
                };
                List<PersistenceConsoleProvider.Runner> list = List.of(newRunner, allFilesRunner);
                if (list == null) {
                    4.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$4", "getSubRunners"));
            }
        };
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner getAllRunnersLegacy(Project project, DbConsoleRootType rootType, VirtualFile consoleDir, Map<VirtualFile, JdbcConsole> allRunningFiles, Consumer<? super VirtualFile> consumer, Icon icon) {
        final JBIterable perFile = FileUtil.fileTraverser((File)VfsUtilCore.virtualToIoFile((VirtualFile)consoleDir)).traverse(TreeTraversal.LEAVES_BFS).take(100).filterMap(file -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)).map(file -> new MyRunner(Objects.requireNonNull(rootType.substituteName(project, (VirtualFile)file, false)), allRunningFiles.containsKey(file), false, true, icon, null, () -> consumer.consume(file)));
        final PersistenceConsoleProvider.Runner dir = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.LOW, DatabaseBundle.message((String)"jump.to.console.files", (Object[])new Object[0]), false, false, true, null, () -> {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiDirectory psiDirectory = psiManager.findDirectory(consoleDir);
            if (psiDirectory != null) {
                psiDirectory.navigate(true);
            }
        });
        return new MyRunner(DatabaseBundle.message((String)"all.runner.title", (Object[])new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                List list = perFile.append((Object)dir).toList();
                if (list == null) {
                    5.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$5", "getSubRunners"));
            }
        };
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createConsoleRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
        DbConsoleRootType rootType;
        String title;
        if (console == null) {
            DatabaseRunners.$$$reportNull$$$0(50);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(51);
        }
        title = (title = (rootType = DbConsoleRootType.getInstance()).substituteName(console.getProject(), console.getVirtualFile(), false)) != null ? title : console.getDisplayName();
        return DatabaseRunners.createRunner(title, console.getIcon(), null, runnable);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createPriorityRunner(@NotNull PriorityAction.Priority priority, @NotNull @Nls String displayName, boolean running, boolean defaultSubRunner, boolean shoundBeChosenIfAlone, @Nullable Icon icon, @NotNull Runnable runnable) {
        if (priority == null) {
            DatabaseRunners.$$$reportNull$$$0(52);
        }
        if (displayName == null) {
            DatabaseRunners.$$$reportNull$$$0(53);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(54);
        }
        return new PriorityRunner(displayName, running, defaultSubRunner, shoundBeChosenIfAlone, icon, null, runnable, priority);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createPriorityRunner(@NotNull PriorityAction.Priority priority, @NotNull @Nls String displayName, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (priority == null) {
            DatabaseRunners.$$$reportNull$$$0(55);
        }
        if (displayName == null) {
            DatabaseRunners.$$$reportNull$$$0(56);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(57);
        }
        return new PriorityRunner(displayName, true, false, true, icon, color, runnable, priority);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(58);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(59);
        }
        return new MyRunner(title, true, false, true, icon, color, runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 3: 
            case 9: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 32: 
            case 35: 
            case 39: 
            case 44: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 20: 
            case 25: 
            case 28: 
            case 33: 
            case 36: 
            case 40: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: 
            case 31: 
            case 34: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 51: 
            case 54: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachDataSourceSchemasRunners";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceSchemasRunners";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachDataSourceRunners";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceRunners";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionRunners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttachDataSourceSchemasRunners";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceSchemasRunners";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceSchemasRunner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseSchemaAndRun";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttachDataSourceRunners";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchDataSourceRunners";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceRunners";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceRunner";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runInDataSource";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceRunnerColor";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSessionRunners";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createNewSessionRunner";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createSessionRunner";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceConsolesRunner";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createPriorityRunner";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createRunner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59 -> new IllegalArgumentException(string);
        };
    }

    static class PriorityRunner
    extends MyRunner
    implements PriorityAction {
        private final PriorityAction.Priority myPriority;

        PriorityRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String displayName, boolean running, boolean defaultSubRunner, boolean shouldBeChosenIfAlone, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable, @NotNull PriorityAction.Priority priority) {
            if (displayName == null) {
                PriorityRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                PriorityRunner.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(2);
            }
            super(displayName, running, defaultSubRunner, shouldBeChosenIfAlone, icon, color, runnable);
            this.myPriority = priority;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(3);
            }
            return priority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        @Nls(capitalization=Nls.Capitalization.Title)
        final String displayName;
        final boolean running;
        final boolean defaultSubRunner;
        final boolean shouldBeChosenIfAlone;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String displayName, boolean running, boolean defaultSubRunner, boolean shouldBeChosenIfAlone, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            this.displayName = displayName;
            this.running = running;
            this.defaultSubRunner = defaultSubRunner;
            this.shouldBeChosenIfAlone = shouldBeChosenIfAlone;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        public boolean isAlreadyRunning() {
            return this.running;
        }

        public boolean isDefaultSubRunner() {
            return this.defaultSubRunner;
        }

        public boolean shouldBeChosenIfAlone() {
            return this.shouldBeChosenIfAlone;
        }

        public void run() {
            this.runnable.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/DatabaseRunners$MyRunner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

