/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DbGridDataHookUpManager;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001a\u0012\u0004\u0012\u00020\u00120\u0019H\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl;", "Lcom/intellij/database/console/session/DatabaseSessionViewService;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "sessionViews", "", "Lcom/intellij/database/run/session/VisibleSession;", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "clientViews", "Lkotlin/Pair;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/console/session/DatabaseClientLogView;", "getView", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "initView", "", "getViewIfAny", "Lcom/intellij/database/run/session/LogView;", "getClientView", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "configurator", "Lkotlin/Function1;", "Lcom/intellij/database/console/session/DatabaseClientLogViewBase;", "key", "getClientViewIfAny", "destroyView", "databaseSessionContributorListenSessions", "findDatabaseSession", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "MyLanguageConsoleImpl", "MyAutoClosableLanguageConsoleImpl", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseSessionViewServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionViewServiceImpl.kt\ncom/intellij/database/console/session/DatabaseSessionViewServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class DatabaseSessionViewServiceImpl
extends DatabaseSessionViewService
implements Disposable.Default {
    @NotNull
    private final Map<VisibleSession<?>, DatabaseSessionLogView> sessionViews = new HashMap();
    @NotNull
    private final Map<Pair<Project, VirtualFile>, DatabaseClientLogView> clientViews = new HashMap();

    @NotNull
    public DatabaseSessionLogView getView(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DatabaseSessionLogView databaseSessionLogView = this.sessionViews.computeIfAbsent((VisibleSession<?>)session, (Function<VisibleSession<?>, DatabaseSessionLogView>)((Function<Object, DatabaseSessionLogView>)arg_0 -> DatabaseSessionViewServiceImpl.getView$lambda$1(arg_0 -> DatabaseSessionViewServiceImpl.getView$lambda$0(session, this, arg_0), arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)databaseSessionLogView, (String)"computeIfAbsent(...)");
        return databaseSessionLogView;
    }

    public void initView(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.getView(session);
    }

    @Nullable
    public LogView<DatabaseSession> getViewIfAny(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionViews.get(session);
    }

    @NotNull
    public DatabaseClientLogView getClientView(@NotNull DatabaseSessionClientWithFile client, @NotNull Function1<? super DatabaseClientLogViewBase<DatabaseSessionClientWithFile>, Unit> configurator) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
        Project project = ((DatabaseSession)client.getSession()).getProject();
        Pair<Project, VirtualFile> key = this.key(client);
        DatabaseClientLogView databaseClientLogView = this.clientViews.computeIfAbsent(key, arg_0 -> DatabaseSessionViewServiceImpl.getClientView$lambda$1(arg_0 -> DatabaseSessionViewServiceImpl.getClientView$lambda$0(project, client, configurator, this, key, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)databaseClientLogView, (String)"computeIfAbsent(...)");
        DatabaseClientLogView view = databaseClientLogView;
        if (!Intrinsics.areEqual(view.getTarget(), (Object)client)) {
            view.setTarget(client, client.getMessageBus());
            configurator.invoke((Object)view);
        }
        return view;
    }

    private final Pair<Project, VirtualFile> key(DatabaseSessionClientWithFile client) {
        return new Pair((Object)((DatabaseSession)client.getSession()).getProject(), (Object)client.getVirtualFile());
    }

    @Nullable
    public LogView<DatabaseSessionClientWithFile> getClientViewIfAny(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return client instanceof DataGridSessionClient ? ((DataGridSessionClient)client).getView() : (LogView)this.clientViews.get(this.key(client));
    }

    public void destroyView(@NotNull DatabaseSessionClientWithFile client) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            LogView<DatabaseSessionClientWithFile> logView = this.getClientViewIfAny(client);
            if (logView == null) break block0;
            LogView<DatabaseSessionClientWithFile> it = logView;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    public void databaseSessionContributorListenSessions() {
        DatabaseServiceViewContributor.listenSessions();
    }

    @Nullable
    public DatabaseSession findDatabaseSession(@NotNull AnActionEvent e) {
        DataGridSessionClient hookUp;
        DatabaseSession session;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Object object = e.getData(Session.SESSION_KEY);
        DatabaseSession databaseSession = session = object instanceof DatabaseSession ? (DatabaseSession)object : null;
        if (session != null) {
            return session;
        }
        JdbcConsoleBase console = JdbcConsole.findConsole(e);
        if (console != null) {
            return (DatabaseSession)console.getSession();
        }
        DataGridSessionClient dataGridSessionClient = hookUp = (DataGridSessionClient)((Object)DbGridDataHookUpManager.getInstance(project2).getClient(e));
        return dataGridSessionClient != null ? dataGridSessionClient.getSession() : null;
    }

    private static final DatabaseSessionLogView getView$lambda$0(DatabaseSession $session, DatabaseSessionViewServiceImpl this$0, VisibleSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ThreadingAssertions.assertEventDispatchThread();
        Project project = $session.getProject();
        String string = $session.getTitle();
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((LocalDataSource)((DatabaseConnectionPoint)$session.getTarget()).getDataSource());
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        MyLanguageConsoleImpl console = new MyLanguageConsoleImpl(project, string, (Language)sqlLanguageDialect);
        DatabaseSessionLogView view = new DatabaseSessionLogView((LanguageConsoleView)console, $session);
        Disposer.register((Disposable)((Disposable)$session), () -> DatabaseSessionViewServiceImpl.getView$lambda$0$0(this$0, $session));
        return view;
    }

    private static final void getView$lambda$0$0(DatabaseSessionViewServiceImpl this$0, DatabaseSession $session) {
        this$0.sessionViews.remove($session);
    }

    private static final DatabaseSessionLogView getView$lambda$1(Function1 $tmp0, Object p0) {
        return (DatabaseSessionLogView)$tmp0.invoke(p0);
    }

    private static final DatabaseClientLogView getClientView$lambda$0(Project $project, DatabaseSessionClientWithFile $client, Function1 $configurator, DatabaseSessionViewServiceImpl this$0, Pair $key, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ThreadingAssertions.assertEventDispatchThread();
        MyAutoClosableLanguageConsoleImpl console = new MyAutoClosableLanguageConsoleImpl($project, $client.getTitle(), $client.getVirtualFile(), $client.getAutoClose());
        DatabaseClientLogView result = new DatabaseClientLogView((LanguageConsoleView)console, $client);
        $configurator.invoke((Object)result);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)result);
        Disposer.register((Disposable)result, () -> DatabaseSessionViewServiceImpl.getClientView$lambda$0$0(this$0, $key));
        return result;
    }

    private static final void getClientView$lambda$0$0(DatabaseSessionViewServiceImpl this$0, Pair $key) {
        this$0.clientViews.remove($key);
    }

    private static final DatabaseClientLogView getClientView$lambda$1(Function1 $tmp0, Object p0) {
        return (DatabaseClientLogView)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyAutoClosableLanguageConsoleImpl;", "Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyLanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoClose", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "closeFile", "", "intellij.database.impl"})
    private static final class MyAutoClosableLanguageConsoleImpl
    extends MyLanguageConsoleImpl {
        private final boolean autoClose;

        public MyAutoClosableLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file, boolean autoClose) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(project, title, file);
            this.autoClose = autoClose;
        }

        protected void closeFile() {
            if (this.autoClose) {
                super.closeFile();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyLanguageConsoleImpl;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/lang/Language;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.database.impl"})
    private static class MyLanguageConsoleImpl
    extends LanguageConsoleImpl {
        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(new LanguageConsoleImpl.Helper(project, file){

                public void setupEditor(EditorEx editor2) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    super.setupEditor(editor2);
                    EditorSettings editorSettings = editor2.getSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
                    EditorSettings editorSettings2 = editorSettings;
                    editorSettings2.setFoldingOutlineShown(true);
                }
            }.setTitle(title));
        }

        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this(project, title, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)""));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

