/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceSessionTemplatesPanel;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.ui.BeforeConnectionStepsPanel;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.ui.HardViewport;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.properties.Level;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.TimeZoneTextField;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.execution.ExecutionBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlDialectSpecificCodeStyleScheme;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private final DataSourceConfigurable myConfigurable;
    private JBScrollPane myRoot;
    private JLabel myIntrospectionLevelLabel;
    private ComboBox<LevelItem> myIntrospectionLevelSelector;
    private JBLabel mySourceLoadingLabel;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private ComboBox<SchemaControl> mySwitchControlBox;
    private JBCheckBox mySingleDatabase;
    private ComboBox<@NlsSafe String> myCodeStyleComboBox;
    private JBCheckBox mySingleSessionCheckBox;
    private JBCheckBox myCheckOutdatedCheckBox;
    private JBCheckBox myTrackNamespaces;
    private JBCheckBox myKeepAliveEnable;
    private JBTextField myKeepAliveTimeout;
    private JBCheckBox myAutoCloseEnable;
    private EditorTextField myInitScript;
    private JBTextField myAutoCloseTimeout;
    private JBCheckBox myAutoSyncCheckBox;
    private JBCheckBox myReadOnlyCheckBox;
    private JPanel myTxControlPanel;
    private JLabel myTxControlLabel;
    private JPanel myTxControlHolder;
    private TextFieldWithAutoCompletion<String> myTimeZoneField;
    private JLabel myTimeZoneLabel;
    private JBCheckBox myUseMiniCat;
    private TextFieldWithBrowseButton myExternalModelData;
    private JLabel myExternalModelDataLabel;
    private BeforeConnectionStepsPanel myBeforeRunStepsPanel;
    private JComponent myConnectionOptionsPanel;
    private final DbOptionsEditor<LocalDataSource> myConnectionOptionsEditor;
    private JComponent myIntrospectionOptionsPanel;
    private final DbOptionsEditor<LocalDataSource> myIntrospectionOptionsEditor;
    private JPanel mySessionTemplatesPanel;
    private ComboBox<String> myIntrospectionSessionTemplate;
    private final DataSourceSessionTemplatesPanel mySessionTemplates;
    private final DataSourceGeneralPanel.MyTxIsolationSelector mySelector;
    private final boolean myUseLevels;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(0);
        }
        this.mySelector = new DataSourceGeneralPanel.MyTxIsolationSelector();
        this.myConfigurable = configurable;
        this.myConnectionOptionsEditor = new DbOptionsEditor<LocalDataSource>((LocalDataSource)this.myConfigurable.getTarget(), p -> p.getLocation() == DbOptionProvider.UiLocation.CONNECTION, null, configurable.getDataContext(), 2);
        this.myIntrospectionOptionsEditor = new DbOptionsEditor<LocalDataSource>((LocalDataSource)this.myConfigurable.getTarget(), p -> p.getLocation() == DbOptionProvider.UiLocation.INTROSPECTION, null, configurable.getDataContext(), 2);
        this.mySessionTemplates = new DataSourceSessionTemplatesPanel(configurable.getProject(), configurable.getSecretService(), (LocalDataSource)configurable.getDataSource(), configurable::getTempDataSource, configurable.getTestConnectionManager());
        this.$$$setupUI$$$();
        ManualPopupButton.INSTANCE.install((EditorTextField)this.myTimeZoneField, false);
        this.mySessionTemplatesPanel.add((Component)this.mySessionTemplates.getComponent(), "Center");
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml").withTitle(DatabaseBundle.message((String)"DataSourceConfigurable.choose.external.model.data", (Object[])new Object[0]));
        this.myExternalModelData.addBrowseFolderListener(configurable.getProject(), descriptor2);
        LocalDataSource dataSource = (LocalDataSource)this.myConfigurable.getDataSource();
        Dbms dbms = dataSource.getDbms();
        this.myUseLevels = DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)dbms);
        this.myIntrospectionLevelLabel.setVisible(this.myUseLevels);
        this.myIntrospectionLevelSelector.setVisible(this.myUseLevels);
        this.myIntrospectionLevelSelector.setModel((ComboBoxModel)((Object)new LevelItemComboBoxModel()));
        this.mySourceLoadingLabel.setVisible(!this.myUseLevels);
        this.mySourceLoading.setVisible(!this.myUseLevels);
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message((String)"data.source.settings.options.source.loading.none", (Object[])new Object[0]), value -> DataSourceOptionsPanel.getSourceLoadingComboText(value)));
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message((String)"data.source.settings.options.schema.switch.auto", (Object[])new Object[0]), value -> DataSourceOptionsPanel.getSchemaSwitchComboText(value)));
        CollectionComboBoxModel sessionsModel = new CollectionComboBoxModel();
        this.updateTemplatesList((CollectionComboBoxModel<String>)sessionsModel);
        this.myIntrospectionSessionTemplate.setModel((ComboBoxModel)sessionsModel);
        this.myIntrospectionSessionTemplate.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message((String)"action.DatabaseConfigEditor.none.text", (Object[])new Object[0]), this::getSessionTemplateName));
        this.mySessionTemplates.onModelChanged(() -> this.updateTemplatesList((CollectionComboBoxModel<String>)sessionsModel));
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((Dbms)dbms);
        boolean tzVisible = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(dbms)).getTimeZoneManager().canChange();
        this.myTimeZoneField.setVisible(tzVisible);
        this.myTimeZoneLabel.setVisible(tzVisible);
        this.myTimeZoneLabel.setLabelFor((Component)this.myTimeZoneField);
        this.mySingleDatabase.setVisible(JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)dataSource));
        DatabaseDialogsHelper.setTextFieldLanguage(this.myInitScript, DbSqlUtilCore.getSqlDialect((LocalDataSource)dataSource));
        this.myKeepAliveEnable.addActionListener(this::update);
        this.myAutoCloseEnable.addActionListener(this::update);
        this.myCodeStyleComboBox.setModel(DataSourceOptionsPanel.createCodeStyleComboBox(dialect));
        JComponent txComponent = DbUIUtil.createActionComponent((AnAction)new DataSourceGeneralPanel.DataSourceTxModeAction(this.mySelector, dbms), (JComponent)this.myRoot);
        this.myTxControlPanel.setLayout(new BorderLayout());
        this.myTxControlPanel.add((Component)txComponent, "Center");
        this.myTxControlHolder.setVisible(DataSourceUtil.isTransactionsSupported((Dbms)dbms));
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        this.myConnectionOptionsEditor.reset(dataSource);
        this.myIntrospectionOptionsEditor.reset(dataSource);
        UIUtil.uiTraverser((Component)this.myRoot).filter(EditorTextField.class).forEach(etf -> etf.setDisposedWith((Disposable)this.myConfigurable));
        this.myExternalModelDataLabel.setLabelFor(this.myExternalModelData.getTextField());
        txComponent.getAccessibleContext().setAccessibleName(this.myTxControlLabel.getText());
        String myKeepAliveTimeoutAccessibleName = AccessibleContextUtil.combineAccessibleStrings((String)DatabaseBundle.message((String)"data.source.keep.alive.label", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"inline.text.field.accessible.name.time.in.prefix", (Object[])new Object[]{DatabaseBundle.message((String)"DataSourceOptionsPanel.sec", (Object[])new Object[0])}));
        this.myKeepAliveTimeout.getAccessibleContext().setAccessibleName(myKeepAliveTimeoutAccessibleName);
        String myAutoCloseEnableAccessibleName = AccessibleContextUtil.combineAccessibleStrings((String)DatabaseBundle.message((String)"data.source.auto.disconnect.label", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"inline.text.field.accessible.name.time.in.prefix", (Object[])new Object[]{DatabaseBundle.message((String)"DataSourceOptionsPanel.sec", (Object[])new Object[0])}));
        this.myAutoCloseTimeout.getAccessibleContext().setAccessibleName(myAutoCloseEnableAccessibleName);
    }

    @NotNull
    DataSourceSessionTemplatesPanel getSessionTemplates() {
        DataSourceSessionTemplatesPanel dataSourceSessionTemplatesPanel = this.mySessionTemplates;
        if (dataSourceSessionTemplatesPanel == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(1);
        }
        return dataSourceSessionTemplatesPanel;
    }

    private void updateTemplatesList(CollectionComboBoxModel<String> sessionsModel) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(null);
        templates.addAll(this.mySessionTemplates.getSessionIds());
        sessionsModel.replaceAll(templates);
        this.myIntrospectionLevelSelector.revalidate();
    }

    private String getSessionTemplateName(String id) {
        return this.mySessionTemplates.getSessionName(id);
    }

    public void hidePassword() {
        this.mySessionTemplates.hidePassword();
    }

    public void reloadCredentials() {
        this.mySessionTemplates.reloadCredentials();
    }

    public static ComboBoxModel<String> createCodeStyleComboBox(@Nullable SqlLanguageDialect dialect) {
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List regularSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        List<SqlDialectSpecificCodeStyleScheme> specificSchemes = DataSourceOptionsPanel.listSpecificSchemes(dialect);
        for (CodeStyleScheme codeStyleScheme : regularSchemes) {
            codeStyleNamesModel.add((Object)codeStyleScheme.getName());
        }
        for (CodeStyleScheme codeStyleScheme : specificSchemes) {
            codeStyleNamesModel.add((Object)codeStyleScheme.getName());
        }
        return codeStyleNamesModel;
    }

    private static List<SqlDialectSpecificCodeStyleScheme> listSpecificSchemes(@Nullable SqlLanguageDialect dialect) {
        if (dialect == null) {
            return Collections.emptyList();
        }
        List schemes = SqlCodeStyles.listSpecificSchemes().filter(s -> s.getApplicableDialect() == dialect).filter(s -> DataSourceOptionsPanel.checkScheme((CodeStyleScheme)s, dialect)).toList();
        return schemes;
    }

    private static Boolean checkScheme(@NotNull CodeStyleScheme scheme, @NotNull SqlLanguageDialect dialect) {
        CodeStyleSettings container;
        SqlCodeStyleSettings sql;
        if (scheme == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(3);
        }
        return (sql = SqlCodeStyles.pickSqlSettingsIfExists((CodeStyleSettings)(container = scheme.getCodeStyleSettings()), (SqlLanguageDialect)dialect)) != null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static String getSchemaSwitchComboText(@NotNull SchemaControl value) {
        if (value == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(4);
        }
        String string = value == SchemaControl.AUTOMATIC ? DatabaseBundle.message((String)"data.source.settings.options.schema.switch.auto", (Object[])new Object[0]) : (value == SchemaControl.MANUAL ? DatabaseBundle.message((String)"data.source.settings.options.schema.switch.manual", (Object[])new Object[0]) : DatabaseBundle.message((String)"data.source.settings.options.schema.switch.disabled", (Object[])new Object[0]));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static String getSourceLoadingComboText(@NotNull DBIntrospectionOptions.SourceLoading value) {
        if (value == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(6);
        }
        String string = value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES ? DatabaseBundle.message((String)"data.source.settings.options.source.loading.all", (Object[])new Object[0]) : (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES ? DatabaseBundle.message((String)"data.source.settings.options.source.loading.all.excl.system", (Object[])new Object[0]) : DatabaseBundle.message((String)"data.source.settings.options.source.loading.none", (Object[])new Object[0]));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void createUIComponents() {
        this.myConnectionOptionsPanel = this.myConnectionOptionsEditor.getComponent();
        this.myIntrospectionOptionsPanel = this.myIntrospectionOptionsEditor.getComponent();
        this.myRoot = new HardViewport.ScrollPane();
        this.myInitScript = DataSourceOptionsPanel.createInitScriptField(this.myConfigurable.getProject(), () -> DbSqlUtilCore.getSqlDialect((Dbms)this.myConfigurable.getTempDataSource().getDbms()));
        this.myBeforeRunStepsPanel = new BeforeConnectionStepsPanel(this.myConfigurable.getProject());
        ExecutionEnvironmentHelper.TimeZoneManager manager = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(((LocalDataSource)this.myConfigurable.getDataSource()).getDbms())).getTimeZoneManager();
        Collection zones = manager.getAvailableTimeZones();
        this.myTimeZoneField = TimeZoneTextField.create(this.myConfigurable.getProject(), zones);
    }

    @NotNull
    static EditorTextField createInitScriptField(@NotNull Project project, final @NotNull Supplier<? extends SqlLanguageDialect> dialect) {
        if (project == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(9);
        }
        final EditorTextField initScript = new EditorTextField("", project, (FileType)SqlFileType.INSTANCE);
        new ExpandableEditorSupport(initScript);
        DataSourceOptionsPanel.addMacroSupport(initScript, macro -> !MacrosDialog.Filters.FILE_PATH.test(macro) && !(macro instanceof EditorMacro) && !(macro instanceof PromptingMacro));
        initScript.setPreferredWidth(JBUI.scale((int)200));
        UiNotifyConnector.installOn((Component)initScript, (Activatable)new Activatable(){

            public void showNotify() {
                DatabaseDialogsHelper.setTextFieldLanguage(initScript, (SqlLanguageDialect)dialect.get());
            }
        });
        EditorTextField editorTextField2 = initScript;
        if (editorTextField2 == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(10);
        }
        return editorTextField2;
    }

    private void update(ActionEvent ignore) {
        this.myKeepAliveTimeout.setEnabled(this.myKeepAliveEnable.isSelected());
        this.myAutoCloseTimeout.setEnabled(this.myAutoCloseEnable.isSelected());
    }

    public void setIntrospectionLevel(@Nullable Level level) {
        this.myIntrospectionLevelSelector.setSelectedItem((Object)LevelItem.of(level));
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(11);
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        Level level;
        if (dataSource == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(12);
        }
        dataSource.setAutoCommit(this.mySelector.isAuto());
        dataSource.setTxIsolation(this.mySelector.getIsolation().getIsolation());
        dataSource.setAutoSynchronize(this.myAutoSyncCheckBox.isSelected());
        boolean isReadonly = this.myReadOnlyCheckBox.isSelected();
        if (!dataSource.isTemporary() && dataSource.isReadOnly() != isReadonly) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("db.readonly.datasource");
        }
        dataSource.setReadOnly(isReadonly);
        if (this.myUseLevels) {
            Object object = this.myIntrospectionLevelSelector.getSelectedItem();
            if (object instanceof LevelItem) {
                LevelItem li = (LevelItem)((Object)object);
                level = li.level;
            } else {
                level = null;
            }
        } else {
            level = null;
        }
        dataSource.setIntrospectionLevel(level);
        if (!this.myUseLevels) {
            dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)ObjectUtils.notNull((Object)((DBIntrospectionOptions.SourceLoading)this.mySourceLoading.getSelectedItem()), (Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES));
        }
        dataSource.setIntrospectorSessionId((String)this.myIntrospectionSessionTemplate.getItem());
        dataSource.getSchemaMapping().setUseMiniCat(this.myUseMiniCat.isSelected());
        dataSource.setRewriteBounds(!this.mySingleDatabase.isSelected());
        dataSource.setSchemaControl((SchemaControl)ObjectUtils.notNull((Object)((SchemaControl)this.mySwitchControlBox.getSelectedItem()), (Object)SchemaControl.AUTOMATIC));
        dataSource.setCodeStyleName(StringUtil.nullize((String)((String)this.myCodeStyleComboBox.getSelectedItem()), (String)"Default"));
        dataSource.setSingleConnection(this.mySingleSessionCheckBox.isSelected());
        dataSource.setCheckOutdated(this.myCheckOutdatedCheckBox.isSelected());
        dataSource.setTrackNamespaces(this.myTrackNamespaces.isSelected());
        dataSource.setInitScript(this.myInitScript.getText());
        dataSource.setKeepAlive(this.myKeepAliveEnable.isSelected());
        dataSource.setAutoClose(this.myAutoCloseEnable.isSelected());
        dataSource.setKeepAliveTimeout(StringUtil.parseInt((String)this.myKeepAliveTimeout.getText(), (int)0));
        dataSource.setAutoCloseTimeout(StringUtil.parseInt((String)this.myAutoCloseTimeout.getText(), (int)0));
        dataSource.setTimeZone(StringUtil.nullize((String)StringUtil.trim((String)this.myTimeZoneField.getText()), (boolean)true));
        dataSource.getBeforeTasks().clear();
        dataSource.getBeforeTasks().addAll(DataSourceUtil.storeBeforeTasks(this.myBeforeRunStepsPanel.getTasks()));
        ModelExternalData.setExternalDataPath((LocalDataSource)dataSource, (String)StringUtil.nullize((String)this.myExternalModelData.getText(), (boolean)true));
        this.myConnectionOptionsEditor.apply(dataSource);
        this.myIntrospectionOptionsEditor.apply(dataSource);
        this.mySessionTemplates.save(dataSource);
    }

    public void reset(LocalDataSource dataSource) {
        this.mySelector.toggle(null, dataSource.isAutoCommit());
        this.mySelector.select(TxIsolation.of((int)dataSource.getTxIsolation()), (AnActionEvent)null);
        this.myAutoSyncCheckBox.setSelected(dataSource.isAutoSynchronize());
        this.myReadOnlyCheckBox.setSelected(dataSource.isReadOnly());
        Level iLevel = dataSource.getIntrospectionLevel();
        this.myIntrospectionLevelSelector.setSelectedItem((Object)LevelItem.of(iLevel));
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
        this.myIntrospectionSessionTemplate.getModel().setSelectedItem(dataSource.getIntrospectorSessionId());
        this.mySwitchControlBox.setSelectedItem((Object)dataSource.getSchemaControl());
        this.myUseMiniCat.setSelected(dataSource.getSchemaMapping().isUseMiniCat());
        this.mySingleDatabase.setSelected(!dataSource.isRewriteBounds());
        this.myCodeStyleComboBox.setSelectedItem((Object)StringUtil.notNullize((String)dataSource.getCodeStyleName(), (String)"Default"));
        this.mySingleSessionCheckBox.setSelected(dataSource.isSingleConnection());
        this.myCheckOutdatedCheckBox.setSelected(dataSource.shouldCheckOutdated());
        this.myCheckOutdatedCheckBox.setEnabled(DBIntrospectorFactory.isOutdatedCheckSupported((Dbms)dataSource.getDbms(), (boolean)false, null));
        this.myCheckOutdatedCheckBox.setToolTipText(this.myCheckOutdatedCheckBox.isEnabled() ? null : DatabaseBundle.message((String)"data.source.settings.options.outdated.check.unsupported", (Object[])new Object[0]));
        this.myTrackNamespaces.setSelected(dataSource.shouldTrackNamespaces());
        this.myInitScript.setText(dataSource.getInitScript());
        this.myKeepAliveEnable.setSelected(dataSource.isKeepAlive());
        this.myAutoCloseEnable.setSelected(dataSource.isAutoClose());
        this.myKeepAliveTimeout.setText(String.valueOf(dataSource.getKeepAliveTimeout()));
        this.myAutoCloseTimeout.setText(String.valueOf(dataSource.getAutoCloseTimeout()));
        this.myTimeZoneField.setText(StringUtil.notNullize((String)dataSource.getTimeZone()));
        this.myExternalModelData.setText(StringUtil.notNullize((String)ModelExternalData.getExternalDataPath((LocalDataSource)dataSource)));
        this.myConnectionOptionsEditor.reset(dataSource);
        this.myIntrospectionOptionsEditor.reset(dataSource);
        ConsoleRunConfiguration runConfiguration = ConsoleRunConfiguration.newConfiguration((Project)this.myConfigurable.getProject());
        this.myBeforeRunStepsPanel.doReset(DataSourceUtil.instantiateBeforeTasks((ConsoleRunConfiguration)runConfiguration, (List)dataSource.getBeforeTasks()));
        this.mySessionTemplates.reset(dataSource);
        this.update(null);
    }

    public static void addMacroSupport(@NotNull EditorTextField textField, @NotNull Predicate<? super Macro> macroFilter) {
        if (textField == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(13);
        }
        if (macroFilter == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(14);
        }
        ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineVariables, (Icon)AllIcons.General.InlineVariablesHover, (String)ExecutionBundle.message((String)"insert.macros", (Object[])new Object[0]), () -> DataSourceOptionsPanel.show(textField, macroFilter, null));
        textField.addSettingsProvider(editor2 -> ExtendableEditorSupport.setupExtension((EditorEx)editor2, null, (ExtendableTextComponent.Extension)extension));
    }

    public static void show(@NotNull EditorTextField textComponent, @NotNull Predicate<? super Macro> filter, @Nullable Map<String, String> userMacros) {
        String macro;
        MacrosDialog dialog;
        if (textComponent == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(15);
        }
        if (filter == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(16);
        }
        if ((dialog = new MacrosDialog((Component)textComponent, filter, userMacros)).showAndGet() && (macro = dialog.getSelectedMacroName()) != null) {
            WriteCommandAction.runWriteCommandAction((Project)textComponent.getProject(), null, null, () -> {
                int position;
                int selectionEnd;
                Caret caret = textComponent.getCaretModel().getCurrentCaret();
                int selectionStart = caret.getSelectionStart();
                if (selectionStart < (selectionEnd = caret.getSelectionEnd())) {
                    textComponent.getDocument().deleteString(selectionStart, selectionEnd);
                    position = selectionStart;
                } else {
                    position = caret.getOffset();
                }
                String nameToInsert = macro.startsWith("$") || macro.startsWith("%") ? macro : "$" + macro + "$";
                textComponent.getDocument().insertString(position, (CharSequence)nameToInsert);
                textComponent.setCaretPosition(position + nameToInsert.length());
            }, (PsiFile[])new PsiFile[0]);
        }
        IdeFocusManager.findInstance().requestFocus((Component)textComponent, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroFilter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionTemplates";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaSwitchComboText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLoadingComboText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitScriptField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSwitchComboText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceLoadingComboText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInitScriptField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addMacroSupport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 10 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        ComboBox comboBox;
        ComboBox comboBox2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox3;
        JBCheckBox jBCheckBox4;
        ComboBox comboBox4;
        JLabel jLabel3;
        JPanel jPanel2;
        JLabel jLabel4;
        JPanel jPanel3;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        ComboBox comboBox5;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox8;
        JBTextField jBTextField2;
        JBCheckBox jBCheckBox9;
        this.createUIComponents();
        JBScrollPane jBScrollPane = this.myRoot;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(10, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.connection.title"), (int)0, (int)0, null, null));
        this.myKeepAliveEnable = jBCheckBox9 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox9, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.keep.alive.label"));
        jPanel5.add((Component)jBCheckBox9, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myKeepAliveTimeout = jBTextField2 = new JBTextField();
        jPanel5.add((Component)jBTextField2, new GridConstraints(5, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("DataSourceOptionsPanel.sec"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseEnable = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.auto.disconnect.label"));
        jPanel5.add((Component)jBCheckBox8, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseTimeout = jBTextField = new JBTextField();
        jPanel5.add((Component)jBTextField, new GridConstraints(6, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 4, 1, 1, 0, 1, 2, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("DataSourceOptionsPanel.sec"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(6, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.switch.schema.label"));
        jPanel5.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox5 = new ComboBox();
        jPanel5.add((Component)comboBox5, new GridConstraints(2, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.startup.script.label"));
        jPanel5.add((Component)jLabel6, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myInitScript;
        jPanel5.add((Component)editorTextField2, new GridConstraints(9, 1, 1, 4, 0, 1, 3, 0, null, null, null));
        this.myReadOnlyCheckBox = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.read.only.label"));
        jPanel5.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySingleSessionCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.single.session.mode.label"));
        jPanel5.add((Component)jBCheckBox6, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySingleDatabase = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.single.dataase.mode.label"));
        jPanel5.add((Component)jBCheckBox5, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTxControlHolder = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 0, null, null, null));
        this.myTxControlLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.transaction.control.label"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTxControlPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myTimeZoneLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.time.zone.label"));
        jPanel5.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithAutoCompletion<String> textFieldWithAutoCompletion = this.myTimeZoneField;
        jPanel5.add((Component)textFieldWithAutoCompletion, new GridConstraints(3, 1, 1, 4, 8, 0, 6, 0, null, null, null));
        JComponent jComponent = this.myConnectionOptionsPanel;
        jPanel5.add((Component)jComponent, new GridConstraints(8, 0, 1, 5, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.other.title"), (int)0, (int)0, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.code.style.label"));
        jPanel6.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeStyleComboBox = comboBox4 = new ComboBox();
        comboBox4.setEnabled(true);
        jPanel6.add((Component)comboBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.editor.url.label.Introspection.title"), (int)0, (int)0, null, null));
        this.myCheckOutdatedCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.warn.outdated.label"));
        jPanel7.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox3 = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox3.setModel(defaultComboBoxModel);
        jPanel7.add((Component)comboBox3, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.auto.sync.label"));
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLoadingLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.load.sources.label"));
        jPanel7.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseMiniCat = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.pre.introspected.label"));
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myExternalModelDataLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.external.data.label"));
        jLabel2.setToolTipText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.external.data.label.tooltip"));
        jPanel7.add((Component)jLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExternalModelData = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myIntrospectionLevelLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("introspectionLevel.selector.label"));
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIntrospectionLevelSelector = comboBox2 = new ComboBox();
        jPanel7.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.use.session.template"));
        jPanel7.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIntrospectionSessionTemplate = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel2);
        jPanel7.add((Component)comboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myTrackNamespaces = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("settings.track.databases.schemas.creation.and.deletion"));
        jPanel7.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JComponent jComponent2 = this.myIntrospectionOptionsPanel;
        jPanel7.add((Component)jComponent2, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel8, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("before.connection"), (int)0, (int)0, null, null));
        BeforeConnectionStepsPanel beforeConnectionStepsPanel = this.myBeforeRunStepsPanel;
        jPanel8.add((Component)beforeConnectionStepsPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.mySessionTemplatesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.session.templates"), (int)0, (int)0, null, null));
        jLabel5.setLabelFor((Component)comboBox5);
        jLabel6.setLabelFor((Component)editorTextField2);
        jBLabel4.setLabelFor((Component)comboBox4);
        jBLabel.setLabelFor((Component)comboBox3);
        jLabel.setLabelFor((Component)comboBox2);
        jLabel7.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class LevelItemComboBoxModel
    extends EnumComboBoxModel<LevelItem> {
        private LevelItemComboBoxModel() {
            super(LevelItem.class);
        }
    }

    private static enum LevelItem {
        LI_AUTO(null, DatabaseBundle.messagePointer((String)"database.introspection.level.auto.name", (Object[])new Object[0])),
        LI_1(Level.L1, DatabaseBundle.messagePointer((String)"database.introspection.level.1.name", (Object[])new Object[0])),
        LI_2(Level.L2, DatabaseBundle.messagePointer((String)"database.introspection.level.2.name", (Object[])new Object[0])),
        LI_3(Level.L3, DatabaseBundle.messagePointer((String)"database.introspection.level.3.name", (Object[])new Object[0]));

        @Nullable
        final Level level;
        private final @NotNull Supplier<@Nls String> myNamePointer;

        private LevelItem(Level level, Supplier<String> namePointer) {
            if (namePointer == null) {
                LevelItem.$$$reportNull$$$0(0);
            }
            this.level = level;
            this.myNamePointer = namePointer;
        }

        static LevelItem of(@Nullable Level level) {
            LevelItem levelItem;
            if (level == null) {
                levelItem = LI_AUTO;
            } else {
                switch (level) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case L1: {
                        levelItem = LI_1;
                        break;
                    }
                    case L2: {
                        levelItem = LI_2;
                        break;
                    }
                    case L3: {
                        levelItem = LI_3;
                    }
                }
            }
            return levelItem;
        }

        public String toString() {
            return this.myNamePointer.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePointer", "com/intellij/database/dataSource/DataSourceOptionsPanel$LevelItem", "<init>"));
        }
    }
}

