/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DbNamespaceNode;
import com.intellij.database.view.DbNamespacesTree;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DataSourceScopeEditorTree
extends DbCheckBoxTree<DbNamespaceNode> {
    public static final String ADD_PATTERN_TAG = "add_pattern";

    DataSourceScopeEditorTree(@NotNull Project project, @NotNull CheckedTreeNode root, @NotNull Supplier<Couple<String>> fakeCurrent, @NotNull DataSourceSchemaMapping mapping) {
        if (project == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(1);
        }
        if (fakeCurrent == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(3);
        }
        super(root, new MyTreeCellRenderer(fakeCurrent, mapping));
        this.setEditable(true);
        this.setCellEditor(new MyTreeCellEditor(project));
        HoverHelper.register((JTree)((Object)this));
    }

    public boolean isPathEditable(TreePath path) {
        DbNamespaceNode node = (DbNamespaceNode)this.getSearchModel().getUserObject((DefaultMutableTreeNode)((CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class)));
        return node != null && node.getObject() instanceof TreePatternNode.PatternWrapper;
    }

    private static boolean isCurrent(DbNamespaceNode node, Couple<@NlsSafe String> fcs) {
        BasicMateNamespace namespace;
        boolean isCurrent = fcs == null ? (namespace = (BasicMateNamespace)ObjectUtils.tryCast((Object)node.getObject(), BasicMateNamespace.class)) != null && namespace.isCurrent() : DbNamespacesTree.matches(fcs, (DbNamespaceNode)node);
        return isCurrent;
    }

    @Nullable
    private static Language getRegExpLanguage() {
        return Language.findLanguageByID((String)"RegExp");
    }

    static CheckedTreeNode createNode(DbNamespaceNode node) {
        CheckedTreeNode res2 = new CheckedTreeNode(node){

            public void setChecked(boolean checked) {
                super.setChecked(checked);
                ((DbNamespaceNode)this.getUserObject()).setChecked(checked);
            }

            public boolean isLeaf() {
                DbNamespaceNode userNode = (DbNamespaceNode)ObjectUtils.tryCast((Object)this.getUserObject(), DbNamespaceNode.class);
                if (userNode == null) {
                    return super.isLeaf();
                }
                if (!userNode.getChildNodes().isEmpty()) {
                    return false;
                }
                if (userNode.getObject() == "*" || userNode instanceof DbNamespaceNode.CurNode) {
                    return true;
                }
                BasicMetaObject meta = userNode.getMeta();
                if (meta == null) {
                    return false;
                }
                for (BasicMetaObject child : meta.children) {
                    if (!child.kindOf(BasicMateNamespace.class)) continue;
                    return false;
                }
                return true;
            }
        };
        res2.setChecked(node.isChecked());
        return res2;
    }

    @Nullable
    static DataSourceScopeEditorTree getTree(DataContext dataContext) {
        return (DataSourceScopeEditorTree)((Object)ObjectUtils.tryCast((Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext), DataSourceScopeEditorTree.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "fakeCurrent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "mapping";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<DbNamespaceNode> {
        private final Supplier<Couple<String>> myCurrent;
        private final DataSourceSchemaMapping myMapping;
        private boolean treeIsShowning;

        MyTreeCellRenderer(@NotNull Supplier<Couple<String>> current, @NotNull DataSourceSchemaMapping mapping) {
            if (current == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (mapping == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(1);
            }
            this.treeIsShowning = false;
            this.myCurrent = current;
            this.myMapping = mapping;
        }

        @Override
        public void customizeRenderer(JTree baseTree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.treeIsShowning = baseTree.isShowing();
            super.customizeRenderer(baseTree, value, selected, expanded, leaf, row, hasFocus);
        }

        @Override
        protected void customizeCheckboxRenderer(DbCheckBoxTree<DbNamespaceNode> tree, DbNamespaceNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
            this.renderText((JTree)((Object)tree), node, (ColoredTextContainer)renderer2);
            ImplicitSelectionCache cache = ImplicitSelectionCache.get(tree);
            if (cache.isImplicitlySelected(node) && !this.myCheckbox.isSelected()) {
                this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
        }

        @Override
        protected void renderText(JTree baseTree, DbNamespaceNode node, ColoredTextContainer renderer2) {
            this.setToolTipText(null);
            String name = node.getName();
            Couple<@NlsSafe String> fcs = this.myCurrent.get();
            ObjectKind kind = node.getKind();
            if (node.getObject() instanceof DasObject) {
                if (StringUtil.isEmpty((String)name)) {
                    renderer2.append(DatabaseBundle.message((String)"data.source.scope.editor.tree.unnamed.node.name", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer2.append(name, DbImplUtilCore.isDatabase((ObjectKind)kind) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                boolean isCurrent = DataSourceScopeEditorTree.isCurrent(node, fcs);
                if (isCurrent) {
                    renderer2.append("  (" + DbNamespacesTree.getCurrentNodeText((DbNamespaceNode)node) + ")", fcs == null ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
                if (!MyTreeCellRenderer.isStandardKind(kind)) {
                    MyTreeCellRenderer.markExternal(renderer2, kind);
                } else {
                    BasicNamespace nsp = (BasicNamespace)ObjectUtils.tryCast((Object)node.getObject(), BasicNamespace.class);
                    if (nsp != null) {
                        this.markSubstituted(node, renderer2, nsp);
                    }
                }
            } else if (node instanceof DbNamespaceNode.CurNode) {
                renderer2.append(DbNamespacesTree.getCurrentNodeText((DbNamespaceNode)node), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (fcs == null) {
                    DasObject curObject = ((DbNamespaceNode.CurNode)node).getCurObject();
                    if (curObject != null) {
                        renderer2.append(" (" + curObject.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else {
                    String cur;
                    String string = cur = DbImplUtilCore.isDatabase((ObjectKind)kind) ? (String)fcs.first : (String)fcs.second;
                    if (cur != null) {
                        renderer2.append(" (" + cur + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }
                }
            } else if (node.getObject() == "*") {
                renderer2.append(DbNamespacesTree.getAllNodeText((DbNamespaceNode)node), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer2.append("    ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                boolean hovered = MyTreeCellRenderer.isHovered(baseTree, node, DataSourceScopeEditorTree.ADD_PATTERN_TAG);
                renderer2.append(DatabaseBundle.message((String)"label.add.pattern", (Object[])new Object[0]), MyTreeCellRenderer.getLinkAttributes(hovered), (Object)DataSourceScopeEditorTree.ADD_PATTERN_TAG);
            } else {
                Object hovered = node.getObject();
                if (hovered instanceof TreePatternNode.PatternWrapper) {
                    boolean hasError;
                    TreePatternNode.PatternWrapper pattern = (TreePatternNode.PatternWrapper)hovered;
                    String text = pattern.getText();
                    boolean bl = hasError = pattern.getError() != null;
                    if (hasError) {
                        this.setToolTipText(pattern.getError());
                    }
                    MyTreeCellRenderer.renderRegexp(renderer2, text, hasError);
                } else {
                    renderer2.append(StringUtil.isEmpty((String)name) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.unnamed.node.name", (Object[])new Object[0]) : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
                    if (!MyTreeCellRenderer.isStandardKind(kind)) {
                        MyTreeCellRenderer.markExternal(renderer2, kind);
                    }
                }
            }
        }

        @NotNull
        private static SimpleTextAttributes getLinkAttributes(boolean hovered) {
            SimpleTextAttributes base = SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES;
            return !hovered ? base : MyTreeCellRenderer.withStyle(base, base.getStyle() | 0x10);
        }

        @NotNull
        private static SimpleTextAttributes withStyle(SimpleTextAttributes attributes, int style) {
            SimpleTextAttributes simpleTextAttributes = attributes.derive(style, attributes.getFgColor(), attributes.getBgColor(), attributes.getWaveColor());
            if (simpleTextAttributes == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static boolean isHovered(JTree tree, DbNamespaceNode node, String tag) {
            HoverHelper helper = HoverHelper.get(tree);
            if (helper == null || helper.hoveredPath == null) {
                return false;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)helper.hoveredPath.getLastPathComponent(), DefaultMutableTreeNode.class);
            return n != null && n.getUserObject() == node && tag.equals(helper.hoveredTag);
        }

        private static void renderRegexp(ColoredTextContainer renderer2, @NlsSafe String text, boolean hasError) {
            Language regExpLanguage = DataSourceScopeEditorTree.getRegExpLanguage();
            if (regExpLanguage != null) {
                SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)regExpLanguage, null, null);
                EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
                MyTreeCellRenderer.highlightText(text, hasError, renderer2, highlighter, scheme);
            } else {
                renderer2.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static void highlightText(@NlsSafe String text, boolean error, ColoredTextContainer renderer2, SyntaxHighlighter highlighter, EditorColorsScheme scheme) {
            Lexer lexer = highlighter.getHighlightingLexer();
            lexer.start((CharSequence)text);
            while (lexer.getTokenType() != null) {
                IElementType type = lexer.getTokenType();
                TextAttributesKey[] highlights = highlighter.getTokenHighlights(type);
                renderer2.append(StringUtil.notNullize((String)lexer.getTokenText()), MyTreeCellRenderer.getAttributes(scheme, highlights, (TextAttributesKey)(error ? CodeInsightColors.ERRORS_ATTRIBUTES : null)));
                lexer.advance();
            }
        }

        @NotNull
        private static SimpleTextAttributes getAttributes(EditorColorsScheme scheme, TextAttributesKey[] highlights, TextAttributesKey extra) {
            SimpleTextAttributes sa = null;
            if (highlights.length != 0) {
                TextAttributes attributes = null;
                for (TextAttributesKey highlight : highlights) {
                    attributes = TextAttributes.merge((TextAttributes)attributes, (TextAttributes)scheme.getAttributes(highlight));
                }
                if (extra != null) {
                    attributes = TextAttributes.merge(attributes, (TextAttributes)scheme.getAttributes(extra));
                }
                sa = SimpleTextAttributes.fromTextAttributes(attributes);
            }
            if (sa == null) {
                sa = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            SimpleTextAttributes simpleTextAttributes = sa;
            if (simpleTextAttributes == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(3);
            }
            return simpleTextAttributes;
        }

        private static boolean isStandardKind(ObjectKind kind) {
            return kind == ObjectKind.SCHEMA || kind == ObjectKind.DATABASE;
        }

        private static void markExternal(ColoredTextContainer renderer2, ObjectKind kind) {
            if (DbImplUtilCore.isExternalNamespace((ObjectKind)kind)) {
                if (renderer2 instanceof SimpleColoredComponent) {
                    ((SimpleColoredComponent)renderer2).setIconOnTheRight(true);
                }
                renderer2.setIcon(DatabaseIcons.External_link_arrow);
                renderer2.setToolTipText(kind.getPresentableName());
            }
        }

        private void markSubstituted(DbNamespaceNode node, ColoredTextContainer renderer2, BasicNamespace nsp) {
            boolean canSubstitute;
            boolean notRendering = !this.treeIsShowning;
            boolean substituted = notRendering || DataSourceSnapshotManager.getInstance().map((BasicElement)nsp, this.myMapping, false) != null && !node.isChecked();
            boolean bl = canSubstitute = substituted || DataSourceSnapshotManager.getInstance().canSubstitute(nsp, true, false);
            if (canSubstitute) {
                if (renderer2 instanceof SimpleColoredComponent) {
                    ((SimpleColoredComponent)renderer2).setIconOnTheRight(true);
                }
                renderer2.setIcon(substituted ? AllIcons.Actions.Lightning : IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Lightning));
                renderer2.setToolTipText(DatabaseBundle.message((String)(substituted ? "DataSourceScopeEditor.substituted.used" : (DataSourceSnapshotManager.IGNORE_AUTO_MINI_CAT || !this.myMapping.isUseMiniCat() || !node.isChecked() ? "DataSourceScopeEditor.substituted.not.used" : "DataSourceScopeEditor.substituted.not.used.but.will")), (Object[])new Object[0]));
            }
        }

        public String getToolTipText(MouseEvent event) {
            ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
            if (renderer2.getIcon() != null) {
                boolean onIcon;
                Point rp = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)renderer2);
                Dimension size = renderer2.getPreferredSize();
                boolean bl = onIcon = rp.x >= 0 && rp.y >= 0 && rp.x < size.width && rp.y < size.height && rp.x >= size.width - size.height;
                if (onIcon) {
                    return renderer2.getToolTipText();
                }
            }
            return super.getToolTipText(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStyle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final Project myProject;
        private JComponent component;
        private EditorTextField etf;
        private JCheckBox cb;
        private JEditorPane lbl;
        private DbNamespaceNode current;
        private boolean applying;

        MyTreeCellEditor(Project project) {
            if (project == null) {
                MyTreeCellEditor.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent && ((MouseEvent)e).getClickCount() != 2) {
                return false;
            }
            return super.isCellEditable(e);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object o, boolean b, boolean b1, boolean b2, int row) {
            if (this.component == null) {
                this.init();
            }
            this.current = (DbNamespaceNode)DataSourceScopeEditorTree.this.getSearchModel().getUserObject((DefaultMutableTreeNode)((CheckedTreeNode)ObjectUtils.tryCast((Object)o, CheckedTreeNode.class)));
            TreePatternNode.PatternWrapper pattern = this.getPattern();
            this.applying = true;
            this.etf.setText(pattern == null ? null : pattern.getText());
            this.etf.selectAll();
            this.cb.setSelected(this.current != null && this.current.isChecked());
            this.applying = false;
            ObjectKind kind = this.current == null ? null : this.current.getKind();
            this.lbl.setText(new HtmlBuilder().appendRaw(DatabaseBundle.message((String)"label.regexp.for.0", (Object[])new Object[]{(kind == null ? ObjectKind.NONE : kind).getPluralPresentableName()})).wrapWithHtmlBody().toString());
            MyTreeCellEditor.stretch(tree, row, this.component);
            return this.component;
        }

        private static void stretch(JTree tree, int row, JComponent component1) {
            component1.setPreferredSize(null);
            TreePath path = tree.getPathForRow(row);
            Rectangle bounds = tree.getPathBounds(path);
            Dimension size = component1.getPreferredSize();
            RenderingHelper helper = new RenderingHelper((JComponent)tree);
            size.width = helper.getWidth() - helper.getRightMargin() - (bounds == null ? 0 : bounds.x) - size.height;
            component1.setPreferredSize(size);
        }

        private void init() {
            Language regexp = DataSourceScopeEditorTree.getRegExpLanguage();
            LanguageFileType type = regexp == null ? null : FileTypeManager.getInstance().findFileTypeByLanguage(regexp);
            this.etf = new EditorTextField("", this.myProject, (FileType)(type == null ? FileTypes.PLAIN_TEXT : type));
            this.etf.addSettingsProvider(editor2 -> {
                for (JComponent c2 : UIUtil.uiTraverser((Component)editor2.getComponent()).filter(JComponent.class)) {
                    if (c2 instanceof JViewport) continue;
                    c2.setBorder((Border)JBUI.Borders.empty());
                }
                editor2.getContentComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                            e.consume();
                            JTree tree = (JTree)UIUtil.getParentOfType(JTree.class, (Component)MyTreeCellEditor.this.etf);
                            if (tree != null) {
                                tree.stopEditing();
                            }
                        }
                    }
                });
            });
            this.etf.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (MyTreeCellEditor.this.applying) {
                        return;
                    }
                    MyTreeCellEditor.this.applyPattern();
                    CheckedTreeNode node = (CheckedTreeNode)DataSourceScopeEditorTree.this.getSearchModel().getCachedNode((Object)MyTreeCellEditor.this.current);
                    if (node != null) {
                        DataSourceScopeEditorTree.this.getSearchModel().nodeChanged((TreeNode)node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellEditor$2", "documentChanged"));
                }
            });
            this.etf.setBorder((Border)JBUI.Borders.empty());
            this.etf.setBackground(JBUI.CurrentTheme.Tree.Selection.background((boolean)false));
            this.etf.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            this.lbl = MyTreeCellEditor.createRegexpLbl();
            GridLayoutManager layout = new GridLayoutManager(1, 3);
            layout.setHGap(0);
            this.component = new JPanel((LayoutManager)layout);
            GridConstraints constraints = new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, null, null, null);
            this.cb = new JCheckBox();
            this.component.add((Component)this.cb, constraints);
            this.cb.addItemListener(event -> {
                CheckedTreeNode node;
                if (this.applying) {
                    return;
                }
                CheckedTreeNode checkedTreeNode = node = this.current == null ? null : (CheckedTreeNode)DataSourceScopeEditorTree.this.getSearchModel().getCachedNode((Object)this.current);
                if (node != null) {
                    DataSourceScopeEditorTree.this.setNodeState(node, this.cb.isSelected());
                }
            });
            constraints.setColumn(1);
            constraints.setHSizePolicy(7);
            this.component.add((Component)this.etf, constraints);
            constraints.setColumn(2);
            constraints.setHSizePolicy(0);
            this.component.add((Component)this.lbl, constraints);
            this.component.setOpaque(false);
            this.component.setFocusable(false);
            this.component.setFocusCycleRoot(true);
            this.component.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return aContainer == MyTreeCellEditor.this.component ? MyTreeCellEditor.this.etf.getFocusTarget() : super.getDefaultComponent(aContainer);
                }
            });
            this.cb.setOpaque(false);
        }

        private static JEditorPane createRegexpLbl() {
            JEditorPane lbl = new JEditorPane();
            lbl.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
            lbl.setEditable(false);
            lbl.setOpaque(false);
            lbl.addHyperlinkListener(event -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "regexp".equals(event.getDescription())) {
                    RegExHelpPopup.createRegExLinkRunnable((Component)lbl).run();
                }
            });
            lbl.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            return lbl;
        }

        @Nullable
        private TreePatternNode.PatternWrapper getPattern() {
            return this.current == null ? null : (TreePatternNode.PatternWrapper)ObjectUtils.tryCast((Object)this.current.getObject(), TreePatternNode.PatternWrapper.class);
        }

        private void applyPattern() {
            if (this.current == null || this.component == null) {
                return;
            }
            TreePatternNode.PatternWrapper oldP = this.getPattern();
            if (oldP != null && !oldP.getText().equals(this.etf.getText())) {
                TreePatternNode.PatternWrapper newP = TreePatternNode.PatternWrapper.create((String)this.etf.getText());
                this.current.setObject((Object)newP);
                this.current.setName(newP.getText());
            }
            this.current.setChecked(this.cb.isSelected());
        }

        @Override
        public Object getCellEditorValue() {
            this.applyPattern();
            return this.current;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellEditor", "<init>"));
        }
    }

    public static class HoverHelper
    extends MouseAdapter
    implements MouseMotionListener {
        private static final Key<HoverHelper> KEY = Key.create((String)"HoverHelper");
        public TreePath hoveredPath = null;
        public Object hoveredTag = null;

        public static void register(JTree tree) {
            HoverHelper.unregister(tree);
            HoverHelper helper = new HoverHelper();
            ClientProperty.put((JComponent)tree, KEY, (Object)helper);
            tree.addMouseMotionListener(helper);
            tree.addMouseListener(helper);
        }

        public static void unregister(JTree tree) {
            HoverHelper helper = HoverHelper.get(tree);
            if (helper != null) {
                ClientProperty.put((JComponent)tree, KEY, null);
                tree.removeMouseMotionListener(helper);
                tree.removeMouseListener(helper);
            }
        }

        @Nullable
        public static HoverHelper get(JTree tree) {
            return (HoverHelper)ClientProperty.get((Component)tree, KEY);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.updateHover((JTree)ObjectUtils.tryCast((Object)e.getComponent(), JTree.class), null);
        }

        private boolean setHover(TreePath hoveredPath, Object hoveredTag) {
            if (Objects.equals(hoveredPath, this.hoveredPath) && Objects.equals(hoveredTag, this.hoveredTag)) {
                return false;
            }
            this.hoveredPath = hoveredPath;
            this.hoveredTag = hoveredTag;
            return true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateHover(e);
        }

        public void updateHover(MouseEvent e) {
            this.updateHover((JTree)ObjectUtils.tryCast((Object)e.getComponent(), JTree.class), e.getPoint());
        }

        private void updateHover(@Nullable JTree tree, @Nullable Point point) {
            TreePath path;
            TreePath treePath = path = tree == null || point == null ? null : tree.getPathForLocation(point.x, point.y);
            if (this.setHover(path, HoverHelper.getTag(tree, point, path)) && tree != null) {
                Rectangle bounds;
                Rectangle rectangle = bounds = path == null ? null : tree.getPathBounds(path);
                if (bounds != null) {
                    tree.repaint(bounds);
                } else {
                    tree.repaint();
                }
            }
        }

        @Nullable
        private static Object getTag(@Nullable JTree tree, @Nullable Point point, @Nullable TreePath path) {
            Object tag;
            SimpleColoredComponent renderer2;
            if (path == null || point == null || tree == null) {
                return null;
            }
            Rectangle bounds = tree.getPathBounds(path);
            Component component = bounds == null ? null : tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), tree.isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(path.getLastPathComponent()), tree.getRowForPath(path), false);
            SimpleColoredComponent simpleColoredComponent = renderer2 = component == null ? null : (SimpleColoredComponent)UIUtil.findComponentOfType((JComponent)((JComponent)ObjectUtils.tryCast(component, JComponent.class)), SimpleColoredComponent.class);
            if (renderer2 == null) {
                tag = null;
            } else {
                component.setSize(bounds.getSize());
                point.translate(-bounds.x, -bounds.y);
                point = SwingUtilities.convertPoint(component, point, (Component)renderer2);
                tag = new Rectangle(renderer2.getSize()).contains(point) ? renderer2.getFragmentTagAt(point.x) : null;
            }
            return tag;
        }
    }

    private static class ImplicitSelectionCache {
        private final DbCheckBoxTree<DbNamespaceNode> myTree;
        private TreePattern mySelection;
        private final Map<DbNamespaceNode, List<TreePatternNode>> myMatchingCache;

        @NotNull
        private static ImplicitSelectionCache get(@NotNull DbCheckBoxTree<DbNamespaceNode> tree) {
            ImplicitSelectionCache cache;
            if (tree == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(0);
            }
            if ((cache = (ImplicitSelectionCache)UIUtil.getClientProperty(tree, ImplicitSelectionCache.class)) == null) {
                cache = new ImplicitSelectionCache(tree);
                tree.putClientProperty(ImplicitSelectionCache.class, cache);
            }
            ImplicitSelectionCache implicitSelectionCache = cache;
            if (implicitSelectionCache == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(1);
            }
            return implicitSelectionCache;
        }

        private ImplicitSelectionCache(@NotNull DbCheckBoxTree<DbNamespaceNode> tree) {
            if (tree == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(2);
            }
            this.myMatchingCache = FactoryMap.create(this::getMatchingNodes);
            this.myTree = tree;
            this.myTree.getModel().addTreeModelListener(TreeModelAdapter.create((a, b) -> this.clearCaches()));
            tree.addCheckboxTreeListener(new CheckboxTreeListener(){

                public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.clearCaches();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/DataSourceScopeEditorTree$ImplicitSelectionCache$1", "nodeStateChanged"));
                }
            });
        }

        void clearCaches() {
            if (this.mySelection == null) {
                return;
            }
            this.mySelection = null;
            this.myMatchingCache.clear();
        }

        TreePattern getSelection() {
            if (this.mySelection == null) {
                this.mySelection = DbNamespacesTree.buildPattern((DbNamespaceNode)((DbNamespaceNode)this.myTree.getSearchModel().getRootObject()), (boolean)false);
            }
            return this.mySelection;
        }

        boolean isImplicitlySelected(@NotNull DbNamespaceNode node) {
            if (node == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(3);
            }
            return !this.myMatchingCache.get(node).isEmpty();
        }

        List<TreePatternNode> getMatchingNodes(@NotNull DbNamespaceNode node) {
            DbNamespaceNode parent;
            if (node == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(4);
            }
            if ((parent = (DbNamespaceNode)node.getParent()) == null) {
                return Collections.singletonList(this.getSelection().root);
            }
            ObjectKind kind = node.getKind();
            if (kind == null) {
                return Collections.emptyList();
            }
            List<TreePatternNode> parentMatches = this.myMatchingCache.get(parent);
            if (parentMatches.isEmpty()) {
                return Collections.emptyList();
            }
            Condition<TreePatternNode.BaseNaming> matcher = ImplicitSelectionCache.createMatcher(node);
            if (matcher == null) {
                return Collections.emptyList();
            }
            LinkedHashSet<TreePatternNode> res2 = new LinkedHashSet<TreePatternNode>();
            for (TreePatternNode pm : parentMatches) {
                TreePatternNode.Group g = pm.getGroup(kind);
                if (g == null || g.children == null) continue;
                for (TreePatternNode c2 : g.children) {
                    if (!matcher.value((Object)c2.naming)) continue;
                    res2.add(c2);
                }
            }
            return new ArrayList<TreePatternNode>(res2);
        }

        @Nullable
        private static Condition<TreePatternNode.BaseNaming> createMatcher(@NotNull DbNamespaceNode node) {
            Object object;
            if (node == null) {
                ImplicitSelectionCache.$$$reportNull$$$0(5);
            }
            if ((object = node.getObject()) instanceof DasObject) {
                DasObject das = (DasObject)object;
                boolean current = das instanceof BasicMateNamespace && ((BasicMateNamespace)das).isCurrent();
                ObjectName name = TreePatternUtils.nameOf((DasObject)das);
                Casing casing = DbImplUtilCore.getCasingProvider((DasObject)das).getCasing(das.getKind(), das);
                return n -> n.matches(name, casing) || current && n.matches(ObjectName.quoted((String)"@"), null);
            }
            if (object instanceof String) {
                String s = (String)object;
                ObjectName name = ObjectName.quoted((String)s);
                return n -> n.matches(name, null);
            }
            if (object instanceof TreePatternNode.PatternWrapper) {
                TreePatternNode.PatternWrapper pw = (TreePatternNode.PatternWrapper)object;
                return n -> n instanceof TreePatternNode.NegativeNaming && ContainerUtil.find((Iterable)SmartPredicate.orTerms((SmartPredicate)((TreePatternNode.NegativeNaming)n).pattern, (boolean)false), (Object)pw) != null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$ImplicitSelectionCache";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$ImplicitSelectionCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isImplicitlySelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getMatchingNodes";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createMatcher";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

