/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.connectivity.dataSource.AbstractDataSourceManager;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class LocalDataSourceManager
extends AbstractDataSourceManager<LocalDataSource> {
    private static final String LRU_KEY = "DatabaseDriversLRU";
    private final DataSourceStorage myProjectStorage;

    @NotNull
    public static LocalDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(0);
        }
        LocalDataSourceManager localDataSourceManager = Objects.requireNonNull((LocalDataSourceManager)((Object)ContainerUtil.findInstance((Iterable)EP_NAME.getExtensions((AreaInstance)project), LocalDataSourceManager.class)));
        if (localDataSourceManager == null) {
            LocalDataSourceManager.$$$reportNull$$$0(1);
        }
        return localDataSourceManager;
    }

    public LocalDataSourceManager(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(2);
        }
        super(project, DataSourceStorage.getProjectStorage((Project)project).getDataSources());
        this.myProjectStorage = DataSourceStorage.getProjectStorage((Project)project);
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDataSourceManager.this.attachDataSource((RawDataSource)dataSource);
            }

            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalDataSourceManager.this.detachDataSource((RawDataSource)dataSource);
            }

            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null) {
                    LocalDataSourceManager.this.resetElementMap(LocalDataSourceManager.this.myProjectStorage.getDataSources());
                } else {
                    LocalDataSourceManager.this.updateDataSource((RawDataSource)dataSource);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isLoading(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(3);
        }
        return this.myProjectStorage.isLoading(element);
    }

    public void addDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(4);
        }
        this.myProjectStorage.addDataSource(element);
    }

    public void removeDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(5);
        }
        this.myProjectStorage.removeDataSource(element);
    }

    public void renameDataSource(@NotNull LocalDataSource element, @NotNull String name) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(6);
        }
        if (name == null) {
            LocalDataSourceManager.$$$reportNull$$$0(7);
        }
        element.setName(name);
        this.myProjectStorage.updateDataSource(element);
    }

    protected void saveDataSource(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(8);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(9);
        }
        return new DataSourceConfigurable(this, element, this.myProject);
    }

    @NotNull
    public AnAction getCreateDataSourceAction(@NotNull Consumer<? super LocalDataSource> consumer) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(10);
        }
        List<AnAction> actions = this.getCreateDataSourceActions(DatabaseDriverManager.getInstance().getDrivers(), consumer);
        NewDataSourceActionGroup group = new NewDataSourceActionGroup(actions);
        group.setPopup(true);
        group.getTemplatePresentation().setIcon(DatabaseIcons.Dbms);
        NewDataSourceActionGroup newDataSourceActionGroup = group;
        if (newDataSourceActionGroup == null) {
            LocalDataSourceManager.$$$reportNull$$$0(11);
        }
        return newDataSourceActionGroup;
    }

    @NotNull
    public LocalDataSource createEmpty() {
        return new LocalDataSource();
    }

    @NotNull
    public List<AnAction> getCreateDataSourceActions(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull Consumer<? super LocalDataSource> consumer) {
        if (allDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(13);
        }
        Consumer cachingConsumer = driver -> {
            DatabaseViewActions.addToLRUNames(this.myProject, 5, LRU_KEY, this.getDriverKey((DatabaseDriver)driver));
            consumer.consume((Object)driver.createDataSource(null));
        };
        List<String> lruNames = DatabaseViewActions.getLRUNames(this.myProject, LRU_KEY);
        LinkedHashMap<String, DatabaseDriver> fromLru = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> completeSupport = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> userCreated = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> basicSupport = new LinkedHashMap<String, DatabaseDriver>();
        MultiMap allDriversMap = MultiMap.createLinked();
        for (DatabaseDriver databaseDriver : allDrivers) {
            String key = this.getDriverKey(databaseDriver);
            allDriversMap.putValue((Object)key, (Object)databaseDriver);
            if (lruNames.contains(key)) {
                fromLru.putIfAbsent(key, databaseDriver);
                if (!databaseDriver.isPredefined() || !LocalDataSourceManager.isGenericSupport(databaseDriver)) continue;
                basicSupport.putIfAbsent(key, databaseDriver);
                continue;
            }
            if (!databaseDriver.isPredefined()) {
                userCreated.putIfAbsent(key, databaseDriver);
                continue;
            }
            if (!LocalDataSourceManager.isGenericSupport(databaseDriver)) {
                completeSupport.putIfAbsent(key, databaseDriver);
                continue;
            }
            basicSupport.putIfAbsent(key, databaseDriver);
        }
        List topLevel = ContainerUtil.mapNotNull((Collection)allDriversMap.entrySet(), e -> (DatabaseDriver)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())));
        Function<DatabaseDriver, @NlsActions.ActionText String> function = LocalDataSourceManager.getDisplayDriverNamer(topLevel);
        Function<DatabaseDriver, Collection<? extends DatabaseDriver>> children = d -> allDriversMap.get((Object)this.getDriverKey((DatabaseDriver)d));
        Comparator<DatabaseDriver> comparator = Comparator.comparing(function);
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        this.addActions(Separator.create((String)DatabaseBundle.message((String)"separator.data.sources.recent", (Object[])new Object[0])), result, fromLru.values(), Comparator.comparingInt(o -> lruNames.indexOf(this.getDriverKey((DatabaseDriver)o))).thenComparing(comparator), (Consumer<? super DatabaseDriver>)cachingConsumer, function, children);
        this.addActions(Separator.create((String)DatabaseBundle.message((String)"separator.user.drivers", (Object[])new Object[0])), result, userCreated.values(), comparator, (Consumer<? super DatabaseDriver>)cachingConsumer, function, children);
        this.addActions(Separator.create((String)DatabaseBundle.message((String)"separator.complete.support", (Object[])new Object[0])), result, completeSupport.values(), comparator, (Consumer<? super DatabaseDriver>)cachingConsumer, function, children);
        if (!basicSupport.isEmpty()) {
            result.add((AnAction)Separator.getInstance());
            DefaultActionGroup other = new DefaultActionGroup(DatabaseBundle.message((String)"action.data.sources.other.text", (Object[])new Object[0]), true);
            result.add((AnAction)other);
            other.addSeparator(DatabaseBundle.message((String)"separator.basic.support", (Object[])new Object[0]));
            Comparator<DatabaseDriver> bc = Comparator.comparing(d -> LocalDataSourceManager.getExtraSection(d), Comparing::compare).thenComparing(comparator);
            String ps = null;
            for (DatabaseDriver driver3 : ContainerUtil.sorted(basicSupport.values(), bc)) {
                String section = LocalDataSourceManager.getExtraSection(driver3);
                if (!Objects.equals(ps, section)) {
                    other.addSeparator(section);
                    ps = section;
                }
                other.add(this.createAction((Consumer<? super DatabaseDriver>)cachingConsumer, driver3, children.apply(driver3), function.apply(driver3)));
            }
        }
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public static boolean isGenericSupport(DatabaseDriver driver) {
        return DbImplUtil.isGenericSupport((Dbms)DbImplUtilCore.getDbms((DatabaseDriver)driver)) || LocalDataSourceManager.getExtraSection(driver) != null;
    }

    @NlsSafe
    @Nullable
    public static String getExtraSection(DatabaseDriver d) {
        String comment = d.getComment();
        return comment != null && comment.endsWith("drivers.xml") ? comment : null;
    }

    public void addActions(@Nullable Separator separator, List<? super AnAction> result, Iterable<? extends DatabaseDriver> drivers, Comparator<? super DatabaseDriver> comparator, @NotNull Consumer<? super DatabaseDriver> consumer, @NotNull Function<DatabaseDriver, @NlsActions.ActionText String> driverNames, @NotNull Function<DatabaseDriver, Collection<? extends DatabaseDriver>> children) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(15);
        }
        if (driverNames == null) {
            LocalDataSourceManager.$$$reportNull$$$0(16);
        }
        if (children == null) {
            LocalDataSourceManager.$$$reportNull$$$0(17);
        }
        if (separator != null) {
            result.add((AnAction)separator);
        }
        for (DatabaseDriver driver : ContainerUtil.sorted(drivers, comparator)) {
            result.add((AnAction)this.createAction(consumer, driver, children.apply(driver), driverNames.apply(driver)));
        }
    }

    @NotNull
    private AnAction createAction(final @NotNull Consumer<? super DatabaseDriver> consumer, final @NotNull DatabaseDriver defaultDriver, @NotNull Collection<? extends DatabaseDriver> subDrivers, @NlsActions.ActionText String name) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(18);
        }
        if (defaultDriver == null) {
            LocalDataSourceManager.$$$reportNull$$$0(19);
        }
        if (subDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(20);
        }
        final AnAction[] children = ContainerUtil.getOnlyItem(subDrivers) == defaultDriver ? AnAction.EMPTY_ARRAY : ContainerUtil.map(subDrivers, d -> new DumbAwareAction(this, d.getName(), null, d.getIcon(0), (Consumer)consumer, (DatabaseDriver)d){
            final /* synthetic */ Consumer val$consumer;
            final /* synthetic */ DatabaseDriver val$d;
            {
                this.val$consumer = consumer;
                this.val$d = databaseDriver;
                super(arg0, arg1, arg2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$consumer.consume((Object)this.val$d);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/LocalDataSourceManager$2", "actionPerformed"));
            }
        }).toArray(AnAction.EMPTY_ARRAY);
        return new ActionGroup(this, name, null, defaultDriver.getIcon(0)){

            public boolean isDumbAware() {
                return true;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.update(e);
                e.getPresentation().setPerformGroup(true);
                e.getPresentation().setPopupGroup(true);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                consumer.consume((Object)defaultDriver);
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = e == null ? AnAction.EMPTY_ARRAY : children;
                if (anActionArray == null) {
                    3.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public String getDriverKey(DatabaseDriver o) {
        return o.isPredefined() && LocalDataSourceManager.getExtraSection(o) == null ? LocalDataSourceManager.predefinedDriverKey(o) : o.getId();
    }

    private static String predefinedDriverKey(DatabaseDriver o) {
        DatabaseDriverImpl d;
        if (o instanceof DatabaseDriverImpl && (d = (DatabaseDriverImpl)o).getGroupWithId() != null) {
            return d.getGroupWithId();
        }
        String id = o.getId();
        int dotIdx = id.lastIndexOf(".");
        String beforeDot = dotIdx == -1 ? id : id.substring(0, dotIdx);
        return StringUtil.trimEnd((String)beforeDot, (String)"_aurora");
    }

    public static @NotNull Function<DatabaseDriver, @NlsActions.ActionText String> getDisplayDriverNamer(Collection<DatabaseDriver> drivers) {
        MultiMap nameToDriver = MultiMap.create();
        HashMap<DatabaseDriver, @NlsActions.ActionText String> driverToName = new HashMap<DatabaseDriver, String>();
        for (DatabaseDriver driver : drivers) {
            String name = LocalDataSourceManager.getDisplayDriverName(driver);
            driverToName.put(driver, name);
            nameToDriver.putValue((Object)name, (Object)driver);
        }
        for (Map.Entry entry : nameToDriver.entrySet()) {
            if (((Collection)entry.getValue()).size() < 2) continue;
            for (DatabaseDriver driver : (Collection)entry.getValue()) {
                driverToName.put(driver, driver.getName());
            }
        }
        Function<DatabaseDriver, String> function = d -> driverToName.getOrDefault(d, d.getName());
        if (function == null) {
            LocalDataSourceManager.$$$reportNull$$$0(21);
        }
        return function;
    }

    @NlsActions.ActionText
    @NotNull
    private static String getDisplayDriverName(DatabaseDriver o) {
        Dbms dbms = DbImplUtilCore.getDbms((DatabaseDriver)o);
        if (!o.isPredefined() || LocalDataSourceManager.getExtraSection(o) != null) {
            String string = o.getName();
            if (string == null) {
                LocalDataSourceManager.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = dbms == Dbms.UNKNOWN ? o.getName() : dbms.getDisplayName();
        if (string == null) {
            LocalDataSourceManager.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public LocalDataSource copyDataSource(@NotNull String newName, @NotNull LocalDataSource copyFrom) {
        if (newName == null) {
            LocalDataSourceManager.$$$reportNull$$$0(24);
        }
        if (copyFrom == null) {
            LocalDataSourceManager.$$$reportNull$$$0(25);
        }
        LocalDataSource result = copyFrom.copy(false);
        result.setName(StringUtil.notNullize((String)newName));
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(26);
        }
        return localDataSource;
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(27);
        }
        for (VirtualFile file : files2) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<LocalDataSource> createDataSourceByFiles(@NotNull DatabaseCredentials credentials, @NotNull List<VirtualFile> files2) {
        if (credentials == null) {
            LocalDataSourceManager.$$$reportNull$$$0(28);
        }
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(29);
        }
        final ArrayList<LocalDataSource> result = new ArrayList<LocalDataSource>();
        DataSourceRegistry registry = new DataSourceRegistry(this.myProject);
        registry.setImportedFlag(false);
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(this){

            public void onCreated(@NotNull DasDataSource dataSource) {
                if (dataSource == null) {
                    4.$$$reportNull$$$0(0);
                }
                result.add((LocalDataSource)dataSource);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/LocalDataSourceManager$4", "onCreated"));
            }
        };
        for (VirtualFile file : files2) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType)) continue;
            Dbms dbms = ((DbStorageFileType)fileType).getDbms();
            String defaultName = DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)file.getNameWithoutExtension());
            final String path = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
            DataSourceConfigUtil.buildDataSource(dbms, defaultName, null, null, new DataSourceConfiguration(){

                @Override
                public String getDatabase() {
                    return path;
                }
            }, registry.getBuilder().withCallback(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myProject, registry, true, true, credentials);
        ArrayList<LocalDataSource> arrayList = result;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public boolean isMyDataSource(@NotNull Class<? extends DasDataSource> clazz) {
        if (clazz == null) {
            LocalDataSourceManager.$$$reportNull$$$0(31);
        }
        return LocalDataSource.class.isAssignableFrom(clazz);
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(32);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(33);
        }
        return DbImplUtilCore.guessDatabaseDialect((RawConnectionConfig)element);
    }

    @Nullable
    public Language getQueryLanguage(@NotNull LocalDataSource element) {
        Language language;
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(34);
        }
        if ((language = DbSqlUtilCore.findLanguage((LocalDataSource)element)) instanceof SqlLanguageDialect) {
            SqlLanguageDialect sl = (SqlLanguageDialect)language;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile file = DatabaseEditorHelper.getDataSourceRootDir((DasDataSource)element);
                if (file != null) {
                    SqlPsiFacade.getInstance((Project)this.myProject).getDialectPusherKey().setPersistentValue(file, (Object)sl);
                }
            });
        }
        return language;
    }

    @Nullable
    public Language getPushedQueryLanguage(@NotNull LocalDataSource element) {
        VirtualFile file;
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(35);
        }
        return (file = DatabaseEditorHelper.getDataSourceRootDir((DasDataSource)element)) == null ? null : (Language)SqlPsiFacade.getInstance((Project)this.myProject).getDialectPusherKey().getPersistentValue(file);
    }

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource source) {
        if (source == null) {
            LocalDataSourceManager.$$$reportNull$$$0(36);
        }
        Promise promise = this.myProjectStorage.getLoadingPromise(source);
        if (promise == null) {
            LocalDataSourceManager.$$$reportNull$$$0(37);
        }
        return promise;
    }

    public String toString() {
        return "%s(project %s and %d data sources)".formatted(LocalDataSourceManager.class.getSimpleName(), this.myProject.getName(), this.myProjectStorage.getCount());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 14, 21, 22, 23, 26, 30, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverNames";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDriver";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDrivers";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverNamer";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceActions";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isMyDataSource";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getQueryLanguage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPushedQueryLanguage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 14, 21, 22, 23, 26, 30, 37 -> new IllegalStateException(string);
        };
    }

    static class NewDataSourceActionGroup
    extends DefaultActionGroup {
        NewDataSourceActionGroup(List<AnAction> actions) {
            super(DatabaseBundle.messagePointer((String)"default.datasource.name", (Object[])new Object[0]), actions);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewDataSourceActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewDataSourceActionGroup.$$$reportNull$$$0(1);
            }
            e.getPresentation().putClientProperty(ActionUtil.SHOW_ICON_IN_MAIN_MENU, (Object)true);
            if (!DatabaseViewActions.isDataSourceActionsEnabled(e)) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager$NewDataSourceActionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$NewDataSourceActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

