/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.ArtifactProblemFix;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.ChangePasswordFix;
import com.intellij.database.dialects.DatabaseAlterLoginHelper;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFixFactoryImpl
implements DatabaseFixFactory {
    @Nullable
    public ErrorInfo.Fix changeDriverClass(@Nullable DatabaseDriver driver) {
        return driver == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message((String)"DatabaseErrorHandler.change.driver.class", (Object[])new Object[0]), driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusDriverClassSelector));
    }

    @Nullable
    public ErrorInfo.Fix changeKeepAliveQuery(@Nullable DatabaseDriver driver) {
        return driver == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message((String)"change.driver.keep.alive.query", (Object[])new Object[0]), driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusKeepAliveField));
    }

    @Nullable
    public ErrorInfo.Fix editDriver(@Nullable DatabaseDriver driver) {
        return driver == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message((String)"DatabaseErrorHandler.edit.driver", (Object[])new Object[0]), driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {}));
    }

    @Nullable
    public ErrorInfo.Fix addLibraryPath(@NotNull @Nls String message, @Nullable DatabaseDriver driver, boolean isNative) {
        if (message == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(0);
        }
        return driver == null ? null : DatabaseFixFactoryImpl.settingsFix(message, driver, true, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> c2.getClassPathPanel().addCustomDrivers(true)));
    }

    @NotNull
    public ErrorInfo.Fix switchToLatestDriver(final @NotNull LocalDataSource dataSource, final boolean downloaded) {
        if (dataSource == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(1);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return DatabaseBundle.message((String)(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver"), (Object[])new Object[0]);
            }

            public void apply(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseConfigEditor editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                final NamedProgressive task = DatabaseDriverValidator.createDownloaderTask(dataSource, editor2, project);
                new Task.Modal(this, project, task.getName(), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        task.run(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseFixFactoryImpl$1$1", "run"));
                    }
                }.queue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$1", "apply"));
            }
        };
    }

    @Nullable
    public ErrorInfo.Fix changePassword(@NotNull DatabaseConnectionConfig config) {
        if (config == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(2);
        }
        return !DatabaseAlterLoginHelper.canAlterLogin(config) ? null : new ChangePasswordFix(config);
    }

    @Nullable
    public ErrorInfo.Fix setVmEnv(@Nls @NotNull String text, @NotNull LocalDataSource dataSource, @NotNull String name, @Nullable String val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(4);
        }
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(5);
        }
        return DatabaseFixFactoryImpl.settingsFix(text, dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.getVmEnv().put(name, val)));
            DatabaseFixFactoryImpl.focusVmEnv(c2);
        }));
    }

    @Nullable
    public ErrorInfo.Fix setOption(@Nls @NotNull String text, @NotNull LocalDataSource dataSource, @NotNull String name, @Nullable String val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(8);
        }
        return DatabaseFixFactoryImpl.settingsFix(text, dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.setVmOptions(DatabaseFixFactoryImpl.setOption(ds.getVmOptions(), name, val))));
            DatabaseFixFactoryImpl.focusVmOptions(c2);
        }));
    }

    @Nullable
    public <Target, V> ErrorInfo.Fix setOption(@Nls @NotNull String text, @NotNull Target target, @NotNull DbOptionProvider<Target, V> option, V val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(9);
        }
        if (target == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(10);
        }
        if (option == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(11);
        }
        if (target instanceof LocalDataSource) {
            LocalDataSource targetDs = (LocalDataSource)target;
            return DatabaseFixFactoryImpl.setOption(text, targetDs, option, val);
        }
        if (target instanceof DatabaseDriver) {
            DatabaseDriver targetDr = (DatabaseDriver)target;
            return DatabaseFixFactoryImpl.setOption(text, targetDr, option, val);
        }
        return null;
    }

    @NotNull
    private static <V> ErrorInfo.Fix setOption(@Nls @NotNull String text, LocalDataSource target, DbOptionProvider<LocalDataSource, V> option, V val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(12);
        }
        return DatabaseFixFactoryImpl.settingsFix(text, target, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> option.store(ds, val)))));
    }

    @NotNull
    private static <V> ErrorInfo.Fix setOption(@Nls @NotNull String text, DatabaseDriver target, DbOptionProvider<DatabaseDriver, V> option, V val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(13);
        }
        ErrorInfo.Fix fix = DatabaseFixFactoryImpl.settingsFix(text, target, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)ds -> option.store(ds, val)), c2)));
        if (fix == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(14);
        }
        return fix;
    }

    @Nullable
    public ErrorInfo.Fix setOption(@Nls @NotNull String text, @NotNull DatabaseDriver driver, @NotNull String name, @Nullable String val) {
        if (text == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(15);
        }
        if (driver == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(16);
        }
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(17);
        }
        return DatabaseFixFactoryImpl.settingsFix(text, driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)dr -> dr.setVmOptions(DatabaseFixFactoryImpl.setOption(dr.getVmOptions(), name, val))), c2);
            DatabaseFixFactoryImpl.focusVmOptions(c2);
        }));
    }

    @Nullable
    public ErrorInfo.Fix enableSSL(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        DataSourceSslConfiguration ssl = dataSource.getSslCfg();
        if (ssl == null || !ssl.myEnabled) {
            return DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message((String)"enable.ssl", (Object[])new Object[0]), dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
                DataSourceSslConfiguration cur = ds.getSslCfg();
                if (cur == null) {
                    cur = new DataSourceSslConfiguration(true, JdbcSettings.SslMode.REQUIRE);
                } else {
                    cur.myEnabled = true;
                }
                ds.setSslCfg(cur);
            }))));
        }
        return null;
    }

    @Nullable
    public ErrorInfo.Fix setDriverProperty(@Nullable LocalDataSource dataSource, @Nls @NotNull String message, @NotNull String prop, @Nullable String value) {
        if (message == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(18);
        }
        if (prop == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(19);
        }
        return dataSource == null ? null : DatabaseFixFactoryImpl.settingsFix(message, dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> DatabaseFixFactoryImpl.setDriverProperty(configurable, prop, value)));
    }

    private static void setDriverProperty(@NotNull DataSourceConfigurable configurable, @NotNull String prop, @Nullable String value) {
        if (configurable == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(20);
        }
        if (prop == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(21);
        }
        DataSourceUiUtil.modify(configurable, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
            if (value != null) {
                ds.getDriverProperties().put(prop, value);
            } else {
                ds.getDriverProperties().remove(prop);
            }
        }));
        JComponent panel2 = configurable.selectAdvancedPanel();
        IdeFocusManager.getInstance((Project)configurable.getProject()).doWhenFocusSettlesDown(() -> {
            TableView props = (TableView)UIUtil.uiTraverser((Component)panel2).filter(TableView.class).first();
            if (props != null) {
                for (int i = 0; i < props.getRowCount(); ++i) {
                    if (!prop.equals(props.getModel().getValueAt(i, 0))) continue;
                    int vi = props.getRowSorter() == null ? i : props.getRowSorter().convertRowIndexToView(i);
                    props.setRowSelectionInterval(vi, vi);
                    TableUtil.scrollSelectionToVisible((JTable)props);
                    break;
                }
            }
        });
    }

    public static void focusVmOptions(AbstractDatabaseConfigurable<?> c2) {
        JComponent panel2;
        String ex;
        if (c2 instanceof DataSourceConfigurable) {
            DataSourceConfigurable dsc = (DataSourceConfigurable)c2;
            ex = dsc.getTempDataSource().getVmOptions();
            panel2 = dsc.selectAdvancedPanel();
        } else if (c2 instanceof DatabaseDriverConfigurable) {
            DatabaseDriverConfigurable drc = (DatabaseDriverConfigurable)c2;
            ex = drc.getTempDriver().getVmOptions();
            panel2 = drc.selectAdvancedPanel();
        } else {
            return;
        }
        Condition filter = e -> e.getText().equals(ex);
        Project project = c2.getProject();
        DatabaseFixFactoryImpl.findComponent(project, panel2, RawCommandLineEditor.class, filter, e -> {
            if (e != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)e.getTextField(), true);
            }
        });
    }

    public static void focusVmEnv(AbstractDatabaseConfigurable<?> c2) {
        JComponent panel2;
        if (c2 instanceof DataSourceConfigurable) {
            DataSourceConfigurable dsc = (DataSourceConfigurable)c2;
            panel2 = dsc.selectAdvancedPanel();
        } else if (c2 instanceof DatabaseDriverConfigurable) {
            DatabaseDriverConfigurable drc = (DatabaseDriverConfigurable)c2;
            panel2 = drc.selectAdvancedPanel();
        } else {
            return;
        }
        Project project = c2.getProject();
        DatabaseFixFactoryImpl.findComponent(project, panel2, EnvironmentVariablesTextFieldWithBrowseButton.class, null, e -> {
            if (e != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)e.getTextField(), true);
            }
        });
    }

    private static <T extends Component> void findComponent(Project project, JComponent panel2, Class<T> clazz, Condition<? super T> filter, Consumer<? super T> consumer) {
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
            JBIterable editors2 = UIUtil.uiTraverser((Component)panel2).filter(clazz).collect();
            consumer.consume((filter == null ? editors2 : editors2.filter(filter)).append((Iterable)editors2).first());
        });
    }

    @Nullable
    private static String setOption(@Nullable String options, @NotNull String name, @Nullable String val) {
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(22);
        }
        ParametersList list = new ParametersList();
        list.addParametersString(options);
        if (val == null) {
            list.replaceOrAppend("-D" + name, "");
        } else {
            list.addProperty(name, val);
        }
        return StringUtil.nullize((String)list.getParametersString());
    }

    @Nullable
    public ErrorInfo.Fix setVmOptions(@NotNull @Nls String message, @Nullable LocalDataSource dataSource, @NotNull String options) {
        if (message == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(23);
        }
        if (options == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return dataSource == null ? null : DatabaseFixFactoryImpl.settingsFix(message, dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> {
            DataSourceUiUtil.modify(configurable, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.setVmOptions(options)));
            DatabaseFixFactoryImpl.focusVmOptions(configurable);
        }));
    }

    @NotNull
    public static ErrorInfo.Fix settingsFix(final @Nls @NotNull String name, final @NotNull LocalDataSource ds, final @NotNull Consumer<? super DataSourceConfigurable> consumer) {
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(25);
        }
        if (ds == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(27);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return name;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor2;
                if (dataContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                DataSourceUiUtil.navigate(editor2, ds, (Consumer<? super DataSourceConfigurable>)consumer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$2", "apply"));
            }
        };
    }

    @Nullable
    private static ErrorInfo.Fix settingsFix(@Nls @NotNull String name, @Nullable DatabaseDriver dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer) {
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(29);
        }
        return dr == null ? null : DatabaseFixFactoryImpl.settingsFix(name, dr, true, consumer);
    }

    @NotNull
    private static ErrorInfo.Fix settingsFix(final @Nls @NotNull String name, final @NotNull DatabaseDriver dr, final boolean navigate, final @NotNull Consumer<? super DatabaseDriverConfigurable> consumer) {
        if (name == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(30);
        }
        if (dr == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(32);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return name;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor2;
                if (dataContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                if (navigate) {
                    DataSourceUiUtil.navigate(editor2, dr, (Consumer<? super DatabaseDriverConfigurable>)consumer);
                } else {
                    DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)editor2.getConfigurable((Object)dr, true, DatabaseDriverConfigurable.class));
                    if (configurable != null) {
                        consumer.consume((Object)configurable);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$3", "apply"));
            }
        };
    }

    @Nullable
    public ErrorInfo.Fix setUpArtifact(DatabaseDriver driver, boolean navigate, Supplier<// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DatabaseArtifactList.ArtifactVersion> artifact) {
        return DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message((String)"set.up.required.libraries", (Object[])new Object[0]), driver, navigate, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)configurable -> {
            DatabaseArtifactList.ArtifactVersion version = (DatabaseArtifactList.ArtifactVersion)artifact.get();
            if (version == null) {
                return;
            }
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)d -> d.getArtifacts().add(DatabaseDriverImpl.createArtifactRef((String)version.artifact.id, (Version)version.version, (String)"stable"))), configurable);
            DatabaseFixFactoryImpl.download(driver, configurable, version);
        }));
    }

    public static void download(DatabaseDriver driver, DatabaseDriverConfigurable configurable, DatabaseArtifactList.ArtifactVersion artifact) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        final NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(artifact, driver, configurable.getController(), configurable.getProject());
        if (indicator != null) {
            downloader.run(indicator);
        } else {
            new Task.Modal(configurable.getProject(), configurable.getCommonBar(), downloader.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    downloader.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseFixFactoryImpl$4", "run"));
                }
            }.queue();
        }
    }

    @NotNull
    public ErrorInfo.Fix setAuthProvider(@NotNull LocalDataSource target, @NotNull @Nls String message, String providerId) {
        if (target == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(33);
        }
        if (message == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(34);
        }
        return DatabaseFixFactoryImpl.settingsFix(message, target, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DatabaseAuthProvider provider = DatabaseAuthProvider.get((String)providerId);
            c2.getUrlEditor().getAuthPanel().validateAuthTypes((DatabaseConnectionConfig)target, provider);
        }));
    }

    @NotNull
    public ErrorInfo.Fix setUrl(@NotNull LocalDataSource target, @Nls @NotNull String message, String url) {
        if (target == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(35);
        }
        if (message == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(36);
        }
        return DatabaseFixFactoryImpl.settingsFix(message, target, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DynamicJdbcUrlEditor editor2 = c2.getUrlEditor();
            editor2.setUrl(StringUtil.notNullize((String)url), editor2.isUrlOnly());
            editor2.requestUrlFocus();
        }));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ErrorInfo.Fix switchToLatestDriver(final ArtifactProblemFix fix) {
        return new ErrorInfo.Fix(){

            @NotNull
            public String getName() {
                String string = DatabaseBundle.message((String)"DataSourceConfigurable.transfer.driver", (Object[])new Object[0]);
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void apply(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    5.$$$reportNull$$$0(1);
                }
                for (Function0 action : fix.getFixActions()) {
                    action.invoke();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/DatabaseFixFactoryImpl$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/DatabaseFixFactoryImpl$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DatabaseFixFactoryImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DatabaseFixFactoryImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "switchToLatestDriver";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changePassword";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 14: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDriverProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setVmOptions";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "settingsFix";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setAuthProvider";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

