/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element) {
        DbElement psiElement;
        if (element == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        Project project = element.getProject();
        DbElement extracted = DbNavigationUtils.extractDbElementFromPsi(element);
        DbElement dbElement = extracted != null ? extracted : (psiElement = element instanceof DasObject ? (DasObject)element : (DasObject)SqlPsiFacade.getInstance((Project)project).findRelatedDbElements(element, false).first());
        if (psiElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DbViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        LinkedHashMap<DasObject, GotoRelatedItem> result = new LinkedHashMap<DasObject, GotoRelatedItem>();
        ArrayList<GotoRelatedItem> resultExt = new ArrayList<GotoRelatedItem>();
        if (psiElement instanceof DasColumn) {
            DbViewGotoRelatedProvider.addForeignKeys(project, result, (DasColumn)psiElement);
        } else if (psiElement instanceof DasTableChild) {
            if (psiElement instanceof DasForeignKey) {
                DbViewGotoRelatedProvider.addItems(result, (MultiRef<? extends DasTypedObject>)((DasForeignKey)psiElement).getRefColumns(), DatabaseBundle.message((String)"separator.referenced", (Object[])new Object[0]));
            }
            if (psiElement instanceof DasConstraint) {
                String group = psiElement instanceof DasForeignKey ? DatabaseBundle.message((String)"separator.referring", (Object[])new Object[0]) : "";
                DbViewGotoRelatedProvider.addItems(result, (MultiRef<? extends DasTypedObject>)((DasConstraint)psiElement).getColumnsRef(), group);
            } else if (psiElement instanceof DasIndex) {
                DbViewGotoRelatedProvider.addItems(result, (MultiRef<? extends DasTypedObject>)((DasIndex)psiElement).getColumnsRef(), "");
            }
        } else if (psiElement instanceof DasSynonym) {
            DbViewGotoRelatedProvider.addItem(result, ((DasSynonym)psiElement).resolveTarget());
        } else if (psiElement instanceof DbDataSource) {
            DbDataSource dataSource = (DbDataSource)psiElement;
            DbViewGotoRelatedProvider.addAssociations(project, result, dataSource);
            DbViewGotoRelatedProvider.addDataSourceFiles((DasDataSource)dataSource, resultExt, element.getManager());
        }
        DbViewGotoRelatedProvider.addPredecessors((DasObject)psiElement, result);
        DbViewGotoRelatedProvider.addSuccessors((DasObject)psiElement, result);
        ArrayList res2 = new ArrayList(result.values());
        res2.addAll(resultExt);
        ArrayList arrayList = res2;
        if (arrayList == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addForeignKeys(Project project, Map<DasObject, GotoRelatedItem> result, DasColumn columnInfo) {
        DbViewGotoRelatedProvider.addForeignKeys(project, result, columnInfo, true);
        DbViewGotoRelatedProvider.addForeignKeys(project, result, columnInfo, false);
    }

    private static void addForeignKeys(Project project, Map<DasObject, GotoRelatedItem> result, DasColumn columnInfo, boolean direct) {
        JBIterable keys = direct ? ModelRelationManager.getForeignKeys((Project)project, (DasTable)columnInfo.getTable()) : ModelRelationManager.getExportedKeys((Project)project, (DasTable)columnInfo.getTable());
        for (DasForeignKey keyInfo : keys) {
            MultiRef r1 = keyInfo.getColumnsRef();
            MultiRef r2 = keyInfo.getRefColumns();
            MultiRef.It it = (direct ? r1 : r2).iterate();
            MultiRef.It it2 = (direct ? r2 : r1).iterate();
            while (it.hasNext()) {
                String next = (String)it.next();
                if (it2.hasNext()) {
                    it2.next();
                }
                if (!Objects.equals(next, columnInfo.getName())) continue;
                DbViewGotoRelatedProvider.addItem(result, (DasObject)it2.resolve());
            }
        }
    }

    private static void addDataSourceFiles(DasDataSource dataSource, final List<GotoRelatedItem> resultExt, final PsiManager psiManager) {
        VirtualFile dsRoot;
        String uniqueId = dataSource.getUniqueId();
        final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
        VirtualFile virtualFile = dsRoot = root != null && root.isDirectory() ? root.findChild(uniqueId) : null;
        if (dsRoot == null || !dsRoot.isDirectory()) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dsRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(final @NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory()) {
                    return true;
                }
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile instanceof SqlFile) {
                    resultExt.add(new GotoRelatedItem((PsiElement)psiFile){

                        @NlsSafe
                        @Nullable
                        public String getCustomName() {
                            return rootType.substituteName(psiManager.getProject(), file);
                        }

                        @Nls
                        public String getCustomContainerName() {
                            return "(" + rootType.getDisplayName() + ")";
                        }

                        @Nullable
                        public Icon getCustomIcon() {
                            return rootType.substituteIcon(psiManager.getProject(), file);
                        }
                    });
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
            }
        });
    }

    private static void addAssociations(Project project, Map<DasObject, GotoRelatedItem> result, DbDataSource dataSource) {
        String uniqueId = dataSource.getUniqueId();
        Set mapped = DdlMappingsManager.getInstance((Project)project).iterateMappings().filter(m -> m.isDdlDataSourceId(uniqueId) || m.isDataSourceId(uniqueId)).filterMap(m -> m.isDataSourceId(uniqueId) ? m.getDdlDataSourceId() : m.getDataSourceId()).toSet();
        for (DbDataSource ds : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            DbDataSource parent;
            if (mapped.contains(ds.getUniqueId())) {
                DbViewGotoRelatedProvider.addDataSourceItem(result, ds, "", DatabaseBundle.message((String)"mapped.data.source", (Object[])new Object[0]));
            }
            if ((parent = DbViewGotoRelatedProvider.getParentDataSource(ds)) == null || !parent.getUniqueId().equals(uniqueId)) continue;
            DbViewGotoRelatedProvider.addDataSourceItem(result, ds, "", DatabaseBundle.message((String)"derived.data.source", (Object[])new Object[0]));
        }
        DbDataSource parent = DbViewGotoRelatedProvider.getParentDataSource(dataSource);
        if (parent != null) {
            DbViewGotoRelatedProvider.addDataSourceItem(result, parent, "", DatabaseBundle.message((String)"parent.data.source", (Object[])new Object[0]));
        }
    }

    @Nullable
    private static DbDataSource getParentDataSource(DbDataSource ds) {
        RawDataSource delegate = ds.getDelegate();
        return delegate instanceof SqlDataSource ? ((SqlDataSource)delegate).getParentDataSource() : null;
    }

    private static void addPredecessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement((DasObject)psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement predecessor : basic.getPredecessors()) {
                DbElement tgt = DbImplUtilCore.findElement((DbDataSource)ds, (DasObject)predecessor);
                if (tgt == null) continue;
                DbViewGotoRelatedProvider.addItem(result, (DasObject)tgt);
            }
        }
    }

    private static void addSuccessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement((DasObject)psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement candidate : DbImplUtilCore.traverseVisibleObjects((DasDataSource)ds).filter(BasicElement.class)) {
                DbElement tgt;
                if (candidate == basic || ContainerUtil.find((Iterable)candidate.getPredecessors(), (Object)basic) == null || (tgt = DbImplUtilCore.findElement((DbDataSource)ds, (DasObject)candidate)) == null) continue;
                DbViewGotoRelatedProvider.addItem(result, (DasObject)tgt, DatabaseBundle.message((String)"separator.referenced.by", (Object[])new Object[0]));
            }
        }
    }

    private static void addItems(Map<DasObject, GotoRelatedItem> result, MultiRef<? extends DasTypedObject> columns, @NlsContexts.Separator String title) {
        for (DasTypedObject column : columns.resolveObjects()) {
            DbViewGotoRelatedProvider.addItem(result, (DasObject)column, title);
        }
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result, DasObject target) {
        DbViewGotoRelatedProvider.addItem(result, target, "");
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result, DasObject target, @NlsContexts.Separator String title) {
        if (result.containsKey(target)) {
            return;
        }
        if (target instanceof DbDataSource) {
            DbViewGotoRelatedProvider.addDataSourceItem(result, (DbDataSource)target, title, null);
        } else if (target instanceof DbElement) {
            result.put(target, new GotoRelatedItem((PsiElement)((DbElement)target), title){

                public void navigate() {
                    DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                    NavigationItem navElement = DatabaseTargetElementEvaluator.getGotoDeclarationTarget(dbElement);
                    Objects.requireNonNull(navElement).navigate(true);
                }

                @Nls
                @Nullable
                public String getCustomContainerName() {
                    DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                    DbElement parent = dbElement.getParent();
                    return parent == null ? null : parent.getName();
                }
            });
        } else if (target instanceof PsiElement) {
            result.put(target, new GotoRelatedItem((PsiElement)target, title));
        }
    }

    private static void addDataSourceItem(Map<DasObject, GotoRelatedItem> result, DbDataSource target, @NlsContexts.Separator String title, final @Nls @Nullable String containerName) {
        result.put((DasObject)target, new GotoRelatedItem((PsiElement)target, title){

            public void navigate() {
                DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                DbNavigationUtils.navigateToDatabaseView(dbElement, true);
            }

            @Nls
            @Nullable
            public String getCustomContainerName() {
                return containerName;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

