/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseSchemaAction
extends ActionGroup
implements DumbAware {
    private static final int MAX_SHOWN_SCHEMA_SYMBOLS = 35;
    private static final FileAttribute LEGACY_SEARCH_PATH_ATTRIBUTE = new FileAttribute("datasource_namespace", 2, true);
    private static final PerProjectFileAttributes ourSearchPathAttributes = new PerProjectFileAttributes("datasource.namespace", 1);

    public ChooseSchemaAction() {
        this.setPopup(true);
        this.getTemplatePresentation().setPerformGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChooseSchemaAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (AnAction.EMPTY_ARRAY == null) {
            ChooseSchemaAction.$$$reportNull$$$0(1);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(2);
        }
        this.actionPerformed(e, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e, @Nullable Runnable finalRunnable) {
        JdbcConsole console;
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(3);
        }
        if ((console = JdbcConsole.findConsole(e)) == null) {
            return;
        }
        WizardPopup popup2 = ChooseSchemaAction.createPopupForStep(console.getProject(), null, ChooseSchemaAction.createInitialStep(console), null, finalRunnable);
        DbUIUtil.showPopup((JBPopup)popup2, null, e);
        popup2.pack(true, true);
    }

    public void update(@NotNull AnActionEvent e) {
        ObjectKind kind;
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(4);
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        Presentation presentation = e.getPresentation();
        ObjectKind objectKind = kind = console == null ? null : DbImplUtil.getDatabaseDialect((JdbcConsoleBase)console).getSearchPathObjectKind();
        if (console == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        List schemas = SearchPath.getElements((SearchPath)console.getSearchPath());
        ObjectKind expected = (ObjectKind)ObjectUtils.chooseNotNull((Object)kind, (Object)ObjectKind.SCHEMA);
        boolean shorter = !schemas.isEmpty() && ((ObjectPath)schemas.get((int)0)).kind != expected;
        boolean isToolbar = e.isFromActionToolbar();
        String schemasText = isToolbar && !schemas.isEmpty() ? DbImplUtil.searchPathPresentation((List)schemas) : "";
        String placeholder = StringUtil.toLowerCase((String)expected.name());
        String text = !isToolbar ? DatabaseBundle.message((String)"action.ChooseSchema.text", (Object[])new Object[0]) : StringUtil.shortenTextWithEllipsis((String)(StringUtil.isEmpty((String)schemasText) ? "<" + placeholder + ">" : (shorter ? schemasText + ".<" + placeholder + ">" : schemasText)), (int)35, (int)0);
        presentation.setText(text, false);
        presentation.setDescription(DatabaseBundle.message((String)"action.ChooseSchema.description", (Object[])new Object[0]));
        presentation.setIcon(e.isFromActionToolbar() ? DbPresentationCore.getIcon((ObjectKind)expected) : null);
    }

    private static WizardPopup createPopupForStep(@Nullable Project project, @Nullable WizardPopup parent, @NotNull ListPopupStep<ObjectPath> step2, @Nullable ObjectPath parentValue, @Nullable Runnable finalRunnable) {
        if (step2 == null) {
            ChooseSchemaAction.$$$reportNull$$$0(5);
        }
        if (step2 instanceof SearchPathStep) {
            return new SearchPathPopup(project, parent, (SearchPathStep)step2, parentValue, finalRunnable);
        }
        if (step2 instanceof DbScStep) {
            return new DbScListPopup(project, parent, (DbScStep)step2, parentValue, finalRunnable);
        }
        return new SimpleListPopup(project, parent, step2, parentValue, finalRunnable);
    }

    @NotNull
    private static ListPopupStep<ObjectPath> createInitialStep(@NotNull JdbcConsole console) {
        DatabaseDialectEx dialect;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(6);
        }
        if ((dialect = DbImplUtil.getDatabaseDialect((JdbcConsoleBase)console)).getSearchPathObjectKind() != ObjectKind.DATABASE && (JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)((DatabaseConnectionPoint)console.getTarget())) || dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)ObjectPath.create((String)"test", (ObjectKind)ObjectKind.DATABASE))) != null)) {
            DbScStep dbScStep = DbScStep.create(console);
            if (dbScStep == null) {
                ChooseSchemaAction.$$$reportNull$$$0(7);
            }
            return dbScStep;
        }
        BaseStep baseStep = dialect.supportsSearchPath() ? new SearchPathStep(console) : SingleScOrDbStep.create(console);
        if (baseStep == null) {
            ChooseSchemaAction.$$$reportNull$$$0(8);
        }
        return baseStep;
    }

    public static void scheduleSavedSchemaSwitch(@NotNull JdbcConsole console) {
        SearchPath o;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(9);
        }
        if ((o = ChooseSchemaAction.getSchemaToSwitchToInner(console)) == null) {
            return;
        }
        SearchPath path = DbImplUtil.getAutoSwitchPath((LocalDataSource)console.getDataSource(), (SearchPath)o);
        if (path == null) {
            return;
        }
        console.switchSchema(path, false);
    }

    @Nullable
    private static SearchPath getSchemaToSwitchToInner(@NotNull JdbcConsole console) {
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(10);
        }
        Project project = console.getProject();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((JdbcConsoleBase)console);
        SearchPath schemaPaths = ChooseSchemaAction.getSelectedSearchPath(project, console.getVirtualFile(), dialect);
        if (schemaPaths != null && schemaPaths.getCurrent().kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (DataSourceStorage.getProjectStorage((Project)project).isLoading(localDataSource)) {
                DataSourceUtil.promiseFacadeUpdate((DbPsiFacade)DbPsiFacade.getInstance((Project)project), (Disposable)console).onProcessed(o -> ChooseSchemaAction.scheduleSavedSchemaSwitch(console));
            } else {
                return SearchPath.of((List)JBIterable.from((Iterable)SearchPath.getElements((SearchPath)schemaPaths)).filter(p -> (p.kind == ObjectKind.SCHEMA || p.kind == ObjectKind.DATABASE) && DatabaseEditorHelper.findNamespace(project, (DasDataSource)localDataSource, p) != null).toList());
            }
        }
        return null;
    }

    @ApiStatus.Internal
    public static void copySearchPathTo(@NotNull Project project, @NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull LocalDataSource dataSource) {
        DatabaseDialectEx dialect;
        SearchPath schemaPaths;
        if (project == null) {
            ChooseSchemaAction.$$$reportNull$$$0(11);
        }
        if (from == null) {
            ChooseSchemaAction.$$$reportNull$$$0(12);
        }
        if (to == null) {
            ChooseSchemaAction.$$$reportNull$$$0(13);
        }
        if (dataSource == null) {
            ChooseSchemaAction.$$$reportNull$$$0(14);
        }
        if ((schemaPaths = ChooseSchemaAction.getSelectedSearchPath(project, from, dialect = DbImplUtil.getDatabaseDialect((RawConnectionConfig)dataSource))) != null) {
            ChooseSchemaAction.setSelectedSearchPath(project, to, schemaPaths);
        }
    }

    public static void setSelectedSearchPath(@NotNull Project project, @NotNull VirtualFile file, @Nullable SearchPath schemaPaths) {
        FileAttribute attribute;
        if (project == null) {
            ChooseSchemaAction.$$$reportNull$$$0(15);
        }
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(16);
        }
        if ((attribute = ourSearchPathAttributes.get(project)) != null) {
            DbImplUtilCore.writeVFSAttributeSafe((VirtualFile)file, (FileAttribute)attribute, (String)ChooseSchemaAction.serialize(schemaPaths));
        }
    }

    @Nullable
    private static SearchPath getSelectedSearchPath(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (project == null) {
            ChooseSchemaAction.$$$reportNull$$$0(17);
        }
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            ChooseSchemaAction.$$$reportNull$$$0(19);
        }
        BasicMetaModel metaModel = DbImplUtilCore.getMetaModel((Dbms)dialect.getDbms());
        String legacyValue = DbImplUtilCore.readVFSAttributeSafe((VirtualFile)file, (FileAttribute)LEGACY_SEARCH_PATH_ATTRIBUTE);
        if (legacyValue != null) {
            DbImplUtilCore.writeVFSAttributeSafe((VirtualFile)file, (FileAttribute)LEGACY_SEARCH_PATH_ATTRIBUTE, null);
            FileAttribute attributes = ourSearchPathAttributes.get(project);
            if (attributes != null) {
                DbImplUtilCore.writeVFSAttributeSafe((VirtualFile)file, (FileAttribute)attributes, (String)legacyValue);
            }
            return ChooseSchemaAction.deserializeList(legacyValue, (MetaModel)metaModel);
        }
        FileAttribute attribute = ourSearchPathAttributes.get(project);
        if (attribute == null) {
            return null;
        }
        String value = DbImplUtilCore.readVFSAttributeSafe((VirtualFile)file, (FileAttribute)attribute);
        return ChooseSchemaAction.deserializeList(value, (MetaModel)metaModel);
    }

    @Nullable
    private static SearchPath deserializeList(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            ChooseSchemaAction.$$$reportNull$$$0(20);
        }
        if (o == null) {
            return null;
        }
        return SearchPath.of((List)JBIterable.of((Object[])o.split(",")).transform(x -> ObjectPaths.deserialize((String)x, (MetaModel)metaModel)).toList());
    }

    @Contract(value="!null->!null")
    private static String serialize(@Nullable SearchPath o) {
        if (o == null) {
            return null;
        }
        return StringUtil.join((Collection)o.elements, ObjectPaths::serialize, (String)",");
    }

    @NlsContexts.Label
    @NotNull
    private static String getText(ObjectPath value) {
        String text = StringUtil.shortenTextWithEllipsis((String)value.getName(), (int)35, (int)0, (boolean)true);
        String string = text.isEmpty() ? DatabaseBundle.message((String)"label.unnamed", (Object[])new Object[]{value.kind.getPresentableName()}) : text;
        if (string == null) {
            ChooseSchemaAction.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean canSwitchTo(DatabaseDialectEx dialect, @NotNull ObjectPath path, @NotNull DatabaseConnectionPoint target) {
        if (path == null) {
            ChooseSchemaAction.$$$reportNull$$$0(22);
        }
        if (target == null) {
            ChooseSchemaAction.$$$reportNull$$$0(23);
        }
        return DbImplUtil.canSwitchTo((SearchPath)SearchPath.of((ObjectPath)path), (DatabaseDialectEx)dialect) || path.kind == ObjectKind.DATABASE && JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)target);
    }

    private static void switchSearchPath(@NotNull JdbcConsole console, @NotNull SearchPath path) {
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(24);
        }
        if (path == null) {
            ChooseSchemaAction.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().invokeLater(() -> console.switchSchema(path, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialStep";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopupForStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStep";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSavedSchemaSwitch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaToSwitchToInner";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copySearchPathTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedSearchPath";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedSearchPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "switchSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }

    private static class SearchPathStep
    extends BaseStep<ObjectPath>
    implements ListPopupStepEx<ObjectPath> {
        private final ListSeparator mySearchPathSeparator;
        private final ListSeparator myAvailSeparator;
        private final ListSeparator myIntrospectedSep;
        private final JdbcConsole myConsole;
        private final List<ObjectPath> mySearchPath;
        private final List<ObjectPath> myInitialPath;
        private final List<ObjectPath> myRest;
        private final List<ObjectPath> myPaths;
        private boolean myPathsDirty;
        private final Set<ObjectPath> myIntrospected;

        SearchPathStep(@NotNull JdbcConsole console) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(0);
            }
            this.mySearchPathSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.search.path", (Object[])new Object[0]));
            this.myAvailSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.add.to.search.path", (Object[])new Object[0]));
            this.myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
            this.myPaths = new ArrayList<ObjectPath>();
            this.myPathsDirty = true;
            this.myConsole = console;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((JdbcConsoleBase)console);
            LocalDataSource dataSource = console.getDataSource();
            this.mySearchPath = new ArrayList<ObjectPath>();
            for (ObjectPath path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (!ChooseSchemaAction.canSwitchTo(dialect, path, (DatabaseConnectionPoint)console.getTarget())) continue;
                this.mySearchPath.add(path);
            }
            this.myRest = new ArrayList<ObjectPath>();
            this.myIntrospected = new HashSet<ObjectPath>();
            TreePattern scope2 = dataSource.getIntrospectionScope();
            for (DasObject namespace : (JBTreeTraverser)dataSource.getModel().traverser().expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of((DasObject)namespace);
                if (path == null || !ChooseSchemaAction.canSwitchTo(dialect, path, (DatabaseConnectionPoint)console.getTarget())) continue;
                this.myRest.add(path);
                if (!DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)namespace)) continue;
                this.myIntrospected.add(path);
            }
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = new ArrayList<ObjectPath>(this.mySearchPath);
        }

        SearchPathStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @NotNull List<ObjectPath> searchPath, @NotNull Set<ObjectPath> introspected) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SearchPathStep.$$$reportNull$$$0(2);
            }
            if (searchPath == null) {
                SearchPathStep.$$$reportNull$$$0(3);
            }
            if (introspected == null) {
                SearchPathStep.$$$reportNull$$$0(4);
            }
            this.mySearchPathSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.search.path", (Object[])new Object[0]));
            this.myAvailSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.add.to.search.path", (Object[])new Object[0]));
            this.myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
            this.myPaths = new ArrayList<ObjectPath>();
            this.myPathsDirty = true;
            this.myConsole = console;
            this.mySearchPath = new ArrayList<ObjectPath>(searchPath);
            this.myRest = new ArrayList<ObjectPath>(paths);
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = new ArrayList<ObjectPath>(this.mySearchPath);
            this.myIntrospected = introspected;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(ObjectPath value) {
            String string = ChooseSchemaAction.getText(value);
            if (string == null) {
                SearchPathStep.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            if (this.myPathsDirty) {
                ContainerUtil.sort(this.myRest, Comparator.comparing(p -> !this.myIntrospected.contains(p)).thenComparing(ObjectPath.PATH_COMPARATOR));
                this.myPaths.clear();
                this.myPaths.addAll(this.mySearchPath);
                this.myPaths.addAll(this.myRest);
            }
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(6);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            return null;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value) {
            if (Comparing.equal((Object)value, (Object)((ObjectPath)ContainerUtil.getFirstItem(this.mySearchPath)))) {
                return this.mySearchPathSeparator;
            }
            if (Comparing.equal((Object)value, (Object)((ObjectPath)ContainerUtil.getFirstItem(this.myRest)))) {
                return this.myAvailSeparator;
            }
            if (this.myIntrospected.contains(value)) {
                return null;
            }
            int idx = this.myRest.indexOf(value);
            if (idx < 1) {
                return null;
            }
            if (this.myIntrospected.contains(this.myRest.get(idx - 1))) {
                return this.myIntrospectedSep;
            }
            return null;
        }

        public int getDefaultOptionIndex() {
            return 0;
        }

        @NotNull
        public JdbcConsole getConsole() {
            JdbcConsole jdbcConsole = this.myConsole;
            if (jdbcConsole == null) {
                SearchPathStep.$$$reportNull$$$0(7);
            }
            return jdbcConsole;
        }

        @NotNull
        public List<ObjectPath> getPathItems() {
            List<ObjectPath> list = this.mySearchPath;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(8);
            }
            return list;
        }

        public boolean changed() {
            return !this.mySearchPath.equals(this.myInitialPath);
        }

        public void removeFromPath(ObjectPath item) {
            if (!this.mySearchPath.remove(item)) {
                return;
            }
            this.myRest.add(item);
            this.myPathsDirty = true;
        }

        public void moveInPath(ObjectPath item, int idx) {
            int prevIdx = this.mySearchPath.indexOf(item);
            if (prevIdx == idx) {
                return;
            }
            if (prevIdx != -1) {
                this.mySearchPath.remove(prevIdx);
            } else {
                this.myRest.remove(item);
            }
            if (prevIdx != -1 && idx > prevIdx) {
                --idx;
            }
            this.mySearchPath.add(idx, item);
            this.myPathsDirty = true;
        }

        public void reset() {
            HashSet<ObjectPath> values = new HashSet<ObjectPath>(this.getValues());
            this.mySearchPath.clear();
            this.mySearchPath.addAll(this.myInitialPath);
            values.removeAll(this.mySearchPath);
            this.myRest.clear();
            this.myRest.addAll(values);
            this.myPathsDirty = true;
        }

        @Nullable
        public String getTooltipTextFor(ObjectPath value) {
            if (value.getName().equals(ChooseSchemaAction.getText(value))) {
                return null;
            }
            return value.getName();
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                SearchPathStep.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "introspected";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsole";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmptyText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class SearchPathPopup
    extends SimpleListPopup {
        private static final int ZONE_SIZE = 30;
        private static final int TEXT_HORIZONTAL_MARGINS = JBUI.scale((int)20);
        private static final int ICON_WIDTH = JBUI.scale((int)24);
        private final JComponent myButtonsPanel;

        SearchPathPopup(@Nullable Project project, @Nullable WizardPopup parent, @NotNull SearchPathStep step2, @Nullable ObjectPath parentValue, @Nullable Runnable finalRunnable) {
            if (step2 == null) {
                SearchPathPopup.$$$reportNull$$$0(0);
            }
            super(project, parent, (ListPopupStep<ObjectPath>)step2, parentValue, finalRunnable);
            this.registerAction("Select schema", 10, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.replaceItem(this.getSelectedValue(), this.getStep());
                    this.apply();
                }
            });
            this.registerAction("Apply schemas", 10, 2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            });
            this.registerAction("Toggle schema", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleItem(this.getSelectedValue());
                }
            });
            new AnAction(ApplicationBundle.message((String)"arrangement.action.rule.move.up.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, this.getList());
            new AnAction(ApplicationBundle.message((String)"arrangement.action.rule.move.down.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, this.getList());
            this.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean ctrl;
                    int listIdx = this.getList().locationToIndex(e.getPoint());
                    if (listIdx == -1) {
                        return;
                    }
                    ObjectPath item = this.getList().getModel().getElementAt(listIdx);
                    if (item == null) {
                        return;
                    }
                    SearchPathStep step2 = this.getStep();
                    boolean bl = ctrl = (e.getModifiers() & 2) != 0 || this.isInControlZone(listIdx, e.getPoint());
                    if (ctrl) {
                        this.toggleItem(item);
                    } else {
                        this.replaceItem(item, step2);
                    }
                }
            });
            RowsDnDSupport.install(this.getList(), (EditableModel)new EditableModel(){

                public void addRow() {
                    throw new UnsupportedOperationException();
                }

                public void exchangeRows(int oldIndex, int newIndex) {
                    SearchPathStep step2 = this.getStep();
                    ObjectPath item = step2.getValues().get(oldIndex);
                    List<ObjectPath> path = step2.getPathItems();
                    if (newIndex <= path.size()) {
                        step2.moveInPath(item, newIndex);
                    } else if (path.contains(item)) {
                        step2.removeFromPath(item);
                    } else {
                        return;
                    }
                    this.update(item);
                }

                public boolean canExchangeRows(int oldIndex, int newIndex) {
                    List<ObjectPath> path = this.getStep().getPathItems();
                    return oldIndex <= path.size() || newIndex <= path.size();
                }

                public void removeRow(int idx) {
                    throw new UnsupportedOperationException();
                }
            });
            Dimension popupSize = this.getComponent().getPreferredSize();
            Dimension footerSize = this.footerComponent.getPreferredSize();
            for (int i = 1; i < 4; ++i) {
                this.updateAdvertisement(i % 2 == 0, i / 2 == 0);
                this.collectPreferred(popupSize, this.getContent());
                this.collectPreferred(footerSize, this.footerComponent);
            }
            int extra = 20;
            if (step2.getPathItems().isEmpty()) {
                popupSize.height += extra;
            }
            if (step2.getPathItems().size() == step2.getValues().size()) {
                popupSize.height += extra;
            }
            popupSize.height += extra;
            popupSize.width = this.evaluateSearchPathsWidth(step2) + TEXT_HORIZONTAL_MARGINS * 2 + ICON_WIDTH;
            this.getList().getParent().setPreferredSize(popupSize);
            this.footerComponent.setPreferredSize(footerSize);
            DbUIUtil.invokeLater(() -> this.updateAdvertisement(this.getMousePos()));
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
            this.myButtonsPanel = new JPanel(new GridLayout(1, 2));
            this.myButtonsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
            this.getContent().add((Component)JBUI.Panels.simplePanel().addToCenter((Component)this.getComponent()).addToBottom((Component)this.myButtonsPanel), "Center");
            GridConstraints constraints = new GridConstraints();
            this.myButtonsPanel.add((Component)new JButton(new AbstractAction(CommonBundle.getOkButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            }), constraints);
            constraints.setColumn(1);
            this.myButtonsPanel.add(new JButton(new AbstractAction(CommonBundle.getCancelButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPathStep step2 = this.getStep();
                    step2.reset();
                    this.update(null);
                }
            }));
            this.myButtonsPanel.setVisible(false);
        }

        public void apply() {
            SearchPathStep step2 = this.getStep();
            JdbcConsole console = step2.getConsole();
            SearchPath p = SearchPath.of(step2.getPathItems());
            if (p != null && !p.equals((Object)console.getSearchPath())) {
                ChooseSchemaAction.switchSearchPath(console, p);
            }
            this.closeOk(null);
            this.disposeAllParents(null);
        }

        public void replaceItem(ObjectPath item, SearchPathStep step2) {
            if (item == null) {
                return;
            }
            int idx = step2.getValues().indexOf(item);
            for (ObjectPath path : new ArrayList<ObjectPath>(step2.getPathItems())) {
                step2.removeFromPath(path);
            }
            step2.moveInPath(item, 0);
            if (idx != -1) {
                item = step2.getValues().get(idx);
            }
            this.update(item);
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        @Nullable
        private ObjectPath getSelectedValue() {
            return this.getList().getSelectedValue();
        }

        private boolean isInControlZone(int index, Point pt) {
            ObjectPath val = this.getList().getModel().getElementAt(index);
            List<ObjectPath> items = this.getStep().getPathItems();
            if (items.size() < 2 && items.contains(val)) {
                return false;
            }
            return SearchPathPopup.isInControlZone(this.getList(), index, pt);
        }

        private static <E> boolean isInControlZone(@NotNull JList<E> list, int index, Point pt) {
            if (list == null) {
                SearchPathPopup.$$$reportNull$$$0(1);
            }
            E val = list.getModel().getElementAt(index);
            Rectangle bounds = list.getCellBounds(index, index);
            if (!bounds.contains(pt)) {
                return false;
            }
            ListCellRenderer rr = ExpandedItemListCellRendererWrapper.unwrap(list.getCellRenderer());
            Component component = rr.getListCellRendererComponent(list, val, index, true, true);
            bounds.width = Math.max(bounds.width, component.getPreferredSize().width);
            JLabel zComp = SearchPathPopup.getControlComponent(rr);
            if (zComp == null || !zComp.isVisible()) {
                return false;
            }
            component.setBounds(bounds);
            Container stopAt = component.getParent();
            ContainerUtil.reverse((List)UIUtil.uiParents((Component)zComp, (boolean)true).takeWhile(c2 -> c2 != stopAt).toList()).forEach(Component::doLayout);
            Rectangle zBounds = zComp.getBounds();
            zBounds = SwingUtilities.convertRectangle(zComp, zBounds, component);
            zBounds.translate(bounds.x, bounds.y);
            return zBounds.contains(pt);
        }

        @Nullable
        private static JLabel getControlComponent(ListCellRenderer<?> rr) {
            GroupedItemsListRenderer gr;
            if (rr instanceof ExpandedItemListCellRendererWrapper) {
                rr = ((ExpandedItemListCellRendererWrapper)rr).getWrappee();
            }
            return (gr = (GroupedItemsListRenderer)ObjectUtils.tryCast(rr, GroupedItemsListRenderer.class)) == null ? null : gr.getNextStepLabel();
        }

        private void toggleItem(@Nullable ObjectPath item) {
            if (item == null) {
                return;
            }
            SearchPathStep step2 = this.getStep();
            List<ObjectPath> path = step2.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1 && path.size() < 2) {
                return;
            }
            if (idx != -1) {
                step2.removeFromPath(item);
                item = idx < path.size() ? path.get(idx) : path.get(path.size() - 1);
            } else {
                List<ObjectPath> values = step2.getValues();
                idx = values.indexOf(item);
                step2.moveInPath(item, path.size());
                values = step2.getValues();
                item = idx + 1 < values.size() ? values.get(idx + 1) : values.get(values.size() - 1);
            }
            this.update(item);
        }

        private void moveItem(@Nullable ObjectPath item, boolean up) {
            if (item == null) {
                return;
            }
            SearchPathStep step2 = this.getStep();
            List<ObjectPath> path = step2.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1) {
                if (!up && idx + 1 == path.size() || up && idx == 0) {
                    if (path.size() < 2) {
                        return;
                    }
                    step2.removeFromPath(item);
                } else {
                    step2.moveInPath(item, idx + (up ? -1 : 2));
                }
            } else {
                step2.moveInPath(item, up ? path.size() : 0);
            }
            this.update(item);
        }

        public SearchPathStep getStep() {
            return (SearchPathStep)super.getStep();
        }

        private void updateAdvertisement(Point pt) {
            int idx = this.getList().locationToIndex(pt);
            this.updateAdvertisement(idx < this.getStep().getPathItems().size(), idx != -1 && this.isInControlZone(idx, pt));
        }

        private void updateAdvertisement(boolean inPath, boolean ctrl) {
            if (!ctrl) {
                this.setAdText(inPath ? DatabaseBundle.message((String)"action.ChooseSchema.in.path.ad", (Object[])new Object[]{KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_UP.getShortcuts()), KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_DOWN.getShortcuts())}) : DatabaseBundle.message((String)"action.ChooseSchema.out.path.ad", (Object[])new Object[0]));
            } else {
                this.setAdText(inPath ? DatabaseBundle.message((String)"action.ChooseSchema.in.path.ctrl.ad", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ChooseSchema.out.path.ctrl.ad", (Object[])new Object[0]));
            }
        }

        public void cancel(InputEvent e) {
            if (e instanceof MouseEvent) {
                this.setOk(true);
            }
            super.cancel(e);
        }

        public void setOk(boolean ok2) {
            this.myOk = ok2;
            super.setOk(ok2);
        }

        protected boolean isActionClick(MouseEvent e) {
            return false;
        }

        private void update(ObjectPath item) {
            this.getListModel().updateOriginalList();
            if (item != null) {
                this.getList().setSelectedValue(item, true);
            }
            this.getList().validate();
            this.getList().repaint();
            this.myButtonsPanel.setVisible(this.getStep().changed());
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new SpItemRenderer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInControlZone";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class SpItemRenderer
        extends ElementWithControlRenderer<ObjectPath> {
            public SpItemRenderer() {
                super(SearchPathPopup.this);
                Font font = this.mySeparatorComponent.getFont();
                this.mySeparatorComponent.setFont(font.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
                this.myNextStepLabel.setPreferredSize(new Dimension(30, 20));
            }

            protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value, boolean isSelected) {
                super.customizeComponent(list, (Object)value, isSelected);
                this.myNextStepLabel.setVisible(isSelected);
                SearchPathStep step2 = SearchPathPopup.this.getStep();
                if (isSelected) {
                    boolean ctrl = this.isControl(list, value);
                    Icon add = ctrl ? DatabaseIcons.AddHover : DatabaseIcons.Add;
                    Icon del = ctrl ? AllIcons.Welcome.RecentProjects.RemoveHover : AllIcons.Welcome.RecentProjects.Remove;
                    List<ObjectPath> path = step2.getPathItems();
                    if (path.size() < 2) {
                        del = null;
                    }
                    Icon icon = path.contains(value) ? del : add;
                    this.highlightZones(list, value);
                    this.myNextStepLabel.setIcon(icon);
                }
                this.myNextStepLabel.setSize((Dimension)new JBDimension(22, 22));
                this.myNextStepLabel.setBorder(JBUI.Borders.empty((int)2));
            }

            @Override
            protected boolean isInControlZone(int idx, Point pt) {
                return SearchPathPopup.this.isInControlZone(idx, pt);
            }
        }
    }

    private static class DbScStep
    extends ObjectPathsStep {
        private final JdbcConsole myConsole;

        static DbScStep create(@NotNull JdbcConsole console) {
            ObjectPath dbPath;
            if (console == null) {
                DbScStep.$$$reportNull$$$0(0);
            }
            LocalDataSource dataSource = console.getDataSource();
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>();
            TreePattern scope2 = dataSource.getIntrospectionScope();
            int sep = 0;
            for (DasObject namespace : (JBTreeTraverser)dataSource.getModel().traverser().expand(Conditions.alwaysFalse())) {
                ObjectPath path = ObjectPaths.of((DasObject)namespace);
                if (path == null || path.kind != ObjectKind.DATABASE) continue;
                paths.add(DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)namespace) ? sep++ : paths.size(), path);
            }
            ObjectPath cur = SearchPath.getCurrent((SearchPath)console.getSearchPath());
            if (cur != null && (dbPath = cur.findParent(ObjectKind.DATABASE, false)) != null && !paths.contains(dbPath)) {
                paths.add(dbPath);
            }
            return new DbScStep(console, paths, cur, sep);
        }

        DbScStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @Nullable ObjectPath current, int introspectedEnd) {
            if (console == null) {
                DbScStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                DbScStep.$$$reportNull$$$0(2);
            }
            super(paths, introspectedEnd, current);
            this.myConsole = console;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (finalChoice || selectedValue == null) {
                if (selectedValue != null) {
                    ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
                }
                return FINAL_CHOICE;
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((JdbcConsoleBase)this.myConsole);
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>();
            int sep = 0;
            TreePattern scope2 = this.myConsole.getDataSource().getIntrospectionScope();
            for (DasObject schema : this.getSchemas(selectedValue)) {
                boolean introspected = DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)schema);
                ObjectPath p = ObjectPaths.of((DasObject)schema);
                if (!introspected) {
                    paths.add(p);
                    continue;
                }
                paths.add(sep++, p);
            }
            ArrayList<ObjectPath> searchPath = new ArrayList<ObjectPath>(SearchPath.getElements((SearchPath)this.myConsole.getSearchPath()));
            Iterator it = searchPath.iterator();
            while (it.hasNext()) {
                ObjectPath p = (ObjectPath)it.next();
                if (p.kind == ObjectKind.SCHEMA && p.parent != null && p.parent.name.equals(selectedValue.getName())) continue;
                it.remove();
            }
            if (dialect.supportsSearchPath()) {
                return new SearchPathStep(this.myConsole, paths, searchPath, new HashSet<ObjectPath>(paths.subList(0, sep)));
            }
            ObjectPath cur = (ObjectPath)ContainerUtil.getFirstItem(searchPath);
            if (cur != null && !paths.contains(cur)) {
                cur = null;
            }
            return new SingleScOrDbStep(this.myConsole, paths, cur, sep);
        }

        public boolean isFinal(ObjectPath value) {
            return false;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return !this.getSchemas(selectedValue).isEmpty();
        }

        @NotNull
        public JBIterable<? extends DasObject> getSchemas(@Nullable ObjectPath selectedValue) {
            LocalDataSource dataSource = this.myConsole.getDataSource();
            if (selectedValue == null || dataSource.getSchemaControl() == SchemaControl.FORBID) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DbScStep.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)dataSource.getModel().traverser().expandAndSkip(x -> x.getKind() == ObjectKind.DATABASE && x.getName().equals(selectedValue.getName()))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).traverse();
            if (jBIterable == null) {
                DbScStep.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemas";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class DbScListPopup
    extends SimpleListPopup {
        DbScListPopup(@Nullable Project project, @Nullable WizardPopup parent, @NotNull DbScStep step2, @Nullable ObjectPath parentValue, @Nullable Runnable finalRunnable) {
            if (step2 == null) {
                DbScListPopup.$$$reportNull$$$0(0);
            }
            super(project, parent, (ListPopupStep<ObjectPath>)step2, parentValue, finalRunnable);
            if (step2.getValues().isEmpty()) {
                return;
            }
            Dimension sz = new Dimension(0, 0);
            for (int i = 1; i < 4; ++i) {
                this.updateAdvertisement(i % 2 == 0, i / 2 == 0);
                this.collectPreferred(sz, this.footerComponent);
            }
            sz.width += 20;
            this.footerComponent.setPreferredSize(sz);
            DbUIUtil.invokeLater(() -> this.updateAdvertisement(this.getMousePos()));
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
        }

        private void updateAdvertisement(@NotNull Point pt) {
            int idx;
            if (pt == null) {
                DbScListPopup.$$$reportNull$$$0(1);
            }
            this.updateAdvertisement((idx = this.getList().locationToIndex(pt)) != -1 && this.isInControlZone(idx, pt), idx != -1 && idx == this.getStep().getDefaultOptionIndex());
        }

        private void updateAdvertisement(boolean ctrl, boolean cur) {
            if (ctrl) {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.configure.ad", (Object[])new Object[0]));
            } else if (cur) {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.default.ad", (Object[])new Object[0]));
            } else {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.connect.ad", (Object[])new Object[0]));
            }
        }

        protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
            int index = this.getList().locationToIndex(e.getPoint());
            if (index == -1) {
                return super.handleFinalChoices(e, selectedValue, listStep);
            }
            return !this.isInControlZone(index, e.getPoint());
        }

        public void handleSelect(boolean handleFinalChoices) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices);
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices, e);
        }

        public DbScStep getStep() {
            return (DbScStep)super.getStep();
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        private boolean isInControlZone(int index, Point pt) {
            return SearchPathPopup.isInControlZone(this.getList(), index, pt);
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new ItemRenderer(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pt";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScListPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAdvertisement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ItemRenderer
        extends PopupListElementRenderer<ObjectPath> {
            private ItemRenderer(DbScListPopup dbScListPopup) {
                super((ListPopupImpl)dbScListPopup);
            }

            protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value, boolean isSelected) {
                super.customizeComponent(list, (Object)value, isSelected);
                this.myNextStepLabel.setSize((Dimension)new JBDimension(22, 22));
                this.myNextStepLabel.setBorder(JBUI.Borders.empty((int)2));
            }
        }
    }

    private static class SimpleListPopup
    extends ListPopupImpl {
        private final ObjectPath myParentValue;
        private final Runnable myFinalRunnable;
        protected JLabel footerComponent;

        SimpleListPopup(@Nullable Project project, @Nullable WizardPopup parent, @NotNull ListPopupStep<ObjectPath> step2, @Nullable ObjectPath parentValue, @Nullable Runnable finalRunnable) {
            if (step2 == null) {
                SimpleListPopup.$$$reportNull$$$0(0);
            }
            super(project, parent, step2, (Object)parentValue);
            this.footerComponent = HintUtil.createAdComponent((String)"", (Border)JBUI.CurrentTheme.Advertiser.border(), (int)2);
            this.myParentValue = parentValue;
            this.myFinalRunnable = finalRunnable;
            this.setFinalRunnable(finalRunnable);
            final ListPopupImpl popup2 = (ListPopupImpl)ObjectUtils.tryCast((Object)parent, ListPopupImpl.class);
            if (popup2 != null) {
                this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (!Comparing.equal(popup2.getList().getSelectedValue(), (Object)myParentValue)) {
                            popup2.getList().setSelectedValue(myParentValue, false);
                        }
                    }
                });
            }
            this.checkSchemaChangingSupport(step2);
            Insets padding = UIUtil.getListViewportPadding((boolean)false);
            this.getList().setBorder((Border)JBUI.Borders.empty((int)padding.top, (int)padding.left, (int)padding.bottom, (int)0));
            if (step2.getValues().isEmpty()) {
                this.setCorrectSizeForEmptyList();
            } else {
                this.footerComponent.setBorder((Border)JBUI.Borders.empty((int)6, (int)16));
                this.setFooterComponent(this.footerComponent);
                this.setMaxRowCount(15);
            }
        }

        protected void setCorrectSizeForEmptyList() {
            JList list = this.getList();
            Dimension size = list.getPreferredSize();
            this.getContent().setBorder((Border)JBUI.Borders.empty((int)10, (int)30, (int)8, (int)30));
            this.getContent().setBackground(this.getList().getBackground());
            Container listParent = list.getParent();
            listParent.setPreferredSize(size);
        }

        @NotNull
        protected JScrollPane createScrollPane(JComponent content) {
            JScrollPane sp = super.createScrollPane(content);
            if (sp instanceof JBScrollPane) {
                JBScrollPane jbsp = (JBScrollPane)sp;
                jbsp.setOverlappingScrollBar(true);
            }
            JScrollPane jScrollPane = sp;
            if (jScrollPane == null) {
                SimpleListPopup.$$$reportNull$$$0(1);
            }
            return jScrollPane;
        }

        protected void collectPreferred(Dimension sz, JComponent content) {
            Dimension pref = content.getPreferredSize();
            sz.width = Math.max(sz.width, pref.width);
            sz.height = Math.max(sz.height, pref.height);
        }

        private void checkSchemaChangingSupport(@NotNull ListPopupStep<ObjectPath> step2) {
            DatabaseDialectEx dialect;
            if (step2 == null) {
                SimpleListPopup.$$$reportNull$$$0(2);
            }
            if (step2 instanceof SingleScOrDbStep && (dialect = DatabaseDialects.findByDbms((Dbms)((SingleScOrDbStep)step2).getDbms())) != null && !dialect.supportsSchemaChanging() && this.getList() instanceof JBList) {
                ((JBList)this.getList()).setEmptyText(DatabaseBundle.message((String)"status.text.schema.changing.not.supported", (Object[])new Object[0]));
                this.setCorrectSizeForEmptyList();
            }
        }

        protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
            return step2 instanceof ListPopupStep ? ChooseSchemaAction.createPopupForStep(this.getProject(), parent, (ListPopupStep<ObjectPath>)((ListPopupStep)step2), (ObjectPath)ObjectUtils.tryCast((Object)parentValue, ObjectPath.class), this.myFinalRunnable) : super.createPopup(parent, step2, parentValue);
        }

        @NotNull
        protected Point getMousePos() {
            PointerInfo info2 = MouseInfo.getPointerInfo();
            Point pt = info2 == null ? new Point(0, 0) : info2.getLocation();
            SwingUtilities.convertPointFromScreen(pt, this.getList());
            Point point = pt;
            if (point == null) {
                SimpleListPopup.$$$reportNull$$$0(3);
            }
            return point;
        }

        protected int evaluateSearchPathsWidth(SearchPathStep step2) {
            FontMetrics fm = this.getList().getFontMetrics(UIUtil.getListFont());
            int maxWidth = -1;
            List<ObjectPath> values = step2.getValues();
            for (ObjectPath value : values) {
                maxWidth = Math.max(fm.stringWidth(ChooseSchemaAction.getText(value)), maxWidth);
            }
            return maxWidth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createScrollPane";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMousePos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkSchemaChangingSupport";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class SingleScOrDbStep
    extends ObjectPathsStep {
        private final JdbcConsole myConsole;

        public Dbms getDbms() {
            return this.myConsole.getDataSource().getDbms();
        }

        static SingleScOrDbStep create(@NotNull JdbcConsole console) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(0);
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((JdbcConsoleBase)console);
            ObjectKind kind = dialect.getSearchPathObjectKind();
            LocalDataSource dataSource = console.getDataSource();
            boolean sensitive = console.getDataSource().getCaseModes().quoted.sensitive;
            Map allPaths = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)(sensitive ? ObjectPaths.SIMPLE_SENSITIVE_STRATEGY : ObjectPaths.SIMPLE_INSENSITIVE_STRATEGY));
            ObjectPath cur = null;
            for (Object path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (kind != null && !ChooseSchemaAction.canSwitchTo(dialect, (ObjectPath)path, (DatabaseConnectionPoint)console.getTarget())) continue;
                if (cur == null) {
                    cur = path;
                }
                allPaths.put(path, false);
            }
            TreePattern scope2 = dataSource.getIntrospectionScope();
            for (DasObject namespace : (JBTreeTraverser)dataSource.getModel().traverser().expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of((DasObject)namespace);
                if (path == null || kind != null && !ChooseSchemaAction.canSwitchTo(dialect, path, (DatabaseConnectionPoint)console.getTarget()) || path.name.isEmpty()) continue;
                allPaths.put(path, DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)namespace));
            }
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>(allPaths.size());
            int sep = 0;
            for (int i = 0; i < 2; ++i) {
                boolean introspected = i == 0;
                for (Map.Entry entry : allPaths.entrySet()) {
                    if (introspected != (Boolean)entry.getValue()) continue;
                    paths.add((ObjectPath)entry.getKey());
                }
                if (!introspected) continue;
                sep = paths.size();
            }
            return new SingleScOrDbStep(console, paths, cur, sep);
        }

        SingleScOrDbStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @Nullable ObjectPath current, int introspectedEnd) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SingleScOrDbStep.$$$reportNull$$$0(2);
            }
            super(paths, introspectedEnd, current);
            this.myConsole = console;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (selectedValue != null) {
                ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SingleScOrDbStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ElementWithControlRenderer<T>
    extends PopupListElementRenderer<T> {
        private int myControlIndex;
        public final Color UNFOCUSED;

        ElementWithControlRenderer(final @NotNull ListPopupImpl popup2) {
            if (popup2 == null) {
                ElementWithControlRenderer.$$$reportNull$$$0(0);
            }
            super(popup2);
            this.myControlIndex = -1;
            this.UNFOCUSED = UIUtil.mix((Color)this.getSelectionBackground(), (Color)this.getBackground(), (double)0.2);
            popup2.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int i2;
                    JList list = popup2.getList();
                    int i0 = myControlIndex;
                    int i1 = list.locationToIndex(e.getPoint());
                    int n = i2 = i1 != -1 && !this.isInControlZone(i1, e.getPoint()) ? -1 : i1;
                    if (i0 < 0 && i1 < 0) {
                        return;
                    }
                    myControlIndex = i2;
                    Rectangle bounds = list.getCellBounds(i0 < 0 ? i1 : i0, i1 < 0 ? i0 : i1);
                    list.repaint(bounds);
                }
            });
            this.myNextStepLabel.setHorizontalAlignment(0);
            this.myNextStepLabel.setOpaque(true);
            ((JComponent)this.myTextLabel.getParent()).setBorder((Border)JBUI.Borders.empty((int)UIUtil.getListCellVPadding(), (int)0));
        }

        protected void highlightZones(JList<? extends T> list, T value) {
            boolean ctrl = this.isControl(list, value);
            if (ctrl) {
                UIUtil.setBackgroundRecursively((Component)this.getItemComponent(), (Color)this.UNFOCUSED);
            }
            if (this.myNextStepLabel.getIcon() != null) {
                this.myNextStepLabel.setBackground(ctrl ? this.getSelectionBackground() : this.UNFOCUSED);
            }
        }

        protected boolean isControl(JList<? extends T> list, T value) {
            return this.myControlIndex != -1 && this.myControlIndex < list.getModel().getSize() && list.getModel().getElementAt(this.myControlIndex) == value;
        }

        protected abstract boolean isInControlZone(int var1, Point var2);

        protected Border getDefaultItemComponentBorder() {
            return JBUI.Borders.emptyLeft((int)UIUtil.getListCellHPadding());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/actions/ChooseSchemaAction$ElementWithControlRenderer", "<init>"));
        }
    }

    private static abstract class ObjectPathsStep
    extends BaseStep<ObjectPath>
    implements ListPopupStepEx<ObjectPath> {
        private final ListSeparator myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
        protected final List<ObjectPath> myPaths;
        protected final int myIntrospectedEnd;
        protected final ObjectPath myCurrent;

        protected ObjectPathsStep(List<ObjectPath> paths, int end, ObjectPath current) {
            this.myPaths = paths;
            this.myIntrospectedEnd = end;
            this.myCurrent = current;
            this.myPaths.subList(0, this.myIntrospectedEnd).sort(ObjectPath.PATH_COMPARATOR);
            this.myPaths.subList(this.myIntrospectedEnd, this.myPaths.size()).sort(ObjectPath.PATH_COMPARATOR);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @NotNull
        public String getTextFor(ObjectPath value) {
            String string = ChooseSchemaAction.getText(value);
            if (string == null) {
                ObjectPathsStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getTooltipTextFor(ObjectPath value) {
            if (value.getName().equals(ChooseSchemaAction.getText(value))) {
                return null;
            }
            return value.getName();
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                ObjectPathsStep.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public List<ObjectPath> getValues() {
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                ObjectPathsStep.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value) {
            return this.myIntrospectedEnd < this.myPaths.size() && value.equals(this.myPaths.get(this.myIntrospectedEnd)) ? this.myIntrospectedSep : null;
        }

        public int getDefaultOptionIndex() {
            return this.myPaths.indexOf(this.myCurrent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$ObjectPathsStep";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$ObjectPathsStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmptyText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

