/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.statistic.DbFusConnectionLoggerKt;
import com.intellij.database.statistic.ModificationType;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.sql.SQLException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/statistic/DbFusConnectionLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "connectionSuccessful", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "connectionFailed", "sqlException", "Ljava/sql/SQLException;", "testConnectionFinished", "th", "", "testConnectionStarted", "dataSourceModified", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "modificationType", "Lcom/intellij/database/statistic/ModificationType;", "cleanupErrorState", "", "Connect", "TestConnection", "ConfigEditor", "Storage", "intellij.database.impl"})
public final class DbFusConnectionLogger
extends CounterUsagesCollector {
    @NotNull
    public static final DbFusConnectionLogger INSTANCE = new DbFusConnectionLogger();

    private DbFusConnectionLogger() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return DbFusConnectionLoggerKt.access$getGROUP$p();
    }

    public final void connectionSuccessful(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        EventPair[] eventPairArray = new EventPair[]{DbFusConnectionLoggerKt.access$getDATA_SOURCE_ID$p().with((Object)DbFusConnectionLoggerKt.access$toDataSourceId(connectionPoint)), DbFusConnectionLoggerKt.access$getDBMS$p().with(connectionPoint.getDbms()), EventFields.Version.with((Object)connectionPoint.getDataSource().getVersion().toString())};
        DbFusConnectionLoggerKt.access$getCONNECTION_SUCCESS_EVENT$p().log(project, eventPairArray);
    }

    private final void connectionFailed(Project project, DatabaseConnectionPoint connectionPoint, SQLException sqlException) {
        VarargEventId varargEventId = DbFusConnectionLoggerKt.access$getCONNECTION_FAILED_EVENT$p();
        EventPair[] eventPairArray = new EventPair[5];
        eventPairArray[0] = DbFusConnectionLoggerKt.access$getDATA_SOURCE_ID$p().with((Object)DbFusConnectionLoggerKt.access$toDataSourceId(connectionPoint));
        eventPairArray[1] = DbFusConnectionLoggerKt.access$getDBMS$p().with(connectionPoint.getDbms());
        eventPairArray[2] = EventFields.Version.with((Object)connectionPoint.getDataSource().getVersion().toString());
        SQLException sQLException = sqlException;
        eventPairArray[3] = DbFusConnectionLoggerKt.access$getERROR_CODE$p().with((Object)(sQLException != null ? sQLException.getErrorCode() : -1));
        StringEventField stringEventField = DbFusConnectionLoggerKt.access$getSQL_STATE$p();
        Object object = sqlException;
        if (object == null || (object = ((SQLException)object).getSQLState()) == null) {
            object = "";
        }
        eventPairArray[4] = stringEventField.with((Object)this.cleanupErrorState((String)object));
        varargEventId.log(project, eventPairArray);
    }

    private final void testConnectionFinished(Project project, DatabaseConnectionPoint connectionPoint, Throwable th) {
        EventPair[] eventPairArray = new EventPair[]{DbFusConnectionLoggerKt.access$getDATA_SOURCE_ID$p().with((Object)DbFusConnectionLoggerKt.access$toDataSourceId(connectionPoint)), DbFusConnectionLoggerKt.access$getFAILED$p().with((Object)(th != null ? 1 : 0))};
        DbFusConnectionLoggerKt.access$getTEST_CONNECTION_COMPLETE_EVENT$p().log(project, eventPairArray);
    }

    private final void testConnectionStarted(Project project, DatabaseConnectionPoint connectionPoint) {
        EventPair[] eventPairArray = new EventPair[]{DbFusConnectionLoggerKt.access$getDATA_SOURCE_ID$p().with((Object)DbFusConnectionLoggerKt.access$toDataSourceId(connectionPoint)), DbFusConnectionLoggerKt.access$getDBMS$p().with(connectionPoint.getDbms()), EventFields.Version.with((Object)connectionPoint.getDataSource().getVersion().toString())};
        DbFusConnectionLoggerKt.access$getTEST_CONNECTION_EVENT$p().log(project, eventPairArray);
    }

    private final void dataSourceModified(Project project, LocalDataSource dataSource, ModificationType modificationType) {
        EventPair[] eventPairArray = new EventPair[]{DbFusConnectionLoggerKt.access$getDATA_SOURCE_ID$p().with((Object)DbFusConnectionLoggerKt.access$toDataSourceId((DatabaseConnectionPoint)dataSource)), DbFusConnectionLoggerKt.access$getTYPE$p().with((Object)modificationType)};
        DbFusConnectionLoggerKt.access$getDATA_SOURCE_MODIFIED_EVENT$p().log(project, eventPairArray);
    }

    private final String cleanupErrorState(String $this$cleanupErrorState) {
        String string = $this$cleanupErrorState;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String st = StringsKt.replace$default((String)string2, (String)"[^0-9A-Z ]", (String)" ", (boolean)false, (int)4, null);
        if (st.length() < 5) {
            st = StringsKt.padStart((String)st, (int)5, (char)' ');
        }
        if (st.length() > 5) {
            String string3 = st.substring(0, 5);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            st = string3;
        }
        return st;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/statistic/DbFusConnectionLogger$ConfigEditor;", "Lcom/intellij/database/view/ui/DatabaseConfigEditor$Listener;", "<init>", "()V", "applied", "", "target", "", "isNew", "", "intellij.database.impl"})
    public static final class ConfigEditor
    implements DatabaseConfigEditor.Listener {
        public void applied(@NotNull Object target, boolean isNew) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (isNew) {
                return;
            }
            DbDataSource dbDataSource = target instanceof DbDataSource ? (DbDataSource)target : null;
            if (dbDataSource == null) {
                return;
            }
            DbDataSource dbDataSource2 = dbDataSource;
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbDataSource2));
            if (localDataSource == null) {
                return;
            }
            LocalDataSource dataSource = localDataSource;
            Project project = dbDataSource2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            INSTANCE.dataSourceModified(project, dataSource, ModificationType.MODIFIED_IN_DIALOG);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/statistic/DbFusConnectionLogger$Connect;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Listener;", "<init>", "()V", "connectionChanged", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "added", "", "connectionFailed", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "th", "", "intellij.database.impl"})
    public static final class Connect
    implements DatabaseConnectionManager.Listener {
        public void connectionChanged(@NotNull DatabaseConnection connection, boolean added) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            if (added) {
                Project project = connection.getConfiguration().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                DatabaseConnectionPoint databaseConnectionPoint = connection.getConnectionPoint();
                Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"getConnectionPoint(...)");
                INSTANCE.connectionSuccessful(project, databaseConnectionPoint);
            }
        }

        public void connectionFailed(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull Throwable th) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)th, (String)"th");
            if (AsyncUtil.isCancellation((Throwable)th)) {
                return;
            }
            SQLException sqlException = (SQLException)ExceptionUtil.findCause((Throwable)th, SQLException.class);
            INSTANCE.connectionFailed(project, connectionPoint, sqlException);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/statistic/DbFusConnectionLogger$Storage;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "dataSourceRemoved", "intellij.database.impl"})
    public static final class Storage
    implements DataSourceManager.Listener {
        @NotNull
        private final Project project;

        public Storage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            if (!(dataSource instanceof LocalDataSource)) {
                return;
            }
            INSTANCE.dataSourceModified(this.project, (LocalDataSource)dataSource, ModificationType.CREATED);
        }

        public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            if (!(dataSource instanceof LocalDataSource)) {
                return;
            }
            INSTANCE.dataSourceModified(this.project, (LocalDataSource)dataSource, ModificationType.REMOVED);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/statistic/DbFusConnectionLogger$TestConnection;", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Listener;", "<init>", "()V", "started", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "finished", "result", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "th", "", "intellij.database.impl"})
    public static final class TestConnection
    implements DataSourceTestConnectionManager.Listener {
        @Override
        public void started(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            INSTANCE.testConnectionStarted(project, connectionPoint);
        }

        @Override
        public void finished(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DataSourceTestConnectionManager.TestConnectionResult result, @Nullable Throwable th) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            INSTANCE.testConnectionFinished(project, connectionPoint, th);
        }
    }
}

