/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.internals;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.actions.diagnostic.DatabaseTreeTweakAction;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvTreeLayerDef;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.forest.DvBushRef;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestGartner;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010#\u001a\u00020$*\u00020\u00172\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(J\u0006\u0010)\u001a\u00020$J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020$H\u0002J\b\u0010/\u001a\u00020$H\u0002J\b\u00100\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "forestService", "Lcom/intellij/database/view/structure/forest/DvForestService;", "forest", "Lcom/intellij/database/view/structure/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "allDefs", "Lkotlin/enums/EnumEntries;", "Lcom/intellij/database/view/structure/DvTreeLayerDef;", "service", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "storeyLayers", "Ljava/util/SortedMap;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "layerRows", "", "Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$LayerRow;", "mainPane", "Ljavax/swing/JTabbedPane;", "topPanelOfLayers", "Lcom/intellij/openapi/ui/DialogPanel;", "topPanelOfTheForest", "applyButton", "Ljavax/swing/JButton;", "forestTextArea", "Lcom/intellij/ui/components/JBTextArea;", "statsTextField", "Lcom/intellij/ui/components/JBTextField;", "forestData", "", "onceWhenTabActivated", "", "tabIndex", "", "listener", "Lkotlin/Function0;", "doIt", "setup", "apply", "setupForestData", "showForestState", "showStats", "reimportAllDS", "dispose", "LayerRow", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseTreeTweakDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseTreeTweakDialog.kt\ncom/intellij/database/view/internals/DatabaseTreeTweakDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n30#2,2:238\n30#2,2:240\n30#2,2:242\n1#3:244\n*S KotlinDebug\n*F\n+ 1 DatabaseTreeTweakDialog.kt\ncom/intellij/database/view/internals/DatabaseTreeTweakDialog\n*L\n50#1:238,2\n69#1:240,2\n227#1:242,2\n*E\n"})
public final class DatabaseTreeTweakDialog
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final DvForestService forestService;
    @NotNull
    private final DvForest<DataSourceNode> forest;
    @NotNull
    private final EnumEntries<DvTreeLayerDef> allDefs;
    @NotNull
    private final DvTreeStructureService service;
    @NotNull
    private final SortedMap<DvTreeLayerDef, DvTreeStoreyLayer> storeyLayers;
    @NotNull
    private final Map<DvTreeLayerDef, LayerRow> layerRows;
    @NotNull
    private final JTabbedPane mainPane;
    @NotNull
    private final DialogPanel topPanelOfLayers;
    @NotNull
    private final DialogPanel topPanelOfTheForest;
    @NotNull
    private final JButton applyButton;
    private JBTextArea forestTextArea;
    private JBTextField statsTextField;
    @Nullable
    private String forestData;

    /*
     * WARNING - void declaration
     */
    public DatabaseTreeTweakDialog(@NotNull Project project) {
        void $this$_init__u24lambda_u242;
        JBTabbedPane jBTabbedPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.allDefs = DvTreeLayerDef.getEntries();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.service = (DvTreeStructureService)object;
        this.storeyLayers = this.service.getAllStoreyLayers();
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = DvForestService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.forestService = (DvForestService)object2;
        this.forest = this.forestService.getForest();
        EnumMap layerRows = new EnumMap(DvTreeLayerDef.class);
        Ref.ObjectRef applyButton = new Ref.ObjectRef();
        this.topPanelOfLayers = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$0(this, layerRows, applyButton, arg_0));
        this.topPanelOfTheForest = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$1(this, arg_0));
        JBTabbedPane jBTabbedPane2 = jBTabbedPane = new JBTabbedPane();
        DatabaseTreeTweakDialog databaseTreeTweakDialog = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.setFont($this$_init__u24lambda_u242.getFont().deriveFont(1));
        $this$_init__u24lambda_u242.addTab("Layers", (Component)this.topPanelOfLayers);
        $this$_init__u24lambda_u242.setMnemonicAt(0, 76);
        $this$_init__u24lambda_u242.addTab("Forest", (Component)this.topPanelOfTheForest);
        $this$_init__u24lambda_u242.setMnemonicAt(1, 70);
        this.onceWhenTabActivated((JTabbedPane)$this$_init__u24lambda_u242, 1, (Function0<Unit>)((Function0)() -> DatabaseTreeTweakDialog.lambda$2$0(this)));
        databaseTreeTweakDialog.mainPane = (JTabbedPane)jBTabbedPane;
        this.layerRows = layerRows;
        Object object3 = applyButton.element;
        Intrinsics.checkNotNull((Object)object3);
        this.applyButton = (JButton)object3;
    }

    public final void onceWhenTabActivated(@NotNull JTabbedPane $this$onceWhenTabActivated, int tabIndex, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$onceWhenTabActivated, (String)"<this>");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$onceWhenTabActivated.addChangeListener(new ChangeListener($this$onceWhenTabActivated, tabIndex, listener2){
            final /* synthetic */ JTabbedPane $this_onceWhenTabActivated;
            final /* synthetic */ int $tabIndex;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$this_onceWhenTabActivated = $receiver;
                this.$tabIndex = $tabIndex;
                this.$listener = $listener;
            }

            public void stateChanged(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$this_onceWhenTabActivated.getSelectedIndex() == this.$tabIndex) {
                    this.$this_onceWhenTabActivated.removeChangeListener(this);
                    this.$listener.invoke();
                }
            }
        });
    }

    public final void doIt() {
        DialogBuilder dialogBuilder;
        DialogBuilder $this$doIt_u24lambda_u240 = dialogBuilder = new DialogBuilder(this.project);
        boolean bl = false;
        $this$doIt_u24lambda_u240.setTitle("Database Explorer Debug");
        $this$doIt_u24lambda_u240.setCenterPanel((JComponent)this.mainPane);
        $this$doIt_u24lambda_u240.setPreferredFocusComponent((JComponent)this.mainPane);
        $this$doIt_u24lambda_u240.addDisposable((Disposable)this);
        $this$doIt_u24lambda_u240.setDimensionServiceKey(DatabaseTreeTweakAction.class.getSimpleName());
        $this$doIt_u24lambda_u240.removeAllActions();
        DialogBuilder dia = dialogBuilder;
        this.setup();
        dia.showNotModal();
    }

    private final void setup() {
        Set selectedDefs = this.service.getSelectedLayerDefs();
        for (LayerRow row : this.layerRows.values()) {
            ButtonKt.selected(row.getCheckBox(), (boolean)selectedDefs.contains(row.getDef()));
        }
    }

    private final void apply() {
        EnumSet<DvTreeLayerDef> newSelectedDefs = EnumSet.noneOf(DvTreeLayerDef.class);
        for (LayerRow lr : this.layerRows.values()) {
            if (!((JBCheckBox)lr.getCheckBox().getComponent()).isSelected()) continue;
            newSelectedDefs.add(lr.getDef());
        }
        this.applyButton.setEnabled(false);
        Intrinsics.checkNotNull(newSelectedDefs);
        this.service.setupLayers((Set)newSelectedDefs);
        DatabaseView.refreshViewNicely(this.project);
        this.setup();
    }

    private final void setupForestData() {
        this.showForestState();
        this.showStats();
    }

    private final void showForestState() {
        DvForestGartner gartner = new DvForestGartner(this.forest);
        this.forestData = gartner.exportState();
        JBTextArea jBTextArea = this.forestTextArea;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"forestTextArea");
            jBTextArea = null;
        }
        String string = this.forestData;
        Intrinsics.checkNotNull((Object)string);
        jBTextArea.setText(string);
        JBTextArea jBTextArea2 = this.forestTextArea;
        if (jBTextArea2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"forestTextArea");
            jBTextArea2 = null;
        }
        jBTextArea2.setCaretPosition(0);
    }

    private final void showStats() {
        Ref.IntRef cntOfFolders = new Ref.IntRef();
        Ref.IntRef cntOfBrokenBushes = new Ref.IntRef();
        HashSet dataSourcesInFolders = new HashSet();
        this.forest.readTree(() -> DatabaseTreeTweakDialog.showStats$lambda$0(this, dataSourcesInFolders, cntOfBrokenBushes, cntOfFolders));
        BasicModelRegistry mr = BasicModelRegistry.Companion.instance();
        List allDataSources = SequencesKt.toList((Sequence)mr.listDataSourceNodesForProject(this.project));
        int cntOfAllDataSources = allDataSources.size();
        int cntOfDataSourcesInFolders = dataSourcesInFolders.size();
        int cntOfForgottenDataSources = CollectionsKt.minus((Iterable)allDataSources, (Iterable)dataSourcesInFolders).size();
        String str = "Folders " + cntOfFolders.element + ", Data Sources " + cntOfAllDataSources + ", In folders " + cntOfDataSourcesInFolders + ", Broken Bushes " + cntOfBrokenBushes.element + ", Forgotten " + cntOfForgottenDataSources;
        JBTextField jBTextField = this.statsTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statsTextField");
            jBTextField = null;
        }
        jBTextField.setText(str);
        JBTextField jBTextField2 = this.statsTextField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statsTextField");
            jBTextField2 = null;
        }
        jBTextField2.setCaretPosition(0);
    }

    private final void reimportAllDS() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForestService forestService = (DvForestService)object;
        forestService.importRestDataSources();
        this.setupForestData();
    }

    public void dispose() {
        this.mainPane.setVisible(false);
        this.mainPane.removeAll();
    }

    private static final Unit _init_$lambda$0(DatabaseTreeTweakDialog this$0, EnumMap $layerRows, Ref.ObjectRef $applyButton, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("#", DatabaseTreeTweakDialog::lambda$0$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        $this$panel.row("0", DatabaseTreeTweakDialog::lambda$0$1);
        for (DvTreeLayerDef def : this$0.allDefs) {
            $this$panel.row(String.valueOf(def.getLevel()), arg_0 -> DatabaseTreeTweakDialog.lambda$0$2(def, $layerRows, this$0, $applyButton, arg_0));
        }
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$0$3($applyButton, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        $this$row.label("Layer");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        $this$row.label("Root").customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)new IntelliJSpacingConfiguration().getHorizontalIndent(), (int)0, (int)0, (int)13, null));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(DvTreeLayerDef $def, EnumMap $layerRows, DatabaseTreeTweakDialog this$0, Ref.ObjectRef $applyButton, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        Cell $this$lambda_u240_u242_u240 = cell = $this$row.checkBox($def.getDisplayName());
        boolean bl = false;
        $this$lambda_u240_u242_u240.enabled(this$0.storeyLayers.keySet().contains($def));
        Cell cb = cell;
        cb.onChanged(arg_0 -> DatabaseTreeTweakDialog.lambda$0$2$1($applyButton, arg_0));
        ((Map)$layerRows).put($def, new LayerRow($def, (Cell<? extends JBCheckBox>)cb));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$1(Ref.ObjectRef $applyButton, JBCheckBox it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JButton jButton = (JButton)$applyButton.element;
            if (jButton == null) break block0;
            jButton.setEnabled(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(Ref.ObjectRef $applyButton, DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell b = $this$row.button("Apply Layers", arg_0 -> DatabaseTreeTweakDialog.lambda$0$3$0(this$0, arg_0));
        $applyButton.element = b.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3$0(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.apply();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(DatabaseTreeTweakDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$1$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$1$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textArea().align(Align.FILL).applyToComponent(arg_0 -> DatabaseTreeTweakDialog.lambda$1$0$0(this$0, arg_0));
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$0(DatabaseTreeTweakDialog this$0, JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.forestTextArea = $this$applyToComponent;
        $this$applyToComponent.setEditable(false);
        $this$applyToComponent.setLineWrap(false);
        $this$applyToComponent.setRows(15);
        $this$applyToComponent.setColumns(60);
        $this$applyToComponent.setFont(new Font("Monospaced", 0, $this$applyToComponent.getFont().getSize()));
        ListenerUiUtil.onceWhenFocusGained$default((Component)((Component)$this$applyToComponent), null, arg_0 -> DatabaseTreeTweakDialog.lambda$1$0$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$0$0(DatabaseTreeTweakDialog this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setupForestData();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$1(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textField().align((Align)AlignX.FILL.INSTANCE).applyToComponent(arg_0 -> DatabaseTreeTweakDialog.lambda$1$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$1$0(DatabaseTreeTweakDialog this$0, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.statsTextField = $this$applyToComponent;
        $this$applyToComponent.setEditable(false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$2(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button("Reimport All DS", arg_0 -> DatabaseTreeTweakDialog.lambda$1$2$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$2$0(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reimportAllDS();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$2$0(DatabaseTreeTweakDialog this$0) {
        this$0.setupForestData();
        return Unit.INSTANCE;
    }

    private static final Unit showStats$lambda$0(DatabaseTreeTweakDialog this$0, HashSet $dataSourcesInFolders, Ref.IntRef $cntOfBrokenBushes, Ref.IntRef $cntOfFolders) {
        Sequence allFolders = this$0.forest.getRoot().traversFolders();
        for (DvFolder f : allFolders) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(f.getInnerBushRefList().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                DataSourceNode dsn;
                DvBushRef r = (DvBushRef)iterator.next();
                if (r.isValid()) {
                    BasicUniqueBush basicUniqueBush = r.getBush();
                    Intrinsics.checkNotNull((Object)basicUniqueBush, (String)"null cannot be cast to non-null type com.intellij.database.view.DataSourceNode");
                    v1 = (DataSourceNode)basicUniqueBush;
                } else {
                    v1 = dsn = null;
                }
                if (dsn != null) {
                    ((Collection)$dataSourcesInFolders).add(dsn);
                    continue;
                }
                int n = $cntOfBrokenBushes.element;
                $cntOfBrokenBushes.element = n + 1;
            }
            int n = $cntOfFolders.element;
            $cntOfFolders.element = n + 1;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$LayerRow;", "", "def", "Lcom/intellij/database/view/structure/DvTreeLayerDef;", "checkBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeLayerDef;Lcom/intellij/ui/dsl/builder/Cell;)V", "getDef", "()Lcom/intellij/database/view/structure/DvTreeLayerDef;", "getCheckBox", "()Lcom/intellij/ui/dsl/builder/Cell;", "intellij.database.impl"})
    private static final class LayerRow {
        @NotNull
        private final DvTreeLayerDef def;
        @NotNull
        private final Cell<JBCheckBox> checkBox;

        public LayerRow(@NotNull DvTreeLayerDef def, @NotNull Cell<? extends JBCheckBox> checkBox) {
            Intrinsics.checkNotNullParameter((Object)def, (String)"def");
            Intrinsics.checkNotNullParameter(checkBox, (String)"checkBox");
            this.def = def;
            this.checkBox = checkBox;
        }

        @NotNull
        public final DvTreeLayerDef getDef() {
            return this.def;
        }

        @NotNull
        public final Cell<JBCheckBox> getCheckBox() {
            return this.checkBox;
        }
    }
}

