/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionDataStorage;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.view.ui.CloudConfigurable;
import com.intellij.database.view.ui.CloudConfigurableKt;
import com.intellij.database.view.ui.CloudConfigurationPanel;
import com.intellij.database.view.ui.CloudDatabasesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010#\u001a\t\u0018\u00010!\u00a2\u0006\u0002\b$H\u0016J\b\u0010%\u001a\u00020\u0002H\u0016J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020\u0002H\u0014J\n\u0010.\u001a\u0004\u0018\u00010+H\u0016J\n\u0010/\u001a\u0004\u0018\u00010+H\u0016J\b\u00100\u001a\u00020!H\u0016J\b\u00101\u001a\u00020+H\u0016J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020'H\u0016J\b\u00105\u001a\u00020-H\u0016J\b\u00106\u001a\u00020'H\u0002J\u0006\u00107\u001a\u00020-J\u0010\u00107\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\b\u00108\u001a\u00020-H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020!H\u0002J\u0006\u0010;\u001a\u00020-J\u0006\u0010<\u001a\u00020-J\u000e\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020?J\u0012\u0010@\u001a\u00020-2\n\u0010A\u001a\u00060Bj\u0002`CR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/database/view/ui/CloudConfigurable;", "Lcom/intellij/database/dataSource/AbstractDatabaseConfigurable;", "Lcom/intellij/database/cloudExplorer/CloudConnectionData;", "project", "Lcom/intellij/openapi/project/Project;", "cd", "controller", "Lcom/intellij/database/view/ui/DatabaseConfigEditor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/cloudExplorer/CloudConnectionData;Lcom/intellij/database/view/ui/DatabaseConfigEditor;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setCoroutineScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "myConnectionData", "tempConnectionData", "myRootPanel", "Ljavax/swing/JPanel;", "myNameComponent", "Lcom/intellij/database/dataSource/DatabaseNameComponent;", "myTabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "myConfigurationPanel", "Lcom/intellij/database/view/ui/CloudConfigurationPanel;", "myDatabasesPanel", "Lcom/intellij/database/view/ui/CloudDatabasesPanel;", "myTestConnectionInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastSaveStamp", "", "myConfigurationTabName", "", "myDatabasesTabName", "getHelpTopic", "Lorg/jetbrains/annotations/NonNls;", "getTempTarget", "isTempTarget", "", "target", "", "getComponent", "Ljavax/swing/JComponent;", "reset", "", "getPreferredFocusedComponent", "getCommonBar", "getDisplayName", "createComponent", "createSouthPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "isModified", "onUserActivity", "isNewConnectionData", "saveConnectionData", "apply", "navigateToTab", "tabName", "navigateToDatabasesTab", "navigateToConfigurationTab", "addNewDataSource", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "showError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.database.impl"})
public final class CloudConfigurable
extends AbstractDatabaseConfigurable<CloudConnectionData> {
    public CoroutineScope coroutineScope;
    @NotNull
    private final CloudConnectionData myConnectionData;
    @NotNull
    private final CloudConnectionData tempConnectionData;
    @NotNull
    private final JPanel myRootPanel;
    @NotNull
    private final DatabaseNameComponent myNameComponent;
    @NotNull
    private final JBTabbedPane myTabbedPane;
    @Nullable
    private CloudConfigurationPanel myConfigurationPanel;
    @Nullable
    private CloudDatabasesPanel myDatabasesPanel;
    @NotNull
    private AtomicBoolean myTestConnectionInProgress;
    private long lastSaveStamp;
    @Nls
    @NotNull
    private final String myConfigurationTabName;
    @Nls
    @NotNull
    private final String myDatabasesTabName;

    public CloudConfigurable(@NotNull Project project, @NotNull CloudConnectionData cd, @NotNull DatabaseConfigEditor controller) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cd, (String)"cd");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super(project, (Object)cd);
        this.myConnectionData = cd;
        this.myRootPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)0), JBUIScale.scale((int)5)));
        this.myNameComponent = new DatabaseNameComponent(this, controller, false);
        this.myTabbedPane = new JBTabbedPane();
        this.myTestConnectionInProgress = new AtomicBoolean(false);
        String string = DatabaseBundle.message((String)"clouds.tab.configuration", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myConfigurationTabName = string;
        String string2 = DatabaseBundle.message((String)"cloud.tab.databases", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.myDatabasesTabName = string2;
        this.setController(controller);
        this.tempConnectionData = cd.copy();
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope != null) {
            return coroutineScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"coroutineScope");
        return null;
    }

    public final void setCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.coroutineScope = coroutineScope;
    }

    @Nullable
    public String getHelpTopic() {
        return "cloud.help.topic";
    }

    @NotNull
    public CloudConnectionData getTempTarget() {
        long curStamp = this.getModificationCount();
        if (curStamp != this.lastSaveStamp) {
            this.lastSaveStamp = curStamp;
            this.saveConnectionData(this.tempConnectionData);
        }
        return this.tempConnectionData;
    }

    public boolean isTempTarget(@Nullable Object target) {
        return target == this.tempConnectionData;
    }

    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    protected void reset(@NotNull CloudConnectionData target) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.myNameComponent.reset(target, null);
            CloudConfigurationPanel cloudConfigurationPanel = this.myConfigurationPanel;
            if (cloudConfigurationPanel == null) break block0;
            cloudConfigurationPanel.reset(target);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Nullable
    public JComponent getCommonBar() {
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myNameComponent.getNameValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameValue(...)");
        return string;
    }

    @NotNull
    public JComponent createComponent() {
        CoroutineScope coroutineScope = this.getController().getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.setCoroutineScope(CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"javaClass", null, (boolean)false, (int)6, null));
        Disposer.register((Disposable)((Disposable)this), () -> CloudConfigurable.createComponent$lambda$0(this));
        this.myRootPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane.setTabComponentInsets(null);
        this.myRootPanel.add((Component)this.myTabbedPane, "Center");
        CloudConfigurationPanel cloudConfigurationPanel = this.myConfigurationPanel = new CloudConfigurationPanel(this);
        Intrinsics.checkNotNull((Object)cloudConfigurationPanel);
        JComponent configurationComponent = cloudConfigurationPanel.getComponent();
        this.myDatabasesPanel = new CloudDatabasesPanel(this);
        JPanel extendedConfigurationPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)0), JBUIScale.scale((int)5)));
        extendedConfigurationPanel.add((Component)configurationComponent, "North");
        extendedConfigurationPanel.add((Component)this.createSouthPanel(), "South");
        this.myTabbedPane.addTab(this.myConfigurationTabName, (Component)extendedConfigurationPanel);
        CloudDatabasesPanel cloudDatabasesPanel = this.myDatabasesPanel;
        this.myTabbedPane.addTab(this.myDatabasesTabName, (Component)(cloudDatabasesPanel != null ? cloudDatabasesPanel.getComponent() : null));
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myRootPanel;
    }

    private final DialogPanel createSouthPanel() {
        String string = DatabaseBundle.message((String)"cloud.tab.next.select.databases", (Object[])new Object[0]);
        JButton moveToDatabasesButton2 = new JButton(new AbstractAction(this, string){
            final /* synthetic */ CloudConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.navigateToDatabasesTab();
            }
        });
        String $this$createSouthPanel_u24lambda_u241 = string = BuilderKt.panel(arg_0 -> CloudConfigurable.createSouthPanel$lambda$0(moveToDatabasesButton2, this, arg_0));
        boolean bl = false;
        $this$createSouthPanel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        return string;
    }

    public boolean isModified() {
        if (this.isNewConnectionData()) {
            return true;
        }
        return !this.getTempTarget().equalsConfiguration(this.myConnectionData);
    }

    public void onUserActivity() {
        this.saveConnectionData(this.tempConnectionData);
    }

    private final boolean isNewConnectionData() {
        return CloudConnectionDataStorage.Companion.getInstance().getConnectionData(this.myConnectionData.getId()) == null;
    }

    public final void saveConnectionData() {
        this.saveConnectionData(this.tempConnectionData);
    }

    private final void saveConnectionData(CloudConnectionData cd) {
        block0: {
            this.myNameComponent.save(cd);
            CloudConfigurationPanel cloudConfigurationPanel = this.myConfigurationPanel;
            if (cloudConfigurationPanel == null) break block0;
            cloudConfigurationPanel.saveFields(cd);
        }
    }

    public void apply() throws ConfigurationException {
        this.saveConnectionData(this.tempConnectionData);
        this.saveConnectionData(this.myConnectionData);
        CloudConnectionDataStorage.Companion.getInstance().update(this.myConnectionData);
    }

    private final void navigateToTab(String tabName) {
        int index = DataSourceConfigurable.findTabIndex(this.myTabbedPane, tabName);
        if (index == -1) {
            CloudConfigurableKt.access$getLOG$p().error("Cannot find tab with name " + tabName);
            return;
        }
        this.myTabbedPane.setSelectedIndex(index);
    }

    public final void navigateToDatabasesTab() {
        this.navigateToTab(this.myDatabasesTabName);
    }

    public final void navigateToConfigurationTab() {
        this.navigateToTab(this.myConfigurationTabName);
    }

    public final void addNewDataSource(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.getController().onCreated((Object)dataSource);
    }

    public final void showError(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.getController().showErrorNotification((AbstractDatabaseConfigurable)this, (Object)"CLOUD_ERROR", e);
    }

    private static final void createComponent$lambda$0(CloudConfigurable this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.getCoroutineScope(), null, (int)1, null);
    }

    private static final Unit createSouthPanel$lambda$0(JButton $moveToDatabasesButton, CloudConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CloudConfigurable.createSouthPanel$lambda$0$0($moveToDatabasesButton, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createSouthPanel$lambda$0$0(JButton $moveToDatabasesButton, CloudConfigurable this$0, Row $this$row) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBLabel testLabel = new JBLabel();
        String string = DatabaseBundle.message((String)"cloud.tab.test.connection.details", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ActionLink $this$createSouthPanel_u24lambda_u240_u240_u241 = object = new ActionLink(string, arg_0 -> CloudConfigurable.createSouthPanel$lambda$0$0$0(this$0, arg_0));
        boolean bl = false;
        $this$createSouthPanel_u24lambda_u240_u240_u241.setVisible(false);
        ActionLink detailsLink = object;
        object = DatabaseBundle.message((String)"cloud.tab.test.connection", (Object[])new Object[0]);
        $this$row.cell((JComponent)new JButton(new AbstractAction(testLabel, detailsLink, this$0, (String)object){
            final /* synthetic */ JBLabel $testLabel;
            final /* synthetic */ ActionLink $detailsLink;
            final /* synthetic */ CloudConfigurable this$0;
            {
                this.$testLabel = $testLabel;
                this.$detailsLink = $detailsLink;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            private final void loading() {
                this.$testLabel.setText("");
                this.$testLabel.setIcon((Icon)new AnimatedIcon.Default());
                this.$detailsLink.setVisible(false);
            }

            private final void success(@NlsSafe String result) {
                this.$testLabel.setText(result);
                this.$testLabel.setIcon(null);
                this.$detailsLink.setVisible(true);
            }

            private final void error() {
                this.$testLabel.setText("");
                this.$testLabel.setIcon(AllIcons.General.Error);
                this.$detailsLink.setVisible(true);
            }

            public void actionPerformed(ActionEvent e) {
                if (!CloudConfigurable.access$getMyTestConnectionInProgress$p(this.this$0).compareAndSet(false, true)) {
                    return;
                }
                this.loading();
                BuildersKt.launch$default((CoroutineScope)this.this$0.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, this.this$0, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ createSouthPanel.1.1.1 this$0;
                    final /* synthetic */ CloudConfigurable this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_3 = this.this$0;
                                v0 = CloudConfigurable.access$getMyDatabasesPanel$p(this.this$1);
                                Intrinsics.checkNotNull((Object)v0);
                                this.L$0 = var2_3;
                                this.label = 1;
                                v1 = v0.testConnection((Continuation<? super String>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                var2_3 = this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl18:
                                // 2 sources

                                createSouthPanel.1.1.1.access$success(var2_3, (String)v1);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null).invokeOnCompletion(arg_0 -> createSouthPanel.1.1.1.actionPerformed$lambda$0(this, this.this$0, arg_0));
            }

            private static final Unit actionPerformed$lambda$0(createSouthPanel.1.1.1 this$0, CloudConfigurable this$1, Throwable it) {
                if (it != null) {
                    this$0.error();
                }
                CloudConfigurable.access$getMyTestConnectionInProgress$p(this$1).set(false);
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ void access$success(createSouthPanel.1.1.1 $this, String result) {
                $this.success(result);
            }
        })).gap(RightGap.SMALL);
        $this$row.cell((JComponent)testLabel);
        $this$row.cell((JComponent)detailsLink);
        $this$row.cell((JComponent)$moveToDatabasesButton).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createSouthPanel$lambda$0$0$0(CloudConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.navigateToTab(this$0.myDatabasesTabName);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicBoolean access$getMyTestConnectionInProgress$p(CloudConfigurable $this) {
        return $this.myTestConnectionInProgress;
    }

    public static final /* synthetic */ CloudDatabasesPanel access$getMyDatabasesPanel$p(CloudConfigurable $this) {
        return $this.myDatabasesPanel;
    }
}

