/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromCloud;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class DataSourcesSideTab
extends DatabaseConfigSideTab {
    DataSourceErrorsConfigurable myErrorsConfigurable;
    AnAction myAddAction;

    public DataSourcesSideTab(@NotNull DatabaseConfigEditorImpl editor2) {
        if (editor2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message((String)"tab.title.data.sources", (Object[])new Object[0]), editor2);
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this.myEditor, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().revalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
            editor2.updateCurrentValidationProblem();
        });
    }

    Collection<DbDataSource> getAllDataSources(DatabaseConfigEditorImpl.DataSourceSettings settings) {
        LinkedHashSet<DbDataSource> result = new LinkedHashSet<DbDataSource>(settings.facade.getDataSources());
        result.addAll(settings.newDataSources);
        result.removeAll(this.myRemovedObjects);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DataSourcesSideTab.$$$reportNull$$$0(1);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List<@NlsContexts.Separator String> sections = Arrays.asList(DatabaseBundle.message((String)"separator.global.data.sources", (Object[])new Object[0]), DatabaseBundle.message((String)"separator.project.data.sources", (Object[])new Object[0]), DatabaseBundle.message((String)"separator.ddl.data.sources", (Object[])new Object[0]), DatabaseBundle.message((String)"separator.imported.data.sources", (Object[])new Object[0]));
            List items = this.sectionize(this.getAllDataSources(settings), this::createItem, o -> o.isGlobal() ? 0 : (o.isImported() ? 3 : (((DbDataSourceImpl)o.getObject()).getDelegate() instanceof SqlDataSource ? 2 : 1)));
            for (int i = 0; i < items.size(); ++i) {
                this.mySidePanel.addSeparator(sections.get(i));
                List list = items.get(i);
                list.sort(Comparator.comparing(SidePanelItem.DataSourceItem::getName, DbPresentation.NAMES_COMPARATOR));
                for (SidePanelItem item : list) {
                    addedItems.add(this.addToSidePanel(item));
                }
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
            if (keepSelection) {
                this.restoreSelection(selection);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @Override
    public boolean isMine(Object object) {
        return object instanceof DasDataSource;
    }

    @NotNull
    public SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj) {
        SidePanelItem.DataSourceItem item;
        if (obj == null) {
            DataSourcesSideTab.$$$reportNull$$$0(2);
        }
        if ((item = (SidePanelItem.DataSourceItem)this.getSidePanelItem(obj)) == null) {
            item = new SidePanelItem.DataSourceItem(this.myEditor, (DbDataSourceImpl)obj);
        }
        SidePanelItem.DataSourceItem dataSourceItem = this.createItem(item);
        if (dataSourceItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(3);
        }
        return dataSourceItem;
    }

    @NotNull
    public SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj) {
        SidePanelItem.ErrorsItem item;
        if (obj == null) {
            DataSourcesSideTab.$$$reportNull$$$0(4);
        }
        if ((item = (SidePanelItem.ErrorsItem)this.getSidePanelItem(obj)) == null) {
            item = new SidePanelItem.ErrorsItem(this.myEditor, obj);
        }
        SidePanelItem.ErrorsItem errorsItem = this.createItem(item);
        if (errorsItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(5);
        }
        return errorsItem;
    }

    @Override
    public void disposeUi() {
        super.disposeUi();
        this.myErrorsConfigurable.disposeUIResources();
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.DataSourceItem dataSourceItem;
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(6);
        }
        if ((dataSourceItem = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(item, SidePanelItem.DataSourceItem.class)) == null) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)dataSourceItem.getObject();
        AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
        this.copy(dataSource, configurable);
    }

    @VisibleForTesting
    public DasDataSource copy(DbDataSource dataSource, AbstractDataSourceConfigurable<?, ?> configurable) {
        DatabaseCredentials credentials;
        Object delegate;
        if (configurable instanceof DataSourceConfigurable) {
            delegate = ((DataSourceConfigurable)configurable).getTempDataSourceForConnection();
            credentials = this.myEditor.getSecretService();
        } else if (configurable != null) {
            delegate = configurable.getTempDataSource();
            credentials = this.myEditor.getSecretService();
        } else {
            delegate = dataSource.getDelegate();
            credentials = DatabaseCredentials.getInstance();
        }
        String newName = this.myEditor.generateObjectName(null, delegate.getName());
        DataSourceManager dbManager = this.myEditor.getSettings().facade.getDataSourceManager(dataSource);
        RawDataSource databaseSystem = dbManager.copyDataSource(newName, (RawDataSource)delegate);
        if (delegate instanceof LocalDataSource) {
            DatabaseAuthProvider.copyAllCredentials((DatabaseConnectionPoint)delegate, (DatabaseCredentials)credentials, (DatabaseConnectionConfig)((LocalDataSource)databaseSystem), (DatabaseCredentials)this.myEditor.getSecretService());
        }
        this.onDataSourceCreated(this.myEditor.getSettings().facade, dbManager, databaseSystem);
        return databaseSystem;
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(7);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target) {
        ActionManager actionManager = ActionManager.getInstance();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        DatabaseConfigSideTab.CopyAction copyAction = new DatabaseConfigSideTab.CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        BackAction backAction = new BackAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        DatabaseConfigSideTab.ResetAction revertAction2 = new DatabaseConfigSideTab.ResetAction();
        revertAction2.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        SetIntrospectionLevelAction setIntrospectionLevelAction = new SetIntrospectionLevelAction();
        SourceLoadingAction sourceLoading = new SourceLoadingAction();
        left.addAll(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction});
        right.addAll(new AnAction[]{backAction, forwardAction});
        context.add(this.myAddAction);
        context.add((AnAction)removeAction);
        context.add((AnAction)copyAction);
        context.add((AnAction)scopeAction);
        context.addSeparator();
        context.add((AnAction)editDefaultsAction);
        context.add((AnAction)new ChooseDriverGroup());
        context.addSeparator();
        context.add((AnAction)revertAction2);
        context.add((AnAction)setIntrospectionLevelAction);
        context.add((AnAction)sourceLoading);
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(10);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    public boolean isUsed(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DataSourcesSideTab.$$$reportNull$$$0(11);
        }
        for (DbDataSource ds : this.getAllDataSources(this.myEditor.getSettings())) {
            SidePanelItem.DataSourceItem item;
            LocalDataSource dataSource;
            DatabaseDriver dsDriver;
            if (this.myRemovedObjects.contains(ds) || (dsDriver = (dataSource = (item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(this.getSidePanelItem(ds), SidePanelItem.DataSourceItem.class)) == null ? null : item.extractActualLocalDataSource()) == null ? null : dataSource.getDatabaseDriver()) != driver) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onApply() throws ConfigurationException {
        DbDeleteProvider.closeAllFilesBeforeDataSourceRemoval(this.myEditor.getSettings().facade.getProject(), (Set)JBIterable.from((Iterable)this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo(new LinkedHashSet()));
        super.onApply();
        this.myEditor.getSettings().facade.clearCaches();
    }

    @Override
    protected void ensureNewObjectDropped(Object object) {
        if (object instanceof DbDataSource) {
            this.myEditor.getSettings().newDataSources.remove(object);
        }
    }

    @Override
    protected void removeObject(Object object) {
        if (object instanceof DbDataSource) {
            DbDataSource element = (DbDataSource)object;
            for (DbDataSource existingDS : this.myEditor.getSettings().facade.getDataSources()) {
                if (existingDS.getDelegate() != element.getDelegate()) continue;
                this.myEditor.getSettings().facade.getDataSourceManager(element).removeDataSource(element.getDelegate());
                break;
            }
        }
    }

    @Override
    @Nullable
    public SidePanelItem<?, ?> getSidePanelItem(@Nullable Object key) {
        if (key instanceof DasDataSource && !(key instanceof DbDataSource)) {
            return (SidePanelItem)ContainerUtil.find(this.mySidePanelItems.values(), item -> item instanceof SidePanelItem.DataSourceItem && ((DbDataSource)item.getObject()).getDelegate() == key);
        }
        return super.getSidePanelItem(key);
    }

    void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull RawDataSource dataSource) {
        if (facade == null) {
            DataSourcesSideTab.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            DataSourcesSideTab.$$$reportNull$$$0(13);
        }
        if (dataSource == null) {
            DataSourcesSideTab.$$$reportNull$$$0(14);
        }
        DbDataSource element = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource, manager);
        this.myEditor.getSettings().newDataSources.add(element);
        this.myEditor.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, null);
        DatabaseConfigEditorImpl.createEditorIfNeeded(this.createItem(element));
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(element, true);
    }

    public List<AnAction> getAddActions(@Nullable java.util.function.Consumer<DasDataSource> callback) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        DatabaseConfigEditorImpl.DataSourceSettings settings = this.myEditor.getSettings();
        DbPsiFacade facade = settings.facade;
        LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(facade.getProject());
        Function toTemp = o -> this.isRemoved(o) ? null : this.myEditor.getTempTargetOrTarget(o);
        java.util.function.Consumer<LocalDataSource> consumer = ds -> this.handleCreated(facade, (DataSourceManager)defaultManager, (RawDataSource)ds, callback);
        JBIterable newDrivers = JBIterable.from(settings.newDrivers).filterMap(toTemp);
        JBIterable existingDrivers = JBIterable.from((Iterable)DatabaseDriverManager.getInstance().getDrivers()).filterMap(toTemp);
        actions.addAll(defaultManager.getCreateDataSourceActions(newDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)consumer::accept)));
        actions.add((AnAction)Separator.getInstance());
        actions.addAll(defaultManager.getCreateDataSourceActions(existingDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)consumer::accept)));
        actions.add((AnAction)Separator.getInstance());
        for (DataSourceManager manager : DataSourceManager.getManagers((Project)facade.getProject())) {
            if (manager == defaultManager) continue;
            ContainerUtil.addIfNotNull(actions, (Object)this.getCreateActions(callback, facade, manager));
        }
        DatabaseViewActions.DataSourceFactory factory = (f, m, ds) -> this.handleCreated(f, (DataSourceManager)m, (RawDataSource)ds, (java.util.function.Consumer)callback);
        actions.add((AnAction)new AddDataSourceFromUrl(factory));
        actions.add((AnAction)new AddDataSourceFromCloud());
        actions.add((AnAction)new AddDataSourceFromPath.FromDialog(factory));
        return actions;
    }

    @Nullable
    private <T extends RawDataSource> AnAction getCreateActions(@Nullable java.util.function.Consumer<? super T> callback, DbPsiFacade facade, DataSourceManager<T> manager) {
        return manager.getCreateDataSourceAction(ds -> this.handleCreated(facade, manager, (RawDataSource)ds, callback));
    }

    private <T extends RawDataSource> void handleCreated(DbPsiFacade f, DataSourceManager<T> m, T ds, @Nullable java.util.function.Consumer<? super T> callback) {
        this.onDataSourceCreated(f, m, ds);
        if (callback != null) {
            callback.accept(ds);
        }
    }

    @Nullable
    public static DataSourcesSideTab getDataSourcesTab(@Nullable AnActionEvent e) {
        return e == null ? null : (DataSourcesSideTab)ObjectUtils.tryCast((Object)e.getData(SIDE_PANEL), DataSourcesSideTab.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDataSources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocalDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class AddAction
    extends ActionGroup
    implements DumbAware {
        private AddAction() {
            super(DatabaseBundle.message((String)"action.DatabaseConfigEditor.add.text", (Object[])new Object[0]), null, IconUtil.getAddIcon());
            this.setPopup(true);
            this.getTemplatePresentation().setPerformGroup(true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.SUPPRESS_SUBMENU, (Object)true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20, null, ActionPlaces.getPopupPlace((String)"database"));
            DbUIUtil.showPopup((JBPopup)popup2, null, e);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    AddAction.$$$reportNull$$$0(1);
                }
                return AnAction.EMPTY_ARRAY;
            }
            List<AnAction> actions = dataSourcesTab.getAddActions(null);
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        GoToDriverAction() {
            super(DatabaseBundle.message((String)"action.DatabaseConfigEditor.go.to.driver.text", (Object[])new Object[0]), null, AllIcons.General.Settings);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GoToDriverAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(DataSourcesSideTab.getDataSourcesTab(e) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            LocalDataSource localDataSource;
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(2);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection = dataSourcesTab.getSelectedDataSources();
            SidePanelItem.DataSourceItem dataSource = (SidePanelItem.DataSourceItem)selection.first();
            LocalDataSource localDataSource2 = localDataSource = dataSource == null ? null : dataSource.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            dataSourcesTab.myEditor.navigateTo(localDataSource.getDatabaseDriver(), false);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(3);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                return false;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection = dataSourcesTab.getSelectedDataSources();
            if (selection.size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = Objects.requireNonNull((SidePanelItem.DataSourceItem)selection.first()).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$GoToDriverAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$GoToDriverAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DataSourceScopeAction
    extends DumbAwareAction {
        DataSourceScopeAction() {
            super(DatabaseBundle.message((String)"action.DatabaseConfigEditor.data.source.scope.text", (Object[])new Object[0]), null, AllIcons.ToolbarDecorator.Import);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                DataSourceScopeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        boolean isIDEScopeSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(1);
            }
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            boolean isIDEScope = true;
            if (dataSourcesTab != null) {
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    isIDEScope &= item.isGlobal();
                }
            }
            return isIDEScope;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(2);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setEnabled(!dataSourcesTab.getSelectedLocalDataSources().filter(ds -> DataSourceScopeAction.canMoveToScope(e.getProject(), ds, null)).isEmpty());
            }
            boolean ideScope = this.isIDEScopeSelected(e);
            e.getPresentation().setText(DatabaseBundle.message((String)(ideScope ? "action.DatabaseConfigEditor.move.to.project.text" : "action.DatabaseConfigEditor.make.global.text"), (Object[])new Object[0]));
            e.getPresentation().setIcon(ideScope ? AllIcons.ToolbarDecorator.Import : AllIcons.ToolbarDecorator.Export);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(3);
            }
            boolean isIDEScope = this.isIDEScopeSelected(e);
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                return;
            }
            for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable;
                if (!DataSourceScopeAction.canMoveToScope(e.getProject(), item, !isIDEScope) || (configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class))) == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
        }

        private static boolean canMoveToScope(Project project, SidePanelItem.DataSourceItem item, Boolean global) {
            LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)item.getObject()).getDelegate(), LocalDataSource.class);
            if (ds == null) {
                return false;
            }
            String id = ds.getUniqueId();
            if (global == null) {
                global = !ds.isGlobal();
            }
            DataSourceStorage storage = DbSrcUtils.getDataSourceStorage((Project)(global != false ? null : project));
            for (LocalDataSource source : storage.getDataSources()) {
                if (source.isGlobal() != global.booleanValue() || !id.equals(source.getUniqueId()) || source == ds) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$DataSourceScopeAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$DataSourceScopeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isIDEScopeSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SetIntrospectionLevelAction
    extends ActionGroup {
        private final AnAction[] mySetActions = new AnAction[]{new SetValueAction(Level.L1, DatabaseBundle.message((String)"database.introspection.level.1.name", (Object[])new Object[0]), DatabaseIcons.Level1), new SetValueAction(Level.L2, DatabaseBundle.message((String)"database.introspection.level.2.name", (Object[])new Object[0]), DatabaseIcons.Level2), new SetValueAction(Level.L3, DatabaseBundle.message((String)"database.introspection.level.3.name", (Object[])new Object[0]), DatabaseIcons.Level3)};

        SetIntrospectionLevelAction() {
            super(DatabaseBundle.message((String)"dataSourceSideTab.introspectionLevel.action.group.setDefaultLevel.text", (Object[])new Object[0]), DatabaseBundle.message((String)"dataSourceSideTab.introspectionLevel.action.group.setDefaultLevel.description", (Object[])new Object[0]), null);
            this.setPopup(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.mySetActions == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(1);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(2);
            }
            JBIterable<SidePanelItem.DataSourceItem> dsItems = (dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) != null ? dataSourcesTab.getSelectedLocalDataSources() : null;
            boolean bl = enabled = dsItems != null && !dsItems.isEmpty();
            if (enabled) {
                for (SidePanelItem.DataSourceItem item : dsItems) {
                    Dbms dbms = ((DbDataSourceImpl)item.getObject()).getDbms();
                    if (DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)dbms)) continue;
                    enabled = false;
                    break;
                }
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }

        private static class SetValueAction
        extends DumbAwareAction {
            private final Level myLevel;

            SetValueAction(@NotNull Level level, @NotNull @NlsActions.ActionText String caption, @Nullable Icon icon) {
                if (level == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                super(caption, null, icon);
                this.myLevel = level;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DataSourcesSideTab dataSourcesTab;
                if (e == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                    return;
                }
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class));
                    if (configurable == null) continue;
                    configurable.setIntrospectionLevel(this.myLevel);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "level";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class SourceLoadingAction
    extends ActionGroup {
        private final AnAction[] mySetActions = new AnAction[]{new SetValueAction(DatabaseBundle.message((String)"action.DatabaseConfigEditor.none.text", (Object[])new Object[0]), DBIntrospectionOptions.SourceLoading.NO_SOURCES), new SetValueAction(DatabaseBundle.message((String)"action.DatabaseConfigEditor.except.system.schemas.text", (Object[])new Object[0]), DBIntrospectionOptions.SourceLoading.USER_SOURCES), new SetValueAction(DatabaseBundle.message((String)"action.DatabaseConfigEditor.all.schemas.text", (Object[])new Object[0]), DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES)};

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SourceLoadingAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        SourceLoadingAction() {
            super(DatabaseBundle.message((String)"action.DatabaseConfigEditor.load.sources.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseConfigEditor.which.sources.to.load.description", (Object[])new Object[0]), AllIcons.Actions.Download);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.mySetActions == null) {
                SourceLoadingAction.$$$reportNull$$$0(1);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                SourceLoadingAction.$$$reportNull$$$0(2);
            }
            JBIterable<SidePanelItem.DataSourceItem> dsItems = (dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) != null ? dataSourcesTab.getSelectedLocalDataSources() : null;
            boolean bl = enabled = dsItems != null && !dsItems.isEmpty();
            if (enabled) {
                for (SidePanelItem.DataSourceItem item : dsItems) {
                    Dbms dbms;
                    Dbms dbms2 = dbms = item.getConfigurable() != null ? ((AbstractDataSourceConfigurable)((Object)item.getConfigurable())).getDataSource().getDbms() : null;
                    if (dbms != null && !DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)dbms)) continue;
                    enabled = false;
                    break;
                }
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }

        private static class SetValueAction
        extends DumbAwareAction {
            private final DBIntrospectionOptions.SourceLoading myMode;

            SetValueAction(@NotNull @NlsActions.ActionText String caption, @NotNull DBIntrospectionOptions.SourceLoading mode) {
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (mode == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                super(caption);
                this.myMode = mode;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DataSourcesSideTab dataSourcesTab;
                if (e == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                    return;
                }
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class));
                    if (configurable == null) continue;
                    configurable.setSourceLoading(this.myMode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        ChooseDriverGroup() {
            super(DatabaseBundle.message((String)"action.DatabaseConfigEditor.change.driver.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.DatabaseConfigEditor.change.data.source.driver.description", (Object[])new Object[0]), null);
            this.getTemplatePresentation().setPopupGroup(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ChooseDriverGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                ChooseDriverGroup.$$$reportNull$$$0(1);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> dataSources = dataSourcesTab.getSelectedLocalDataSources();
            JBIterable<DatabaseDriver> drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource));
            e.getPresentation().setVisible(!dataSources.isEmpty());
            e.getPresentation().setEnabled(drivers.take(2).size() > 1);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            final DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            final JBIterable<SidePanelItem.DataSourceItem> dataSources = dataSourcesTab.getSelectedLocalDataSources();
            List drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource)).filterMap(o -> dataSourcesTab.myEditor.getTempTargetOrTarget(o)).toList();
            if (drivers.size() < 2) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(3);
                }
                return EMPTY_ARRAY;
            }
            final Set selection = dataSourcesTab.getSelectedItems().toSet();
            ArrayList<1> res2 = new ArrayList<1>();
            for (final DatabaseDriver driver : drivers) {
                res2.add(new DumbAwareAction(this, driver.getName(), null, driver.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e1) {
                        if (e1 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (SidePanelItem.DataSourceItem item : dataSources) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class));
                            if (configurable == null) continue;
                            configurable.setDriver(driver);
                        }
                        dataSourcesTab.restoreSelection(selection);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup$1", "actionPerformed"));
                    }
                });
            }
            AnAction[] anActionArray = res2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooseDriverGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

