/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlMappingSideTab
extends DatabaseConfigSideTab {
    public DdlMappingSideTab(@NotNull DatabaseConfigEditorImpl editor2) {
        if (editor2 == null) {
            DdlMappingSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message((String)"tab.title.ddl.mappings", (Object[])new Object[0]), editor2);
    }

    Collection<DdlMapping> getAllMappings(DatabaseConfigEditorImpl.DataSourceSettings settings) {
        DdlMappingsManager mappingsManager = DdlMappingsManager.getInstance((Project)settings.facade.getProject());
        ArrayList<DdlMapping> result = new ArrayList<DdlMapping>(mappingsManager.getMappings());
        result.addAll(settings.newMappings);
        result.removeAll(this.myRemovedObjects);
        result.sort(Comparator.comparing(DdlMapping::getName, DbPresentation.NAMES_COMPARATOR));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DdlMappingSideTab.$$$reportNull$$$0(1);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List list = ContainerUtil.sorted((Collection)ContainerUtil.map(this.getAllMappings(settings), this::createItem), Comparator.comparing(SidePanelItem.MappingItem::getName, DbPresentation.NAMES_COMPARATOR));
            for (SidePanelItem item : list) {
                addedItems.add(this.addToSidePanel(item));
            }
            if (keepSelection) {
                this.restoreSelection(selection);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @Override
    public boolean isMine(Object object) {
        return object instanceof DdlMapping;
    }

    @NotNull
    private SidePanelItem.MappingItem createItem(@NotNull DdlMapping obj) {
        SidePanelItem.MappingItem item;
        if (obj == null) {
            DdlMappingSideTab.$$$reportNull$$$0(2);
        }
        if ((item = (SidePanelItem.MappingItem)this.getSidePanelItem(obj)) == null) {
            item = new SidePanelItem.MappingItem(this.myEditor, obj);
        }
        SidePanelItem.MappingItem mappingItem = this.createItem(item);
        if (mappingItem == null) {
            DdlMappingSideTab.$$$reportNull$$$0(3);
        }
        return mappingItem;
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target) {
        ActionManager actionManager = ActionManager.getInstance();
        AddAction addAction = new AddAction();
        addAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        DatabaseConfigSideTab.CopyAction copyAction = new DatabaseConfigSideTab.CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        BackAction backAction = new BackAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        DatabaseConfigSideTab.ResetAction revertAction2 = new DatabaseConfigSideTab.ResetAction();
        revertAction2.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        left.addAll(new AnAction[]{addAction, removeAction, copyAction});
        right.addAll(new AnAction[]{backAction, forwardAction});
        context.add((AnAction)addAction);
        context.add((AnAction)removeAction);
        context.add((AnAction)copyAction);
        context.addSeparator();
        context.add((AnAction)revertAction2);
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.MappingItem mappingItem;
        if (item == null) {
            DdlMappingSideTab.$$$reportNull$$$0(4);
        }
        return (mappingItem = (SidePanelItem.MappingItem)ObjectUtils.tryCast(item, SidePanelItem.MappingItem.class)) != null;
    }

    @Override
    public void onApply() throws ConfigurationException {
        LinkedHashSet<DdlMapping> newMappings = new LinkedHashSet<DdlMapping>();
        if (DatabaseSettings.getSettings().suggestMappingDumping) {
            for (SidePanelItem<?, ?> item : this.getSidePanelItems()) {
                DdlMapping mapping = (DdlMapping)ObjectUtils.tryCast(item.getObject(), DdlMapping.class);
                if (mapping == null || !this.isObjectCreated(item)) continue;
                newMappings.add(mapping);
            }
        }
        super.onApply();
        newMappings.removeIf(m -> m.getDataSourceId() == null || m.getDdlDataSourceId() == null || m.getScope() == null);
        if (!newMappings.isEmpty()) {
            this.myEditor.onChangesApplied(indicator -> ApplicationManager.getApplication().invokeLater(() -> {
                boolean dump2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DatabaseBundle.message((String)"dialog.title.dump.ddl", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.message.do.you.want.to.dump.to.ddl.data.source", (Object[])new Object[]{StringUtil.join((Collection)newMappings, DdlMapping::getName, (String)"\n"), DatabaseBundle.message((String)"group.DatabaseView.DdlMapping.Actions.text", (Object[])new Object[0])})).yesText(DatabaseBundle.message((String)"button.dump", (Object[])new Object[0]))).noText(DatabaseBundle.message((String)"button.later", (Object[])new Object[0]))).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){

                    public void rememberChoice(boolean isSelected, int exitCode) {
                        DatabaseSettings.getSettings().suggestMappingDumping = !isSelected;
                    }
                })).ask(this.myEditor.getProject());
                if (dump2) {
                    DumpToDdlDataSourceActionKt.dump(this.myEditor.getProject(), newMappings, true);
                }
            }));
        }
    }

    @Override
    protected void ensureNewObjectDropped(Object object) {
        if (object instanceof DdlMapping) {
            this.myEditor.getSettings().newMappings.remove(object);
        }
    }

    @Override
    protected void removeObject(Object object) {
        if (object instanceof DdlMapping) {
            DdlMapping mapping = (DdlMapping)object;
            DdlMappingsManager manager = DdlMappingsManager.getInstance((Project)this.myEditor.getSettings().facade.getProject());
            DdlMapping existing = manager.findById(mapping.getUniqueId());
            if (existing != null) {
                manager.remove(existing);
            }
        }
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.MappingItem mappingItem;
        if (item == null) {
            DdlMappingSideTab.$$$reportNull$$$0(5);
        }
        if ((mappingItem = (SidePanelItem.MappingItem)ObjectUtils.tryCast(item, SidePanelItem.MappingItem.class)) == null) {
            return;
        }
        DdlMapping mapping = this.myEditor.getTempTargetOrTarget((DdlMapping)mappingItem.getObject());
        Set names = (Set)JBIterable.from(this.getAllMappings(this.myEditor.getSettings())).map(DdlMapping::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        String newName = DbUtil.generateUniqueName((String)mapping.getName(), (Set)names);
        this.addNewMappingAndNavigate(mapping.copy(newName, false));
    }

    private DdlMapping createMapping() {
        DdlMapping mapping = new DdlMapping(null);
        mapping.setName(this.myEditor.generateObjectName(mapping, "DDL Mapping"));
        return mapping;
    }

    void addNewMappingAndNavigate(@NotNull DdlMapping newMapping) {
        if (newMapping == null) {
            DdlMappingSideTab.$$$reportNull$$$0(6);
        }
        this.myEditor.getSettings().newMappings.add(newMapping);
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(newMapping, true);
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DdlMappingSideTab.$$$reportNull$$$0(7);
        }
        return item instanceof SidePanelItem.MappingItem;
    }

    @Nullable
    public static DdlMappingSideTab getMappingsTab(@Nullable AnActionEvent e) {
        return e == null ? null : (DdlMappingSideTab)ObjectUtils.tryCast((Object)e.getData(SIDE_PANEL), DdlMappingSideTab.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DdlMappingSideTab";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DdlMappingSideTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewMappingAndNavigate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canCopy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class AddAction
    extends DumbAwareAction {
        private AddAction() {
            super(DatabaseBundle.message((String)"action.create.ddl.mapping.text", (Object[])new Object[0]), null, IconUtil.getAddIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DdlMappingSideTab mappingsTab;
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            if ((mappingsTab = DdlMappingSideTab.getMappingsTab(e)) == null) {
                return;
            }
            mappingsTab.addNewMappingAndNavigate(mappingsTab.createMapping());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DdlMappingSideTab$AddAction", "actionPerformed"));
        }
    }
}

