/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.plugins.frontend.split;

import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.newui.PluginDependencyModel;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.platform.plugins.frontend.split.ContentModuleHeader;
import com.intellij.platform.plugins.frontend.split.PluginHeader;
import com.intellij.platform.plugins.frontend.split.ProductModeCompatibility;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility;", "", "client", "Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;", "backend", "monolith", "<init>", "(Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;)V", "getClient", "()Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;", "getBackend", "getMonolith", "Companion", "intellij.platform.plugins.frontend.split"})
public final class PluginProductModeCompatibility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProductModeCompatibility client;
    @NotNull
    private final ProductModeCompatibility backend;
    @NotNull
    private final ProductModeCompatibility monolith;
    @NotNull
    private static final String FRONTEND_MODULE_ID = "intellij.platform.frontend";
    @NotNull
    private static final String FRONTEND_SPLIT_MODULE_ID = "intellij.platform.frontend.split";
    @NotNull
    private static final String BACKEND_MODULE_ID = "intellij.platform.backend";

    public PluginProductModeCompatibility(@NotNull ProductModeCompatibility client, @NotNull ProductModeCompatibility backend, @NotNull ProductModeCompatibility monolith) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)((Object)monolith), (String)"monolith");
        this.client = client;
        this.backend = backend;
        this.monolith = monolith;
    }

    @NotNull
    public final ProductModeCompatibility getClient() {
        return this.client;
    }

    @NotNull
    public final ProductModeCompatibility getBackend() {
        return this.backend;
    }

    @NotNull
    public final ProductModeCompatibility getMonolith() {
        return this.monolith;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion;", "", "<init>", "()V", "determineProductModeCompatibility", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility;", "plugin", "Lcom/intellij/platform/plugins/frontend/split/PluginHeader;", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "processModuleDependency", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$ModuleRequirement;", "moduleName", "", "requirement", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "backendReq", "frontendReq", "frontendSplitReq", "FRONTEND_MODULE_ID", "FRONTEND_SPLIT_MODULE_ID", "BACKEND_MODULE_ID", "Requirement", "ModuleRequirement", "intellij.platform.plugins.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PluginProductModeCompatibility determineProductModeCompatibility(@NotNull PluginHeader plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Requirement backendReq = Requirement.UNKNOWN;
            Requirement frontendReq = Requirement.UNKNOWN;
            Requirement frontendSplitReq = Requirement.UNKNOWN;
            for (PluginModuleId dep : plugin.getModuleDependencies().getModules()) {
                ModuleRequirement moduleReq = this.processModuleDependency(dep.getId(), Requirement.REQUIRED);
                backendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)backendReq)), (Comparable)((Comparable)((Object)moduleReq.getBackend()))));
                frontendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontend()))));
                frontendSplitReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendSplitReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontendSplit()))));
            }
            for (ContentModuleHeader contentModule : plugin.getContentModules()) {
                Requirement requirement = contentModule.getLoadingRule().getRequired() ? Requirement.REQUIRED : Requirement.OPTIONAL;
                for (PluginModuleId dep : contentModule.getModuleDependencies().getModules()) {
                    ModuleRequirement moduleReq = this.processModuleDependency(dep.getId(), requirement);
                    backendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)backendReq)), (Comparable)((Comparable)((Object)moduleReq.getBackend()))));
                    frontendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontend()))));
                    frontendSplitReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendSplitReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontendSplit()))));
                }
            }
            return this.determineProductModeCompatibility(backendReq, frontendReq, frontendSplitReq);
        }

        @NotNull
        public final PluginProductModeCompatibility determineProductModeCompatibility(@NotNull PluginUiModel plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Requirement backendReq = Requirement.UNKNOWN;
            Requirement frontendReq = Requirement.UNKNOWN;
            Requirement frontendSplitReq = Requirement.UNKNOWN;
            for (PluginDependencyModel dep : plugin.getDependencies()) {
                Requirement requirement = dep.isOptional() ? Requirement.OPTIONAL : Requirement.REQUIRED;
                ModuleRequirement moduleReq = this.processModuleDependency(dep.getPluginId().getIdString(), requirement);
                backendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)backendReq)), (Comparable)((Comparable)((Object)moduleReq.getBackend()))));
                frontendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontend()))));
                frontendSplitReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendSplitReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontendSplit()))));
            }
            return this.determineProductModeCompatibility(backendReq, frontendReq, frontendSplitReq);
        }

        private final ModuleRequirement processModuleDependency(String moduleName, Requirement requirement) {
            return switch (moduleName) {
                case PluginProductModeCompatibility.FRONTEND_MODULE_ID -> new ModuleRequirement(Requirement.UNKNOWN, requirement, Requirement.UNKNOWN);
                case PluginProductModeCompatibility.FRONTEND_SPLIT_MODULE_ID -> new ModuleRequirement(Requirement.UNKNOWN, requirement, requirement);
                case PluginProductModeCompatibility.BACKEND_MODULE_ID -> new ModuleRequirement(requirement, Requirement.UNKNOWN, Requirement.UNKNOWN);
                default -> new ModuleRequirement(Requirement.UNKNOWN, Requirement.UNKNOWN, Requirement.UNKNOWN);
            };
        }

        private final PluginProductModeCompatibility determineProductModeCompatibility(Requirement backendReq, Requirement frontendReq, Requirement frontendSplitReq) {
            return new PluginProductModeCompatibility(backendReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (frontendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN), frontendReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (backendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN), frontendSplitReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (frontendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 && backendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$ModuleRequirement;", "", "backend", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "frontend", "frontendSplit", "<init>", "(Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;)V", "getBackend", "()Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "getFrontend", "getFrontendSplit", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.plugins.frontend.split"})
        private static final class ModuleRequirement {
            @NotNull
            private final Requirement backend;
            @NotNull
            private final Requirement frontend;
            @NotNull
            private final Requirement frontendSplit;

            public ModuleRequirement(@NotNull Requirement backend, @NotNull Requirement frontend, @NotNull Requirement frontendSplit) {
                Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontend), (String)"frontend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontendSplit), (String)"frontendSplit");
                this.backend = backend;
                this.frontend = frontend;
                this.frontendSplit = frontendSplit;
            }

            @NotNull
            public final Requirement getBackend() {
                return this.backend;
            }

            @NotNull
            public final Requirement getFrontend() {
                return this.frontend;
            }

            @NotNull
            public final Requirement getFrontendSplit() {
                return this.frontendSplit;
            }

            @NotNull
            public final Requirement component1() {
                return this.backend;
            }

            @NotNull
            public final Requirement component2() {
                return this.frontend;
            }

            @NotNull
            public final Requirement component3() {
                return this.frontendSplit;
            }

            @NotNull
            public final ModuleRequirement copy(@NotNull Requirement backend, @NotNull Requirement frontend, @NotNull Requirement frontendSplit) {
                Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontend), (String)"frontend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontendSplit), (String)"frontendSplit");
                return new ModuleRequirement(backend, frontend, frontendSplit);
            }

            public static /* synthetic */ ModuleRequirement copy$default(ModuleRequirement moduleRequirement, Requirement requirement, Requirement requirement2, Requirement requirement3, int n, Object object) {
                if ((n & 1) != 0) {
                    requirement = moduleRequirement.backend;
                }
                if ((n & 2) != 0) {
                    requirement2 = moduleRequirement.frontend;
                }
                if ((n & 4) != 0) {
                    requirement3 = moduleRequirement.frontendSplit;
                }
                return moduleRequirement.copy(requirement, requirement2, requirement3);
            }

            @NotNull
            public String toString() {
                return "ModuleRequirement(backend=" + this.backend + ", frontend=" + this.frontend + ", frontendSplit=" + this.frontendSplit + ")";
            }

            public int hashCode() {
                int result2 = this.backend.hashCode();
                result2 = result2 * 31 + this.frontend.hashCode();
                result2 = result2 * 31 + this.frontendSplit.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ModuleRequirement)) {
                    return false;
                }
                ModuleRequirement moduleRequirement = (ModuleRequirement)other;
                if (this.backend != moduleRequirement.backend) {
                    return false;
                }
                if (this.frontend != moduleRequirement.frontend) {
                    return false;
                }
                return this.frontendSplit == moduleRequirement.frontendSplit;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN", "OPTIONAL", "REQUIRED", "intellij.platform.plugins.frontend.split"})
        private static final class Requirement
        extends Enum<Requirement> {
            public static final /* enum */ Requirement UNKNOWN = new Requirement();
            public static final /* enum */ Requirement OPTIONAL = new Requirement();
            public static final /* enum */ Requirement REQUIRED = new Requirement();
            private static final /* synthetic */ Requirement[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Requirement[] values() {
                return (Requirement[])$VALUES.clone();
            }

            public static Requirement valueOf(String value) {
                return Enum.valueOf(Requirement.class, value);
            }

            @NotNull
            public static EnumEntries<Requirement> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = requirementArray = new Requirement[]{Requirement.UNKNOWN, Requirement.OPTIONAL, Requirement.REQUIRED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

