/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocMethodInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocMethodInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocSimpleInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocSymbolInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocSymbolInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDocCommentIndexingDataCalculatorUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCustomTagsHandler;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCustomTags;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationBuilder
implements JSDocCommentVisitor,
JSDocDescriptionProcessor,
JSDocCustomTagsHandler.JSDocBlockTagQuickDocBuilder {
    public static final String OPEN_PRE = "<pre>";
    public static final String FENCE = "```";
    public static final String FENCE_REPLACEMENT = "!!!CODE_FENCE!!!";
    private static final Set<JSDocBlockTags> MODIFIER_TAGS = Set.of(JSDocBlockTags.PRIVATE, JSDocBlockTags.PUBLIC, JSDocBlockTags.PROTECTED, JSDocBlockTags.PACKAGE, JSDocBlockTags.STATIC);
    private static final Pattern ourBrTagPattern = Pattern.compile("</?br\\s?/?>", 2);
    private static final Pattern ourNonEmptyLinePattern = Pattern.compile("\n(?!\n)");
    @NotNull
    private final JSDocMethodInfoBuilder myTargetInfo;
    @Nullable
    private final JSFunctionItem function;
    @NotNull
    private final PsiElement myElement;
    @Nullable
    private final PsiElement myContextElement;
    private boolean seenInheritDoc;
    private final JSDocumentationProvider myProvider;
    private final JSTypeSource typeSource;

    protected JSDocumentationBuilder(@NotNull PsiElement element2, @Nullable PsiElement _contextElement, JSDocumentationProvider provider) {
        JSExpression initializer;
        if (element2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
        this.myContextElement = _contextElement;
        this.myProvider = provider;
        if (element2 instanceof JSVariable && (initializer = JSPsiImplUtils.getAssignedExpression((PsiElement)element2)) instanceof JSFunctionExpression) {
            element2 = initializer;
        }
        this.function = JSDocumentationBuilder.findFunction(element2, _contextElement);
        this.myTargetInfo = new JSDocMethodInfoBuilder();
        this.typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)this.myElement, (boolean)true);
    }

    @NotNull
    public String transformText(@NotNull String text) {
        if (text == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(1);
        }
        if (text.indexOf(60) != -1) {
            return JSDocumentationBuilder.replaceBrTagsWithNewLines(text);
        }
        String string = text;
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String transformInlineTag(@NotNull JSDocInlineTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(3);
        }
        String string = JSDocumentationUtils.transformInlineTag((JSDocInlineTag)tag);
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String transformPreContent(@NotNull String pre, @NotNull String content, @NotNull String indentation) {
        if (pre == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(5);
        }
        if (content == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(6);
        }
        if (indentation == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(7);
        }
        if (pre.equals(OPEN_PRE)) {
            String string = "\n" + StringsKt.prependIndent((String)("```\n" + StringsKt.trimIndent((String)(indentation + content.replace(FENCE, FENCE_REPLACEMENT))) + "\n```"), (String)indentation);
            if (string == null) {
                JSDocumentationBuilder.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = FENCE + content + FENCE;
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String postProcessDescription(@NotNull String rawDescription) {
        if (rawDescription == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(10);
        }
        String string = JSDocBuilderSimpleInfo.convertMarkdownToHtml(rawDescription, this.myElement.getProject()).replace(FENCE_REPLACEMENT, FENCE);
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void visitDescription(@NotNull JSDocDescription description) {
        if (description == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(12);
        }
        this.myTargetInfo.appendDescription(description.getDescriptionText((JSDocDescriptionProcessor)this));
    }

    public void appendDescription(@Nullable String description) {
        this.myTargetInfo.appendDescription(description);
    }

    public boolean hasDescription() {
        return this.myTargetInfo.hasDescription();
    }

    public void addSection(@NotNull String key, @Nullable String contents) {
        if (key == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(13);
        }
        this.myTargetInfo.addSimpleTag(key, contents);
    }

    @Nullable
    private static JSFunctionItem findFunction(PsiElement element2, PsiElement _contextElement) {
        JSDocComment comment;
        TypeScriptFunctionType functionType;
        JSFunctionItem result2 = TypeScriptSignatureChooser.resolveAnyFunction((PsiElement)element2, (PsiElement)_contextElement);
        if (result2 instanceof TypeScriptFunctionType && (functionType = (TypeScriptFunctionType)result2).getName() == null) {
            result2 = null;
        }
        if (result2 == null && (comment = JSDocumentationUtils.findOwnDocComment((PsiElement)element2)) instanceof JSDocCommentImpl) {
            JSImplicitElement implicitElement;
            String name = comment.getExplicitName();
            if (name == null && element2 instanceof PsiNamedElement) {
                name = ((PsiNamedElement)element2).getName();
            }
            if (name == null) {
                name = "";
            }
            if ((implicitElement = JSDocCommentIndexingDataCalculatorUtil.buildImplicitElement((JSDocCommentImpl)comment, name)) instanceof JSFunctionItem) {
                result2 = (JSFunctionItem)implicitElement;
            }
        }
        return result2;
    }

    @NotNull
    private static String replaceBrTagsWithNewLines(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(14);
        }
        String string = ourBrTagPattern.matcher(line).replaceAll("\n\n");
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void visitDefaultTag(@NotNull JSDocTag tag) {
        String defaultValue;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(16);
        }
        if ((defaultValue = tag.getDescriptionText()) == null) {
            return;
        }
        boolean color = defaultValue.startsWith("0x") && defaultValue.length() == 8;
        String content = defaultValue.substring(color ? 2 : 0);
        this.myTargetInfo.setDefaultValue(content, color, defaultValue);
    }

    public void visitSeeTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(17);
        }
        this.myTargetInfo.addSeeAlsoText(StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{tag.getNamepathText(), tag.getTypeText(), tag.getDescriptionText()}), (String)" "));
    }

    public void visitExampleTag(@NotNull JSDocTag tag) {
        JSDocDescription descriptionPsi;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(18);
        }
        if ((descriptionPsi = tag.getDescription()) == null) {
            return;
        }
        boolean hasMarkdownPre = ContainerUtil.exists((Object[])descriptionPsi.getChildren(), it -> it.getNode().getElementType() == JSDocTokenTypes.DOC_PRE);
        if (hasMarkdownPre) {
            String rawDescription = descriptionPsi.getLeadingWhitespace() + descriptionPsi.getDescriptionText((JSDocDescriptionProcessor)this);
            this.myTargetInfo.addExample("<div class='section'>Example: </div> " + JSDocBuilderSimpleInfo.convertMarkdownToHtml(rawDescription, tag.getProject()));
        } else {
            String rawDescription = descriptionPsi.getLeadingWhitespace() + descriptionPsi.getDescriptionText();
            int firstLineEnd = rawDescription.indexOf(10);
            String firstLine = firstLineEnd >= 0 ? rawDescription.substring(0, firstLineEnd).trim() : "";
            Object rawContents = rawDescription.substring(firstLineEnd + 1);
            rawContents = " " + ourNonEmptyLinePattern.matcher((CharSequence)rawContents).replaceAll("\n ");
            this.myTargetInfo.addExample("<div class='section'>Example: " + JSDocBuilderSimpleInfo.convertMarkdownToHtml(firstLine, tag.getProject()) + "</div>" + QuickDocHighlightingHelper.getStyledCodeBlock((Project)tag.getProject(), (Language)JavascriptLanguage.INSTANCE, (CharSequence)rawContents));
        }
    }

    public void visitDescriptionTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(19);
        }
        this.myTargetInfo.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
    }

    public void visitTypeTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(20);
        }
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getContextOfType((PsiElement)tag, (Class[])new Class[]{JSDocComment.class});
        String type2 = tag.getTypeText();
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            type2 = handler.adjustTypeFromJSDoc(this.myElement, docComment, type2);
        }
        this.myTargetInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)type2, (JSTypeSource)this.typeSource);
    }

    public void visitConstantTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(21);
        }
        this.myTargetInfo.finalAccess = "final";
    }

    public void visitNamespaceTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(22);
        }
        this.myTargetInfo.namespace = tag.getNamepathText();
    }

    public void visitParamTag(@NotNull JSDocTag tag) {
        JSDocTagNamepath namepathPsi;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(23);
        }
        if ((namepathPsi = tag.getNamepath()) == null) {
            return;
        }
        String defaultValue = namepathPsi.getDefaultValue();
        boolean optional = namepathPsi.isOptional();
        String matchName = namepathPsi.getNamepathText();
        if (matchName.indexOf(46) > 0) {
            String fieldName;
            String parameterName = matchName.substring(0, matchName.indexOf("."));
            JSDocParameterInfoBuilder currentParameterInfo = this.myTargetInfo.getInfoForParameterName(parameterName);
            if (currentParameterInfo.optionsMap == null) {
                currentParameterInfo.optionsMap = new LinkedHashMap<String, JSDocParameterInfoBuilder>();
            }
            if ((fieldName = JSDocumentationBuilder.getFieldName(matchName)) != null) {
                JSDocParameterInfoBuilder parameterInfo = new JSDocParameterInfoBuilder();
                JSParameterTypeDecorator parameterType = JSTypeParser.createParameterType((Project)this.myElement.getProject(), (String)tag.getTypeText(), (JSTypeSource)this.typeSource);
                if (parameterType != null) {
                    parameterInfo.updateFromDecorator(parameterType);
                }
                parameterInfo.optional = optional;
                parameterInfo.initialValue = defaultValue;
                parameterInfo.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
                currentParameterInfo.optionsMap.put(fieldName, parameterInfo);
            }
        } else {
            JSDocParameterInfoBuilder info = this.myTargetInfo.getInfoForParameterName(matchName);
            info.docName = matchName;
            info.defaultValue = defaultValue;
            info.optional = optional;
            info.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
            JSDocParameterInfoBuilder currentParameterInfo = info;
        }
    }

    public void visitInheritDocTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(24);
        }
        this.seenInheritDoc = true;
    }

    public void visitPropertyTag(@NotNull JSDocTag tag) {
        boolean matchesElement;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(25);
        }
        JSPsiElementBase namedItem = this.function == null && this.myElement instanceof JSPsiElementBase ? (JSPsiElementBase)this.myElement : null;
        JSDocTagNamepath namepathPsi = tag.getNamepath();
        if (namepathPsi == null) {
            return;
        }
        String name = namepathPsi.getNamepathText();
        boolean bl = matchesElement = namedItem != null && !(namedItem instanceof JSImplicitElement) && Objects.equals(name, namedItem.getName());
        if (!matchesElement) {
            JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName((String)name);
            if (this.myTargetInfo.myProperties == null) {
                this.myTargetInfo.myProperties = new LinkedHashMap();
            }
            JSDocParameterInfoBuilder property = new JSDocParameterInfoBuilder();
            String type2 = tag.getTypeText();
            if (type2 != null) {
                property.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)type2, (JSTypeSource)this.typeSource);
            }
            if (qualifiedName.getParent() != null) {
                property.namespace = qualifiedName.getParent().getQualifiedName();
            }
            property.optional = namepathPsi.isOptional();
            property.defaultValue = namepathPsi.getDefaultValue();
            property.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
            this.myTargetInfo.myProperties.put(qualifiedName, property);
        }
    }

    public void visitTypedefTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(26);
        }
        this.myTargetInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)tag.getTypeText(), (JSTypeSource)this.typeSource);
    }

    public void visitThrowsTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(27);
        }
        JSDocBuilderSimpleInfo throwsInfo = new JSDocBuilderSimpleInfo();
        String typeString = tag.getTypeText();
        if (typeString != null) {
            throwsInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)typeString, (JSTypeSource)this.typeSource);
        }
        throwsInfo.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
        this.myTargetInfo.throwsInfos.add(throwsInfo);
    }

    public void visitFiresTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(28);
        }
        JSDocBuilderSimpleInfo firesInfo = new JSDocBuilderSimpleInfo();
        String typeString = tag.getNamepathText();
        if (typeString != null) {
            firesInfo.hasFiredEvents = true;
            firesInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)typeString, (JSTypeSource)this.typeSource);
        }
        firesInfo.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
        this.myTargetInfo.firesInfos.add(firesInfo);
    }

    public void visitClassTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(29);
        }
        this.myTargetInfo.methodType = StringUtil.toLowerCase((String)tag.getNamepathText());
        this.myTargetInfo.appendDescription(tag.getDescriptionText((JSDocDescriptionProcessor)this));
    }

    public void visitMethodTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(30);
        }
        this.myTargetInfo.methodType = StringUtil.toLowerCase((String)tag.getNamepathText());
    }

    public void visitReturnsTag(@NotNull JSDocTag tag) {
        String description;
        JSType typeFromCommentsFunction;
        DialectOptionHolder holder;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(31);
        }
        JSDocBuilderSimpleInfo returnInfo = this.myTargetInfo.returnInfo;
        boolean addReturnTypeInfoFromComments = true;
        String type2 = tag.getTypeText();
        if (this.function instanceof JSFunction && (holder = DialectDetector.dialectOfElement((PsiElement)this.function)) != null && (holder.isTypeScript || holder.isECMA4) && (typeFromCommentsFunction = JSPsiImplUtils.getTypeFromDeclaration((JSElement)this.function)) != null && !typeFromCommentsFunction.getTypeText().equals(type2)) {
            addReturnTypeInfoFromComments = false;
        }
        Object text = "";
        if (type2 != null) {
            if (addReturnTypeInfoFromComments) {
                if (this.function == null || !this.function.isSetProperty()) {
                    returnInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)type2, (JSTypeSource)this.typeSource);
                }
            } else {
                text = (String)text + type2 + " ";
            }
        }
        if ((description = tag.getDescriptionText((JSDocDescriptionProcessor)this)) != null) {
            text = (String)text + description;
        }
        returnInfo.appendDescription((CharSequence)text);
    }

    public void visitJSDocTag(@NotNull JSDocTag tag) {
        JSDocTagDefinition definition;
        JSDocCustomTagsHandler customTagHandler;
        if (tag == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(32);
        }
        if ((customTagHandler = JSDocCustomTags.INSTANCE.getHandler(definition = tag.getTagDefinition())) != null && customTagHandler.handleBlockTag(tag, (JSDocCustomTagsHandler.JSDocBlockTagQuickDocBuilder)this)) {
            return;
        }
        if (MODIFIER_TAGS.contains(definition)) {
            this.myTargetInfo.modifiers = this.myTargetInfo.modifiers == null ? definition.getName() : this.myTargetInfo.modifiers + ", " + definition.getName();
            String type2 = tag.getTypeText();
            if (type2 != null) {
                this.myTargetInfo.type = JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)type2, (JSTypeSource)this.typeSource);
            }
        } else if (definition.showInQuickInfoDoc()) {
            String tagLabel = definition.getLabel();
            String type3 = tag.getTypeText();
            String namepath = tag.getNamepathText();
            String description = tag.getDescriptionText((JSDocDescriptionProcessor)this);
            StringBuilder text = new StringBuilder();
            if (namepath != null) {
                int separatorIndex = StringUtil.lastIndexOfAny((CharSequence)namepath, (String)".#~");
                text.append("<code>").append(separatorIndex <= 0 ? "" : JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(JSTypeParser.createTypeFromJSDoc((Project)this.myElement.getProject(), (String)namepath.substring(0, separatorIndex), (JSTypeSource)this.typeSource), this.myElement, false)).append(separatorIndex > 0 ? namepath.substring(separatorIndex, separatorIndex + 1) : "").append(namepath.substring(separatorIndex + 1)).append("</code>");
            }
            if (type3 != null) {
                if (namepath != null) {
                    text.append(": ");
                }
                QuickDocHighlightingHelper.appendStyledInlineCode((StringBuilder)text, (Project)tag.getProject(), (Language)JavascriptLanguage.INSTANCE, (String)type3);
            }
            if (description != null) {
                if (type3 != null || namepath != null) {
                    text.append(" &ndash; ");
                }
                text.append(description.trim());
            }
            this.myTargetInfo.addSimpleTag(tagLabel, text.toString());
        }
    }

    public void finishVisiting(@Nullable JSDocTag lastTag) {
        JSDocDescription description;
        if (lastTag != null && !JSDocBlockTags.isDescriptionAllowed((CharSequence)lastTag.getName()) && (description = lastTag.getDescription()) != null && description.getLeadingWhitespace().contains("\n")) {
            this.myTargetInfo.appendDescription(description.getDescriptionText((JSDocDescriptionProcessor)this));
        }
        if (this.seenInheritDoc) {
            this.processOverriddenMembers();
        }
    }

    public void processOverriddenMembers() {
        if (this.function != null) {
            JSDocMethodInfoBuilder methodInfo = this.myTargetInfo;
            AtomicReference<Processor> processorRef = new AtomicReference<Processor>();
            HashSet hashSet = new HashSet();
            Processor processor = function -> {
                PsiComment e;
                if (!visited.add(function)) {
                    return true;
                }
                if (function != this.myElement && (e = JSDocumentationUtils.findDocComment((PsiElement)function.getNavigationElement())) != null) {
                    JSDocumentationBuilder builder2 = new JSDocumentationBuilder((PsiElement)function, (PsiElement)function, this.myProvider);
                    JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)e, (ASTNode)e.getNode(), (JSDocCommentVisitor)builder2);
                    JSDocMethodInfoBuilder superMethodInfo = builder2.myTargetInfo;
                    methodInfo.mergeDescriptionWith(superMethodInfo);
                    methodInfo.mergeSignatureWith(this.function, (JSFunction)function, superMethodInfo);
                    return false;
                }
                for (JSFunction f : JSInheritanceUtil.findImplementedMethods((JSFunction)function)) {
                    if (((Processor)processorRef.get()).process((Object)f)) continue;
                    return false;
                }
                for (JSPsiElementBase m : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function, (boolean)true)) {
                    JSFunctionItem f = JSPsiImplUtils.calculatePossibleFunction((PsiElement)m, null, (boolean)true);
                    if (!(f instanceof JSFunction) || ((Processor)processorRef.get()).process((Object)((JSFunction)f))) continue;
                    return false;
                }
                return true;
            };
            processorRef.set(processor);
            processor.process((Object)((JSFunction)this.myElement));
        } else if (this.myElement instanceof JSPsiElementBase) {
            Collection<Object> members = this.myElement instanceof JSClass ? List.of(((JSClass)this.myElement).getSuperClasses()) : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)((JSPsiElementBase)this.myElement), (boolean)false);
            for (JSPsiElementBase jSPsiElementBase : members) {
                PsiComment e = JSDocumentationUtils.findDocComment((PsiElement)jSPsiElementBase);
                if (e == null) continue;
                JSDocumentationBuilder builder2 = new JSDocumentationBuilder((PsiElement)jSPsiElementBase, (PsiElement)jSPsiElementBase, this.myProvider);
                JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)e, (ASTNode)e.getNode(), (JSDocCommentVisitor)builder2);
                this.myTargetInfo.mergeDescriptionWith(builder2.myTargetInfo);
            }
        }
    }

    private static String getFieldName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    @Nullable
    @Nls
    final String getDoc() {
        return this.getDoc(false);
    }

    @Nullable
    @Nls
    final String getDoc(boolean isForProperty) {
        return this.getDoc(isForProperty, null);
    }

    @Nullable
    @Nls
    final String getDoc(boolean isForProperty, @Nullable Ref<String> definitionDetails) {
        @Nls StringBuilder newResult = new StringBuilder();
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)(this.myContextElement != null ? this.myContextElement : this.myElement), () -> {
            JSDocSimpleInfoPrinter<?> printer = this.createPrinter(isForProperty);
            printer.appendDoc(newResult, this.myProvider, definitionDetails);
        });
        StringUtil.trimEnd((StringBuilder)newResult, (CharSequence)"<table class='sections'></table>");
        return !newResult.isEmpty() ? newResult.toString() : null;
    }

    @NotNull
    protected JSDocSimpleInfoPrinter<?> createPrinter(boolean isForProperty) {
        JSDocSimpleInfoPrinter<?> jSDocSimpleInfoPrinter;
        JSDocBuilderSimpleInfo propertyTarget;
        JSDocBuilderSimpleInfo target2 = this.myTargetInfo;
        if (isForProperty && this.myElement instanceof JSElementBase && (propertyTarget = this.findMostSuitablePropertyOrParameterProperty()) != null) {
            target2 = propertyTarget;
        }
        if (this.function != null && target2 instanceof JSDocMethodInfoBuilder) {
            JSDocMethodInfoBuilder methodInfoBuilder = target2;
            jSDocSimpleInfoPrinter = this.createMethodInfoPrinter(methodInfoBuilder, this.function, this.myElement, this.myContextElement);
        } else if (target2 instanceof JSDocSymbolInfoBuilder) {
            JSDocSymbolInfoBuilder symbolInfoBuilder = target2;
            jSDocSimpleInfoPrinter = this.createSymbolInfoPrinter(symbolInfoBuilder, this.myElement, this.myContextElement);
        } else {
            jSDocSimpleInfoPrinter = this.createSimpleInfoPrinter(target2, this.myElement, this.myContextElement);
        }
        JSDocSimpleInfoPrinter<?> printer = jSDocSimpleInfoPrinter;
        printer.myDocBuilder = this;
        JSDocSimpleInfoPrinter<?> jSDocSimpleInfoPrinter2 = printer;
        if (jSDocSimpleInfoPrinter2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(33);
        }
        return jSDocSimpleInfoPrinter2;
    }

    @NotNull
    protected JSDocSimpleInfoPrinter<?> createSymbolInfoPrinter(@NotNull JSDocSymbolInfoBuilder target2, @NotNull PsiElement element2, @Nullable PsiElement contextElement) {
        if (target2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(34);
        }
        if (element2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(35);
        }
        return new JSDocSymbolInfoPrinter<JSDocSymbolInfoBuilder>(target2, element2, contextElement, true);
    }

    @NotNull
    protected JSDocSimpleInfoPrinter<?> createMethodInfoPrinter(@NotNull JSDocMethodInfoBuilder target2, @NotNull JSFunctionItem function, @NotNull PsiElement element2, @Nullable PsiElement contextElement) {
        if (target2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(36);
        }
        if (function == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(37);
        }
        if (element2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(38);
        }
        return new JSDocMethodInfoPrinter(target2, function, element2, contextElement);
    }

    @NotNull
    protected JSDocSimpleInfoPrinter<?> createSimpleInfoPrinter(@NotNull JSDocBuilderSimpleInfo target2, @NotNull PsiElement element2, @Nullable PsiElement contextElement) {
        if (target2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(39);
        }
        if (element2 == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(40);
        }
        return new JSDocSimpleInfoPrinter<JSDocBuilderSimpleInfo>(target2, element2, contextElement, true);
    }

    @Nullable
    private JSDocBuilderSimpleInfo findMostSuitablePropertyOrParameterProperty() {
        Map properties2 = this.myTargetInfo.myProperties;
        for (JSQualifiedNameImpl propertyName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSElementBase)this.myElement)); propertyName != null; propertyName = propertyName.withoutInnermostComponent(null)) {
            JSDocParameterInfoBuilder propertyInfo;
            if (properties2 != null && (propertyInfo = (JSDocParameterInfoBuilder)properties2.get(propertyName)) != null) {
                return propertyInfo;
            }
            for (Map.Entry<String, JSDocParameterInfoBuilder> parameter : this.myTargetInfo.parameterInfoMap.entrySet()) {
                JSDocParameterInfoBuilder parameterProperty;
                Map<String, JSDocParameterInfoBuilder> optionsMap = parameter.getValue().optionsMap;
                if (optionsMap == null || (parameterProperty = optionsMap.get(propertyName.getQualifiedName())) == null) continue;
                return parameterProperty;
            }
        }
        return null;
    }

    @Nullable
    @Nls
    protected final String getRenderedDoc() {
        String description = this.createPrinter(false).getRenderedDoc(this.myProvider);
        if (description == null) {
            return null;
        }
        return !(description = StringUtil.trimEnd((String)description, (String)"<table class='sections'></table>")).isEmpty() ? description : null;
    }

    @NotNull
    static String getNameForDocumentation(JSPsiNamedElementBase element2) {
        String name = element2.getName();
        if (name != null) {
            char quote = JSCodeStyleSettings.getQuoteChar((PsiElement)element2);
            name = JSSymbolUtil.quoteIfSpecialPropertyName((String)name, (boolean)JSUtils.isPrivateSharpItem((PsiElement)element2), (char)quote);
            String string = name = JSDocumentationBuilder.ensureBracketsForQuotedName(name, quote);
            if (string == null) {
                JSDocumentationBuilder.$$$reportNull$$$0(41);
            }
            return string;
        }
        if (element2 instanceof JSComputedPropertyNameOwner) {
            String expressionAsReferenceName;
            ES6ComputedName computedName = ((JSComputedPropertyNameOwner)element2).getComputedPropertyName();
            String string = expressionAsReferenceName = computedName == null ? null : computedName.getExpressionAsReferenceName();
            if (expressionAsReferenceName != null) {
                String string2 = "[" + expressionAsReferenceName + "]";
                if (string2 == null) {
                    JSDocumentationBuilder.$$$reportNull$$$0(42);
                }
                return string2;
            }
            return "[<computed>]";
        }
        return "<unknown>";
    }

    @NotNull
    static String ensureBracketsForQuotedName(String name, char quote) {
        if (name.charAt(0) == quote) {
            String string = "[" + name + "]";
            if (string == null) {
                JSDocumentationBuilder.$$$reportNull$$$0(43);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Nullable
    @Nls
    public String getParameterDoc(@NotNull JSParameter parameter, @Nullable PsiElement docComment, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (parameter == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(45);
        }
        if (provider == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(46);
        }
        if (this.function == null) {
            return null;
        }
        String name = parameter.getName();
        JSDocMethodInfoBuilder methodInfo = this.myTargetInfo;
        JSDocParameterInfoBuilder parameterInfo = methodInfo.parameterInfoMap.get(name);
        if (parameterInfo == null && docComment instanceof JSDocComment && this.function instanceof JSFunction && JSDestructuringUtil.isDestructuring((PsiElement)parameter.getParent())) {
            JSDestructuringContext destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)parameter.getParent(), JSDestructuringParameter.class::isInstance);
            if (destructuringContext.getOuterElement() != null) {
                String fieldName = destructuringContext.buildFieldName();
                JSDocParameterInfoBuilder containerInfo = methodInfo.parameterInfoMap.get(fieldName);
                if (containerInfo == null) {
                    JSDestructuringParameter destructuringParameter = (JSDestructuringParameter)destructuringContext.getOuterElement();
                    int parameterIndex = JSContextTypeEvaluator.getParameterIndex((JSParameterListElement)destructuringParameter);
                    ArrayList<JSDocParameterInfoBuilder> topLevelParameters = new ArrayList<JSDocParameterInfoBuilder>(methodInfo.parameterInfoMap.values());
                    if (parameterIndex >= 0 && parameterIndex < topLevelParameters.size()) {
                        containerInfo = topLevelParameters.get(parameterIndex);
                    }
                }
                if (containerInfo != null && fieldName != null) {
                    JSDocParameterInfoBuilder fieldInfo;
                    JSDocParameterInfoBuilder jSDocParameterInfoBuilder = fieldInfo = containerInfo.optionsMap != null ? containerInfo.optionsMap.get(fieldName) : null;
                    if (fieldInfo != null) {
                        return this.buildParameterInfo(name, parameter, fieldInfo, provider, place);
                    }
                }
            }
        }
        if (parameterInfo == null) {
            parameterInfo = new JSDocParameterInfoBuilder();
        }
        return this.buildParameterInfo(name, parameter, parameterInfo, provider, place);
    }

    @NotNull
    @Nls
    private String buildParameterInfo(@Nullable String name, @NotNull JSParameter parameter, @NotNull JSDocParameterInfoBuilder parameterInfo, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (parameter == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(47);
        }
        if (parameterInfo == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(48);
        }
        if (provider == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(49);
        }
        @Nls StringBuilder newResult = new StringBuilder();
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)(place != null ? place : parameter), () -> {
            JSDocParameterInfoPrinter printer = new JSDocParameterInfoPrinter((JSParameterItem)parameter, parameterInfo);
            printer.appendDoc(name, this.myTargetInfo, newResult, provider, place);
        });
        String string = newResult.toString();
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(50);
        }
        return string;
    }

    public void fillEvaluatedType() {
        if (!(this.myElement instanceof JSClass) && this.myTargetInfo.type == null) {
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)(this.myContextElement != null ? this.myContextElement : this.myElement), () -> {
                this.myTargetInfo.type = this.calculateEvaluatedType();
                return this.myTargetInfo.type;
            });
        }
    }

    public boolean showDoc() {
        if (DialectDetector.isActionScript((PsiElement)this.myElement)) {
            return this.myElement instanceof JSClass || this.myTargetInfo.type != null;
        }
        return true;
    }

    @Nullable
    private JSType calculateEvaluatedType() {
        JSType type2;
        JSType typeForDoc;
        PsiElement parent;
        PsiElement contextElement = this.myContextElement;
        if (contextElement != null && (parent = contextElement.getParent()) instanceof JSReferenceExpression && (typeForDoc = JSShowTypeInfoAction.getTypeForDocumentation(parent)) != null && !JSTypeUtils.isAnyType((JSType)typeForDoc)) {
            return typeForDoc;
        }
        JSType declaredType = JSTypeUtils.getTypeOfElement((PsiElement)this.myElement);
        if (declaredType != null && !JSTypeUtils.hasTypes((JSType)declaredType, (Class[])new Class[]{JSEvaluableOnlyType.class}) && !JSTypeUtils.hasTypes((JSType)declaredType, (Class[])new Class[]{JSGenericParameterType.class})) {
            return declaredType;
        }
        JSExpression expressionForTypeEvaluation = JSPsiImplUtils.getAssignedExpression((PsiElement)this.myElement);
        if (expressionForTypeEvaluation != null && !(expressionForTypeEvaluation instanceof JSFunctionExpression) && (type2 = JSResolveUtil.getExpressionJSType((JSExpression)expressionForTypeEvaluation)) != null && !(type2 instanceof JSAnyType)) {
            if (type2.isSourceStrict()) {
                type2 = JSTypeUtils.copyWithStrictRecursive((JSType)type2, (boolean)false);
            }
            return type2;
        }
        if (expressionForTypeEvaluation == null) {
            return JSShowTypeInfoAction.getTypeForDocumentation(this.myElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 9, 11, 15, 33, 41, 42, 43, 44, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pre";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDescription";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "transformText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "transformInlineTag";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "transformPreContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessDescription";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceBrTagsWithNewLines";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrinter";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForDocumentation";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureBracketsForQuotedName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "transformText";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "transformInlineTag";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transformPreContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "postProcessDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitDescription";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addSection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceBrTagsWithNewLines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitDefaultTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitSeeTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitExampleTag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitDescriptionTag";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantTag";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitNamespaceTag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitParamTag";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitInheritDocTag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitPropertyTag";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitTypedefTag";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowsTag";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitFiresTag";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitClassTag";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodTag";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnsTag";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitJSDocTag";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolInfoPrinter";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createMethodInfoPrinter";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleInfoPrinter";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDoc";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 9, 11, 15, 33, 41, 42, 43, 44, 50 -> new IllegalStateException(string);
        };
    }
}

