/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerOverrideExtensionsConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultFileReferenceCompletionFilter;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContextBuilder;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0014\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0004\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0004\u00a8\u0006'"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase;", "Lcom/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileReferenceContextBuilder;", "<init>", "()V", "createFileReferenceContext", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileReferenceContext;", "unquotedRefText", "", "host", "Lcom/intellij/psi/PsiElement;", "getModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "placeRoot", "getModuleDirectory", "dependencyName", "getSubstitutions", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "packageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "moduleRoot", "mergeWithStandardExtensions", "", "ext", "(Ljava/lang/String;)[Ljava/lang/String;", "getTypeScriptExtensionsByJs", "createReferenceCompletionFilter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiFileSystemItem;", "mergedExtensions", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/String;)Lcom/intellij/openapi/util/Condition;", "getAdditionalDescriptors", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportDescriptor;", "configuration", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "baseDescriptor", "getPackageJsonDataForRoot", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSPackageJsonMappingContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPackageJsonMappingContributorBase.kt\ncom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1011#2,2:150\n1#3:152\n*S KotlinDebug\n*F\n+ 1 JSPackageJsonMappingContributorBase.kt\ncom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase\n*L\n141#1:150,2\n*E\n"})
public abstract class JSPackageJsonMappingContributorBase
implements JSModuleReferenceContributor,
JSFileReferenceContextBuilder {
    @Override
    @Nullable
    public JSFileReferenceContext createFileReferenceContext(@NotNull String unquotedRefText, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        VirtualFile virtualFile = NodeModuleUtil.getMainModuleRoot(host);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile placeRoot = virtualFile;
        VirtualFile virtualFile2 = this.getModuleRoot(unquotedRefText, host, placeRoot);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile moduleRoot = virtualFile2;
        PackageJsonData packageJsonData = this.getPackageJsonDataForRoot(moduleRoot);
        if (packageJsonData == null) {
            return null;
        }
        PackageJsonData packageJsonData2 = packageJsonData;
        JSModulePathMappings<JSModulePathSubstitution> substitutions = this.getSubstitutions(packageJsonData2, placeRoot, moduleRoot);
        if (substitutions.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[]{};
        return new JSDefaultFileReferenceContext(unquotedRefText, host, this, substitutions, moduleRoot, stringArray){
            final /* synthetic */ PsiElement $host;
            final /* synthetic */ JSPackageJsonMappingContributorBase this$0;
            final /* synthetic */ JSModulePathMappings<JSModulePathSubstitution> $substitutions;
            final /* synthetic */ VirtualFile $moduleRoot;
            {
                this.$host = $host;
                this.this$0 = $receiver;
                this.$substitutions = $substitutions;
                this.$moduleRoot = $moduleRoot;
                super($unquotedRefText, $host, null, $super_call_param$1);
            }

            public Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return JSPackageJsonMappingContributorBase.access$createReferenceCompletionFilter(this.this$0, this.$host, new String[0]);
            }

            public int getReferencesWeight() {
                return JSModuleBaseReference.ModuleTypes.DEFAULT.weight();
            }

            public JSModulePathMappings<JSModulePathSubstitution> pathsMappings() {
                return this.$substitutions;
            }

            public List<VirtualFile> getDefaultRoots(Project project, String moduleName, VirtualFile contextFile) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
                return CollectionsKt.emptyList();
            }

            public Collection<VirtualFile> getMappingRoots() {
                return CollectionsKt.listOf((Object)this.$moduleRoot);
            }
        };
    }

    private final VirtualFile getModuleRoot(String unquotedRefText, PsiElement host, VirtualFile placeRoot) {
        if (!StringsKt.startsWith$default((String)unquotedRefText, (String)"#", (boolean)false, (int)2, null)) {
            String string = NodeModuleSearchUtil.extractDependencyName(unquotedRefText);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
            String dependencyName = string;
            if (((CharSequence)dependencyName).length() == 0) {
                return null;
            }
            return this.getModuleDirectory(host, dependencyName, placeRoot);
        }
        return placeRoot;
    }

    private final VirtualFile getModuleDirectory(PsiElement host, String dependencyName, VirtualFile placeRoot) {
        InstalledPackageVersion existingPackage = new NodeInstalledPackageFinder(host.getProject(), placeRoot).findInstalledPackage(dependencyName);
        InstalledPackageVersion installedPackageVersion = existingPackage;
        if (installedPackageVersion == null || (installedPackageVersion = installedPackageVersion.getPackageDir()) == null) {
            return null;
        }
        return installedPackageVersion;
    }

    private final JSModulePathMappings<JSModulePathSubstitution> getSubstitutions(PackageJsonData packageJsonData, VirtualFile placeRoot, VirtualFile moduleRoot) {
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings;
        if (Intrinsics.areEqual((Object)placeRoot, (Object)moduleRoot)) {
            JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings2 = packageJsonData.getImports();
            Intrinsics.checkNotNull(jSModulePathMappings2);
            jSModulePathMappings = jSModulePathMappings2;
        } else {
            JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings3 = packageJsonData.getExports();
            Intrinsics.checkNotNull(jSModulePathMappings3);
            jSModulePathMappings = jSModulePathMappings3;
        }
        return jSModulePathMappings;
    }

    @NotNull
    protected String[] mergeWithStandardExtensions(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return (String[])ArraysKt.plus((Object[])this.getTypeScriptExtensionsByJs(ext), (Object)ext);
    }

    @NotNull
    protected final String[] getTypeScriptExtensionsByJs(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        switch (ext) {
            case ".js": {
                Intrinsics.checkNotNullExpressionValue((Object)TypeScriptUtil.TYPESCRIPT_EXTENSIONS, (String)"TYPESCRIPT_EXTENSIONS");
                return TypeScriptUtil.TYPESCRIPT_EXTENSIONS;
            }
            case ".mjs": {
                String[] stringArray = new String[]{".ts", ".mts", ".d.ts", ".d.mts"};
                return stringArray;
            }
            case ".cjs": {
                String[] stringArray = new String[]{".ts", ".cts", ".d.ts", ".d.cts"};
                return stringArray;
            }
        }
        String[] stringArray = new String[]{ext};
        return stringArray;
    }

    private final Condition<PsiFileSystemItem> createReferenceCompletionFilter(PsiElement host, String[] mergedExtensions) {
        JSDefaultFileReferenceCompletionFilter parentCondition = new JSDefaultFileReferenceCompletionFilter(host);
        return arg_0 -> JSPackageJsonMappingContributorBase.createReferenceCompletionFilter$lambda$0(parentCondition, mergedExtensions, arg_0);
    }

    @NotNull
    public List<JSImportDescriptor> getAdditionalDescriptors(@NotNull JSImportPathConfiguration configuration, @NotNull JSImportDescriptor baseDescriptor) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)baseDescriptor, (String)"baseDescriptor");
        VirtualFile virtualFile = configuration.getPlaceRoot();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile placeRoot = virtualFile;
        VirtualFile virtualFile2 = configuration.getImportedFileRoot();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile moduleRoot = virtualFile2;
        PackageJsonData packageJsonData = this.getPackageJsonDataForRoot(moduleRoot);
        if (packageJsonData == null) {
            return CollectionsKt.emptyList();
        }
        PackageJsonData packageJsonData2 = packageJsonData;
        if (Intrinsics.areEqual((Object)baseDescriptor.getModuleName(), (Object)packageJsonData2.getName())) {
            return CollectionsKt.emptyList();
        }
        JSModulePathMappings<JSModulePathSubstitution> substitutions = this.getSubstitutions(packageJsonData2, placeRoot, moduleRoot);
        if (substitutions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map extToSubstitutions = new LinkedHashMap();
        for (Object substitution : substitutions.getSubstitutions()) {
            Pair object = JSPathMappingsUtil.splitMappings((JSModulePathSubstitution)substitution);
            Intrinsics.checkNotNull((Object)object);
            List relativeMappings = (List)ExtensionsKt.component1((Pair)object);
            Map extensionsWithMappings = JSPathMappingsUtil.mapWithExtensions((Collection)relativeMappings);
            Intrinsics.checkNotNull((Object)extensionsWithMappings);
            for (Map.Entry entry : extensionsWithMappings.entrySet()) {
                List list;
                String ext = (String)entry.getKey();
                List mappings = (List)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)extToSubstitutions.computeIfAbsent(ext, arg_0 -> JSPackageJsonMappingContributorBase.getAdditionalDescriptors$lambda$1(JSPackageJsonMappingContributorBase::getAdditionalDescriptors$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
                list.add(new JSModulePathSubstitutionImpl(substitution.getPattern(), (Collection)mappings));
            }
        }
        List result2 = new ArrayList();
        for (Map.Entry entry : extToSubstitutions.entrySet()) {
            List<JSImportDescriptor> mappings;
            JSImportPathBuilder jSImportPathBuilder;
            JSImportPathConfiguration jSImportPathConfiguration;
            String ext = (String)entry.getKey();
            List fixedSubstitutions = (List)entry.getValue();
            if (((CharSequence)ext).length() == 0) {
                jSImportPathConfiguration = configuration;
            } else {
                List list = ArraysKt.toList((Object[])this.mergeWithStandardExtensions(ext));
                jSImportPathConfiguration = new WebBundlerOverrideExtensionsConfiguration(configuration, list){

                    public JSModuleNameInfo.ExtensionSettings getPathSettings() {
                        return JSModuleNameInfo.ExtensionSettings.NO_EXTENSION;
                    }
                };
            }
            JSImportPathConfiguration overrideConfiguration2 = jSImportPathConfiguration;
            Intrinsics.checkNotNullExpressionValue((Object)JSImportPathBuilder.createBuilder(overrideConfiguration2), (String)"createBuilder(...)");
            Intrinsics.checkNotNullExpressionValue(jSImportPathBuilder.getMappingsForBaseUrl(moduleRoot, (JSModulePathMappings<? extends JSModulePathSubstitution>)JSModulePathMappings.Companion.build((Collection)fixedSubstitutions)), (String)"getMappingsForBaseUrl(...)");
            result2.addAll((Collection)mappings);
        }
        List $this$sortBy$iv = result2;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    JSImportDescriptor it = (JSImportDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getModuleName().length());
                    it = (JSImportDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getModuleName().length()));
                }
            });
        }
        return result2;
    }

    @Nullable
    protected final PackageJsonData getPackageJsonDataForRoot(@NotNull VirtualFile moduleRoot) {
        PackageJsonData packageJsonData;
        Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(moduleRoot);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            packageJsonData = PackageJsonData.getOrCreate(it);
        } else {
            packageJsonData = null;
        }
        return packageJsonData;
    }

    private static final boolean createReferenceCompletionFilter$lambda$0(JSDefaultFileReferenceCompletionFilter $parentCondition, String[] $mergedExtensions, PsiFileSystemItem it) {
        if (!$parentCondition.value(it)) {
            return false;
        }
        if (it instanceof PsiFile && !($mergedExtensions.length == 0)) {
            String newExt = JSFileReferencesUtil.findExtension((CharSequence)((PsiFile)it).getName(), (String[])$mergedExtensions);
            return newExt != null;
        }
        return true;
    }

    private static final List getAdditionalDescriptors$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getAdditionalDescriptors$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Condition access$createReferenceCompletionFilter(JSPackageJsonMappingContributorBase $this, PsiElement host, String[] mergedExtensions) {
        return $this.createReferenceCompletionFilter(host, mergedExtensions);
    }
}

