/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection.dataflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFAEngine;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.DfaInstance;
import com.intellij.codeInsight.dataflow.Semilattice;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspection.dataflow.JSVariableInfo;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSControlFlowScope;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSControlFlowProcessor {
    private static final DefinedValuesInfo INITIAL = new DefinedValuesInfo();
    @NotNull
    private final Map<JSVariable, Set<JSExpression>> myResultVariablesWritten;
    private final Map<JSVariable, Set<JSExpression>> myResultVariablesOverwritten;
    private final Map<JSExpression, JSVariable> myVariablesReadWithoutInitialization;
    private final Set<? super JSVariable> myReadAtLeastOnce;
    private final Set<String> myVariablesReferencedInInners;
    private final Set<String> myVariablesWrittenInInners;

    public void processInstructions(Instruction @NotNull [] instructions) {
        if (instructions == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(0);
        }
        Semilattice<DefinedValuesInfo> semilattice = new Semilattice<DefinedValuesInfo>(this){

            public DefinedValuesInfo join(@NotNull List<DefinedValuesInfo> predInstructions) {
                if (predInstructions == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (predInstructions.isEmpty()) {
                    return INITIAL;
                }
                if (predInstructions.size() == 1) {
                    return predInstructions.get(0);
                }
                DefinedValuesInfo info = new DefinedValuesInfo();
                JSControlFlowProcessor.mergeBranches(predInstructions, info);
                return info;
            }

            public boolean eq(@NotNull DefinedValuesInfo e1, @NotNull DefinedValuesInfo e2) {
                if (e1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return e1.equals(e2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "predInstructions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e2";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "join";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "eq";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DfaInstance<DefinedValuesInfo> instance = new DfaInstance<DefinedValuesInfo>(){

            public DefinedValuesInfo fun(DefinedValuesInfo info, Instruction instruction) {
                Instruction singlePrev;
                Collection allPred = instruction.allPred();
                if (info == INITIAL) {
                    info = info.cloneState();
                } else if (allPred.size() == 1 && (singlePrev = (Instruction)allPred.iterator().next()).allSucc().size() != 1) {
                    info = info.cloneState();
                }
                return JSControlFlowProcessor.processInstruction(instruction, JSControlFlowProcessor.this, info);
            }

            @NotNull
            public DefinedValuesInfo initial() {
                DefinedValuesInfo definedValuesInfo = INITIAL;
                if (definedValuesInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return definedValuesInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$2", "initial"));
            }
        };
        DFAEngine engine = new DFAEngine(instructions, (DfaInstance)instance, (Semilattice)semilattice);
        try {
            List infos = engine.performDFA();
            if (infos.isEmpty()) {
                return;
            }
            Map<JSVariable, JSVariableInfo> infoMap = ((DefinedValuesInfo)infos.get((int)(infos.size() - 1))).myVariableInfo;
            for (Map.Entry<JSVariable, JSVariableInfo> entry : infoMap.entrySet()) {
                HashSet<JSExpression> variablesWrittenResult = new HashSet<JSExpression>();
                JSVariableInfo variableInfo = entry.getValue();
                Set<JSExpression> writtenSet = variableInfo.getVariablesWritten();
                Set<JSExpression> readSet = variableInfo.getVariablesRead();
                for (JSExpression written : writtenSet) {
                    if (readSet.contains(written)) continue;
                    variablesWrittenResult.add(written);
                }
                this.myResultVariablesWritten.put(entry.getKey(), variablesWrittenResult);
                this.myResultVariablesOverwritten.put(entry.getKey(), variableInfo.getVariablesOverwritten());
            }
        }
        catch (DFALimitExceededException dFALimitExceededException) {
            // empty catch block
        }
    }

    public static void processControlFlow(@NotNull JSExecutionScope element2, @NotNull JSControlFlowProcessor controlFlowProcessor) {
        JSControlFlowService.JSControlFlow flow;
        Object[] instructions;
        Instruction firstInstruction;
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(1);
        }
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(2);
        }
        if ((firstInstruction = (Instruction)ArrayUtil.getFirstElement((Object[])(instructions = (flow = JSControlFlowService.getService((Project)element2.getProject()).getControlFlow((JSControlFlowScope)element2)).getInstructions()))) == null) {
            return;
        }
        controlFlowProcessor.processInstructions((Instruction[])instructions);
    }

    @NotNull
    private static DefinedValuesInfo processInstruction(@NotNull Instruction currentInstruction, @NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull DefinedValuesInfo info) {
        if (currentInstruction == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(3);
        }
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(4);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(5);
        }
        PsiElement element2 = currentInstruction.getElement();
        if (currentInstruction instanceof JSReadWriteInstruction) {
            ReadWriteAccessDetector.Access access = ((JSReadWriteInstruction)currentInstruction).getAccess();
            if (access == ReadWriteAccessDetector.Access.Read && element2 instanceof JSExpression) {
                return controlFlowProcessor.valueRead((JSExpression)element2, info);
            }
            if (element2 instanceof JSForInStatement) {
                return JSControlFlowProcessor.processForInStatement(controlFlowProcessor, (JSForInStatement)element2, access, info);
            }
            if (element2 instanceof JSReferenceExpression) {
                DefinedValuesInfo definedValuesInfo = JSControlFlowProcessor.processJSReferenceExpression(controlFlowProcessor, (JSReferenceExpression)element2, access, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(6);
                }
                return definedValuesInfo;
            }
            if (element2 instanceof JSAssignmentExpression) {
                return JSControlFlowProcessor.processJSAssignmentExpression(controlFlowProcessor, (JSAssignmentExpression)element2, access, info);
            }
            if (element2 instanceof JSDefinitionExpression) {
                return JSControlFlowProcessor.processJSDefinitionExpression((JSDefinitionExpression)element2, info);
            }
            if (access == ReadWriteAccessDetector.Access.Write && element2 instanceof JSVariable) {
                return JSControlFlowProcessor.processJSVariable((JSVariable)element2, info);
            }
        } else {
            if (element2 instanceof JSFunction) {
                controlFlowProcessor.functionEncountered((JSFunction)element2);
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(7);
                }
                return definedValuesInfo;
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                PsiElement elementForTrueValue;
                boolean value = ((JSConditionInstruction)currentInstruction).getValue();
                Object object = value ? element2 : (elementForTrueValue = element2 instanceof JSPrefixExpression && ((JSPrefixExpression)element2).getOperationSign() == JSTokenTypes.EXCL ? ((JSPrefixExpression)element2).getExpression() : null);
                if (elementForTrueValue != null) {
                    return JSControlFlowProcessor.processConditionalTrueInstruction(elementForTrueValue, info);
                }
            }
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(8);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processForInStatement(@NotNull JSControlFlowProcessor processor, @NotNull JSForInStatement element2, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        if (processor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(10);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(11);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(12);
        }
        if (access != ReadWriteAccessDetector.Access.Write) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(13);
            }
            return definedValuesInfo;
        }
        JSExpression expression = element2.getVariableExpression();
        if (expression instanceof JSReferenceExpression) {
            DefinedValuesInfo definedValuesInfo = JSControlFlowProcessor.processJSReferenceExpression(processor, (JSReferenceExpression)expression, access, info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(14);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(15);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processJSDefinitionExpression(@NotNull JSDefinitionExpression element2, @NotNull DefinedValuesInfo info) {
        JSExpression collectionExpression;
        JSExpression expression;
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(16);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(17);
        }
        if ((expression = element2.getExpression()) == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(18);
            }
            return definedValuesInfo;
        }
        PsiElement parent = element2.getParent();
        if (parent instanceof JSForInStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
            return JSControlFlowProcessor.valueWritten((JSElement)expression, collectionExpression, info);
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(19);
        }
        return definedValuesInfo;
    }

    private static DefinedValuesInfo processJSReferenceExpression(@NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull JSReferenceExpression node, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        JSForInStatement forInStatement;
        PsiElement parent;
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(20);
        }
        if (node == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(21);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(22);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(23);
        }
        if ((parent = node.getParent()) instanceof JSForInStatement && (forInStatement = (JSForInStatement)parent).getVariableExpression() == node) {
            return JSControlFlowProcessor.valueWritten((JSElement)node, forInStatement.getCollectionExpression(), info);
        }
        if (access == ReadWriteAccessDetector.Access.Write) {
            JSExpression initializer = JSDestructuringUtil.getDestructuringAssignmentSource((JSExpression)node);
            return JSControlFlowProcessor.valueWritten((JSElement)node, initializer != null ? initializer : (JSExpression)node.getReference(), info);
        }
        if (access == ReadWriteAccessDetector.Access.ReadWrite) {
            DefinedValuesInfo newInfo = controlFlowProcessor.valueRead((JSExpression)node, info);
            return JSControlFlowProcessor.valueWritten((JSElement)node, (JSExpression)node.getReference(), newInfo);
        }
        return info;
    }

    @NotNull
    private static DefinedValuesInfo processJSVariable(@NotNull JSVariable element2, @NotNull DefinedValuesInfo info) {
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(24);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(25);
        }
        PsiElement identifier = element2.getNameIdentifier();
        JSExpression initializer = element2.getInitializer();
        if (initializer != null) {
            if (identifier != null) {
                return JSControlFlowProcessor.valueWritten((JSElement)element2, initializer, info);
            }
        } else {
            JSExpression collectionExpression;
            PsiElement parent;
            initializer = JSDestructuringUtil.getNearestDestructuringInitializer((JSVariable)element2);
            if (initializer != null) {
                return JSControlFlowProcessor.valueWritten((JSElement)element2, initializer, info);
            }
            PsiElement varStatement = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)element2);
            PsiElement psiElement = parent = varStatement != null ? varStatement.getParent() : null;
            if (parent instanceof JSForInStatement && ((JSForInStatement)parent).getVarDeclaration() == varStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
                return JSControlFlowProcessor.valueWritten((JSElement)element2, collectionExpression, info);
            }
        }
        return JSControlFlowProcessor.valueWritten((JSElement)element2, null, info);
    }

    @NotNull
    private static DefinedValuesInfo processJSAssignmentExpression(@NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull JSAssignmentExpression element2, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        JSDefinitionExpression definitionExpression;
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(26);
        }
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(27);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(28);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(29);
        }
        if ((definitionExpression = element2.getDefinitionExpression()) == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(30);
            }
            return definedValuesInfo;
        }
        JSExpression initializerExpression = JSTypeGuardUtil.getInitializerExpression((PsiElement)element2);
        JSExpression expression = definitionExpression.getExpression();
        if (expression == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(31);
            }
            return definedValuesInfo;
        }
        if (access == ReadWriteAccessDetector.Access.Write) {
            return JSControlFlowProcessor.valueWritten((JSElement)expression, initializerExpression, info);
        }
        if (access == ReadWriteAccessDetector.Access.ReadWrite) {
            DefinedValuesInfo newInfo = controlFlowProcessor.valueRead(expression, info);
            return JSControlFlowProcessor.valueWritten((JSElement)expression, initializerExpression, newInfo);
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(32);
        }
        return definedValuesInfo;
    }

    public JSControlFlowProcessor(@NotNull Map<JSVariable, Set<JSExpression>> variablesWritten, @NotNull Map<JSExpression, JSVariable> variablesReadWithoutInitialization, @NotNull Set<? super JSVariable> readAtLeastOnce, @NotNull Set<String> variablesReferencedInInners, @NotNull Set<String> variablesWrittenInInners, @NotNull Map<JSVariable, Set<JSExpression>> valuesOverwritten) {
        if (variablesWritten == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(33);
        }
        if (variablesReadWithoutInitialization == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(34);
        }
        if (readAtLeastOnce == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(35);
        }
        if (variablesReferencedInInners == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(36);
        }
        if (variablesWrittenInInners == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(37);
        }
        if (valuesOverwritten == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(38);
        }
        this.myResultVariablesWritten = variablesWritten;
        this.myVariablesReadWithoutInitialization = variablesReadWithoutInitialization;
        this.myReadAtLeastOnce = readAtLeastOnce;
        this.myVariablesReferencedInInners = variablesReferencedInInners;
        this.myVariablesWrittenInInners = variablesWrittenInInners;
        this.myResultVariablesOverwritten = valuesOverwritten;
    }

    @NotNull
    private DefinedValuesInfo valueRead(@Nullable JSExpression expression, @NotNull DefinedValuesInfo info) {
        PsiPolyVariantReference reference;
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(39);
        }
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null) {
            return this.valueRead(expression, ((JSReferenceExpression)expression).resolve(), info);
        }
        if (expression instanceof JSXXmlLiteralExpressionImpl && (reference = JSXResolveUtil.getTopLevelReference((JSXmlLiteralExpression)((JSXmlLiteralExpression)expression))) != null) {
            return this.valueRead(expression, reference.resolve(), info);
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(40);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processConditionalTrueInstruction(@Nullable PsiElement expression, @NotNull DefinedValuesInfo info) {
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(41);
        }
        if (expression instanceof JSBinaryExpression) {
            JSExpression typeOfExpression;
            JSExpression possibleTypeOf = ((JSBinaryExpression)expression).getLOperand();
            IElementType binaryOperation = ((JSBinaryExpression)expression).getOperationSign();
            if (!JSTokenTypes.EQUALITY_OPERATIONS.contains(binaryOperation)) {
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(42);
                }
                return definedValuesInfo;
            }
            if (!(possibleTypeOf instanceof JSPrefixExpression) && !((possibleTypeOf = ((JSBinaryExpression)expression).getROperand()) instanceof JSPrefixExpression)) {
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(43);
                }
                return definedValuesInfo;
            }
            IElementType sign = ((JSPrefixExpression)possibleTypeOf).getOperationSign();
            if (sign == JSTokenTypes.TYPEOF_KEYWORD && (typeOfExpression = JSUtils.unparenthesize((JSExpression)((JSPrefixExpression)possibleTypeOf).getExpression())) instanceof JSReferenceExpression) {
                expression = typeOfExpression;
            }
        }
        if (!(expression instanceof JSReferenceExpression)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(44);
            }
            return definedValuesInfo;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
        if (referenceExpression.getQualifier() != null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(45);
            }
            return definedValuesInfo;
        }
        PsiElement resolved = referenceExpression.resolve();
        if (!(resolved instanceof JSVariable)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(46);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo newInfo = info.cloneState();
        if (newInfo.conditionalVariables == null) {
            newInfo.conditionalVariables = new HashSet<JSVariable>(1);
        }
        newInfo.conditionalVariables.add((JSVariable)resolved);
        DefinedValuesInfo definedValuesInfo = newInfo;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(47);
        }
        return definedValuesInfo;
    }

    @NotNull
    private DefinedValuesInfo valueRead(@NotNull JSExpression reference, @Nullable PsiElement resolve2, @NotNull DefinedValuesInfo info) {
        JSVariable var;
        block14: {
            block13: {
                if (reference == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(48);
                }
                if (info == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(49);
                }
                if (!(resolve2 instanceof JSVariable)) break block13;
                var = (JSVariable)resolve2;
                if (!(resolve2 instanceof ImplicitJSVariableImpl)) break block14;
            }
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(50);
            }
            return definedValuesInfo;
        }
        boolean readSomething = resolve2 instanceof JSParameter || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var);
        JSVariableInfo variableInfo = info.myVariableInfo.get(var);
        if (variableInfo != null) {
            Set<JSExpression> written = variableInfo.getVariablesWritten();
            variableInfo.addReads(written);
            if (!written.isEmpty()) {
                readSomething = true;
            }
        }
        if (info.conditionalVariables != null && info.conditionalVariables.contains(var)) {
            readSomething = true;
        }
        if (!readSomething && JSControlFlowProcessor.isReadInConditional(reference)) {
            readSomething = true;
        }
        if (!readSomething && info.conditionalVariables != null && info.conditionalVariables.contains(var)) {
            readSomething = true;
        }
        if (!readSomething) {
            this.myVariablesReadWithoutInitialization.put(reference, var);
        }
        this.myReadAtLeastOnce.add((JSVariable)var);
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(51);
        }
        return definedValuesInfo;
    }

    public void functionEncountered(JSFunction function) {
        ((JSFunctionBaseImpl)function).addReferencedExternalNames(this.myVariablesReferencedInInners);
        ((JSFunctionBaseImpl)function).addWrittenExternalNames(this.myVariablesWrittenInInners);
    }

    private static void mergeBranches(@NotNull List<DefinedValuesInfo> merge, @NotNull DefinedValuesInfo branch) {
        if (merge == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(52);
        }
        if (branch == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(53);
        }
        assert (merge.size() > 1);
        Map<JSVariable, JSVariableInfo> result2 = branch.myVariableInfo;
        for (int i = merge.size() - 1; i >= 0; --i) {
            DefinedValuesInfo info = merge.get(i);
            for (Map.Entry<JSVariable, JSVariableInfo> entry : info.myVariableInfo.entrySet()) {
                JSVariable variable = entry.getKey();
                JSVariableInfo value = entry.getValue();
                JSVariableInfo varInfo = result2.get(variable);
                if (varInfo == null) {
                    result2.put(variable, value.cloneState());
                    continue;
                }
                varInfo.addReads(value.getVariablesRead());
                varInfo.addWrites(value.getVariablesWritten());
                varInfo.intersectOverwrittenWith(value.getVariablesOverwritten());
            }
        }
    }

    @NotNull
    private static DefinedValuesInfo valueWritten(@NotNull JSElement element2, @Nullable JSExpression rOperand, @NotNull DefinedValuesInfo info) {
        Set<JSExpression> valueWritten;
        if (element2 == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(54);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(55);
        }
        JSVariable var = null;
        if (element2 instanceof JSReferenceExpression && ((JSReferenceExpression)element2).getQualifier() == null) {
            PsiElement resolve2 = ((JSReferenceExpression)element2).resolve();
            if (resolve2 instanceof JSVariable) {
                var = (JSVariable)resolve2;
            }
        } else if (element2 instanceof JSVariable) {
            var = (JSVariable)element2;
        }
        if (var == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(56);
            }
            return definedValuesInfo;
        }
        if (rOperand == null) {
            info.myVariableInfo.put(var, new JSVariableInfo());
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(57);
            }
            return definedValuesInfo;
        }
        Map<JSVariable, JSVariableInfo> infoMap = info.myVariableInfo;
        JSVariableInfo variableInfo = infoMap.get(var);
        if (variableInfo == null) {
            infoMap.put(var, new JSVariableInfo());
            variableInfo = infoMap.get(var);
        }
        if ((valueWritten = variableInfo.getVariablesWritten()).contains(rOperand)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(58);
            }
            return definedValuesInfo;
        }
        Set<JSExpression> valueRead = variableInfo.getVariablesRead();
        for (JSExpression expression : valueWritten) {
            if (valueRead.contains(expression)) continue;
            variableInfo.addOverwritten(expression);
        }
        variableInfo.addWrite(rOperand);
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(59);
        }
        return definedValuesInfo;
    }

    private static boolean isReadInConditional(@NotNull JSExpression reference) {
        IElementType sign;
        PsiElement parent;
        if (reference == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(60);
        }
        if ((parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)reference)) instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)parent).getOperationSign()) == JSTokenTypes.EXCL || sign == JSTokenTypes.TYPEOF_KEYWORD)) {
            return true;
        }
        if (JSControlFlowProcessor.isConditionOfBlock(reference, parent)) {
            return true;
        }
        if (parent instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
            IElementType sign2 = binaryExpression.getOperationSign();
            if (sign2 == JSTokenTypes.ANDAND || sign2 == JSTokenTypes.OROR) {
                return true;
            }
            if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign2) && (reference == binaryExpression.getROperand() && JSSymbolUtil.isUndefinedExpression((JSExpression)binaryExpression.getLOperand()) || reference == binaryExpression.getLOperand() && JSSymbolUtil.isUndefinedExpression((JSExpression)binaryExpression.getROperand()))) {
                return true;
            }
        }
        return parent instanceof JSElvisOwner && ((JSElvisOwner)parent).isElvis();
    }

    @Contract(value="_, null -> false")
    private static boolean isConditionOfBlock(JSExpression key, PsiElement parent) {
        return parent instanceof JSConditionOwner && key == ((JSConditionOwner)parent).getCondition();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 13, 14, 15, 18, 19, 30, 31, 32, 40, 42, 43, 44, 45, 46, 47, 50, 51, 56, 57, 58, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 29: 
            case 39: 
            case 41: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesWritten";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesReadWithoutInitialization";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readAtLeastOnce";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesReferencedInInners";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesWrittenInInners";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesOverwritten";
                break;
            }
            case 48: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merge";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processInstruction";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processForInStatement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processJSDefinitionExpression";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processJSAssignmentExpression";
                break;
            }
            case 40: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "valueRead";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "processConditionalTrueInstruction";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "valueWritten";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInstructions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processControlFlow";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processInstruction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processForInStatement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processJSDefinitionExpression";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processJSReferenceExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processJSVariable";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processJSAssignmentExpression";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 39: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "valueRead";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processConditionalTrueInstruction";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "mergeBranches";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "valueWritten";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isReadInConditional";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 13, 14, 15, 18, 19, 30, 31, 32, 40, 42, 43, 44, 45, 46, 47, 50, 51, 56, 57, 58, 59 -> new IllegalStateException(string);
        };
    }

    private static final class DefinedValuesInfo {
        @NotNull
        final Map<JSVariable, JSVariableInfo> myVariableInfo;
        @Nullable
        Set<JSVariable> conditionalVariables;

        @Contract(pure=true)
        private DefinedValuesInfo(@NotNull Map<JSVariable, JSVariableInfo> variableInfo) {
            if (variableInfo == null) {
                DefinedValuesInfo.$$$reportNull$$$0(0);
            }
            this.myVariableInfo = variableInfo;
        }

        DefinedValuesInfo() {
            this(new HashMap<JSVariable, JSVariableInfo>());
        }

        DefinedValuesInfo cloneState() {
            HashMap<JSVariable, JSVariableInfo> variableInfo = new HashMap<JSVariable, JSVariableInfo>(this.myVariableInfo.size() + 1);
            this.myVariableInfo.forEach((variable, varInfo) -> variableInfo.put((JSVariable)variable, varInfo.cloneState()));
            DefinedValuesInfo newInfo = new DefinedValuesInfo(variableInfo);
            if (this.conditionalVariables != null) {
                newInfo.conditionalVariables = new HashSet<JSVariable>(this.conditionalVariables);
            }
            return newInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefinedValuesInfo)) {
                return false;
            }
            DefinedValuesInfo info = (DefinedValuesInfo)o;
            if (!this.myVariableInfo.equals(info.myVariableInfo)) {
                return false;
            }
            return Objects.equals(this.conditionalVariables, info.conditionalVariables);
        }

        public int hashCode() {
            int result2 = this.myVariableInfo.hashCode();
            result2 = 31 * result2 + (this.conditionalVariables != null ? this.conditionalVariables.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableInfo", "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$DefinedValuesInfo", "<init>"));
        }
    }
}

