/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.modules;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002\u001a\u0016\u0010\t\u001a\u00020\u0001*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\u0016\u0010\t\u001a\u00020\u0001*\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\u0016\u0010\t\u001a\u00020\u0001*\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u00a8\u0006\u0013"}, d2={"isLibraryElement", "", "context", "Lcom/intellij/psi/PsiElement;", "getExportedElement", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeListOwner;", "Lcom/intellij/lang/ecmascript6/psi/ES6ExportDefaultAssignment;", "getNamedElementToExport", "getElementToExportFromReference", "isFromModule", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;", "exportModule", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclaration;", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "applyExportStatus", "", "namedElement", "exported", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/lang/javascript/intentions/modules/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class UtilKt {
    public static final boolean isLibraryElement(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context2.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index = projectFileIndex;
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context2);
        return file != null && index.isInLibrary(file);
    }

    @Nullable
    public static final JSAttributeListOwner getExportedElement(@NotNull ES6ExportDefaultAssignment $this$getExportedElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getExportedElement, (String)"<this>");
        JSAttributeListOwner jSAttributeListOwner = UtilKt.getNamedElementToExport($this$getExportedElement);
        if (jSAttributeListOwner == null) {
            jSAttributeListOwner = UtilKt.getElementToExportFromReference($this$getExportedElement);
        }
        return jSAttributeListOwner;
    }

    private static final JSAttributeListOwner getNamedElementToExport(ES6ExportDefaultAssignment $this$getNamedElementToExport) {
        JSAttributeListOwner jSAttributeListOwner;
        JSNamedElement jSNamedElement = $this$getNamedElementToExport.getNamedElement();
        if (jSNamedElement != null) {
            JSNamedElement it = jSNamedElement;
            boolean bl = false;
            jSAttributeListOwner = it instanceof JSAttributeListOwner ? (JSAttributeListOwner)it : null;
        } else {
            jSAttributeListOwner = null;
        }
        return jSAttributeListOwner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final JSAttributeListOwner getElementToExportFromReference(ES6ExportDefaultAssignment $this$getElementToExportFromReference) {
        JSExpression jSExpression = $this$getElementToExportFromReference.getExpression();
        if (jSExpression == null) return null;
        PsiReference psiReference = jSExpression.getReference();
        if (psiReference == null) return null;
        PsiElement psiElement = psiReference.resolve();
        if (psiElement == null) return null;
        PsiElement it = psiElement;
        boolean bl = false;
        if (!(it instanceof JSAttributeListOwner)) return null;
        JSAttributeListOwner jSAttributeListOwner = (JSAttributeListOwner)it;
        JSAttributeListOwner jSAttributeListOwner2 = jSAttributeListOwner;
        if (jSAttributeListOwner2 == null) return null;
        JSAttributeListOwner jSAttributeListOwner3 = jSAttributeListOwner2;
        it = jSAttributeListOwner3;
        boolean bl2 = false;
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)it)) return null;
        JSAttributeListOwner jSAttributeListOwner4 = jSAttributeListOwner3;
        return jSAttributeListOwner4;
    }

    public static final boolean isFromModule(@NotNull ES6ImportExportDeclarationPart $this$isFromModule, @Nullable PsiFile exportModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromModule, (String)"<this>");
        ES6ImportExportDeclaration eS6ImportExportDeclaration = $this$isFromModule.getDeclaration();
        if (eS6ImportExportDeclaration == null) {
            return false;
        }
        ES6ImportExportDeclaration declaration = eS6ImportExportDeclaration;
        return UtilKt.isFromModule(declaration, exportModule);
    }

    public static final boolean isFromModule(@NotNull ES6ImportExportDeclaration $this$isFromModule, @Nullable PsiFile exportModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromModule, (String)"<this>");
        ES6FromClause eS6FromClause = $this$isFromModule.getFromClause();
        if (eS6FromClause == null) {
            return false;
        }
        ES6FromClause fromClause = eS6FromClause;
        return UtilKt.isFromModule(fromClause, exportModule);
    }

    public static final boolean isFromModule(@NotNull ES6FromClause $this$isFromModule, @Nullable PsiFile exportModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromModule, (String)"<this>");
        Collection collection = $this$isFromModule.resolveReferencedElements();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveReferencedElements(...)");
        PsiElement fromModule = (PsiElement)CollectionsKt.singleOrNull((Iterable)collection);
        return Intrinsics.areEqual((Object)fromModule, (Object)exportModule);
    }

    public static final void applyExportStatus(@Nullable JSAttributeListOwner namedElement, boolean exported) {
        JSAttributeListOwner target2;
        JSAttributeListOwner jSAttributeListOwner = target2 = namedElement instanceof JSVariable ? (JSAttributeListOwner)((JSVariable)namedElement).getStatement() : namedElement;
        if (target2 == null) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(target2);
        wrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, exported);
        wrapper.applyTo(target2);
    }
}

