/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "reexports", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/util/Set;)V", "accept", "", "candidate", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "Factory", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nNodeModulesDFilesFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesDFilesFilter.kt\ncom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class NodeModulesDFilesFilter
implements JSImportCandidatesFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PsiElement> reexports;
    @NotNull
    private static final Regex dFileSuffixRegex = new Regex("\\.d(-[A-Za-z0-9_]+)?$");

    public NodeModulesDFilesFilter(@NotNull Set<? extends PsiElement> reexports) {
        Intrinsics.checkNotNullParameter(reexports, (String)"reexports");
        this.reexports = reexports;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        void it;
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        if (!NodeModulesDFilesFilter.Companion.isInDFile(candidate.getElement())) return true;
        PsiElement psiElement = candidate.getElement();
        Iterable iterable = this.reexports;
        boolean bl = false;
        if (CollectionsKt.contains((Iterable)iterable, (Object)(it instanceof ES6ExportSpecifier ? ((ES6ExportSpecifier)it).resolve() : psiElement))) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter$Companion;", "", "<init>", "()V", "dFileSuffixRegex", "Lkotlin/text/Regex;", "isInDFile", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isInDFile(PsiElement element2) {
            boolean bl;
            Object object = element2;
            if (object != null && (object = object.getContainingFile()) != null && (object = object.getName()) != null && (object = StringsKt.removeSuffix((String)object, (CharSequence)".d.ts")) != null) {
                CharSequence charSequence = (CharSequence)object;
                bl = dFileSuffixRegex.containsMatchIn(charSequence);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "<init>", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nNodeModulesDFilesFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesDFilesFilter.kt\ncom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n2746#2,3:40\n1625#2:43\n1869#2:44\n1870#2:48\n1626#2:49\n19#3:45\n1#4:46\n1#4:47\n*S KotlinDebug\n*F\n+ 1 NodeModulesDFilesFilter.kt\ncom/intellij/lang/javascript/modules/imports/filter/NodeModulesDFilesFilter$Factory\n*L\n14#1:40,3\n16#1:43\n16#1:44\n16#1:48\n16#1:49\n17#1:45\n16#1:47\n*E\n"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            void $this$mapNotNullTo$iv;
            boolean bl;
            block6: {
                Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
                Iterable $this$none$iv = candidates;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        JSImportCandidate it = (JSImportCandidate)element$iv;
                        boolean bl2 = false;
                        if (!Companion.isInDFile(it.getElement())) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
            Iterable $i$f$none = candidates;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv;
                ES6ExportSpecifier eS6ExportSpecifier;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl3 = false;
                JSImportCandidate it = (JSImportCandidate)element$iv;
                boolean bl4 = false;
                PsiElement $this$asSafely$iv = it.getElement();
                boolean $i$f$asSafely = false;
                PsiElement psiElement = $this$asSafely$iv;
                if (!(psiElement instanceof ES6ExportSpecifier)) {
                    psiElement = null;
                }
                ES6ExportSpecifier specifier = eS6ExportSpecifier = (ES6ExportSpecifier)psiElement;
                boolean bl5 = false;
                Object object = !Companion.isInDFile((PsiElement)specifier) ? eS6ExportSpecifier : null;
                if ((object != null ? object.resolve() : null) == null) continue;
                it$iv = it$iv;
                boolean bl6 = false;
                destination$iv.add(it$iv);
            }
            HashSet reexports = (HashSet)destination$iv;
            return !((Collection)reexports).isEmpty() ? (JSImportCandidatesFilter)new NodeModulesDFilesFilter(reexports) : null;
        }
    }
}

