/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberInputValidator
implements RenameInputValidator {
    private static final ElementPattern<JSNamedElement> ourPattern = PlatformPatterns.psiElement(JSNamedElement.class).with((PatternCondition)new PatternCondition<JSNamedElement>("class member"){

        public boolean accepts(@NotNull JSNamedElement element2, ProcessingContext context2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (DialectDetector.isActionScript((PsiElement)element2)) {
                return false;
            }
            return element2 instanceof JSDefinitionExpression || element2 instanceof JSProperty || JSUtils.isMember((PsiElement)element2) || element2 instanceof TypeScriptTypeMember;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSMemberInputValidator$1", "accepts"));
        }
    });

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern<JSNamedElement> elementPattern = ourPattern;
        if (elementPattern == null) {
            JSMemberInputValidator.$$$reportNull$$$0(0);
        }
        return elementPattern;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement psiElement, @NotNull ProcessingContext context2) {
        if (newName == null) {
            JSMemberInputValidator.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSMemberInputValidator.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)psiElement).getExpression();
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                return true;
            }
            return JSNamesValidation.isPropertyName(newName, psiElement);
        }
        if (psiElement instanceof JSNamedElement) {
            IElementType currentElementType = JSMemberInputValidator.getIdentifierElementType((JSNamedElement)psiElement);
            if (JSTokenTypes.STRING_LITERALS.contains(currentElementType)) {
                return true;
            }
            if (psiElement instanceof JSProperty) {
                return JSNamesValidation.isPropertyName(newName, psiElement);
            }
            if (JSUtils.isMember((PsiElement)psiElement)) {
                return JSNamesValidation.isClassMemberName(newName, psiElement);
            }
            return BasicJavascriptNamesValidator.isIdentifierName((CharSequence)newName);
        }
        return false;
    }

    @Nullable
    public static IElementType getIdentifierElementType(@NotNull JSNamedElement namedElement) {
        PsiElement identifierPsi;
        if (namedElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(4);
        }
        identifierPsi = (identifierPsi = namedElement.getNameIdentifier()) instanceof JSReferenceExpression ? ((JSReferenceExpression)identifierPsi).getReferenceNameElement() : identifierPsi;
        return identifierPsi != null ? identifierPsi.getNode().getElementType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSMemberInputValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSMemberInputValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

